﻿/*!
 * Bootstrap Colorpicker
 * http://mjolnic.github.io/bootstrap-colorpicker/
 *
 * Originally written by (c) 2012 Stefan Petre
 * Licensed under the Apache License v2.0
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * @todo Update DOCS
 */
(function(n){"use strict";var i=function(n){this.value={h:0,s:0,b:0,a:1};this.origFormat=null;n&&(n.toLowerCase!==undefined?this.setColor(n):n.h!==undefined&&(this.value=n))},r,t;i.prototype={constructor:i,_sanitizeNumber:function(n){return typeof n=="number"?n:isNaN(n)||n===null||n===""||n===undefined?1:n.toLowerCase!==undefined?parseFloat(n):1},setColor:function(n){n=n.toLowerCase();this.value=this.stringToHSB(n)||{h:0,s:0,b:0,a:1}},stringToHSB:function(t){t=t.toLowerCase();var i=this,r=!1;return n.each(this.stringParsers,function(n,u){var e=u.re.exec(t),f=e&&u.parse.apply(i,[e]),o=u.format||"rgba";return f?(r=o.match(/hsla?/)?i.RGBtoHSB.apply(i,i.HSLtoRGB.apply(i,f)):i.RGBtoHSB.apply(i,f),i.origFormat=o,!1):!0}),r},setHue:function(n){this.value.h=1-n},setSaturation:function(n){this.value.s=n},setBrightness:function(n){this.value.b=1-n},setAlpha:function(n){this.value.a=parseInt((1-n)*100,10)/100},toRGB:function(n,t,i,r){n=n||this.value.h;t=t||this.value.s;i=i||this.value.b;r=r||this.value.a;var u,f,e,c,l,o,s,h;n&&t===undefined&&i===undefined&&(t=n.s,i=n.v,n=n.h);c=Math.floor(n*6);l=n*6-c;o=i*(1-t);s=i*(1-l*t);h=i*(1-(1-l)*t);switch(c%6){case 0:u=i;f=h;e=o;break;case 1:u=s;f=i;e=o;break;case 2:u=o;f=i;e=h;break;case 3:u=o;f=s;e=i;break;case 4:u=h;f=o;e=i;break;case 5:u=i;f=o;e=s}return{r:Math.floor(u*255),g:Math.floor(f*255),b:Math.floor(e*255),a:r}},toHex:function(n,t,i,r){var u=this.toRGB(n,t,i,r);return"#"+(16777216|parseInt(u.r)<<16|parseInt(u.g)<<8|parseInt(u.b)).toString(16).substr(1)},toHSL:function(n,t,i,r){n=n||this.value.h;t=t||this.value.s;i=i||this.value.b;r=r||this.value.a;var e=n,u=(2-t)*i,f=t*i;return f/=u>0&&u<=1?u:2-u,u/=2,f>1&&(f=1),{h:e,s:f,l:u,a:r}},RGBtoHSB:function(n,t,i,r){n/=255;t/=255;i/=255;var e,o,f,u;return f=Math.max(n,t,i),u=f-Math.min(n,t,i),e=u===0?null:f===n?(t-i)/u:f===t?(i-n)/u+2:(n-t)/u+4,e=(e+360)%6/6,o=u===0?0:u/f,{h:this._sanitizeNumber(e),s:o,b:f,a:this._sanitizeNumber(r)}},HueToRGB:function(n,t,i){return i<0?i+=1:i>1&&(i-=1),i*6<1?n+(t-n)*i*6:i*2<1?t:i*3<2?n+(t-n)*(2/3-i)*6:n},HSLtoRGB:function(n,t,i,r){var u;t<0&&(t=0);u=i<=.5?i*(1+t):i+t-i*t;var f=2*i-u,e=n+1/3,o=n,s=n-1/3,h=Math.round(this.HueToRGB(f,u,e)*255),c=Math.round(this.HueToRGB(f,u,o)*255),l=Math.round(this.HueToRGB(f,u,s)*255);return[h,c,l,this._sanitizeNumber(r)]},toString:function(n){var t,i;n=n||"rgba";switch(n){case"rgb":return t=this.toRGB(),"rgb("+t.r+","+t.g+","+t.b+")";case"rgba":return t=this.toRGB(),"rgba("+t.r+","+t.g+","+t.b+","+t.a+")";case"hsl":return i=this.toHSL(),"hsl("+Math.round(i.h*360)+","+Math.round(i.s*100)+"%,"+Math.round(i.l*100)+"%)";case"hsla":return i=this.toHSL(),"hsla("+Math.round(i.h*360)+","+Math.round(i.s*100)+"%,"+Math.round(i.l*100)+"%,"+i.a+")";case"hex":return this.toHex();default:return!1}},stringParsers:[{re:/#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/,format:"hex",parse:function(n){return[parseInt(n[1],16),parseInt(n[2],16),parseInt(n[3],16),1]}},{re:/#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/,format:"hex",parse:function(n){return[parseInt(n[1]+n[1],16),parseInt(n[2]+n[2],16),parseInt(n[3]+n[3],16),1]}},{re:/rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*?\)/,format:"rgb",parse:function(n){return[n[1],n[2],n[3],1]}},{re:/rgb\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*?\)/,format:"rgb",parse:function(n){return[2.55*n[1],2.55*n[2],2.55*n[3],1]}},{re:/rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,format:"rgba",parse:function(n){return[n[1],n[2],n[3],n[4]]}},{re:/rgba\(\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,format:"rgba",parse:function(n){return[2.55*n[1],2.55*n[2],2.55*n[3],n[4]]}},{re:/hsl\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*?\)/,format:"hsl",parse:function(n){return[n[1]/360,n[2]/100,n[3]/100,n[4]]}},{re:/hsla\(\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\%\s*,\s*(\d+(?:\.\d+)?)\%\s*(?:,\s*(\d+(?:\.\d+)?)\s*)?\)/,format:"hsla",parse:function(n){return[n[1]/360,n[2]/100,n[3]/100,n[4]]}},{re:/^([a-z]{3,})$/,format:"alias",parse:function(n){var i=this.colorNameToHex(n[0])||"#000000",t=this.stringParsers[0].re.exec(i);return t&&this.stringParsers[0].parse.apply(this,[t])}}],colorNameToHex:function(n){var t={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4","indianred ":"#cd5c5c","indigo ":"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"};return typeof t[n.toLowerCase()]!="undefined"?t[n.toLowerCase()]:!1}};r={horizontal:!1,inline:!1,color:!1,format:!1,input:"input",container:!1,component:".add-on, .input-group-addon",sliders:{saturation:{maxLeft:100,maxTop:100,callLeft:"setSaturation",callTop:"setBrightness"},hue:{maxLeft:0,maxTop:100,callLeft:!1,callTop:"setHue"},alpha:{maxLeft:0,maxTop:100,callLeft:!1,callTop:"setAlpha"}},slidersHorz:{saturation:{maxLeft:100,maxTop:100,callLeft:"setSaturation",callTop:"setBrightness"},hue:{maxLeft:100,maxTop:0,callLeft:"setHue",callTop:!1},alpha:{maxLeft:100,maxTop:0,callLeft:"setAlpha",callTop:!1}},template:'<div class="colorpicker dropdown-menu"><div class="colorpicker-saturation"><i><b><\/b><\/i><\/div><div class="colorpicker-hue"><i><\/i><\/div><div class="colorpicker-alpha"><i><\/i><\/div><div class="colorpicker-color"><div /><\/div><\/div>'};t=function(t,u){this.element=n(t).addClass("colorpicker-element");this.options=n.extend({},r,this.element.data(),u);this.component=this.options.component;this.component=this.component!==!1?this.element.find(this.component):!1;this.component&&this.component.length===0&&(this.component=!1);this.container=this.options.container===!0?this.element:this.options.container;this.container=this.container!==!1?n(this.container):!1;this.input=this.element.is("input")?this.element:this.options.input?this.element.find(this.options.input):!1;this.input&&this.input.length===0&&(this.input=!1);this.color=new i(this.options.color!==!1?this.options.color:this.getValue());this.format=this.options.format!==!1?this.options.format:this.color.origFormat;this.picker=n(this.options.template);this.options.inline?this.picker.addClass("colorpicker-inline colorpicker-visible"):this.picker.addClass("colorpicker-hidden");this.options.horizontal&&this.picker.addClass("colorpicker-horizontal");(this.format==="rgba"||this.format==="hsla")&&this.picker.addClass("colorpicker-with-alpha");this.picker.on("mousedown.colorpicker",n.proxy(this.mousedown,this));if(this.picker.appendTo(this.container?this.container:n("body")),this.input!==!1){this.input.on({"keyup.colorpicker":n.proxy(this.keyup,this)});if(this.component===!1)this.element.on({"focus.colorpicker":n.proxy(this.show,this)});if(this.options.inline===!1)this.element.on({"focusout.colorpicker":n.proxy(this.hide,this)})}if(this.component!==!1)this.component.on({"click.colorpicker":n.proxy(this.show,this)});if(this.input===!1&&this.component===!1)this.element.on({"click.colorpicker":n.proxy(this.show,this)});this.update();n(n.proxy(function(){this.element.trigger("create")},this))};t.version="2.0.0-beta";t.Color=i;t.prototype={constructor:t,destroy:function(){this.picker.remove();this.element.removeData("colorpicker").off(".colorpicker");this.input!==!1&&this.input.off(".colorpicker");this.component!==!1&&this.component.off(".colorpicker");this.element.removeClass("colorpicker-element");this.element.trigger({type:"destroy"})},reposition:function(){if(this.options.inline!==!1)return!1;var n=this.component?this.component.offset():this.element.offset();this.picker.css({top:n.top+(this.component?this.component.outerHeight():this.element.outerHeight()),left:n.left})},show:function(t){if(this.isDisabled())return!1;this.picker.addClass("colorpicker-visible").removeClass("colorpicker-hidden");this.reposition();n(window).on("resize.colorpicker",n.proxy(this.reposition,this));if(!this.hasInput()&&t&&t.stopPropagation&&t.preventDefault&&(t.stopPropagation(),t.preventDefault()),this.options.inline===!1)n(window.document).on({"mousedown.colorpicker":n.proxy(this.hide,this)});this.element.trigger({type:"showPicker",color:this.color})},hide:function(){this.picker.addClass("colorpicker-hidden").removeClass("colorpicker-visible");n(window).off("resize.colorpicker",this.reposition);n(document).off({"mousedown.colorpicker":this.hide});this.update();this.element.trigger({type:"hidePicker",color:this.color})},updateData:function(n){return n=n||this.color.toString(this.format),this.element.data("color",n),n},updateInput:function(n){return n=n||this.color.toString(this.format),this.input!==!1&&this.input.prop("value",n),n},updatePicker:function(n){n!==undefined&&(this.color=new i(n));var t=this.options.horizontal===!1?this.options.sliders:this.options.slidersHorz,r=this.picker.find("i");if(r.length!==0)return this.options.horizontal===!1?(t=this.options.sliders,r.eq(1).css("top",t.hue.maxTop*(1-this.color.value.h)).end().eq(2).css("top",t.alpha.maxTop*(1-this.color.value.a))):(t=this.options.slidersHorz,r.eq(1).css("left",t.hue.maxLeft*(1-this.color.value.h)).end().eq(2).css("left",t.alpha.maxLeft*(1-this.color.value.a))),r.eq(0).css({top:t.saturation.maxTop-this.color.value.b*t.saturation.maxTop,left:this.color.value.s*t.saturation.maxLeft}),this.picker.find(".colorpicker-saturation").css("backgroundColor",this.color.toHex(this.color.value.h,1,1,1)),this.picker.find(".colorpicker-alpha").css("backgroundColor",this.color.toHex()),this.picker.find(".colorpicker-color, .colorpicker-color div").css("backgroundColor",this.color.toString(this.format)),n},updateComponent:function(n){if(n=n||this.color.toString(this.format),this.component!==!1){var t=this.component.find("i").eq(0);t.length>0?t.css({backgroundColor:n}):this.component.css({backgroundColor:n})}return n},update:function(n){var t=this.updateComponent();return(this.getValue(!1)!==!1||n===!0)&&(this.updateInput(t),this.updateData(t)),this.updatePicker(),t},setValue:function(n){this.color=new i(n);this.update();this.element.trigger({type:"changeColor",color:this.color,value:n})},getValue:function(n){n=n===undefined?"#000000":n;var t;return t=this.hasInput()?this.input.val():this.element.data("color"),(t===undefined||t===""||t===null)&&(t=n),t},hasInput:function(){return this.input!==!1},isDisabled:function(){return this.hasInput()?this.input.prop("disabled")===!0:!1},disable:function(){return this.hasInput()?(this.input.prop("disabled",!0),!0):!1},enable:function(){return this.hasInput()?(this.input.prop("disabled",!1),!0):!1},currentSlider:null,mousePointer:{left:0,top:0},mousedown:function(t){var u;t.stopPropagation();t.preventDefault();var f=n(t.target),i=f.closest("div"),r=this.options.horizontal?this.options.slidersHorz:this.options.sliders;if(!i.is(".colorpicker")){if(i.is(".colorpicker-saturation"))this.currentSlider=n.extend({},r.saturation);else if(i.is(".colorpicker-hue"))this.currentSlider=n.extend({},r.hue);else if(i.is(".colorpicker-alpha"))this.currentSlider=n.extend({},r.alpha);else return!1;u=i.offset();this.currentSlider.guide=i.find("i")[0].style;this.currentSlider.left=t.pageX-u.left;this.currentSlider.top=t.pageY-u.top;this.mousePointer={left:t.pageX,top:t.pageY};n(document).on({"mousemove.colorpicker":n.proxy(this.mousemove,this),"mouseup.colorpicker":n.proxy(this.mouseup,this)}).trigger("mousemove")}return!1},mousemove:function(n){n.stopPropagation();n.preventDefault();var t=Math.max(0,Math.min(this.currentSlider.maxLeft,this.currentSlider.left+((n.pageX||this.mousePointer.left)-this.mousePointer.left))),i=Math.max(0,Math.min(this.currentSlider.maxTop,this.currentSlider.top+((n.pageY||this.mousePointer.top)-this.mousePointer.top)));return this.currentSlider.guide.left=t+"px",this.currentSlider.guide.top=i+"px",this.currentSlider.callLeft&&this.color[this.currentSlider.callLeft].call(this.color,t/100),this.currentSlider.callTop&&this.color[this.currentSlider.callTop].call(this.color,i/100),this.update(!0),this.element.trigger({type:"changeColor",color:this.color}),!1},mouseup:function(t){return t.stopPropagation(),t.preventDefault(),n(document).off({"mousemove.colorpicker":this.mousemove,"mouseup.colorpicker":this.mouseup}),!1},keyup:function(n){if(n.keyCode===38)this.color.value.a<1&&(this.color.value.a=Math.round((this.color.value.a+.01)*100)/100),this.update(!0);else if(n.keyCode===40)this.color.value.a>0&&(this.color.value.a=Math.round((this.color.value.a-.01)*100)/100),this.update(!0);else{var t=this.input.val();this.color=new i(t);this.getValue(!1)!==!1&&(this.updateData(),this.updateComponent(),this.updatePicker())}this.element.trigger({type:"changeColor",color:this.color,value:t})}};n.colorpicker=t;n.fn.colorpicker=function(i){return this.each(function(){var u=n(this),r=u.data("colorpicker"),f=typeof i=="object"?i:{};r||typeof i=="string"?typeof i=="string"&&r[i].apply(r,Array.prototype.slice.call(arguments,1)):u.data("colorpicker",new t(this,f))})};n.fn.colorpicker.constructor=t})(window.jQuery);
//# sourceMappingURL=bootstrap-colorpicker.min.js.map
