﻿#region Using Namespace
using System;
using System.Collections.Generic;
using System.Configuration;
using Sapphire.Ohu.BusinessEntity.Framework.BaseFrameworkBE;
using Sapphire.Ohu.BaseFramework.Utilities;
using Sapphire.Ohu.Web.Helper;
using System.Data;
using System.Collections.Specialized;
using Sapphire.Ohu.BusinessEntity.Component.AlertBE;
using CCA.Util;
using paytm;
using System.Text;
using System.Security.Cryptography;
using System.Net;
using System.Web.Script.Serialization;
using System.Data.SqlClient;
using Microsoft.Reporting.WebForms;
using Sapphire.Vidyalaya.Components.Alert.AlertNotification;
using Sapphire.Vidyalaya.BusinessEntity.Business.FeeBE;
using Sapphire.Vidyalaya.BusinessLogic.Business.FeeManagement.FeeBL;
using System.Linq;
using System.Web;
using System.Text.RegularExpressions;
using Razorpay.Api;
using Sapphire.Ohu.BaseFramework.Security;
using Sapphire.Ohu.BusinessEntity.Application.MasterBE;
using System.IO;
using Sapphire.Ohu.BaseFramework.Exceptions;
using Sapphire.Vidyalaya.BusinessEntity.Business.AdministrationBE;
using FeeManagementReportDataset = global::Sapphire.Vidyalaya.Report.Datasets.FeeManagement;
using System.Security.AccessControl;
using Sapphire.Vidyalaya.DataAccess.Business.Activity.ActivityDA;
using Sapphire.Vidyalaya.BusinessLogic.Business.Common.CommonBL;
using Newtonsoft.Json;
using Sapphire.Vidyalaya.BusinessEntity.Business.OnlinePaymentBE;
#endregion

public partial class Pages_OnlineAdmission_FormConfirmation : System.Web.UI.Page
{
    #region Constant
    string AtomRespHashKey = "", CollectionGroup = "", CCAvenueWorkingKey = "";
    string PaytmMerchantKey = "", PaytmStatusCheckURL = "";
    string PayUMoneySALT = "", PayUMoneyHASHSEQUENCE = "";
    Int64 PaymentTransactionId;
    bool IsAdmissionForm = false;
    string EasebuzzSalt = string.Empty;

    #endregion

    private FeeSetupService FeeSetupServiceClient
    {
        get
        {
            return new FeeSetupService();
        }
    }

    private FeeReceiptService FeeReceiptServiceClient
    {
        get
        {
            return new FeeReceiptService();
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        CommonHelper.LogWriter("Payment Response Called", 1, "Payment Response", HttpContext.Current.Request.Url.AbsoluteUri);
        if (!IsPostBack)
        {
            string QueryString = Request.Url.Query;
            FeeReceiptPathHiddenField.Value = string.Empty; // Add for Mantis Id:0030874
            PaymentTransactionIdHiddenField.Value = string.Empty; //Added for Mantis 0036030 by Foram
            CommonHelper.LogWriter("Payment Response QueryString: " + QueryString, 1, "Payment Response", HttpContext.Current.Request.Url.AbsoluteUri);
            //else condition not working proper because QueryString not equal to null not checked properly
            //if (QueryString != null)
            if (!string.IsNullOrEmpty(QueryString))
            {
                QueryString = QueryString.Split(new string[] { "Query=" }, StringSplitOptions.None)[1];
                //string[] QueryParameters = Request.QueryString["Query"].ToString().Replace("PaytmMerchantKey=" + "has", "PaytmMerchantKey=" + "#").Split(',');
                string[] QueryParameters = QueryString.ToString().Split(',');
                if (QueryParameters.Count() > 1)
                {
                    string PaymentGatewayId = QueryParameters[0].Split('=')[1].ToString();

                    CollectionGroup = QueryParameters[1].Split('=')[1].ToString().Replace('/', ',');

                    if (PaymentGatewayId != "17") { PaymentTransactionId = Int64.Parse(QueryParameters[2].Split('=')[1].ToString()); }

                    PaymentTransactionIdHiddenField.Value = PaymentTransactionId.ToString();  //Added for Mantis 0036030 by Foram
                    if (PaymentGatewayId == "1")
                    {
                        if (QueryParameters.Count() > 2)
                        {
                            AtomRespHashKey = QueryParameters[3].Split('=')[1].ToString();
                            if (QueryParameters.Count() > 4)
                            {
                                IsAdmissionForm = Convert.ToBoolean(int.Parse(QueryParameters[4].Split('=')[1].ToString()));
                            }
                            GetAtomPaymentStatus();
                        }
                    }
                    else if (PaymentGatewayId == "7")
                    {
                        if (QueryParameters.Count() > 2)
                        {
                            string TempWorkingKey = QueryParameters[3].Split('=')[1].ToString().Replace(" ", "+");
                            if (TempWorkingKey.Length == 63 && !TempWorkingKey.EndsWith("+"))
                                TempWorkingKey = TempWorkingKey.Insert(TempWorkingKey.Length, "+");

                            TempWorkingKey = CommonFunction.ReplaceURLEncodedCharacters(TempWorkingKey);
                            CCAvenueWorkingKey = SecurityCryptography.DecryptString(TempWorkingKey);
                            if (QueryParameters.Count() > 4)
                            {
                                IsAdmissionForm = bool.Parse(QueryParameters[4].Split('=')[1].ToString());
                            }
                            GetCCAvenuePaymentStatus();
                        }
                    }
                    else if (PaymentGatewayId == "2")
                    {
                        //string[] NewQuery = QueryString.Split('?')[1].Split(',');
                        if (QueryParameters.Count() > 2)
                        {
                            PaytmMerchantKey = QueryParameters[3].Split('=')[1].ToString().Replace("has", "#");
                            PaytmMerchantKey = CommonFunction.ReplaceURLEncodedCharacters(PaytmMerchantKey);
                            CommonHelper.LogWriter("Paytm MerchantKey : " + PaytmMerchantKey, 1, "Payment Response", HttpContext.Current.Request.Url.AbsoluteUri);
                            PaytmStatusCheckURL = QueryParameters[4].Split('=')[1].ToString();
                            if (QueryParameters.Count() > 5)
                            {
                                IsAdmissionForm = bool.Parse(QueryParameters[5].Split('=')[1].ToString());
                            }
                            GetPaytmPaymentStatus();
                        }
                    }
                    else if (PaymentGatewayId == "3")
                    {
                        if (QueryParameters.Count() > 2)
                        {
                            PayUMoneySALT = QueryParameters[3].Split('=')[1].ToString();
                            PayUMoneyHASHSEQUENCE = QueryParameters[4].Split('=')[1].ToString();
                            if (QueryParameters.Count() > 5)
                            {
                                IsAdmissionForm = bool.Parse(QueryParameters[5].Split('=')[1].ToString());
                            }
                            GetPayUMoneyPaymentStatus();
                        }
                    }
                    else if (PaymentGatewayId == "8")
                    {
                        if (QueryParameters.Count() > 3)
                        {
                            IsAdmissionForm = bool.Parse(QueryParameters[3].Split('=')[1].ToString());
                        }
                        GetBillDeskOldPaymentStatus();
                    }
                    else if (PaymentGatewayId == "9")
                    {
                        if (QueryParameters.Count() > 2)
                        {
                            PayUMoneySALT = QueryParameters[3].Split('=')[1].ToString();
                            PayUMoneyHASHSEQUENCE = QueryParameters[4].Split('=')[1].ToString();
                            if (QueryParameters.Count() > 5)
                            {
                                IsAdmissionForm = bool.Parse(QueryParameters[5].Split('=')[1].ToString());
                            }
                            GetPayUBizPaymentStatus();
                        }
                    }
                    else if (PaymentGatewayId == "10")
                    {
                        if (QueryParameters.Count() > 3)
                        {
                            IsAdmissionForm = bool.Parse(QueryParameters[3].Split('=')[1].ToString());
                        }
                        GetBillDeskNewPaymentStatus();
                    }
                    else if (PaymentGatewayId == "6")
                    {
                        if (QueryParameters.Count() > 3)
                        {
                            IsAdmissionForm = bool.Parse(QueryParameters[3].Split('=')[1].ToString());
                        }
                        GetEazyPayPaymentStatus();
                    }
                    else if (PaymentGatewayId == "15")
                    {
                        EasebuzzSalt = QueryParameters[3].Split('=')[1].ToString();
                        if (QueryParameters.Count() > 4)
                        {
                            IsAdmissionForm = bool.Parse(QueryParameters[4].Split('=')[1].ToString());
                        }
                        GetEasebuzzPaymentStatus();
                    }
                    else if (PaymentGatewayId == "17")
                    {
                        string[] QueryParams = QueryString.ToString().Split(new string[] { "&data=" }, StringSplitOptions.None)[0].Split(',');
                        PaymentTransactionId = Int64.Parse(QueryParams[2].Split('=')[1].ToString());
                        if (QueryParams.Count() > 3)
                        {
                            IsAdmissionForm = bool.Parse(QueryParams[3].Split('=')[1].ToString());
                        }
                        GetHesabePaymentStatus();
                    }
                    else if (PaymentGatewayId == "18")
                    {
                        string[] QueryParams = QueryString.ToString().Split(new string[] { "&data=" }, StringSplitOptions.None)[0].Split(',');
                        PaymentTransactionId = Int64.Parse(QueryParams[2].Split('=')[1].ToString());
                        if (QueryParams.Count() > 3)
                        {
                            IsAdmissionForm = bool.Parse(QueryParams[3].Split('=')[1].ToString());
                        }
                        GetRazorPayCollectNowPaymentStatus();
                    }
                }
                else
                {
                    var base64EncodedBytes = System.Convert.FromBase64String(QueryString.ToString().Replace(" ", "+"));

                    string CCAvenueQuery = System.Text.Encoding.UTF8.GetString(base64EncodedBytes); ;

                    string[] CCAvenueQueryParameters = CCAvenueQuery.Split(',');

                    string PaymentGatewayId = CCAvenueQueryParameters[0].Split('=')[1].ToString();

                    CollectionGroup = CCAvenueQueryParameters[1].Split('=')[1].ToString().Replace('/', ',');

                    PaymentTransactionId = Int64.Parse(CCAvenueQueryParameters[2].Split('=')[1].ToString());

                    if (PaymentGatewayId == "7")
                    {
                        if (CCAvenueQueryParameters.Count() > 2)
                        {
                            CCAvenueWorkingKey = CCAvenueQueryParameters[3].Split('=')[1].ToString();
                            if (CCAvenueQueryParameters.Count() > 4)
                            {
                                IsAdmissionForm = bool.Parse(CCAvenueQueryParameters[4].Split('=')[1].ToString());
                            }
                            GetCCAvenuePaymentStatus();
                        }
                    }
                }
                //IsAdmissionFormHiddenField.Value = IsAdmissionForm.ToString();
            }
            else
            {
                string TransactionResponse = Request.Form.ToString();
                CommonHelper.LogWriter("PageLoad_EazyPay : " + TransactionResponse, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);

                if (Request.Form.Count > 0 && Request.Form.AllKeys.Contains("ReferenceNo"))
                {
                    CommonFunctions cf = new CommonFunctions();
                    string mer_txnid = Request.Form["ReferenceNo"].ToString();
                    string query = "SELECT PaymentGatewayId, FunctionalityId  FROM sOp.tPaymentTransaction WHERE Id = " + mer_txnid;
                    DataSet ds = cf.GetDataset(query);
                    if (ds != null && ds.Tables.Count > 0 && ds.Tables[0] != null && ds.Tables[0].Rows.Count > 0 && Convert.ToInt16(ds.Tables[0].Rows[0]["PaymentGatewayId"].ToString()) == 6)
                    {
                        if (Convert.ToInt32(ds.Tables[0].Rows[0]["FunctionalityId"].ToString()) == 2)
                        {
                            IsAdmissionForm = true;
                        }
                        else
                        {
                            IsAdmissionForm = false;
                        }
                        CommonHelper.LogWriter("PageLoad_EazyPay GetEazyPayPaymentStatus: " + mer_txnid, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);
                        GetEazyPayPaymentStatus();
                    }
                    CommonHelper.LogWriter("PageLoad_EazyPay mer_txnid: " + mer_txnid, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);
                }
            }
            IsAdmissionFormHiddenField.Value = IsAdmissionForm.ToString();
        }
    }

    private void GetAtomPaymentStatus()
    {
        StringBuilder sb = new StringBuilder();
        try
        {
            NameValueCollection nvc = Request.Form;
            string TransactionResponse = Request.Form.ToString();
            CommonHelper.LogWriter("Atom Response : " + TransactionResponse, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);

            if (nvc.Count > 0)
            {
                string Vmmp_txn = nvc["mmp_txn"].ToString(); //atom txn id
                string VpaymentStatus = nvc["f_code"].ToString(); //status
                string Vmer_txn = Request.Form["mer_txn"]; //merchant txnid
                string Vamount = Request.Form["amt"]; //for amount
                string VSurcharge = Request.Form["surcharge"];
                string VProdid = Request.Form["prod"]; //Fee name
                string VDate = Request.Form["date"];
                string Bankid = Request.Form["bank_txn"];
                string VClientcode = Request.Form["clientcode"];
                string VBankname = Request.Form["bank_name"];
                string VDiscriminator = Request.Form["discriminator"];
                string VCardNumber = Request.Form["CardNumber"];
                string VUdf1 = Request.Form["udf1"];
                string VUdf2 = Request.Form["udf2"];
                string VUdf3 = Request.Form["udf3"];
                string VUdf4 = Request.Form["udf4"];
                string VUdf5 = Request.Form["udf5"];
                string VUdf6 = Request.Form["udf6"];
                string VUdf9 = Request.Form["udf9"];
                string VDesc = string.Empty;
                string signature = Request.Params["signature"].ToString();

                if (VpaymentStatus == "Ok")
                {
                    string respHashKey = AtomRespHashKey;
                    string ressignature = "";
                    string strsignature = Vmmp_txn + Vmer_txn + VpaymentStatus + VProdid + VDiscriminator + Vamount + Bankid;
                    byte[] bytes = Encoding.UTF8.GetBytes(respHashKey);
                    byte[] b = new System.Security.Cryptography.HMACSHA512(bytes).ComputeHash(Encoding.UTF8.GetBytes(strsignature));
                    ressignature = byteToHexString(b).ToLower();

                    if (signature == ressignature)
                    {
                        FeeReceiptPrintButton.Visible = !IsAdmissionForm;
                        UpdatePaymentTransaction(PaymentTransactionId, Vmer_txn, Int64.Parse(Vmmp_txn), VBankname, VDiscriminator, VCardNumber, Decimal.Parse(Vamount), TransactionResponse);
                        ThanksLabel.Text = "Thank you for Payment with us!";
                        //OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Vamount).ToString("0.00") + " for " + CollectionGroup + " Success.";
                        OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Vamount).ToString("0.00") + " for " + CollectionGroup + " has been success, and The Transaction Id is " + PaymentTransactionId;
                        OkDiv.Visible = true;
                        PrintButton.Visible = IsAdmissionForm;
                        PrintRecieptButton.Visible = IsAdmissionForm;
                    }
                    else
                    {
                        string SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + TransactionResponse + "' WHERE Id = " + PaymentTransactionId;
                        CommonFunctions cs = new CommonFunctions();
                        cs.GetDataset(SQL_String);
                        ThanksLabel.Text = "Sorry, Your payment did not go through.";
                        //FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Vamount).ToString("0.00") + " for " + CollectionGroup + " failed. Please try again or contact bank for issue.";
                        FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Vamount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                        FDiv.Visible = true;
                    }
                }
                else
                {
                    string SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + TransactionResponse + "' WHERE Id = " + PaymentTransactionId;
                    CommonFunctions cs = new CommonFunctions();
                    cs.GetDataset(SQL_String);
                    ThanksLabel.Text = "Sorry, Your payment did not go through.";
                    //FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Vamount).ToString("0.00") + " for " + CollectionGroup + " failed. Please try again or contact bank for issue.";
                    FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Vamount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                    FDiv.Visible = true;
                }
            }
        }
        catch (Exception)
        {
        }
    }

    private void GetCCAvenuePaymentStatus()
    {
        try
        {
            if (!string.IsNullOrEmpty(CCAvenueWorkingKey))
            {
                CCACrypto ccaCrypto = new CCACrypto();
                string encResponse = ccaCrypto.Decrypt(Request.Form["encResp"], CCAvenueWorkingKey);

                string TransactionResponse = encResponse;
                CommonHelper.LogWriter("CCAvenue enc Response : " + Request.Form["encResp"].ToString() + "\n CCAvenue dec Response : " + TransactionResponse, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);

                string[] segments = encResponse.Split('&');

                int segmentscount = segments.Length;
                if (segmentscount == 42 || segmentscount == 43 || segmentscount == 44 || segmentscount == 45)
                {
                    string OrderId = "", TrackingId = "", OrderStatus = "", Amount = "", StatusCode = "", PaymentMode = "", BankRefNo = "";
                    if (0 < segmentscount && segments[0] != null)
                    {
                        string[] parts = segments[0].Split('=');
                        OrderId = parts[1];
                    }
                    if (segments[1] != null && 1 < segmentscount)
                    {
                        string[] parts = segments[1].Split('=');
                        TrackingId = parts[1];
                    }
                    if (segments[2] != null && 2 < segmentscount)
                    {
                        string[] parts = segments[2].Split('=');
                        BankRefNo = parts[1];
                    }
                    if (3 < segmentscount && segments[3] != null)
                    {
                        string[] parts = segments[3].Split('=');
                        OrderStatus = parts[1];
                    }
                    if (5 < segmentscount && segments[5] != null)
                    {
                        string[] parts = segments[5].Split('=');
                        PaymentMode = parts[1];
                    }
                    if (6 < segmentscount && segments[6] != null)
                    {
                        string[] parts = segments[6].Split('=');
                        StatusCode = parts[1];
                    }
                    if (10 < segmentscount && segments[10] != null)
                    {
                        string[] parts = segments[10].Split('=');
                        Amount = parts[1];
                    }

                    if (OrderStatus == "Success" && Convert.ToInt64(OrderId) == PaymentTransactionId)
                    {
                        FeeReceiptPrintButton.Visible = !IsAdmissionForm;
                        CommonHelper.LogWriter("before success : ", 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);
                        UpdatePaymentTransaction(PaymentTransactionId, OrderId, Int64.Parse(TrackingId), StatusCode, PaymentMode, "", Decimal.Parse(Amount), TransactionResponse);
                        ThanksLabel.Text = "Thank you for Payment with us!";
                        //OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " Success.";
                        OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been success, and The Transaction Id is " + PaymentTransactionId;
                        OkDiv.Visible = true;
                        PrintButton.Visible = IsAdmissionForm;
                        PrintRecieptButton.Visible = IsAdmissionForm;
                    }
                    else if (OrderStatus == "Aborted" && Convert.ToInt64(OrderId) == PaymentTransactionId)
                    {
                        string SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + TransactionResponse + "' WHERE Id = " + PaymentTransactionId;
                        CommonFunctions cs = new CommonFunctions();
                        cs.GetDataset(SQL_String);
                        ThanksLabel.Text = "Sorry, Your payment did not go through.";
                    }
                    else
                    {
                        string SQL_String = string.Empty;
                        if (!string.IsNullOrEmpty(BankRefNo))
                            SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3, BankTransactionId=" + BankRefNo + ", TransactionResponse='" + TransactionResponse + "' WHERE Id = " + PaymentTransactionId;
                        else
                            SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + TransactionResponse + "' WHERE Id = " + PaymentTransactionId;

                        CommonFunctions cs = new CommonFunctions();
                        cs.GetDataset(SQL_String);

                        ThanksLabel.Text = "Sorry, Your payment did not go through.";
                        //FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " failed. Please try again or contact bank for issue.";
                        FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                        FDiv.Visible = true;
                    }
                }
                else
                {
                    ThanksLabel.Text = "Sorry, Your payment did not go through.";
                }
            }
        }
        catch (Exception)
        {
        }
    }

    private void GetPaytmPaymentStatus()
    {
        try
        {
            if (!string.IsNullOrEmpty(PaytmMerchantKey))
            {
                Dictionary<string, string> parameters = new Dictionary<string, string>();
                string paytmChecksum = " ";

                foreach (string key in Request.Form.Keys)
                {
                    parameters.Add(key.Trim(), Request.Form[key].Trim());
                }

                if (parameters.ContainsKey("CHECKSUMHASH"))
                {
                    paytmChecksum = parameters["CHECKSUMHASH"];
                    parameters.Remove("CHECKSUMHASH");
                }

                if (CheckSum.verifyCheckSum(PaytmMerchantKey, parameters, paytmChecksum))
                {
                    string TransactionResponse = Request.Form.ToString();
                    CommonHelper.LogWriter("PayTM Response : " + TransactionResponse, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);
                    string OrderId = " ", MID = " ", Amount = " ", Status = " ", BankTxnId = " ", PaymentMode = " ";

                    foreach (string key in Request.Form.Keys)
                    {
                        if (key.ToUpper() == "ORDERID")
                        {
                            OrderId = Request.Form[key].Trim();
                        }
                        if (key.ToUpper() == "MID")
                        {
                            MID = Request.Form[key].Trim();
                        }
                        if (key.ToUpper() == "TXNAMOUNT")
                        {
                            Amount = Request.Form[key].Trim();
                        }
                        if (key.ToUpper() == "PAYMENTMODE")
                        {
                            PaymentMode = Request.Form[key].Trim();
                        }
                        if (key.ToUpper() == "STATUS")
                        {
                            Status = Request.Form[key].Trim();
                        }
                        if (key.ToUpper() == "BANKTXNID")
                        {
                            BankTxnId = Request.Form[key].Trim();
                        }
                    }
                    CommonHelper.LogWriter("Form Data : " + Status, 1, "Payment Response", HttpContext.Current.Request.Url.AbsoluteUri);
                    if (Status == "TXN_SUCCESS")
                    {
                        CommonHelper.LogWriter("MID : " + MID, 1, "Payment Response", HttpContext.Current.Request.Url.AbsoluteUri);
                        string ResultCheckSum = string.Empty;
                        string STATUS = string.Empty;
                        string AMOUNT = string.Empty;
                        string ApiUrl = string.Empty;

                        Dictionary<string, string> DParameters = new Dictionary<string, string>();
                        DParameters.Add("MID", MID);
                        DParameters.Add("ORDER_ID", OrderId);
                        ResultCheckSum = CheckSum.generateCheckSum(PaytmMerchantKey, DParameters);

                        ApiUrl = PaytmStatusCheckURL;

                        if (!string.IsNullOrEmpty(ApiUrl))
                        {
                            var input = new
                            {
                                MID = MID,
                                ORDERID = OrderId,
                                CheckSum = ResultCheckSum
                            };
                            string inputJson = (new JavaScriptSerializer()).Serialize(input);
                            WebClient client = new WebClient();
                            client.Headers["Content-type"] = "application/json";
                            client.Encoding = Encoding.UTF8;
                            string json = client.UploadString(ApiUrl, inputJson);
                            CommonHelper.LogWriter("Form Data json: " + json, 1, "Payment Response", HttpContext.Current.Request.Url.AbsoluteUri);
                            TxnStatus objTxnStatus = (new JavaScriptSerializer()).Deserialize<TxnStatus>(json);

                            TxnStatus TxnStatusObject = new TxnStatus();
                            TxnStatusObject = objTxnStatus;

                            STATUS = TxnStatusObject.STATUS;
                            AMOUNT = TxnStatusObject.TXNAMOUNT;

                            if (STATUS == Status && AMOUNT == Amount)
                            {
                                Int64 BANKTXNID = 0;
                                bool IsValidBANKTXNID = IsNumeric(BankTxnId);
                                if (IsValidBANKTXNID == true)
                                    BANKTXNID = Convert.ToInt64(BankTxnId);
                                FeeReceiptPrintButton.Visible = !IsAdmissionForm;
                                UpdatePaymentTransaction(PaymentTransactionId, OrderId, BANKTXNID, "Paytm", PaymentMode, " ", Decimal.Parse(Amount), TransactionResponse);
                                ThanksLabel.Text = "Thank you for Payment with us!";
                                //OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " Success.";
                                OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been success, and The Transaction Id is " + PaymentTransactionId;
                                OkDiv.Visible = true;
                                PrintButton.Visible = IsAdmissionForm;
                                PrintRecieptButton.Visible = IsAdmissionForm;

                                CommonHelper.LogWriter("PaymentStatus : " + "Sucess", 1, "Payment Response", HttpContext.Current.Request.Url.AbsoluteUri);
                            }
                            else
                            {
                                string paymentstatuscheck = "Select TransactionStatusId FROM sOp.tPaymentTransaction WHERE Id = " + PaymentTransactionId;
                                CommonFunctions comf = new CommonFunctions();
                                DataSet statusDS = comf.GetDataset(paymentstatuscheck);
                                if (statusDS != null && statusDS.Tables[0].Rows.Count > 0)
                                {
                                    if (statusDS.Tables[0].Rows[0]["TransactionStatusId"].ToString() == "2" || statusDS.Tables[0].Rows[0]["TransactionStatusId"].ToString() == "4")
                                    {
                                        ThanksLabel.Text = "Thank you for Payment with us!";
                                        //OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " Success.";
                                        OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been success, and The Transaction Id is " + PaymentTransactionId;
                                        OkDiv.Visible = true;
                                    }
                                    else
                                    {
                                        ThanksLabel.Text = "Sorry, Your payment did not go through.";
                                        //FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " failed. Please try again or contact bank for issue.";
                                        FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                                        FDiv.Visible = true;
                                    }

                                }
                                else
                                {
                                    string SQL_String = string.Empty;
                                    SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + TransactionResponse + "' WHERE Id = " + PaymentTransactionId;
                                    CommonFunctions cs = new CommonFunctions();
                                    cs.GetDataset(SQL_String);
                                    ThanksLabel.Text = "Sorry, Your payment did not go through.";
                                    //FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " failed. Please try again or contact bank for issue.";
                                    FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                                    FDiv.Visible = true;
                                }
                            }
                        }
                    }
                    else
                    {
                        string paymentstatuscheck = "Select TransactionStatusId FROM sOp.tPaymentTransaction WHERE Id = " + PaymentTransactionId;
                        CommonFunctions comf = new CommonFunctions();
                        DataSet statusDS = comf.GetDataset(paymentstatuscheck);
                        if (statusDS != null && statusDS.Tables[0].Rows.Count > 0)
                        {
                            if (statusDS.Tables[0].Rows[0]["TransactionStatusId"].ToString() == "2" || statusDS.Tables[0].Rows[0]["TransactionStatusId"].ToString() == "4")
                            {
                                ThanksLabel.Text = "Thank you for Payment with us!";
                                //OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " Success.";
                                OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been success, and The Transaction Id is " + PaymentTransactionId;
                                OkDiv.Visible = true;
                            }
                            else
                            {
                                ThanksLabel.Text = "Sorry, Your payment did not go through.";
                                //FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " failed. Please try again or contact bank for issue.";
                                FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                                FDiv.Visible = true;
                            }
                        }
                        else
                        {
                            string SQL_String = string.Empty;
                            SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + TransactionResponse + "' WHERE Id = " + PaymentTransactionId;
                            CommonFunctions cs = new CommonFunctions();
                            cs.GetDataset(SQL_String);
                            ThanksLabel.Text = "Sorry, Your payment did not go through.";
                            //FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " failed. Please try again or contact bank for issue.";
                            FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                            FDiv.Visible = true;
                        }
                    }
                }
            }
        }
        catch (Exception ex)
        {

        }
    }

    private void GetPayUMoneyPaymentStatus()
    {
        try
        {
            if (!string.IsNullOrEmpty(PayUMoneySALT) && !string.IsNullOrEmpty(PayUMoneyHASHSEQUENCE))
            {
                string[] responce_out;
                string[] merc_hash_vars_seq;
                string merc_hash_string = string.Empty;
                string merc_hash = string.Empty;
                string order_id = string.Empty;
                string hash_seq = PayUMoneyHASHSEQUENCE;

                merc_hash_vars_seq = hash_seq.Split('|');
                Array.Reverse(merc_hash_vars_seq);
                merc_hash_string = PayUMoneySALT + "|" + Request.Form["status"];

                foreach (string merc_hash_var in merc_hash_vars_seq)
                {
                    merc_hash_string += "|";
                    merc_hash_string = merc_hash_string + (Request.Form[merc_hash_var] != null ? Request.Form[merc_hash_var] : "");
                }
                merc_hash = Generatehash512(merc_hash_string).ToLower();

                responce_out = merc_hash_string.Split('|');
                CommonHelper.LogWriter("PayUMoney : " + merc_hash, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);
                string Amount = responce_out[15].ToString();
                if (Request.Form["status"] == "success")
                {
                    FeeReceiptPrintButton.Visible = !IsAdmissionForm;
                    UpdatePaymentTransaction(PaymentTransactionId, order_id, Int64.Parse(order_id), "Pay U Money", "NB", "", Decimal.Parse(Amount), merc_hash_string);
                    ThanksLabel.Text = "Thank you for Payment with us!";
                    //OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " Success.";
                    OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been success, and The Transaction Id is " + PaymentTransactionId;
                    OkDiv.Visible = true;
                    PrintButton.Visible = IsAdmissionForm;
                    PrintRecieptButton.Visible = IsAdmissionForm;
                }
                else
                {
                    string SQL_String = string.Empty;
                    SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + merc_hash_string + "' WHERE Id = " + PaymentTransactionId;
                    CommonFunctions cs = new CommonFunctions();
                    cs.GetDataset(SQL_String);

                    ThanksLabel.Text = "Sorry, Your payment did not go through.";
                    //FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " failed. Please try again or contact bank for issue.";
                    FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                    FDiv.Visible = true;
                }
            }
        }
        catch (Exception)
        {

        }
    }

    private void GetBillDeskOldPaymentStatus()
    {
        try
        {
            string TransactionResponse = Request.Form["msg"];
            CommonHelper.LogWriter("BillDeskOld : " + TransactionResponse, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);
            string[] segments = TransactionResponse.Split('|');
            int segmentscount = segments.Length;

            if (segmentscount == 26)
            {
                string AuthStatus = segments[14];
                string Amount = segments[4];
                string BankID = segments[5];
                string BankMerchantID = segments[3];

                if (AuthStatus == "0300")
                {
                    FeeReceiptPrintButton.Visible = !IsAdmissionForm;
                    UpdatePaymentTransaction(PaymentTransactionId, PaymentTransactionId.ToString(), Int64.Parse(BankMerchantID), BankID, "Online Payment", "", Decimal.Parse(Amount), TransactionResponse);
                    ThanksLabel.Text = "Thank you for Payment with us!";
                    //OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " Success.";
                    OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been success, and The Transaction Id is " + PaymentTransactionId;
                    OkDiv.Visible = true;
                    PrintButton.Visible = IsAdmissionForm;
                    PrintRecieptButton.Visible = IsAdmissionForm;
                }
                else
                {
                    string SQL_String = string.Empty;
                    SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + TransactionResponse + "' WHERE Id = " + PaymentTransactionId;
                    CommonFunctions cs = new CommonFunctions();
                    cs.GetDataset(SQL_String);

                    ThanksLabel.Text = "Sorry, Your payment did not go through.";
                    //FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " failed. Please try again or contact bank for issue.";
                    FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                    FDiv.Visible = true;
                }
            }
            else
            {
                ThanksLabel.Text = "Sorry, Your payment did not go through.";
            }
        }
        catch (Exception)
        {

        }
    }

    private void GetPayUBizPaymentStatus()
    {
        try
        {
            if (!string.IsNullOrEmpty(PayUMoneySALT) && !string.IsNullOrEmpty(PayUMoneyHASHSEQUENCE))
            {
                string[] responce_out;
                string[] merc_hash_vars_seq;
                string merc_hash_string = string.Empty;
                string merc_hash = string.Empty;
                string order_id = string.Empty;
                string hash_seq = PayUMoneyHASHSEQUENCE;

                merc_hash_vars_seq = hash_seq.Split('|');
                Array.Reverse(merc_hash_vars_seq);
                merc_hash_string = PayUMoneySALT + "|" + Request.Form["status"];

                foreach (string merc_hash_var in merc_hash_vars_seq)
                {
                    merc_hash_string += "|";
                    merc_hash_string = merc_hash_string + (Request.Form[merc_hash_var] != null ? Request.Form[merc_hash_var] : "");
                }
                merc_hash = Generatehash512(merc_hash_string).ToLower();
                CommonHelper.LogWriter("PayUBiz : " + merc_hash, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);

                responce_out = merc_hash_string.Split('|');
                string Amount = responce_out[15].ToString();
                if (Request.Form["status"] == "success")
                {
                    FeeReceiptPrintButton.Visible = !IsAdmissionForm;
                    UpdatePaymentTransaction(PaymentTransactionId, order_id, Int64.Parse(order_id), "Pay U Biz", "NB", "", Decimal.Parse(Amount), merc_hash_string);
                    ThanksLabel.Text = "Thank you for Payment with us!";
                    //OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " Success.";
                    OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been success, and The Transaction Id is " + PaymentTransactionId;
                    OkDiv.Visible = true;
                    PrintButton.Visible = IsAdmissionForm;
                    PrintRecieptButton.Visible = IsAdmissionForm;
                }
                else
                {
                    string SQL_String = string.Empty;
                    SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + merc_hash_string + "' WHERE Id = " + PaymentTransactionId;
                    CommonFunctions cs = new CommonFunctions();
                    cs.GetDataset(SQL_String);

                    ThanksLabel.Text = "Sorry, Your payment did not go through.";
                    //FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " failed. Please try again or contact bank for issue.";
                    FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                    FDiv.Visible = true;
                }
            }
        }
        catch (Exception)
        {

        }
    }

    private void GetBillDeskNewPaymentStatus()
    {
        try
        {
            string TransactionResponse = Request.Form["msg"];
            CommonHelper.LogWriter("BillDeskNew : " + TransactionResponse, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);
            string[] segments = TransactionResponse.Split('|');
            int segmentscount = segments.Length;

            if (segmentscount == 26)
            {
                string AuthStatus = segments[14];
                string Amount = segments[4];
                string BankID = segments[5];
                string BankMerchantID = segments[3];

                if (AuthStatus == "0300")
                {
                    FeeReceiptPrintButton.Visible = !IsAdmissionForm;
                    UpdatePaymentTransaction(PaymentTransactionId, PaymentTransactionId.ToString(), Int64.Parse(BankMerchantID), BankID, "Online Payment", "", Decimal.Parse(Amount), TransactionResponse);
                    ThanksLabel.Text = "Thank you for Payment with us!";
                    //OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " Success.";
                    OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been success, and The Transaction Id is " + PaymentTransactionId;
                    OkDiv.Visible = true;
                    PrintButton.Visible = IsAdmissionForm;
                    PrintRecieptButton.Visible = IsAdmissionForm;
                }
                else
                {
                    string SQL_String = string.Empty;
                    SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + TransactionResponse + "' WHERE Id = " + PaymentTransactionId;
                    CommonFunctions cs = new CommonFunctions();
                    cs.GetDataset(SQL_String);

                    ThanksLabel.Text = "Sorry, Your payment did not go through.";
                    //FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " failed. Please try again or contact bank for issue.";
                    FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(Amount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                    FDiv.Visible = true;
                }
            }
            else
            {
                ThanksLabel.Text = "Sorry, Your payment did not go through.";
            }
        }
        catch
        {

        }
    }

    #region Easebuzz
    private void GetEasebuzzPaymentStatus()
    {
        StringBuilder sb = new StringBuilder();
        try
        {
            NameValueCollection nvc = Request.Form;
            if (nvc.Count > 0)
            {
                CommonFunctions cf = new CommonFunctions();
                string TransactionRequest = "Select TransactionRequest from sOp.tPaymentTransaction Where Id=" + PaymentTransactionId;
                DataSet TransactionRequestDS = cf.GetDataset(TransactionRequest);
                string ActualRequest = string.Empty, req_gen_hash = string.Empty;
                string[] merc_hash_vars_seq;
                string merc_hash_string = string.Empty;
                string hash_seq = "key|txnid|amount|productinfo|firstname|email|udf1|udf2|udf3|udf4|udf5|udf6|udf7|udf8|udf9|udf10";
                string merc_hash = string.Empty, req_merc_hash = string.Empty;
                string order_id = string.Empty;
                if (TransactionRequestDS != null && TransactionRequestDS.Tables.Count > 0 && TransactionRequestDS.Tables[0] != null && TransactionRequestDS.Tables[0].Rows.Count > 0)
                {
                    ActualRequest = TransactionRequestDS.Tables[0].Rows[0]["TransactionRequest"].ToString();
                    CommonHelper.LogWriter("Easebuzz Actual Transaction Request : " + ActualRequest, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);
                    if (!string.IsNullOrEmpty(ActualRequest))
                    {
                        var keyValuePairs = new Dictionary<string, string>();
                        var queryParameters = ActualRequest.Split('&');

                        foreach (var parameter in queryParameters)
                        {
                            var keyValuePair = parameter.Split(new[] { '=' }, 2);
                            if (keyValuePair.Length == 2)
                            {
                                if (HttpUtility.UrlDecode(keyValuePair[0]) == "amount")
                                {
                                    keyValuePair[1] = !keyValuePair[1].ToString().Trim().Contains(".") ? keyValuePair[1] + ".0" : keyValuePair[1];
                                }
                                keyValuePairs.Add(HttpUtility.UrlDecode(keyValuePair[0]), HttpUtility.UrlDecode(keyValuePair[1]));
                            }
                        }
                        req_gen_hash = EasebuzzSalt
                            + "|" + Request.Form["status"] + "|" + keyValuePairs["udf10"]
                            + "|" + keyValuePairs["udf9"] + "|" + keyValuePairs["udf8"]
                            + "|" + keyValuePairs["udf7"] + "|" + keyValuePairs["udf6"]
                            + "|" + keyValuePairs["udf5"] + "|" + keyValuePairs["udf4"]
                            + "|" + keyValuePairs["udf3"] + "|" + keyValuePairs["udf2"]
                            + "|" + keyValuePairs["udf1"] + "|" + keyValuePairs["email"]
                            + "|" + keyValuePairs["firstname"] + "|" + keyValuePairs["productinfo"]
                            + "|" + keyValuePairs["amount"] + "|" + keyValuePairs["txnid"]
                            + "|" + keyValuePairs["key"];
                        req_merc_hash = Easebuzz_Generatehash512(req_gen_hash).ToLower();
                        CommonHelper.LogWriter("Easebuzz Transaction Request Hash: " + req_merc_hash, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);
                    }
                }
                merc_hash_vars_seq = hash_seq.Split('|');
                Array.Reverse(merc_hash_vars_seq);
                merc_hash_string = EasebuzzSalt + "|" + Request.Form["status"];

                foreach (string merc_hash_var in merc_hash_vars_seq)
                {
                    merc_hash_string += "|";
                    merc_hash_string = merc_hash_string + (Request.Form[merc_hash_var] != null ? Request.Form[merc_hash_var] : "");
                }
                merc_hash = Easebuzz_Generatehash512(merc_hash_string).ToLower();

                string TransactionResponse = Request.Form.ToString();
                CommonHelper.LogWriter("Easebuzz Response Response Hash: " + merc_hash_string, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);
                CommonHelper.LogWriter("Easebuzz Request Form Hash : " + Request.Form["hash"], 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);
                string txnid = nvc["txnid"].ToString(); //Easebuzz txn id
                string amount = Request.Form["amount"]; //Amount
                string status = Request.Form["status"]; //Status
                string easepayid = Request.Form["easepayid"]; //EasepayId

                if (merc_hash == Request.Form["hash"] && req_merc_hash == merc_hash && req_merc_hash == Request.Form["hash"])
                {
                    if (status.ToLower() == "success" && txnid == PaymentTransactionId.ToString())
                    {
                        FeeReceiptPrintButton.Visible = !IsAdmissionForm;
                        UpdatePaymentTransaction(PaymentTransactionId, txnid, Int64.Parse(txnid), "Easebuzz", "NB", "", Decimal.Parse(amount), merc_hash_string);
                        ThanksLabel.Text = "Thank you for Payment with us!";
                        //OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(amount).ToString("0.00") + " for " + CollectionGroup + " Success.";
                        OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(amount).ToString("0.00") + " for " + CollectionGroup + " has been success, and The Transaction Id is " + PaymentTransactionId;
                        OkDiv.Visible = true;
                        PrintButton.Visible = IsAdmissionForm;
                        PrintRecieptButton.Visible = IsAdmissionForm;
                    }
                    else if (status.ToLower() == "usercancelled")
                    {
                        string SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + TransactionResponse + "' WHERE Id = " + PaymentTransactionId;
                        CommonFunctions cs = new CommonFunctions();
                        cs.GetDataset(SQL_String);
                        //ThanksLabel.Text = "Your payment of Rs." + decimal.Parse(amount).ToString("0.00") + " for " + CollectionGroup + " is Pending. Please try again or contact bank for issue.";
                        ThanksLabel.Text = "Your payment of Rs." + decimal.Parse(amount).ToString("0.00") + " for " + CollectionGroup + " is Pending, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                    }
                    else if (status.ToLower() == "initiated" || status.ToLower() == "pending")
                    {
                        string SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 1,TransactionResponse='" + TransactionResponse + "' WHERE Id = " + PaymentTransactionId;
                        CommonFunctions cs = new CommonFunctions();
                        cs.GetDataset(SQL_String);
                        //ThanksLabel.Text = "Your payment of Rs." + decimal.Parse(amount).ToString("0.00") + " for " + CollectionGroup + " is Pending. Please try again or contact bank for issue.";
                        ThanksLabel.Text = "Your payment of Rs." + decimal.Parse(amount).ToString("0.00") + " for " + CollectionGroup + " is Pending, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                    }
                    else
                    {
                        string SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + TransactionResponse + "' WHERE Id = " + PaymentTransactionId;
                        CommonFunctions cs = new CommonFunctions();
                        cs.GetDataset(SQL_String);
                        ThanksLabel.Text = "Sorry, Your payment did not go through.";
                        //FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(amount).ToString("0.00") + " for " + CollectionGroup + " failed. Please try again or contact bank for issue.";
                        FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(amount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                        FDiv.Visible = true;
                    }
                }
                else
                {
                    string SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + TransactionResponse + "' WHERE Id = " + PaymentTransactionId;
                    CommonFunctions cs = new CommonFunctions();
                    cs.GetDataset(SQL_String);
                    ThanksLabel.Text = "Sorry, Your payment did not go through.";
                    //FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(amount).ToString("0.00") + " for " + CollectionGroup + " failed. Please try again or contact bank for issue.";
                    FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(amount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                    FDiv.Visible = true;
                }
            }
            else
            {
                //string SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + TransactionResponse + "' WHERE Id = " + PaymentTransactionId;
                //CommonFunctions cs = new CommonFunctions();
                //cs.GetDataset(SQL_String);
                ThanksLabel.Text = "Sorry, Your payment did not go through.";
            }
        }
        catch (Exception)
        {
        }
    }
    // hashcode generation
    public string Easebuzz_Generatehash512(string text)
    {

        byte[] message = Encoding.UTF8.GetBytes(text);

        UnicodeEncoding UE = new UnicodeEncoding();
        byte[] hashValue;
        SHA512Managed hashString = new SHA512Managed();
        string hex = "";
        hashValue = hashString.ComputeHash(message);
        foreach (byte x in hashValue)
        {
            hex += String.Format("{0:x2}", x);
        }
        return hex;

    }
    #endregion

    #region Hesabe
    private void GetHesabePaymentStatus()
    {
        try
        {
            string TransactionResponse = Request.QueryString["data"];
            string sql_query = string.Empty;
            if (!IsAdmissionForm)
            {
                sql_query = "SELECT TOP 1 ISNULL(GP.HesabeAccessCode,'') AS HesabeAccessCode,ISNULL(GP.HesabeMerchantKey,'') AS HesabeMerchantKey,ISNULL(GP.HesabeMerchantIV,'') AS HesabeMerchantIV,ISNULL(GP.HesabeMerchantCode,'') AS HesabeMerchantCode FROM sOp.tGatewayproduct GP"
                    + " INNER JOIN sOp.tGatewayConfiguration GC ON GC.Id = GP.GatewayConfigurationId"
                    + " INNER JOIN sOp.tGatewayProductReceiptBookMapping GPRBM ON GPRBM.GatewayProductId = GP.Id"
                    + " INNER JOIN sOp.tPaymentTransaction PT ON PT.PaymentGatewayId = GC.PaymentGatewayId"
                    + " INNER JOIN sFee.tOnlineFee TOF ON TOF.Id = PT.TransactionSourceId AND GPRBM.ReceiptBookId = TOF.ReceiptBookId"
                    + " WHERE PT.PaymentGatewayId = 17 AND PT.TransactionSourceTypeId = 2024 AND PT.Id = " + PaymentTransactionId;
            }
            else
            {
                sql_query = "SELECT TOP 1 ISNULL(GP.HesabeAccessCode,'') AS HesabeAccessCode,ISNULL(GP.HesabeMerchantKey,'') AS HesabeMerchantKey,ISNULL(GP.HesabeMerchantIV,'') AS HesabeMerchantIV,ISNULL(GP.HesabeMerchantCode,'') AS HesabeMerchantCode FROM sOp.tGatewayproduct GP"
                    + " INNER JOIN sOp.tGatewayConfiguration GC ON GC.Id = GP.GatewayConfigurationId"
                    + " INNER JOIN sOp.tGatewayProductReceiptBookMapping GPRBM ON GPRBM.GatewayProductId = GP.Id"
                    + " INNER JOIN sOp.tPaymentTransaction PT ON PT.PaymentGatewayId = GC.PaymentGatewayId"
                    + " INNER JOIN sAdmission.tAdmissionForm AF ON AF.Id = PT.TransactionSourceId"
                    + " INNER JOIN sAdmission.tAdmissionCriteria AFC ON AF.ForClassId = AFC.ClassId AND AF.BatchId = AFC.BatchId AND GPRBM.ReceiptBookId = AFC.ReceiptBookId"
                    + " WHERE PT.PaymentGatewayId = 17 AND PT.TransactionSourceTypeId = 2027 AND ISNULL(IsPayFormFeeOnline,0) = 1 AND PT.Id = " + PaymentTransactionId;
            }
            string HesabeMerchantKey = "", HesabeMerchantIV = "";
            CommonFunctions cf = new CommonFunctions();
            DataSet DS = cf.GetDataset(sql_query);
            if (DS != null && DS.Tables.Count > 0 && DS.Tables[0].Rows.Count > 0)
            {
                HesabeMerchantKey = DS.Tables[0].Rows[0]["HesabeMerchantKey"].ToString();
                HesabeMerchantIV = DS.Tables[0].Rows[0]["HesabeMerchantIV"].ToString();
            }
            if (!string.IsNullOrEmpty(TransactionResponse) && !string.IsNullOrEmpty(HesabeMerchantKey) && !string.IsNullOrEmpty(HesabeMerchantIV))
            {
                // Initialize the HesabeCrypt encryption/decryption library using the KEY and IV from the configuration
                var hesabeCrypt = new HesabeCrypt(HesabeMerchantKey, HesabeMerchantIV);

                //Decrypt the response recieved in the data query string 
                var dataDecrypted = hesabeCrypt.Decrypt(TransactionResponse);

                //Trim the junk characters from the derypted response if any.
                dataDecrypted = dataDecrypted.Substring(0, dataDecrypted.LastIndexOf("}") + 1);

                //Desrialize the decrypted response
                var paymentResponse = JsonConvert.DeserializeObject<HesabePaymentResponse>(dataDecrypted);

                if (paymentResponse.Status)
                {
                    FeeReceiptPrintButton.Visible = !IsAdmissionForm;
                    UpdatePaymentTransaction(PaymentTransactionId, paymentResponse.Response.OrderReferenceNumber, Int64.Parse(paymentResponse.Response.OrderReferenceNumber), "Hesabe", "NB", "", Convert.ToDecimal(paymentResponse.Response.Amount), dataDecrypted);
                    ThanksLabel.Text = "Thank you for Payment with us!";
                    OKPaymentStatusLabel.Text = "Your payment of Rs." + Convert.ToDecimal(paymentResponse.Response.Amount).ToString("0.00") + " for " + CollectionGroup + " has been success, and The Transaction Id is " + PaymentTransactionId;
                    OkDiv.Visible = true;
                    PrintButton.Visible = IsAdmissionForm;
                    PrintRecieptButton.Visible = IsAdmissionForm;
                }
                else
                {
                    string SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + dataDecrypted + "' WHERE Id = " + PaymentTransactionId;
                    CommonFunctions cs = new CommonFunctions();
                    cs.GetDataset(SQL_String);
                    ThanksLabel.Text = "Sorry, Your payment did not go through.";
                    FPaymentStatusLabel.Text = "Your payment of Rs." + Convert.ToDecimal(paymentResponse.Response.Amount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                    FDiv.Visible = true;
                }
            }
            else
            {
                ThanksLabel.Text = "Sorry, Your payment did not go through.";
            }
        }
        catch (Exception)
        {
        }
    }
    #endregion
    //For Mantis 0034589 by Foram Start
    #region Razorpay Collect Now
    private void GetRazorPayCollectNowPaymentStatus()
    {
        try
        {
            NameValueCollection nvc = Request.Form;
            if (nvc.Count > 0)
            {
                string sql_query = string.Empty;
                if (!IsAdmissionForm)
                {
                    sql_query = "SELECT TOP 1 ISNULL(GP.RazorpayCollectNowMID,'') AS RazorpayCollectNowMID,ISNULL(GP.RazorpayCollectNowKeyID,'') AS RazorpayCollectNowKeyID,ISNULL(GP.RazorpayCollectNowSecretKey,'') AS RazorpayCollectNowSecretKey, ISNULL(PT.PayAmount, 0) AS PayAmount FROM sOp.tGatewayproduct GP"
                        + " INNER JOIN sOp.tGatewayConfiguration GC ON GC.Id = GP.GatewayConfigurationId"
                        + " INNER JOIN sOp.tGatewayProductReceiptBookMapping GPRBM ON GPRBM.GatewayProductId = GP.Id"
                        + " INNER JOIN sOp.tPaymentTransaction PT ON PT.PaymentGatewayId = GC.PaymentGatewayId"
                        + " INNER JOIN sFee.tOnlineFee TOF ON TOF.Id = PT.TransactionSourceId AND GPRBM.ReceiptBookId = TOF.ReceiptBookId"
                        + " WHERE PT.PaymentGatewayId = 18 AND PT.TransactionSourceTypeId = 2024 AND PT.Id = " + PaymentTransactionId;
                }
                else
                {
                    sql_query = "SELECT TOP 1 ISNULL(GP.RazorpayCollectNowMID,'') AS RazorpayCollectNowMID,ISNULL(GP.RazorpayCollectNowKeyID,'') AS RazorpayCollectNowKeyID,ISNULL(GP.RazorpayCollectNowSecretKey,'') AS RazorpayCollectNowSecretKey, ISNULL(PT.PayAmount, 0) AS PayAmount FROM sOp.tGatewayproduct GP"
                        + " INNER JOIN sOp.tGatewayConfiguration GC ON GC.Id = GP.GatewayConfigurationId"
                        + " INNER JOIN sOp.tGatewayProductReceiptBookMapping GPRBM ON GPRBM.GatewayProductId = GP.Id"
                        + " INNER JOIN sOp.tPaymentTransaction PT ON PT.PaymentGatewayId = GC.PaymentGatewayId"
                        + " INNER JOIN sAdmission.tAdmissionForm AF ON AF.Id = PT.TransactionSourceId"
                        + " INNER JOIN sAdmission.tAdmissionCriteria AFC ON AF.ForClassId = AFC.ClassId AND AF.BatchId = AFC.BatchId AND GPRBM.ReceiptBookId = AFC.ReceiptBookId"
                        + " WHERE PT.PaymentGatewayId = 18 AND PT.TransactionSourceTypeId = 2027 AND ISNULL(IsPayFormFeeOnline,0) = 1 AND PT.Id = " + PaymentTransactionId;
                }
                string RazorpayCollectNowMID = "", RazorpayCollectNowKeyID = "", RazorpayCollectNowSecretKey = "", PayAmount = "";
                CommonFunctions cf = new CommonFunctions();
                DataSet DS = cf.GetDataset(sql_query);
                if (DS != null && DS.Tables.Count > 0 && DS.Tables[0].Rows.Count > 0)
                {
                    RazorpayCollectNowMID = DS.Tables[0].Rows[0]["RazorpayCollectNowMID"].ToString();
                    RazorpayCollectNowKeyID = DS.Tables[0].Rows[0]["RazorpayCollectNowKeyID"].ToString();
                    RazorpayCollectNowSecretKey = DS.Tables[0].Rows[0]["RazorpayCollectNowSecretKey"].ToString();
                    PayAmount = DS.Tables[0].Rows[0]["PayAmount"].ToString();
                }
                if (!string.IsNullOrEmpty(RazorpayCollectNowMID) && !string.IsNullOrEmpty(RazorpayCollectNowKeyID) && !string.IsNullOrEmpty(RazorpayCollectNowSecretKey))
                {
                    string TransactionRequest = "Select TransactionRequest from sOp.tPaymentTransaction Where Id=" + PaymentTransactionId;
                    DataSet TransactionRequestDS = cf.GetDataset(TransactionRequest);
                    string ActualOrderId = string.Empty, ActualRequest = string.Empty;
                    if (TransactionRequestDS != null && TransactionRequestDS.Tables.Count > 0 && TransactionRequestDS.Tables[0] != null && TransactionRequestDS.Tables[0].Rows.Count > 0)
                    {
                        ActualRequest = TransactionRequestDS.Tables[0].Rows[0]["TransactionRequest"].ToString();

                        if (!string.IsNullOrEmpty(ActualRequest))
                        {
                            string[] RequestArray = ActualRequest.Split('&');
                            ActualRequest = RequestArray[2].Substring(9);
                            ActualOrderId = ActualRequest;
                        }
                    }

                    string paymentId = Request.Form["razorpay_payment_id"];
                    string Orderid = Request.Form["razorpay_order_id"];
                    string razorpay_signature = Request.Form["razorpay_signature"];

                    if (ActualOrderId == Orderid)
                    {
                        string Actual_generated_signature = calculateRFC2104HMAC(ActualOrderId + "|" + Request.Form["razorpay_payment_id"], RazorpayCollectNowSecretKey);
                        string generated_signature = calculateRFC2104HMAC(Orderid + "|" + Request.Form["razorpay_payment_id"], RazorpayCollectNowSecretKey);
                        string responseData;
                        responseData = "Key=" + RazorpayCollectNowKeyID
                            + "&Paymentid=" + Request.Form["razorpay_payment_id"]
                            + "&Orderid=" + Request.Form["razorpay_order_id"]
                            + "&Response_Signature=" + Request.Form["razorpay_signature"]
                            + "&PaymentTransactionId=" + PaymentTransactionId
                            + "&Actual_Generated_Signature=" + Actual_generated_signature
                            + "&Generated_Signature=" + generated_signature;

                        if (generated_signature == razorpay_signature && Actual_generated_signature == generated_signature && Actual_generated_signature == razorpay_signature)
                        {
                            FeeReceiptPrintButton.Visible = !IsAdmissionForm;
                            UpdatePaymentTransaction(PaymentTransactionId, PaymentTransactionId.ToString(), PaymentTransactionId, "RazorPayCollectNow", "NB", "", Convert.ToDecimal(PayAmount), responseData);
                            ThanksLabel.Text = "Thank you for Payment with us!";
                            OKPaymentStatusLabel.Text = "Your payment of Rs." + Convert.ToDecimal(PayAmount).ToString("0.00") + " for " + CollectionGroup + " has been success, and The Transaction Id is " + PaymentTransactionId;
                            OkDiv.Visible = true;
                            PrintButton.Visible = IsAdmissionForm;
                            PrintRecieptButton.Visible = IsAdmissionForm;
                        }
                        else
                        {
                            string SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + responseData + "' WHERE Id = " + PaymentTransactionId;
                            CommonFunctions cs = new CommonFunctions();
                            cs.GetDataset(SQL_String);
                            ThanksLabel.Text = "Sorry, Your payment did not go through.";
                            FPaymentStatusLabel.Text = "Your payment of Rs." + Convert.ToDecimal(PayAmount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                            FDiv.Visible = true;
                        }
                    }
                    else
                    {
                        string TransactionResponse = "OrderIdNotMatched";
                        if (string.IsNullOrEmpty(Orderid)) { TransactionResponse = "Transaction Failed or OrderId Is null"; }
                        string SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + TransactionResponse + "' WHERE Id = " + PaymentTransactionId;
                        CommonFunctions cs = new CommonFunctions();
                        cs.GetDataset(SQL_String);
                        ThanksLabel.Text = "Sorry, Your payment did not go through.";
                        FPaymentStatusLabel.Text = "Your payment of Rs." + Convert.ToDecimal(PayAmount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                        FDiv.Visible = true;
                    }
                }
                else
                {
                    ThanksLabel.Text = "Sorry, Your payment did not go through.";
                }
            }
        }
        catch (Exception)
        {
        }
    }
    public string calculateRFC2104HMAC(String data, String secret)
    {
        string result = "";
        try
        {
            using (HMACSHA256 hmac = new HMACSHA256(Encoding.ASCII.GetBytes(secret)))
            {
                var payload = Encoding.ASCII.GetBytes(data);
                var rawHmac = hmac.ComputeHash(payload);
                result = HashEncode(rawHmac);
            }
        }
        catch (Exception e)
        {
        }
        return result;
    }
    private string HashEncode(byte[] hash)
    {
        return BitConverter.ToString(hash).Replace("-", "").ToLower();
    }
    #endregion
    //For Mantis 0034589 by Foram End
    protected void loginButton_Click(object sender, EventArgs e)
    {
        if (IsAdmissionFormHiddenField.Value == "False")
            Response.Redirect("~/Pages/BaseFramework/Security/Login.aspx?OrgGroupId=" + ConfigurationManager.AppSettings["DefaultOrgGroupId"] + "&PaymentResponse=1"); //Changes for Mantis Id:0030874
        else if (IsAdmissionFormHiddenField.Value == "True")
            Response.Redirect("~/Pages/OnlineAdmission/AdmissionHome.aspx?OrgGroupId=" + ConfigurationManager.AppSettings["DefaultOrgGroupId"] + "&OrgId");
    }

    public static string byteToHexString(byte[] byData)
    {
        StringBuilder sb = new StringBuilder((byData.Length * 2));
        for (int i = 0; (i < byData.Length); i++)
        {
            int v = (byData[i] & 255);
            if ((v < 16))
            {
                sb.Append('0');
            }
            sb.Append(v.ToString("X"));
        }
        return sb.ToString();
    }

    public string Generatehash512(string text)
    {
        byte[] message = Encoding.UTF8.GetBytes(text);
        UnicodeEncoding UE = new UnicodeEncoding();
        byte[] hashValue;
        SHA512Managed hashString = new SHA512Managed();
        string hex = "";
        hashValue = hashString.ComputeHash(message);
        foreach (byte x in hashValue)
        {
            hex += String.Format("{0:x2}", x);
        }
        return hex;
    }

    protected void UpdatePaymentTransaction(Int64 PaymentTransactionId, String MerchantTransactionId, Int64 BankTransactionId, String BankName, String PaymentType, String CardNumber, Decimal Amount, string TransactionResponse)
    {
        string SQL_PaymentTransaction = "IF NOT EXISTS(SELECT 1 FROM [sFee].[tReceipt] WHERE [PaymentTransactionId] = " + PaymentTransactionId + ") SELECT 1 AS PaymentTransactionExists";
        CommonFunctions CF = new CommonFunctions();
        DataSet PaymentTransactionDS = CF.GetDataset(SQL_PaymentTransaction);
        CommonHelper.LogWriter("Update Transaction: " + PaymentTransactionId, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);
        if (PaymentTransactionDS != null && PaymentTransactionDS.Tables.Count > 0 && PaymentTransactionDS.Tables[0] != null && PaymentTransactionDS.Tables[0].Rows.Count > 0)
        {
            List<DataParameter> dp = new List<DataParameter>();
            DataParameter d;

            d = new DataParameter { Name = "@rPaymentTransactionId", Value = PaymentTransactionId, DataType = System.Data.DbType.Int64 };
            dp.Add(d);

            d = new DataParameter { Name = "@rMerchantTransactionId", Value = MerchantTransactionId, DataType = System.Data.DbType.String };
            dp.Add(d);

            d = new DataParameter { Name = "@rBankTransactionId", Value = BankTransactionId, DataType = System.Data.DbType.Int64 };
            dp.Add(d);

            d = new DataParameter { Name = "@rBankName", Value = BankName, DataType = System.Data.DbType.String };
            dp.Add(d);

            d = new DataParameter { Name = "@rPaymentType", Value = PaymentType, DataType = System.Data.DbType.String };
            dp.Add(d);

            d = new DataParameter { Name = "@rCardNumber", Value = CardNumber, DataType = System.Data.DbType.String };
            dp.Add(d);

            d = new DataParameter { Name = "@rTransactionResponse", Value = TransactionResponse, DataType = System.Data.DbType.String };
            dp.Add(d);

            CommonFunctions cf = new CommonFunctions();
            DataSet ds = cf.GetDatasetFromSp("sOp.pPaymentTransactionUpdate", dp);

            if (ds != null && ds.Tables[0] != null && ds.Tables[0].Rows.Count > 0 && Int64.Parse(ds.Tables[0].Rows[0][0].ToString()) > 0)
            {
                string SQL_String = string.Empty;
                SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 2 WHERE Id = " + PaymentTransactionId;
                CommonFunctions cs = new CommonFunctions();
                cs.GetDataset(SQL_String);

                Int64 TransactionSourceId = 0;
                SQL_String = "SELECT TransactionSourceId FROM sOp.tPaymentTransaction WHERE Id = " + PaymentTransactionId;
                DataSet Ds = cs.GetDataset(SQL_String);

                if (Ds != null && Ds.Tables[0].Rows.Count > 0)
                {
                    CommonHelper.LogWriter("before Receipt created : ", 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);
                    TransactionSourceId = Convert.ToInt64(Ds.Tables[0].Rows[0][0].ToString());

                    if (IsAdmissionForm == false)
                        CreateFeeReceipt(BankName, PaymentTransactionId);
                    else if (IsAdmissionForm == true)
                        CreateAdmissionFormReceipt(BankName, PaymentTransactionId, TransactionSourceId, Amount.ToString());
                }
            }
        }
    }
    private bool IsNumeric(string InputString)
    {
        bool IsNumber = true;
        try
        {
            Int64.Parse(InputString);
            IsNumber = true;
        }
        catch (Exception)
        {
            IsNumber = false;
        }
        return IsNumber;
    }
    private void GetEazyPayPaymentStatus()
    {
        try
        {
            string TransactionResponse = Request.Form.ToString();
            CommonHelper.LogWriter("EazyPay : " + TransactionResponse, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);

            if (Request.Form.Count > 0)
            {
                string EazyPay_txnid = Request.Form["Unique Ref Number"].ToString();
                string EazyPay_Status = Request.Form["Response Code"].ToString();
                string mer_txnid = Request.Form["ReferenceNo"].ToString();
                string amount = Request.Form["Transaction Amount"].ToString();
                string Payment_method = Request.Form["Payment Mode"].ToString();
                CommonHelper.LogWriter("EazyPay mer_txnid in method: " + mer_txnid, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);
                Int64 transactionid = Convert.ToInt64(mer_txnid);
                if (EazyPay_Status == "E000")
                {
                    FeeReceiptPrintButton.Visible = !IsAdmissionForm;
                    UpdatePaymentTransaction(transactionid, mer_txnid.ToString(), Int64.Parse(EazyPay_txnid.ToString()), "ICICI-EazyPay", Payment_method.ToString(), "", Decimal.Parse(amount.ToString()), TransactionResponse);
                    ThanksLabel.Text = "Thank you for Payment with us!";
                    //OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(amount).ToString("0.00") + " for " + CollectionGroup + " Success.";
                    OKPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(amount).ToString("0.00") + " for " + CollectionGroup + " has been success, and The Transaction Id is " + PaymentTransactionId;
                    OkDiv.Visible = true;
                    PrintButton.Visible = IsAdmissionForm;
                    PrintRecieptButton.Visible = IsAdmissionForm;
                }
                else
                {
                    string SQL_String = string.Empty;
                    SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 3,TransactionResponse='" + TransactionResponse + "' WHERE Id = " + transactionid;
                    CommonFunctions cs = new CommonFunctions();
                    cs.GetDataset(SQL_String);

                    ThanksLabel.Text = "Sorry, Your payment did not go through.";
                    //FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(amount).ToString("0.00") + " for " + CollectionGroup + " failed. Please try again or contact bank for issue.";
                    FPaymentStatusLabel.Text = "Your payment of Rs." + decimal.Parse(amount).ToString("0.00") + " for " + CollectionGroup + " has been failed, and The Transaction Id is " + PaymentTransactionId + ". Please try again or contact bank for issue.";
                    FDiv.Visible = true;
                }
            }
        }
        catch (Exception)
        {

        }
    }

    private void CreateFeeReceipt(string BankName, Int64 PaymentTransactionId)
    {
        Int64 TransactionSourceId = 0;
        int OrgGroupBatchId = 0;

        string SQL_PaymentTransaction = "SELECT PT.TransactionSourceId,BM.OrgGroupBatchId FROM sOp.tPaymentTransaction PT " +
                                        "INNER JOIN sStudent.tAcademic A ON A.Id = PT.PayerSourceId AND PT.PayerSourceTypeId = 2001 " +
                                        "INNER JOIN sSetup.tBatchMaster BM ON BM.Id = A.BatchId WHERE PT.Id = " + PaymentTransactionId;
        CommonFunctions CF = new CommonFunctions();
        DataSet PaymentTransactionDS = CF.GetDataset(SQL_PaymentTransaction);

        CommonHelper.LogWriter("Receipt created : " + SQL_PaymentTransaction, 1, "Web", HttpContext.Current.Request.Url.AbsoluteUri);
        if (PaymentTransactionDS != null && PaymentTransactionDS.Tables[0] != null && PaymentTransactionDS.Tables[0].Rows.Count > 0)
        {
            TransactionSourceId = Int64.Parse(PaymentTransactionDS.Tables[0].Rows[0]["TransactionSourceId"].ToString());
            OrgGroupBatchId = int.Parse(PaymentTransactionDS.Tables[0].Rows[0]["OrgGroupBatchId"].ToString());
        }

        String SQL_String = "SELECT OFD.OnlineFeeId, OFD.FeeSetupId, OFD.Amount	FROM sFee.tOnlineFeeDetail OFD " +
                            "INNER JOIN sFee.tOnlineFee TOF ON TOF.Id=OFD.OnlineFeeId " +
                            "INNER JOIN sOp.tPaymentTransaction PT ON PT.TransactionSourceId=TOF.Id " +
                            "WHERE TOF.Id = " + TransactionSourceId + " AND TOF.SourceTypeId = 2001 AND PT.TransactionSourceTypeId =2024";
        CommonFunctions cf = new CommonFunctions();

        DataSet DS = cf.GetDataset(SQL_String);


        if (DS != null && DS.Tables[0] != null && DS.Tables[0].Rows.Count > 0)
        {
            try
            {
                StringBuilder StrXmlDoc = new StringBuilder();
                StrXmlDoc.Append("<Table>" + "\r\n");
                for (int i = 0; i < DS.Tables[0].Rows.Count; i++)
                {
                    string RootNode = "ReceiptDetail";
                    StrXmlDoc.Append("<" + RootNode + " ");
                    StrXmlDoc.Append("FeeSetupId" + " = '" + DS.Tables[0].Rows[i]["FeeSetupId"].ToString() + "' ");
                    StrXmlDoc.Append("Amount" + "='" + DS.Tables[0].Rows[i]["Amount"].ToString() + "' ");
                    StrXmlDoc.Append("/>" + "\r\n");
                }
                StrXmlDoc.Append("</Table>");

                List<PaymentTransaction> PaymentTransactionList = new List<PaymentTransaction>();
                PaymentTransaction PaymentTransactionDetail = new PaymentTransaction();
                PaymentTransactionDetail.OnlineFeeId = TransactionSourceId;
                PaymentTransactionDetail.SourceTypeId = 2024;
                PaymentTransactionList = FeeSetupServiceClient.GetOnlineFee(PaymentTransactionDetail);

                int OrgGroupId = int.Parse(OrgGroupBatchId.ToString().Substring(0, 4));
                bool IsGenerateReceiptOnOnlinePayment = Convert.ToBoolean(ConfigurationHelper.GetUserConfigurationValueDirect(OrgGroupId, 0, 0, "Fee.IsGenerateReceiptOnOnlinePayment"));
                FeeReceiptPrintButton.Visible = false;
                if (PaymentTransactionList != null && PaymentTransactionList.Count > 0 && IsGenerateReceiptOnOnlinePayment)
                {
                    List<Result> ResultList = new List<Result>();

                    List<FeeReceipt> FeeReceiptList = new List<FeeReceipt>();
                    FeeReceipt FeeReceiptObject = new FeeReceipt();

                    FeeReceiptObject.SourceId = PaymentTransactionList[0].SourceId;
                    FeeReceiptObject.SourceTypeId = 2001;
                    FeeReceiptObject.ReceiptDate = DateTime.Now.Date;
                    FeeReceiptObject.TotalReceiptAmount = PaymentTransactionList[0].FeeAmount;
                    FeeReceiptObject.ReceiptAmount = PaymentTransactionList[0].FeeAmount;
                    FeeReceiptObject.PayTypeId = 8;
                    FeeReceiptObject.BankName = BankName;
                    FeeReceiptObject.ReceiptBookId = PaymentTransactionList[0].ReceiptBookId;
                    FeeReceiptObject.IsObsolete = false;
                    FeeReceiptObject.CreatedUserId = 3;
                    FeeReceiptObject.OrgId = PaymentTransactionList[0].OrgId;
                    FeeReceiptObject.ReceiptXML = StrXmlDoc.ToString();
                    FeeReceiptObject.BatchId = PaymentTransactionList[0].BatchId;
                    FeeReceiptObject.OrgGroupBatchId = OrgGroupBatchId;
                    FeeReceiptObject.Remark = string.Empty;
                    FeeReceiptObject.ChequeDate = DateTime.Now.Date;
                    FeeReceiptObject.Charge = PaymentTransactionList[0].PenaltyAmount;
                    FeeReceiptObject.PaymentTransactionId = PaymentTransactionId;

                    FeeReceiptList.Add(FeeReceiptObject);
                    ResultList = FeeReceiptServiceClient.CreateFeeReceipt(FeeReceiptList);
                    if (ResultList[0].Id > 0)
                    {
                        string SQL_ReceiptGenerated = string.Empty;
                        SQL_ReceiptGenerated = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 4 WHERE Id = " + PaymentTransactionId;
                        CommonFunctions cs = new CommonFunctions();
                        cs.GetDataset(SQL_ReceiptGenerated);

                        // Add for Mantis Id:0030874
                        FeeReceiptPrintButton.Visible = IsGenerateReceiptOnOnlinePayment;
                        PrintFeeReceipt(ResultList[0].Id, PaymentTransactionList[0].ReceiptBookId, PaymentTransactionList[0].SourceId, PaymentTransactionList[0].OrgId, 3, OrgGroupId);
                        AuditHelperDB.CreateAuditActivityLog(OrgGroupId, FeeReceiptObject.OrgId, 3, "", (int)FeeManagementScreenId.FeeManagement.PaymentTransaction, "PaymentResponse - FeeReceiptGenereted - " + PaymentTransactionId, 0, "");
                        SendAlert(ResultList[0].Id, PaymentTransactionList[0].BatchId, PaymentTransactionList[0].OrgId, 3, OrgGroupId);
                        if (Convert.ToBoolean((ConfigurationHelper.GetUserConfigurationValueDirect(OrgGroupId, PaymentTransactionList[0].OrgId, 0, "Fee.IsWhatsAppReceiptOnSave"))) == true)
                            SendReceiptWhatsApp(ResultList[0].Id, PaymentTransactionList[0].ReceiptBookId, PaymentTransactionList[0].SourceId, PaymentTransactionList[0].OrgId, 3, OrgGroupId);
                    }
                }
            }
            catch (Exception Ex)
            {

            }
        }
    }

    #region SendAlert
    private void SendAlert(Int64 ReceiptId, Int32 BatchId, Int32 OrgId, Int64 UserId, Int32 OrgGroupId)
    {
        AlertNotification objAlertNotification = new AlertNotification();
        CommonFunctions cf = new CommonFunctions();
        DataSet Ds = new DataSet();
        Ds = cf.GetDataset("SELECT EventId FROM sAlert.tEventTemplate WHERE IsAutoSend = 1 AND OrgId =" + OrgId + " AND   EventId = 3");
        if (Ds != null && Ds.Tables.Count > 0 && Ds.Tables[0].Rows.Count > 0)
        {
            SMSPredefine Data = new SMSPredefine();
            Data.ScriptType = "StoredProcedure";
            Data.SourceEvent = "Transactional";
            Data.ReceiptId = ReceiptId;
            Data.BatchId = BatchId;
            Data.OrgId = OrgId;
            Data.AdmissionFormId = ReceiptId;
            if (IsAdmissionForm == false)
                objAlertNotification.SendAlert(3, Data, OrgId, UserId, OrgGroupId);
            else if (IsAdmissionForm == true)
                objAlertNotification.SendAlert(56, Data, OrgId, UserId, OrgGroupId);
        }
    }
    #endregion

    private void CreateAdmissionFormReceipt(string BankName, Int64 PaymentTransactionId, Int64 TransactionSourceId, string Amount)
    {
        Int64 AdmissionFormReceiptId = 0;

        String SQL_String = "SELECT OrgId,BatchId,OM.OrgGroupId FROM sAdmission.tAdmissionForm AF INNER JOIN sSetup.tOrganizationMaster OM ON AF.OrgId = OM.Id WHERE AF.Id =" + TransactionSourceId;
        CommonFunctions cf = new CommonFunctions();
        DataSet DS = cf.GetDataset(SQL_String);
        if (DS != null && DS.Tables[0] != null && DS.Tables[0].Rows.Count > 0)
        {
            List<DataParameter> dp = new List<DataParameter>();
            DataParameter d;

            Int16 OrgId = Int16.Parse(DS.Tables[0].Rows[0]["OrgId"].ToString());

            Int32 BatchId = Int32.Parse(DS.Tables[0].Rows[0]["BatchId"].ToString());

            Int32 OrgGroupId = Int32.Parse(DS.Tables[0].Rows[0]["OrgGroupId"].ToString());

            OrgIdHiddenField.Value = OrgId.ToString();
            AdmissionFormIdHiddenField.Value = TransactionSourceId.ToString();

            d = new DataParameter { Name = "@rOrgId", Value = DS.Tables[0].Rows[0]["OrgId"].ToString(), DataType = System.Data.DbType.Int16 };
            dp.Add(d);

            d = new DataParameter { Name = "@rSourceTypeId", Value = 2027, DataType = System.Data.DbType.Int16 };
            dp.Add(d);

            d = new DataParameter { Name = "@rSourceId", Value = TransactionSourceId, DataType = System.Data.DbType.Int64 };
            dp.Add(d);

            d = new DataParameter { Name = "@rReceiptDate", Value = DateTime.Now.Date, DataType = System.Data.DbType.Date };
            dp.Add(d);

            d = new DataParameter { Name = "@rReceiptAmount", Value = Amount, DataType = System.Data.DbType.Decimal };
            dp.Add(d);

            d = new DataParameter { Name = "@rPayTypeId", Value = 1, DataType = System.Data.DbType.Int16 };
            dp.Add(d);

            d = new DataParameter { Name = "@rBatchId", Value = BatchId, DataType = System.Data.DbType.Int32 };
            dp.Add(d);

            cf = new CommonFunctions();
            DataSet AdmissionFormReceiptDS = cf.GetDatasetFromSp("sAdmission.pAdmissionFormReceiptAdd", dp);

            if (AdmissionFormReceiptDS != null && AdmissionFormReceiptDS.Tables[0] != null && AdmissionFormReceiptDS.Tables[0].Rows.Count > 0)
            {
                if (Int64.Parse(AdmissionFormReceiptDS.Tables[0].Rows[0][0].ToString()) != 0)
                {
                    AdmissionFormReceiptId = Int64.Parse(AdmissionFormReceiptDS.Tables[0].Rows[0][0].ToString());
                    if (AdmissionFormReceiptId > 0)
                    {
                        SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 4 WHERE Id = " + PaymentTransactionId;
                        cf.GetDataset(SQL_String);

                        TransactionSourceIdHiddenField.Value = TransactionSourceId.ToString();
                        AdmissionFormReceiptIdHiddenField.Value = AdmissionFormReceiptId.ToString();

                        BatchIdHiddenField.Value = BatchId.ToString();

                        SQL_String = "SELECT FormFeeName FROM sAdmission.tAdmissionForm AF INNER JOIN sAdmission.tAdmissionCriteria AC ON AC.ClassId = AF.ForClassId AND AC.BatchId = AF.BatchId WHERE AF.Id =" + AdmissionFormIdHiddenField.Value;
                        DataSet FormFeeDS = cf.GetDataset(SQL_String);
                        if (FormFeeDS != null && FormFeeDS.Tables[0].Rows.Count > 0)
                        {
                            FeeNameHiddenField.Value = FormFeeDS.Tables[0].Rows[0][0].ToString();
                        }
                        string SQLString = string.Empty;
                        SQLString = "SELECT SourceId FROM sAdmission.tAdmissionFormReceipt WHERE Id = " + AdmissionFormReceiptId;
                        CommonFunctions cs = new CommonFunctions();
                        DataSet ds = cs.GetDataset(SQLString);
                        CommonHelper.LogWriter("Admission Form Status Update : " + SQLString, 1, "Payment Response", HttpContext.Current.Request.Url.AbsoluteUri);
                        if (ds != null && ds.Tables[0] != null && ds.Tables[0].Rows.Count > 0)
                        {
                            CommonHelper.LogWriter("Source Id : " + ds.Tables[0].Rows[0]["SourceId"].ToString(), 1, "Payment Response", HttpContext.Current.Request.Url.AbsoluteUri);
                            SQLString = string.Empty;
                            SQLString = "UPDATE sAdmission.tAdmissionForm SET DataEntryStatusId = 707 WHERE Id = " + ds.Tables[0].Rows[0]["SourceId"].ToString();
                            cs = new CommonFunctions();
                            cs.GetDataset(SQLString);

                            CommonHelper.LogWriter("Admission Form Status Update1 : " + SQLString, 1, "Payment Response", HttpContext.Current.Request.Url.AbsoluteUri);
                        }
                        AuditHelperDB.CreateAuditActivityLog(OrgGroupId, OrgId, 3, "", (int)FeeManagementScreenId.FeeManagement.PaymentTransaction, "PaymentResponse - AdmissionFormReceiptGenereted - " + PaymentTransactionId, 0, "");
                        SendAlert(TransactionSourceId, int.Parse(DS.Tables[0].Rows[0]["BatchId"].ToString()), OrgId, 3, OrgGroupId);
                    }
                }
            }
        }
    }

    protected void PrintButtonReciept_Click(object sender, EventArgs e)
    {
        if (!string.IsNullOrEmpty(TransactionSourceIdHiddenField.Value) && !string.IsNullOrEmpty(AdmissionFormReceiptIdHiddenField.Value))
        {
            Int64 AdmissionFormReceiptId = 0;
            int BatchId = 0, OrgId = 0;

            AdmissionFormReceiptId = Int64.Parse(AdmissionFormReceiptIdHiddenField.Value.ToString());
            BatchId = int.Parse(BatchIdHiddenField.Value.ToString());
            OrgId = int.Parse(OrgIdHiddenField.Value.ToString());

            if (AdmissionFormReceiptId != 0 && BatchId != 0 && OrgId != 0)
                SendPrint(AdmissionFormReceiptId, BatchId, OrgId, Int64.Parse(TransactionSourceIdHiddenField.Value.ToString()));
        }
    }
    protected void PrintButton_Click(object sender, EventArgs e)
    {
        ReportViewer1.ProcessingMode = ProcessingMode.Local;
        //report path
        ReportViewer1.LocalReport.ReportPath = Server.MapPath("../../RDLCReports/Admission/Admission_Form.rdlc");


        this.ReportViewer1.LocalReport.SubreportProcessing += new SubreportProcessingEventHandler(localReport_SubreportProcessing);

        ReportViewer1.LocalReport.DataSources.Clear();

        DataSet dsHeader1 = new DataSet();
        DataSet dsHeader = new DataSet();

        //string sql = "sAdmission.pRptAdmissionFormGet";


        List<DataParameter> dp = new List<DataParameter>();
        DataParameter d;

        d = new DataParameter { Name = "@rId", Value = AdmissionFormIdHiddenField.Value.ToString(), DataType = System.Data.DbType.Int64 };
        dp.Add(d);

        CommonFunctions cf = new CommonFunctions();
        dsHeader = cf.GetDatasetFromSp("sAdmission.pRptAdmissionFormGet", dp);

        List<DataParameter> dp1 = new List<DataParameter>();
        DataParameter d1;
        if (string.IsNullOrEmpty(OrgIdHiddenField.Value.ToString()))

            d1 = new DataParameter { Name = "@rOrgId", Value = Int16.Parse(ConfigurationManager.AppSettings["DefaultOrgId"].ToString()), DataType = System.Data.DbType.Int16 };
        else

            d1 = new DataParameter { Name = "@rOrgId", Value = Int16.Parse(OrgIdHiddenField.Value.ToString()), DataType = System.Data.DbType.Int16 };
        dp1.Add(d1);
        dsHeader1 = cf.GetDatasetFromSp("sSetup.pReportInfoGet", dp1);

        ReportDataSource datasource = new ReportDataSource("AdmissionForm", dsHeader.Tables[0]);
        ReportDataSource datasource1 = new ReportDataSource("ReportInfo", dsHeader1.Tables[0]);
        ReportViewer1.Width = 600;
        ReportViewer1.LocalReport.DataSources.Clear();
        ReportViewer1.LocalReport.DataSources.Add(datasource);
        ReportViewer1.LocalReport.DataSources.Add(datasource1);

        var bytes = ReportViewer1.LocalReport.Render("PDF");
        Response.Buffer = true;
        Response.ContentType = "application/pdf";
        Response.AddHeader("content-disposition", "inline;attachment; filename=Sample.pdf");
        Response.BinaryWrite(bytes);
        Response.Flush();

        Response.Clear();
    }

    public void localReport_SubreportProcessing(object sender, SubreportProcessingEventArgs e)
    {
        switch (e.ReportPath)
        {
            case "AdmissionForm_Sub":

                string AdmissionFormIdText = e.Parameters[0].Values[0];
                string RelationShipIdText = e.Parameters[1].Values[0];
                e.DataSources.Add(new ReportDataSource("AdmissionFormSub", GetEmployeeData(AdmissionFormIdText, RelationShipIdText)));
                break;
            case "AdmissionFormStudent_Sub":
                AdmissionFormIdText = e.Parameters[0].Values[0];

                e.DataSources.Add(new ReportDataSource("AdmissionFormStudent", FetchAdmissionStudentForm(AdmissionFormIdText)));
                break;
            case "AdmissionFormSibling_Sub":
                AdmissionFormIdText = e.Parameters[0].Values[0];

                e.DataSources.Add(new ReportDataSource("AdmissionFormSibling", FetchAdmissionFormSibling(AdmissionFormIdText)));
                break;
            case "AdmissionFormReference_Sub":
                AdmissionFormIdText = e.Parameters[0].Values[0];

                e.DataSources.Add(new ReportDataSource("AdmissionFormReference", FetchAdmissionFormReference(AdmissionFormIdText)));
                break;
            case "AdmissionFormField_Sub":
                AdmissionFormIdText = e.Parameters[0].Values[0];
                e.DataSources.Add(new ReportDataSource("AdmissionFormField", FetchAdmissionFormField(AdmissionFormIdText)));
                break;
        }
    }

    public DataTable GetEmployeeData(string AdmissionFormIdText, string RelationShipIdText)
    {


        string sql = "sAdmission.pRptAdmissionFormParentAcademicSubGet";
        using (SqlDataAdapter da = new SqlDataAdapter(sql, ConfigurationManager.ConnectionStrings["NetVidyalayaSubReport"].ConnectionString))
        {
            da.SelectCommand.CommandType = CommandType.StoredProcedure;
            da.SelectCommand.Parameters.Add("@rId", SqlDbType.BigInt).Value = Int64.Parse(AdmissionFormIdText);
            da.SelectCommand.Parameters.Add("@rRelationShipId", SqlDbType.Int).Value = Int32.Parse(RelationShipIdText);
            DataTable dt = new DataTable();
            da.Fill(dt);
            return dt;
        }

    }
    private DataTable FetchAdmissionStudentForm(string AdmissionFormIdText)
    {

        string sql = "sAdmission.pRptAdmissionFormStudentAcademicSubGet";
        using (SqlDataAdapter da = new SqlDataAdapter(sql, ConfigurationManager.ConnectionStrings["NetVidyalayaSubReport"].ConnectionString))
        {
            da.SelectCommand.CommandType = CommandType.StoredProcedure;
            da.SelectCommand.Parameters.Add("@rId", SqlDbType.BigInt).Value = Int64.Parse(AdmissionFormIdText);
            DataTable dt = new DataTable();
            da.Fill(dt);
            return dt;

        }
    }
    private DataTable FetchAdmissionFormSibling(string AdmissionFormIdText)
    {

        string sql = "sAdmission.pRptAdmissionFormSiblingSubGet";
        using (SqlDataAdapter da = new SqlDataAdapter(sql, ConfigurationManager.ConnectionStrings["NetVidyalayaSubReport"].ConnectionString))
        {
            da.SelectCommand.CommandType = CommandType.StoredProcedure;
            da.SelectCommand.Parameters.Add("@rId", SqlDbType.BigInt).Value = Int64.Parse(AdmissionFormIdText);
            DataTable dt = new DataTable();
            da.Fill(dt);
            return dt;

        }
    }

    private DataTable FetchAdmissionFormReference(string AdmissionFormIdText)
    {

        string sql = "sAdmission.pRptAdmissionFormReferenceSubGet";
        using (SqlDataAdapter da = new SqlDataAdapter(sql, ConfigurationManager.ConnectionStrings["NetVidyalayaSubReport"].ConnectionString))
        {
            da.SelectCommand.CommandType = CommandType.StoredProcedure;
            da.SelectCommand.Parameters.Add("@rId", SqlDbType.BigInt).Value = Int64.Parse(AdmissionFormIdText);
            DataTable dt = new DataTable();
            da.Fill(dt);
            return dt;

        }
    }

    private DataTable FetchAdmissionFormField(string AdmissionFormIdText)
    {

        string sql = "sAdmission.pRptAdmissionFormFieldGet";
        using (SqlDataAdapter da = new SqlDataAdapter(sql, ConfigurationManager.ConnectionStrings["NetVidyalayaSubReport"].ConnectionString))
        {
            da.SelectCommand.CommandType = CommandType.StoredProcedure;
            da.SelectCommand.Parameters.Add("@rId", SqlDbType.BigInt).Value = Int64.Parse(AdmissionFormIdText);
            DataTable dt = new DataTable();
            da.Fill(dt);
            return dt;
        }
    }

    private void SendPrint(Int64 AdmissionFormReceiptId, int BatchId, int OrgId, Int64 PaymentTransactionId)
    {

        ReportViewer1.ProcessingMode = ProcessingMode.Local;
        //Mantis: 33825, add for cs report tick
        string ReportPath = "";
        string GetReportPath = "SELECT 1 AS Result FROM sCommon.tReportClient WHERE ReportId = 30029 AND OrgGroupId = (SELECT OrgGroupId FROM sSetup.tOrganizationMaster WHERE Id= " + OrgId + ")";
        DataSet GetReportPathDS = new DataSet();
        CommonFunctions cf1 = new CommonFunctions();
        GetReportPathDS = cf1.GetDataset(GetReportPath);
        if (GetReportPathDS != null && GetReportPathDS.Tables[0] != null && GetReportPathDS.Tables[0].Rows.Count > 0)
        {
            if (GetReportPathDS.Tables[0].Rows[0]["Result"].ToString() == "1")
            {
                ReportPath = Server.MapPath("../../zReportClient/Admission/OnlineAdmissionFormReceipt.rdlc");
            }
        }
        //report path
        if (ReportPath != "")
            ReportViewer1.LocalReport.ReportPath = ReportPath;
        else
            ReportViewer1.LocalReport.ReportPath = Server.MapPath("../../RDLCReports/Admission/OnlineAdmissionFormReceipt.rdlc");
        ReportViewer1.LocalReport.DataSources.Clear();

        DataSet AdmissionFormReceiptDS = new DataSet();
        DataSet ReportInfoDS = new DataSet();

        AdmissionFormReceiptDS = AdmissionFormReceiptGet(AdmissionFormReceiptId, BatchId, OrgId);
        ReportInfoDS = ReportInfoGet(OrgId);
        ReportDataSource AdmissionFormReceiptDataSource = new ReportDataSource("AdmissionFormReceipt", AdmissionFormReceiptDS.Tables[0]);
        ReportDataSource ReportInfoDataSource = new ReportDataSource("ReportInfo", ReportInfoDS.Tables[0]);
        ReportViewer1.Width = 600;
        ReportViewer1.LocalReport.DataSources.Clear();
        ReportViewer1.LocalReport.DataSources.Add(AdmissionFormReceiptDataSource);
        ReportViewer1.LocalReport.DataSources.Add(ReportInfoDataSource);

        var bytes = ReportViewer1.LocalReport.Render("PDF");
        Response.Buffer = true;
        Response.ContentType = "application/pdf";
        Response.AddHeader("content-disposition", "inline;attachment; filename=Sample.pdf");
        Response.BinaryWrite(bytes);
        Response.Flush();
        Response.Clear();

        string SQL_String = string.Empty;
        SQL_String = "UPDATE sOp.tPaymentTransaction SET TransactionStatusId = 4 WHERE Id = " + PaymentTransactionId;
        CommonFunctions cs = new CommonFunctions();
        cs.GetDataset(SQL_String);

        SQL_String = string.Empty;
        SQL_String = "SELECT SourceId FROM sAdmission.tAdmissionFormReceipt WHERE Id = " + AdmissionFormReceiptId;
        cs = new CommonFunctions();
        DataSet ds = cs.GetDataset(SQL_String);

        if (ds != null && ds.Tables[0] != null && ds.Tables[0].Rows.Count > 0)
        {
            SQL_String = string.Empty;
            SQL_String = "UPDATE sAdmission.tAdmissionForm SET DataEntryStatusId = 707 WHERE Id = " + ds.Tables[0].Rows[0]["SourceId"].ToString();
            cs = new CommonFunctions();
            cs.GetDataset(SQL_String);
        }
    }

    private DataSet AdmissionFormReceiptGet(Int64 AdmissionFormReceiptId, int BatchId, int OrgId)
    {
        DataSet AdmissionFormReceiptDS = new DataSet();
        List<DataParameter> dp = new List<DataParameter>();
        DataParameter d;

        d = new DataParameter { Name = "@rAdmissionFormReceiptId", Value = AdmissionFormReceiptId, DataType = System.Data.DbType.Int64 };
        dp.Add(d);

        d = new DataParameter { Name = "@rBatchId", Value = BatchId, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rOrgId", Value = OrgId, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rFeeName", Value = FeeNameHiddenField.Value.ToString(), DataType = System.Data.DbType.String };
        dp.Add(d);

        CommonFunctions cf = new CommonFunctions();
        AdmissionFormReceiptDS = cf.GetDatasetFromSp("sAdmission.pRptAdmissionFormReceiptGet", dp);

        return AdmissionFormReceiptDS;
    }

    private DataSet ReportInfoGet(int OrgId)
    {
        DataSet ReportInfoDS = new DataSet();
        List<DataParameter> dp = new List<DataParameter>();
        DataParameter d;

        d = new DataParameter { Name = "@rOrgId", Value = OrgId, DataType = System.Data.DbType.Int16 };
        dp.Add(d);

        CommonFunctions cf = new CommonFunctions();
        ReportInfoDS = cf.GetDatasetFromSp("sSetup.pReportInfoGet", dp);

        return ReportInfoDS;
    }

    protected void SendReceiptWhatsApp(Int64 ReceiptId, int ReceiptBookId, Int64 SourceId, int OrgId, Int64 UserId, Int32 OrgGroupId, bool IsAlertWithoutAttachment = false)
    {
        try
        {
            string SQL_String = string.Empty;
            SQL_String = "SELECT FirstName, ISNULL(ParentEmail,'') AS EmailId,StudentId AS ReceiverSourceId, 2003 AS ReceiverSourceTypeId,WhatsAppContactNo FROM sStudent.vStudentCommunication WHERE IsBlockAllAlert=0 AND AcademicId = " + SourceId;
            CommonFunctions cf = new CommonFunctions();
            DataSet ds = cf.GetDataset(SQL_String);
            if (ds != null && ds.Tables.Count > 0 && ds.Tables[0].Rows.Count > 0)
            {
                if (!IsAlertWithoutAttachment)
                    ds.Tables[0].Columns.Add("AttachMent");
                ds.Tables[0].Columns.Add("Subject");
                ds.Tables[0].Columns.Add("MsgText");
                ds.Tables[0].Columns.Add("Name");
                ds.Tables[0].Columns.Add("Class");
                ds.Tables[0].Columns.Add("Division");
                ds.Tables[0].Columns.Add("ReceiptNumber");
                ds.Tables[0].Columns.Add("ReceiptDate");
                ds.Tables[0].Columns.Add("PaidAmount");
                ds.Tables[0].Columns.Add("ChequeNo");

                if (!string.IsNullOrEmpty(ds.Tables[0].Rows[0]["WhatsAppContactNo"].ToString()))
                {
                    //for MultiReceipt - mantisid -- 0033056
                    //bool IsMultiPrint = Convert.ToBoolean((ConfigurationHelper.GetUserConfigurationValueDirect(OrgGroupId, 0, 0, "Fee.IsPrintMultipleFeeReceipt")));-- mantisid - 0033056

                    string IsPrintMultipleFeeReceipt = string.Empty;
                    bool IsMultiPrint;

                    IsPrintMultipleFeeReceipt = ConfigurationHelper.GetUserConfigurationValueDirect(OrgGroupId, 0, 0, "Fee.IsPrintMultipleFeeReceipt");

                    if (IsPrintMultipleFeeReceipt == "True" || IsPrintMultipleFeeReceipt == "Standard")
                        IsMultiPrint = true;
                    else
                        IsMultiPrint = false;

                    string MailSubject = string.Empty, TemplateName = string.Empty, SourceEvent = string.Empty;
                    SQL_String = string.Empty;
                    SQL_String = "SELECT ISNULL(EM.Title, '') AS SourceEvent, ISNULL(ET.MailSubject,'') AS MailSubject, ISNULL(ET.Template,'') AS TemplateName FROM sAlert.tEventMaster EM INNER JOIN sAlert.tEventTemplate ET ON EM.Id = ET.EventId WHERE ET.OrgId=" + OrgId + " AND ET.AlertModeId = 4 AND ET.IsAutoSend = 1 AND ET.EventId = 3";
                    cf = new CommonFunctions();
                    DataSet DS = cf.GetDataset(SQL_String);
                    if (DS != null && DS.Tables.Count > 0 && DS.Tables[0].Rows.Count > 0)
                    {
                        MailSubject = DS.Tables[0].Rows[0]["MailSubject"].ToString();
                        TemplateName = DS.Tables[0].Rows[0]["TemplateName"].ToString();
                        SourceEvent = DS.Tables[0].Rows[0]["SourceEvent"].ToString();
                        SQL_String = string.Empty;
                        SQL_String = "SELECT SA.Name,SA.ClassName,SA.DivisionName,ReceiptNumber,ReceiptDate,ReceiptAmount,R.ChequeNo FROM sFee.tReceipt R " +
                                     "INNER JOIN sStudent.vStudentAcademic SA ON R.SourceId = SA.AcademicId WHERE Id =" + ReceiptId + " AND ReceiptBookId= " + ReceiptBookId;

                        cf = new CommonFunctions();

                        DataSet ReceiptDS = cf.GetDataset(SQL_String);
                        {
                            ds.Tables[0].Rows[0]["Name"] = ReceiptDS.Tables[0].Rows[0]["Name"].ToString();
                            ds.Tables[0].Rows[0]["Class"] = ReceiptDS.Tables[0].Rows[0]["ClassName"].ToString();
                            ds.Tables[0].Rows[0]["Division"] = ReceiptDS.Tables[0].Rows[0]["DivisionName"].ToString();
                            ds.Tables[0].Rows[0]["ReceiptNumber"] = ReceiptDS.Tables[0].Rows[0]["ReceiptNumber"].ToString();
                            ds.Tables[0].Rows[0]["ReceiptDate"] = Convert.ToDateTime(ReceiptDS.Tables[0].Rows[0]["ReceiptDate"].ToString()).ToString("dd/MM/yyyy");
                            ds.Tables[0].Rows[0]["PaidAmount"] = ReceiptDS.Tables[0].Rows[0]["ReceiptAmount"].ToString();
                            ds.Tables[0].Rows[0]["ChequeNo"] = ReceiptDS.Tables[0].Rows[0]["ChequeNo"].ToString();
                        }

                        //StringBuilder sb = new StringBuilder(TemplateName);
                        //sb.Replace("[Name]", ds.Tables[0].Rows[0]["Name"].ToString());
                        //sb.Replace("[Class]", ds.Tables[0].Rows[0]["Class"].ToString());
                        //sb.Replace("[Division]", ds.Tables[0].Rows[0]["Division"].ToString());
                        //sb.Replace("[ReceiptNumber]", ds.Tables[0].Rows[0]["ReceiptNumber"].ToString());
                        //sb.Replace("[ReceiptDate]", Convert.ToDateTime(ds.Tables[0].Rows[0]["ReceiptDate"].ToString()).ToString("dd/MM/yyyy"));
                        //sb.Replace("[PaidAmount]", ds.Tables[0].Rows[0]["PaidAmount"].ToString());
                        //sb.Replace("[ChequeNo]", ds.Tables[0].Rows[0]["ChequeNo"].ToString());
                        //TemplateName = sb.ToString();

                        ds.Tables[0].Rows[0]["Subject"] = MailSubject;
                        ds.Tables[0].Rows[0]["MsgText"] = "";

                        // Add for Mantis Id:0030874
                        if (!IsAlertWithoutAttachment && !string.IsNullOrEmpty(FeeReceiptPathHiddenField.Value))
                        {
                            ds.Tables[0].Rows[0]["AttachMent"] = FeeReceiptPathHiddenField.Value;
                        }
                        AlertNotification objAlertNotification = new AlertNotification();
                        objAlertNotification.SendWhatsAppAlertWithoutTemplate(ds, SourceEvent, 3, OrgId, UserId, OrgGroupId, "", true);
                    }
                }
            }
        }
        catch (Exception ex)
        {
            ExceptionHelper.HandleException(ex, ExceptionPolicyEnum.UI_Policy);
            //var aPath = ConfigurationManager.AppSettings["AbsolutePath"];
            //string APILogPath = aPath + "Content\\TraceLog\\FeeReceipt.txt";

            //if (!File.Exists(APILogPath))
            //    Directory.CreateDirectory(Path.GetDirectoryName(APILogPath));

            //TextWriter tsw = new StreamWriter(APILogPath, true);
            //tsw.WriteLine("========== " + DateTime.Now.ToString("dd/MM/yyyy hh:mm:ss") + " ========== (WhatsApp)");
            //tsw.WriteLine("");
            //tsw.WriteLine("\r\n" + ex);
            //tsw.WriteLine("\r\n" + ex.Message);
            //tsw.WriteLine("");
            //tsw.WriteLine("******************************************");
            //tsw.WriteLine("");
            //tsw.Close();
        }
    }

    private DataSet FeeReceiptGet(Int64 ReceiptId, int OrgId, bool IsMultiPrint = false, int ReportId = 0)
    {
        if (IsMultiPrint)
        {
            ReceiptId = 0;
        }
        DataSet FeeReceiptDS = new DataSet();
        List<DataParameter> dp = new List<DataParameter>();
        DataParameter d;
        d = new DataParameter { Name = "@rReceiptId", Value = ReceiptId, DataType = System.Data.DbType.Int64 };
        dp.Add(d);
        d = new DataParameter { Name = "@rOrgId", Value = OrgId, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        CommonFunctions cf = new CommonFunctions();
        //Changes for Mantis 0034016 by Foram Start
        if (ReportId == 31233)
        {
            FeeReceiptDS = cf.GetDatasetFromSp("[sFee].[pRptFeeReceiptDoubleA5WithNextPendingFeeGet]", dp);
        }
        else if (ReportId == 31353 || ReportId == 31354)
        {
            FeeReceiptDS = cf.GetDatasetFromSp("[sFee].[pRptFeeReceiptWithTaxDetailsGet]", dp);
        }
        else
        {
            FeeReceiptDS = cf.GetDatasetFromSp("[sFee].[pRptFeeReceiptDetailsGet]", dp);
        }
        //Changes for Mantis 0034016 by Foram End
        return FeeReceiptDS;
    }

    // Add for Mantis Id:0030874
    protected void FeeReceiptPrintButton_Click(object sender, EventArgs e)
    {
        try
        {
            if (!string.IsNullOrEmpty(FeeReceiptPathHiddenField.Value))
                Response.Redirect(FeeReceiptPathHiddenField.Value, false);
            else
            {
                //Added for Mantis 0036030 by Foram
                if (!string.IsNullOrEmpty(PaymentTransactionIdHiddenField.Value))
                {
                    if (Convert.ToInt64(PaymentTransactionIdHiddenField.Value) > 0)
                    {
                        string ReportPath = string.Empty;
                        var aPath = ConfigurationManager.AppSettings["AbsolutePath"];
                        var vPath = ConfigurationManager.AppSettings["VirtualPath"];
                        string query = " SELECT A.OrgId, PT.PayerSourceId AS SourceId, R.Id AS ReceiptId " +
                                       " FROM sOp.tPaymentTransaction PT " +
                                       " INNER JOIN sFee.tReceipt R ON R.PaymentTransactionId = PT.Id" +
                                       " INNER JOIN sStudent.tAcademic A ON A.Id = PT.PayerSourceId" +
                                       " WHERE PT.Id = " + PaymentTransactionIdHiddenField.Value;
                        DataSet ds = new DataSet();
                        CommonFunctions cf = new CommonFunctions();
                        ds = cf.GetDataset(query);
                        if (ds != null && ds.Tables.Count > 0 && ds.Tables[0] != null && ds.Tables[0].Rows.Count > 0)
                        {
                            string FinalReportPath = "ReportPDF/" + ds.Tables[0].Rows[0]["OrgId"].ToString() + "/FeeReceipt/" + ds.Tables[0].Rows[0]["SourceId"].ToString();
                            ReportPath = vPath + FinalReportPath.Replace("~", "") + "/" + ds.Tables[0].Rows[0]["ReceiptId"].ToString() + ".pdf"; ;
                            if (Directory.Exists(aPath + FinalReportPath))
                            {
                                Response.Redirect(ReportPath, false);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex)
        {

            throw ex;
        }
    }

    protected void PrintFeeReceipt(Int64 ReceiptId, int ReceiptBookId, Int64 SourceId, int OrgId, Int64 UserId, Int32 OrgGroupId, bool IsAlertWithoutAttachment = false)
    {
        try
        {
            CommonFunctions cf = new CommonFunctions();
            ReportDetail ReportDetailData = new ReportDetail();
            ReportDetailData.IsCustomFile = true;
            ReportDetailData.PrintMode = "Save PDF";
            ReportDetailData.CustomPath = "ReportPDF/" + OrgId + "/FeeReceipt/" + SourceId + "/";
            ReportDetailData.CustomFileName = ReceiptId.ToString();

            ReportFormatGroupMaster ReportFormatGroupMasterData = new ReportFormatGroupMaster();
            ReportFormatGroupMasterData.OrgId = OrgId;
            ReportFormatGroupMasterData.SourceId = ReceiptBookId;
            ReportFormatGroupMasterData.SourceTypeId = 0;
            ReportFormatGroupMasterData.ReportFormatGroupId = 2;
            ReportHelper ReportHelperObject = new ReportHelper();
            ReportDetailData.Id = ReportHelperObject.GetReportIdOther(ReportFormatGroupMasterData);

            string query = "SELECT ReportPath FROM sCommon.tReport WHERE Id = " + ReportDetailData.Id;
            DataSet ReportPathDS = cf.GetDataset(query);
            string ReportPath = string.Empty;
            string RDLCPath = "";
            var aPath = ConfigurationManager.AppSettings["AbsolutePath"];
            var vPath = ConfigurationManager.AppSettings["VirtualPath"];
            if (ReportPathDS != null && ReportPathDS.Tables.Count > 0 && ReportPathDS.Tables[0] != null && ReportPathDS.Tables[0].Rows.Count > 0)
            {
                ReportPath = ReportPathDS.Tables[0].Rows[0]["ReportPath"].ToString();
                string GetReportPath = "SELECT 1 AS Result FROM sCommon.tReportClient WHERE ReportId = " + ReportDetailData.Id + " AND OrgGroupId = " + OrgGroupId;
                DataSet GetReportPathDS = new DataSet();
                GetReportPathDS = cf.GetDataset(GetReportPath);
                if (GetReportPathDS != null && GetReportPathDS.Tables[0] != null && GetReportPathDS.Tables[0].Rows.Count > 0)
                {
                    if (GetReportPathDS.Tables[0].Rows[0]["Result"].ToString() == "1")
                        RDLCPath = aPath + "zReportClient/" + (ReportPathDS.Tables[0].Rows[0][0].ToString().Substring(ReportPathDS.Tables[0].Rows[0][0].ToString().IndexOf("~\\RDLCReports") + "~\\RDLCReports".Length)).Replace("ReportCustom", "zReportClient");
                }
                if (RDLCPath != "")
                    ReportPath = RDLCPath;
                else
                    ReportPath = aPath + ReportPathDS.Tables[0].Rows[0][0].ToString().Replace("~", "");
            }

            string FinalReportPath = ReportDetailData.CustomPath.ToString() + ReceiptId + ".pdf";

            ReportViewer1.ProcessingMode = ProcessingMode.Local;
            ReportViewer1.LocalReport.ReportPath = ReportPath.ToString().Replace(@"~\", "");
            //Server.MapPath("../../" + ReportPath.ToString().Replace(@"~\", ""));
            ReportViewer1.LocalReport.DataSources.Clear();

            DataSet FeeReceiptDS = new DataSet();
            //bool IsMultiPrint = Convert.ToBoolean((ConfigurationHelper.GetUserConfigurationValueDirect(OrgGroupId, 0, 0, "Fee.IsPrintMultipleFeeReceipt")));-- mantisid - 0033056
            string IsPrintMultipleFeeReceipt = string.Empty;
            bool IsMultiPrint;

            IsPrintMultipleFeeReceipt = ConfigurationHelper.GetUserConfigurationValueDirect(OrgGroupId, 0, 0, "Fee.IsPrintMultipleFeeReceipt");
            if (IsPrintMultipleFeeReceipt == "True" || IsPrintMultipleFeeReceipt == "Standard")
                IsMultiPrint = true;
            else
                IsMultiPrint = false;

            FeeReceiptDS = FeeReceiptGet(ReceiptId, OrgId, IsMultiPrint, ReportDetailData.Id);
            //Changes for Mantis 0034016 by Foram Start
            ReportDataSource FeeReceiptDataSource = new ReportDataSource();
            if (ReportDetailData.Id == 31233)
            {
                FeeReceiptDataSource = new ReportDataSource("FeeReceiptDoubleA5WithNextPendingFee", FeeReceiptDS.Tables[0]);
            }
            else if (ReportDetailData.Id == 31353 || ReportDetailData.Id == 31354)
            {
                FeeReceiptDataSource = new ReportDataSource("FeeReceiptWithTaxDetails", FeeReceiptDS.Tables[0]);
            }
            else
            {
                FeeReceiptDataSource = new ReportDataSource("FeeReceipt", FeeReceiptDS.Tables[0]);
            }
            //Changes for Mantis 0034016 by Foram End

            DataSet ReportInfoDS = new DataSet();
            List<DataParameter> dp1 = new List<DataParameter>();
            DataParameter d1;
            if (OrgId == null)
                d1 = new DataParameter { Name = "@rOrgId", Value = Int16.Parse(ConfigurationManager.AppSettings["DefaultOrgId"].ToString()), DataType = System.Data.DbType.Int16 };
            else
                d1 = new DataParameter { Name = "@rOrgId", Value = OrgId, DataType = System.Data.DbType.Int16 };
            dp1.Add(d1);
            ReportInfoDS = cf.GetDatasetFromSp("sSetup.pReportInfoGet", dp1);
            ReportDataSource datasource1 = new ReportDataSource("ReportInfo", ReportInfoDS.Tables[0]);

            ReportViewer1.Width = 600;
            ReportViewer1.LocalReport.DataSources.Clear();
            ReportViewer1.LocalReport.DataSources.Add(FeeReceiptDataSource);
            ReportViewer1.LocalReport.DataSources.Add(datasource1);
            var bytes = ReportViewer1.LocalReport.Render("PDF");

            string ReportViewerPath = aPath + ReportDetailData.CustomPath.ToString() + ReceiptId + ".pdf";
            if (File.Exists(aPath + ReportDetailData.CustomPath.ToString() + ReceiptId.ToString() + ".pdf"))
                File.Delete(aPath + ReportDetailData.CustomPath.ToString() + ReceiptId.ToString() + ".pdf");

            if (!Directory.Exists(aPath + ReportDetailData.CustomPath.ToString()))
            {
                Directory.CreateDirectory(aPath + ReportDetailData.CustomPath.ToString());
                DirectoryInfo dir1 = new DirectoryInfo(aPath + ReportDetailData.CustomPath.ToString());
                System.Security.Principal.WindowsIdentity self = System.Security.Principal.WindowsIdentity.GetCurrent();
                DirectorySecurity ds1 = dir1.GetAccessControl();
                ds1.AddAccessRule(new FileSystemAccessRule(self.Name,
                FileSystemRights.FullControl,
                InheritanceFlags.ObjectInherit |
                InheritanceFlags.ContainerInherit,
                PropagationFlags.None,
                AccessControlType.Allow));
                dir1.SetAccessControl(ds1);
            }
            using (FileStream stream = new FileStream(ReportViewerPath, FileMode.Create))
            {
                stream.Write(bytes, 0, bytes.Length);
            }

            ReportViewer1.LocalReport.DataSources.Clear();
            ReportViewer1.Visible = false;

            FeeReceiptPathHiddenField.Value = vPath + FinalReportPath.Replace("~", "");
        }
        catch (Exception ex)
        {
            ExceptionHelper.HandleException(ex, ExceptionPolicyEnum.UI_Policy);
        }
    }
    // End for Mantis Id:0030874
}