﻿<%@ WebHandler Language="C#" Class="common_file_upload" %>

using System;
using System.Web;
using System.IO;
using Sapphire.Ohu.Web.SessionHelper;
using System.Windows.Forms;
using Sapphire.Ohu.Web.PageController;
using Sapphire.Ohu.BusinessEntity.Framework.BaseFrameworkBE;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Security.AccessControl;
using System.Collections.Generic;
using System.Web.SessionState;
using System.Linq;


using System.Data;
using System.Drawing.Imaging;

public class common_file_upload : IHttpHandler, System.Web.SessionState.IRequiresSessionState, System.Web.SessionState.IReadOnlySessionState
{
    public void ProcessRequest(HttpContext context)
    {
        //context.Response.ContentType = "text/plain";
        //context.Response.Write("Hello World");
        var _with1 = HttpContext.Current;
        string strPath = _with1.Server.MapPath("~/Content/");
        HttpFileCollection postedFile = context.Request.Files;
        string filename = "";
        bool IsImageOptimize = false;

        IsImageOptimize = Convert.ToBoolean(Sapphire.Ohu.Web.Helper.ConfigurationHelper.GetUserConfigurationValue("sCommon.IsOptimizeAppImageUpload"));
        //if (!System.IO.Directory.Exists(strPath + SecuritySession.UserProfile.OrgId))
        //{
        //    System.IO.Directory.CreateDirectory(strPath + SecuritySession.UserProfile.OrgId);
        //    strPath = strPath + SecuritySession.UserProfile.OrgId + "/";
        //}
        //else
        //{
        //    strPath = strPath + SecuritySession.UserProfile.OrgId + "/";
        //}

        string CurrentSize = string.Empty;
        string AllocatedSpace = Sapphire.Ohu.Web.Helper.ConfigurationHelper.GetUserConfigurationValue("Common.CloudStorage");
        string SQL = "SELECT ISNULL(SUM(UD.DocumentSize),0) FROM sCommon.tUploadDocument UD INNER JOIN sSetup.tOrgGroupBatchMaster OGBM ON OGBM.Id = UD.OrgGroupBatchId WHERE OGBM.OrgGroupId = " + SecuritySession.UserProfile.OrgGroupId;
        Sapphire.Ohu.BaseFramework.Utilities.CommonFunctions cf = new Sapphire.Ohu.BaseFramework.Utilities.CommonFunctions();
        DataSet GetCurrentSizeDS = cf.GetDataset(SQL);
        if (GetCurrentSizeDS != null && GetCurrentSizeDS.Tables.Count > 0 && GetCurrentSizeDS.Tables[0].Rows.Count > 0)
        {
            CurrentSize = GetCurrentSizeDS.Tables[0].Rows[0][0].ToString();
        }

        decimal Size = decimal.Parse(CurrentSize) + postedFile[0].ContentLength / 1024;

        if (!string.IsNullOrEmpty(CurrentSize) && (Size / 1048576) > decimal.Parse(AllocatedSpace))
        {
            context.Response.Write("-007");
            return;
        }
        //remove mp4 file validation because of 0026910 mantis issue (no need to allow mp4 file in Gallery)and also not required for all modules as discussed with tester
        List<string> ValidCircularExtensionList = new List<string>() { "bmp", "gif", "jpeg", "jpg", "png", "pdf", "pptx", "ppt", "xlsx", "xls", "docx", "doc", "txt", "csv", "heic", "webp" };
        string FileExtension = postedFile[0].FileName.Split('.').Last().ToLower();
        if (!ValidCircularExtensionList.Contains(FileExtension))
        {
            context.Response.Write("-008");
            return;
        }
        if (postedFile[0].FileName.Contains("//") || postedFile[0].FileName.Contains(".."))
        {
            context.Response.Write("-009");
            return;
        }

        if (SecuritySession.UserProfile != null)
        {
            if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadStudentPhoto)
            {
                if (context.Session["UploadFor"].ToString() == "TempStudentPhotos")
                {

                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempStudentPhotos";
                }
                else if (context.Session["UploadFor"].ToString() == "TempStudentFatherPhotos")
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempStudentFatherPhotos";
                }
                else if (context.Session["UploadFor"].ToString() == "TempStudentMotherPhotos")
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempStudentMotherPhotos";
                }
                else if (context.Session["UploadFor"].ToString() == "TempStudentRelativePhotos")
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempStudentRelativePhotos";
                }
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                {
                    strPath = strPath + "/";
                }

            }
            if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadStudentdocument)
            {
                if (context.Session["UploadDocument"] == "Temp")
                {
                    string documnetid = HttpContext.Current.Request.QueryString["DocId"];
                    if (!string.IsNullOrEmpty(documnetid))
                    {
                        string Tempimageurl;
                        Tempimageurl = HttpContext.Current.Server.MapPath("../../Content/" + SecuritySession.UserProfile.OrgId + "/StudentAllDocuments/Temp/" + documnetid);
                        if ((Directory.Exists(Tempimageurl)))
                        {
                            DirectoryInfo dir = new DirectoryInfo(Tempimageurl);
                            dir.Delete(true);
                        }
                        //Sapphire.Ohu.BaseFramework.Utilities.CommonFunctions cf1 = new Sapphire.Ohu.BaseFramework.Utilities.CommonFunctions();
                        //DataSet ds1 = cf1.GetDataset("DELETE FROM  sStudent.tStudentDocument WHERE SubmitDocumentMasterId=" + documnetid + " AND StudentId=" + StudentId + "");

                        strPath = strPath + SecuritySession.UserProfile.OrgId + "/StudentAllDocuments/Temp/" + documnetid;
                        if (!System.IO.Directory.Exists(strPath))
                        {
                            System.IO.Directory.CreateDirectory(strPath);
                            strPath = strPath + "/";
                        }
                        else
                            strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                    //if (Directory.Exists(strPath))
                    //{
                    //    files = Directory.GetFiles(strPath);
                    //    foreach (string file in files)
                    //    {
                    //        string FileName = Path.GetFileNameWithoutExtension(file);
                    //        string SQL_String = "select Id FROM sStudent.tStudentMaster WHERE Code = '" + FileName + "' AND OrgId =" + SecuritySession.UserProfile.OrgId;
                    //        Sapphire.Ohu.BaseFramework.Utilities.CommonFunctions cf = new Sapphire.Ohu.BaseFramework.Utilities.CommonFunctions();
                    //        System.Data.DataSet ds = new System.Data.DataSet();
                    //        ds = cf.GetDataset(SQL_String);
                    //        //Session["StudentId"] = ds.Tables[0].Rows[0]["Id"].ToString();
                    //        StudentId = Convert.ToInt64(ds.Tables[0].Rows[0]["Id"].ToString());
                    //        string Studentimageurl;
                    //        Studentimageurl = HttpContext.Current.Server.MapPath("../../Content/" + SecuritySession.UserProfile.OrgId + "/StudentAllDocuments/" + StudentId + "/" + documnetid);
                    //        if ((Directory.Exists(Studentimageurl)))
                    //        {
                    //            DirectoryInfo dir = new DirectoryInfo(Studentimageurl);
                    //            dir.Delete(true);
                    //        }
                    //    }
                    //}
                }
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/StudentDocuments/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadEmployeeocument)
            {
                if (context.Session["UploadDocument"] == "Temp")
                {
                    string documnetid = HttpContext.Current.Request.QueryString["DocId"];
                    if (!string.IsNullOrEmpty(documnetid))
                    {
                        string Tempimageurl;
                        Tempimageurl = HttpContext.Current.Server.MapPath("../../Content/" + SecuritySession.UserProfile.OrgId + "/EmployeeAllDocuments/Temp/" + documnetid);
                        if ((Directory.Exists(Tempimageurl)))
                        {
                            DirectoryInfo dir = new DirectoryInfo(Tempimageurl);
                            dir.Delete(true);
                        }
                        strPath = strPath + SecuritySession.UserProfile.OrgId + "/EmployeeAllDocuments/Temp/" + documnetid;
                        if (!System.IO.Directory.Exists(strPath))
                        {
                            System.IO.Directory.CreateDirectory(strPath);
                            strPath = strPath + "/";
                        }
                        else
                            strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/EmployeeDocuments/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadCandidatePhoto)
            {
                strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempCandidatePhotos";
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentICard)
            {
                strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempStudentICard";
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";



            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadEmployeePhoto)
            {
                if (context.Session["Upload"].ToString() == "TempEmployeePhotos")
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempEmployeePhotos";
                else if (context.Session["Upload"].ToString() == "TempEmployeeSign")
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempEmployeeSign";
                }
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";

            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.EmployeeICard)
            {

                strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempEmployeeICard";
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";


            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Circular)
            {
                if (context.Session["TempCircularId"] != null)
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/TempCircular/" + context.Session["TempCircularId"];
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Circular/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }






                //    strPath = strPath + "/OrgGroup/TempCircular";
                //    if (!System.IO.Directory.Exists(strPath))
                //    {
                //        System.IO.Directory.CreateDirectory(strPath);
                //        strPath = strPath + "/";

                //    }
                //    else
                //    {
                //        if (System.IO.Directory.Exists(strPath))
                //        {
                //            string[] Files = Directory.GetFiles(strPath);

                //            foreach (string file in Files)
                //            {

                //                File.Delete(file);

                //            }

                //            System.IO.Directory.CreateDirectory(strPath);
                //            strPath = strPath + "/";
                //        }

                //    }

                //}
                //else
                //{
                //    strPath = strPath + "/Circular";
                //    if (!System.IO.Directory.Exists(strPath))
                //    {
                //        System.IO.Directory.CreateDirectory(strPath);
                //        strPath = strPath + "/";
                //    }
                //    else
                //    {
                //        if (System.IO.Directory.Exists(strPath))
                //        {
                //            string[] Files = Directory.GetFiles(strPath);

                //            foreach (string file in Files)
                //            {

                //                File.Delete(file);

                //            }

                //            System.IO.Directory.CreateDirectory(strPath);
                //            strPath = strPath + "/";
                //        }

                //    }
                //}
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)OnlineLearningScreenId.OnlineLearning.OnlinelearningStudentView)
            {
                if (context.Session["TempOnlineAssignmentSubmitId"] != null)
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/OnlineLearning/AssignmentSubmit/" + context.Session["TempOnlineAssignmentSubmitId"];
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/OnlineLearning/AssignmentSubmit/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }

            }

            else if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Assignment)
            {
                if (context.Session["TempAssignmentId"] != null)
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/Assignment/TempAssignment/" + context.Session["TempAssignmentId"];
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                    //else
                    //{
                    //    string[] Files = Directory.GetFiles(strPath);

                    //    foreach (string file in Files)
                    //    {

                    //        File.Delete(file);

                    //    }

                    //    System.IO.Directory.CreateDirectory(strPath);
                    //    strPath = strPath + "/";


                    //}
                }
                else if (context.Session["AssignmentId"] != null)
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/Assignment/TempAssignment/" + context.Session["TempAssignmentId"];
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                }

                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/Assignment/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                }
                //}
                //else
                //{
                //    strPath = strPath + "/Assignment";
                //    if (!System.IO.Directory.Exists(strPath))
                //    {
                //        System.IO.Directory.CreateDirectory(strPath);
                //        strPath = strPath + "/";
                //    }
                //    else
                //    {
                //        if (System.IO.Directory.Exists(strPath))
                //        {
                //            string[] Files = Directory.GetFiles(strPath);

                //            foreach (string file in Files)
                //            {

                //                File.Delete(file);

                //            }

                //            System.IO.Directory.CreateDirectory(strPath);
                //            strPath = strPath + "/";
                //        }
                //    }
                //}
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.AssignmentView)
            {
                strPath = strPath + SecuritySession.UserProfile.OrgId + "/SubmitAssignmentDocument/" + context.Session["TempAssignmentId"] + "/" + context.Session["AssignmentDocumentUploadSource"].ToString();
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Administration.ImportMasterData)
            {
                strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempMasterData";
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.ReceiptBookMaster)
            {
                if (context.Session["UploadFor"].ToString() == "ReceiptLogoTemp")
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "/OrgGroup/ReceiptLogoTemp";
                else if (context.Session["UploadFor"].ToString() == "ReceiptBookDigitalSignature")
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "/OrgGroup/ReceiptBookDigitalSignature";
                else
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "/OrgGroup/ReceiptLogoTemp1";
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.Payroll.PayrollMaster)
            {
                if (context.Session["UploadFor"].ToString() == "PayrollHeaderTemp")
                {
                    if (context.Session["TempPayrollHeaderId"] != null)
                    {
                        strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/TempPayrollHeader/" + context.Session["TempPayrollHeaderId"];
                        if (!System.IO.Directory.Exists(strPath))
                            System.IO.Directory.CreateDirectory(strPath);
                        else
                            strPath = strPath + "/";
                    }
                    else if (context.Session["PayrollHeaderId"] != null)
                    {
                        strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/PayrollHeader/" + context.Session["PayrollHeaderId"];
                        if (!System.IO.Directory.Exists(strPath))
                            System.IO.Directory.CreateDirectory(strPath);
                        else
                            strPath = strPath + "/";
                    }
                    else
                    {
                        strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroupId/PayrollHeader/Temp";
                        if (!System.IO.Directory.Exists(strPath))
                        {
                            System.IO.Directory.CreateDirectory(strPath);
                            strPath = strPath + "/";
                        }
                    }
                }

            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.ChargeReceiptBookMaster)
            {
                if (context.Session["UploadFor"].ToString() == "ReceiptLogoTemp")
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "/OrgGroup/ReceiptLogoTemp";

                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)ComponentsScreenId.Alert.AdVendorMaster)
            {
                if (context.Session["UploadFor"].ToString() == "AdBannerTemp")
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/AdBannerTemp/";
                else
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/AdBannerTemp/";
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Behaviour)
            {
                if (context.Session["UploadFor"].ToString() == "BehaviourTemp")
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/BehaviourTemp/";
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Behaviour/" + context.Session["BehaviourId"].ToString() + "/";
                    if (Directory.Exists(strPath))
                        Directory.Delete(strPath, true);
                }

                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)FrontOfficeScreenId.AppointmentScheduling.LostFoundRegister)
            {
                if (context.Session["UploadFor"].ToString() == "LostFoundTemp")
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/LostFoundTemp/";
                else
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/LostFoundTemp/";
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.Classwork)
            {
                strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "/Classwork/" + context.Session["ClassworkId"].ToString();
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.MyClasswork)
            {
                strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "/Classwork/" + context.Session["ClassworkId"].ToString() + "/HomeworkSubmitted/" + SecuritySession.UserProfile.AcademicId;
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)SupportScreenId.Utility.ViewPhoto)
            {
                if (context.Session["CategoryId"] != null)
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Gallery/" + context.Session["CategoryId"];
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }

            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)SupportScreenId.Utility.ViewGallery)
            {
                if (context.Session["CategoryId"] != null)
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Gallery/" + context.Session["CategoryId"];
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }

            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadOrganizationPhoto)
            {
                if (context.Session["UploadFor"] == "LoginBG")
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Other";
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
                else if (context.Session["UploadFor"] == "MobileAppLogo")
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/MobileApp";
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
                else if (context.Session["UploadFor"] == "CertificateHead")
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/OrgLogos";
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
                else if (context.Session["UploadFor"] == "MarkSheetHead")
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/OrgLogos";
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
                else if (context.Session["UploadFor"] == "PayrollHead")
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/PayrollHeader";
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
                else
                {

                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/OrgLogos";
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.UploadEBookView)
            {

                strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "Book" + "/" + context.Session["EBookId"];
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";

            }

            else if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentDocuments)
            {
                if (context.Session["UploadFor"] == "StudentAllDocuments")
                {
                    string documnetid = HttpContext.Current.Request.QueryString["DocId"];
                    if (!string.IsNullOrEmpty(documnetid))
                    {
                        string Tempimageurl;
                        Tempimageurl = HttpContext.Current.Server.MapPath("../../Content/" + SecuritySession.UserProfile.OrgId + "/StudentAllDocuments/Temp/" + documnetid);

                        if ((Directory.Exists(Tempimageurl)))
                        {
                            DirectoryInfo dir1 = new DirectoryInfo(Tempimageurl);
                            dir1.Delete(true);
                        }
                        string Studentimageurl;
                        Studentimageurl = HttpContext.Current.Server.MapPath("../../Content/" + SecuritySession.UserProfile.OrgId + "/StudentAllDocuments/" + StudentManagementSession.StudentList[0].Id.ToString() + "/" + documnetid);
                        if ((Directory.Exists(Studentimageurl)))
                        {
                            DirectoryInfo dir = new DirectoryInfo(Studentimageurl);
                            dir.Delete(true);

                        }
                        DataSet ds = cf.GetDataset("DELETE FROM  sStudent.tStudentDocument WHERE SubmitDocumentMasterId=" + documnetid + " AND StudentId=" + StudentManagementSession.StudentList[0].Id.ToString() + "");

                        strPath = strPath + SecuritySession.UserProfile.OrgId + "/StudentAllDocuments/Temp/" + documnetid;
                        if (!System.IO.Directory.Exists(strPath))
                        {
                            System.IO.Directory.CreateDirectory(strPath);
                            strPath = strPath + "/";
                        }
                        else
                            strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/StudentDocuments/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.MyDigitalForm)
            {
                if (context.Session["UploadFor"] == "StudentAllDocuments")
                {
                    string documnetid = HttpContext.Current.Request.QueryString["DocId"];
                    if (!string.IsNullOrEmpty(documnetid))
                    {
                        string Tempimageurl;
                        Tempimageurl = HttpContext.Current.Server.MapPath("../../Content/" + SecuritySession.UserProfile.OrgId + "/StudentAllDocuments/Temp/" + documnetid);

                        if ((Directory.Exists(Tempimageurl)))
                        {
                            DirectoryInfo dir1 = new DirectoryInfo(Tempimageurl);
                            dir1.Delete(true);
                        }

                        strPath = strPath + SecuritySession.UserProfile.OrgId + "/StudentAllDocuments/Temp/" + documnetid;
                        if (!System.IO.Directory.Exists(strPath))
                        {
                            System.IO.Directory.CreateDirectory(strPath);
                            strPath = strPath + "/";
                        }
                        else
                            strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/StudentDocuments/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.EmployeeDocument)
            {
                if (context.Session["UploadFor"] == "EmployeeAllDocuments")
                {
                    string documnetid = HttpContext.Current.Request.QueryString["DocId"];
                    if (!string.IsNullOrEmpty(documnetid))
                    {
                        string Tempimageurl;
                        Tempimageurl = HttpContext.Current.Server.MapPath("../../Content/" + SecuritySession.UserProfile.OrgId + "/EmployeeAllDocuments/Temp/" + documnetid);

                        if ((Directory.Exists(Tempimageurl)))
                        {
                            DirectoryInfo dir1 = new DirectoryInfo(Tempimageurl);
                            dir1.Delete(true);
                        }
                        string Studentimageurl;
                        Studentimageurl = HttpContext.Current.Server.MapPath("../../Content/" + SecuritySession.UserProfile.OrgId + "/EmployeeAllDocuments/" + HrmSession.EmployeeDetailsData.Id.ToString() + "/" + documnetid);
                        if ((Directory.Exists(Studentimageurl)))
                        {
                            DirectoryInfo dir = new DirectoryInfo(Studentimageurl);
                            dir.Delete(true);

                        }
                        DataSet ds = cf.GetDataset("DELETE FROM  sHrm.tEmployeeDocument WHERE SubmitDocumentMasterId=" + documnetid + " AND EmployeeId=" + HrmSession.EmployeeDetailsData.Id.ToString() + "");

                        strPath = strPath + SecuritySession.UserProfile.OrgId + "/EmployeeAllDocuments/Temp/" + documnetid;
                        if (!System.IO.Directory.Exists(strPath))
                        {
                            System.IO.Directory.CreateDirectory(strPath);
                            strPath = strPath + "/";
                        }
                        else
                            strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/EmployeeDocuments/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";

                    }
                    else
                        strPath = strPath + "/";
                }
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.MyDigitalForm)
            {
                if (context.Session["UploadFor"] == "EmployeeAllDocuments")
                {
                    string documnetid = HttpContext.Current.Request.QueryString["DocId"];
                    if (!string.IsNullOrEmpty(documnetid))
                    {
                        string Tempimageurl;
                        Tempimageurl = HttpContext.Current.Server.MapPath("../../Content/" + SecuritySession.UserProfile.OrgId + "/EmployeeAllDocuments/Temp/" + documnetid);

                        if ((Directory.Exists(Tempimageurl)))
                        {
                            DirectoryInfo dir1 = new DirectoryInfo(Tempimageurl);
                            dir1.Delete(true);
                        }

                        strPath = strPath + SecuritySession.UserProfile.OrgId + "/EmployeeAllDocuments/Temp/" + documnetid;
                        if (!System.IO.Directory.Exists(strPath))
                        {
                            System.IO.Directory.CreateDirectory(strPath);
                            strPath = strPath + "/";
                        }
                        else
                            strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/EmployeeDocuments/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentOtherPhoto)
            {
                strPath = strPath + SecuritySession.UserProfile.OrgId + "/StudentPhoto/Temp";
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";

                }
                else
                    strPath = strPath + "/";
            }

            else if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.UploadResult)
            {
                if (HttpContext.Current.Request.QueryString["ScreenId"] == "20179")
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/UploadResult/" + context.Session["ResultId"];
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";

                    }
                    else
                        strPath = strPath + "/";
                }
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/UploadResult/2/" + context.Session["ResultId"];
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";

                    }
                    else
                        strPath = strPath + "/";
                }
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.TopicMaster)
            {
                strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempLessonPlan";
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";

                }
                else
                    strPath = strPath + "/";
            }

            else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.Leave)
            {
                if (context.Session["LeaveId"] != null)
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Leave/" + context.Session["LeaveId"];
                else
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Leave/Temp";
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";

                }
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.MyLeaveRequest
                || SecuritySession.UserProfile.CurrentScreenId == (int)AttendanceScreenId.Attendance.StudentLeaveRequest)
            {
                if (context.Session["LeaveId"] != null)
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/StudentLeave/" + context.Session["LeaveId"];
                else
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/StudentLeave/Temp";
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";

                }
                else
                    strPath = strPath + "/";
            }

            else if (SecuritySession.UserProfile.CurrentScreenId == (int)FinancialManagementScreenId.Accounting.MyExpense)
            {
                if (context.Session["ExpenseId"] != null)
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Expense/" + context.Session["ExpenseId"];
                else
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Expense/Temp";
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";

                }
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.MyLeave)
            {
                if (context.Session["LeaveId"] != null)
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Leave/" + context.Session["LeaveId"];
                else
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Leave/Temp";
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";

                }
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)LibraryScreenId.Library.BookMaster)
            {
                strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "/TempBookphoto";
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";



            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)FinancialManagementScreenId.AssetManagement.AssetMaster && context.Request.Form[2].ToString() == "1")
            {
                if (context.Session["TempAssetMasterId"] != null)// && context.Session["IsAssetEdit"] == "0")
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/TempAssetPhotos/" + context.Session["TempAssetMasterId"];
                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";
                    }
                    else
                        strPath = strPath + "/";
                }
                //else if (context.Session["TempAssetMasterId"] != null && context.Session["IsAssetEdit"] == "1")
                //{
                //    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/AssetPhotos/" + context.Session["TempAssetMasterId"];
                //    if (!System.IO.Directory.Exists(strPath))
                //        System.IO.Directory.CreateDirectory(strPath);
                //    else
                //        strPath = strPath + "/";
                //}
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/AssetPhotos/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }

            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)FinancialManagementScreenId.AssetManagement.AssetMaster && context.Request.Form[2].ToString() == "2")
            {
                if (context.Session["TempAssetMasterId"] != null)// && context.Session["IsAssetEdit"] == "0")
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/TempAssetMaster/" + context.Session["TempAssetMasterId"];
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }
                //else if (context.Session["TempAssetMasterId"] != null && context.Session["IsAssetEdit"] == "1")
                //{
                //    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/AssetMaster/" + context.Session["TempAssetMasterId"];
                //    if (!System.IO.Directory.Exists(strPath))
                //        System.IO.Directory.CreateDirectory(strPath);
                //    else
                //        strPath = strPath + "/";
                //}
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/AssetMaster/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }
            }
            //Add new ScreenId for Student Gate Pass by Hemali Mantis ID: 0027599
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)FrontOfficeScreenId.AppointmentScheduling.StudentGatePass)
            {
                if (context.Session["TempStudentGatePassId"] != null)
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/TempStudentGatePass/" + context.Session["TempStudentGatePassId"];
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/StudentGatePass/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)FrontOfficeScreenId.AppointmentScheduling.InwardRegister)
            {

                strPath = strPath + SecuritySession.UserProfile.OrgId + "/InwardRegister/Temp";
                if (!System.IO.Directory.Exists(strPath))
                    System.IO.Directory.CreateDirectory(strPath);
                else
                    strPath = strPath + "/";

            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)FrontOfficeScreenId.AppointmentScheduling.OutwardRegister)
            {

                strPath = strPath + SecuritySession.UserProfile.OrgId + "/OutwardRegister/Temp";
                if (!System.IO.Directory.Exists(strPath))
                    System.IO.Directory.CreateDirectory(strPath);
                else
                    strPath = strPath + "/";

            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)AdmissionScreenId.Admission.AdmissionFormDetail)
            {

                strPath = strPath + SecuritySession.UserProfile.OrgId + "/AdmissionDetail/" + HttpContext.Current.Request.QueryString["FolderName"] + "/" + context.Session["AdmissionFormPhotoTempId"];
                if (!System.IO.Directory.Exists(strPath))
                    System.IO.Directory.CreateDirectory(strPath);
                else
                    strPath = strPath + "/";

            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockInwardBulk)
            {

                strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempStockInword/" + HttpContext.Current.Request.QueryString["FolderName"];
                if (!System.IO.Directory.Exists(strPath))
                    System.IO.Directory.CreateDirectory(strPath);
                else
                    strPath = strPath + "/";

            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)ComponentsScreenId.Alert.SMSToAll)
            {
                //strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempSMSToAllEmail/" + HttpContext.Current.Request.QueryString["FolderName"];
                strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempSMSToAllEmail/" + context.Session["SMSToAllFiles"];
                if (!System.IO.Directory.Exists(strPath))
                    System.IO.Directory.CreateDirectory(strPath);
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)ComponentsScreenId.Alert.SMSPredefine)
            {
                strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempSMSPredefine/" + context.Session["SMSPredefineFiles"];
                if (!System.IO.Directory.Exists(strPath))
                    System.IO.Directory.CreateDirectory(strPath);
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)ComponentsScreenId.Alert.SMSFromExcel && context.Request.Form[2].ToString() == "2")
            {
                strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempSMSFromExcel/" + context.Session["SMSFromExcelFiles"];
                if (!System.IO.Directory.Exists(strPath))
                    System.IO.Directory.CreateDirectory(strPath);
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Administration.ImageRepository)
            {
                if (HttpContext.Current.Request.QueryString["FolderName"] == "TempImageRepository")
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempImageRepository/";
                else if (HttpContext.Current.Request.QueryString["FolderName"] == "StudentBirthdayCard")
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "/StudentBirthdayCard/";
                else if (HttpContext.Current.Request.QueryString["FolderName"] == "Admission")
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/Admission/";
                else if (HttpContext.Current.Request.QueryString["FolderName"] == "Inquiry")
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/Inquiry/";
                //mantisid - 0029643
                else if (HttpContext.Current.Request.QueryString["FolderName"] == "EmployeeBirthdayCard")
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "/EmployeeBirthdayCard/";

                if (!System.IO.Directory.Exists(strPath))
                    System.IO.Directory.CreateDirectory(strPath);
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Query)
            {
                if (context.Session["TempQueryId"] != null)
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/TempQuery/" + context.Session["TempQueryId"];
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Query/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }

            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.AssignTask)
            {
                if (context.Session["TempTaskId"] != null)
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempTask/" + context.Session["TempTaskId"];
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgId + "/Task/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }

            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)OnlineLearningScreenId.OnlineLearning.OnlineLearning)
            {
                if (context.Session["TempOnlineAssignmentId"] != null && context.Session["IsEdit"] == "0")
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/OnlineLearning/TempAssignment/" + context.Session["TempOnlineAssignmentId"];
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }
                else if (context.Session["TempOnlineAssignmentId"] != null && context.Session["IsEdit"] == "1")
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/OnlineLearning/Assignment/" + context.Session["TempOnlineAssignmentId"];
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/OnlineLearning/Assignment/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }

            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.StudentDocumentUpload)
            {
                strPath = strPath + SecuritySession.UserProfile.OrgId + "/StudentUploadedDocuments/" + context.Session["StudentDocumentId"];
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";

                }
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.EmployeeDocumentUpload)
            {

                strPath = strPath + SecuritySession.UserProfile.OrgId + "/EmployeeUploadedDocuments/" + context.Session["EmployeeDocumentId"];
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";

            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)RecruitmentScreenId.Recruitment.CandidateMaster)
            {
                string documnetid = HttpContext.Current.Request.QueryString["DocId"];
                string FilePath = HttpContext.Current.Request.QueryString["FilePath"];
                strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempRecruitmentRecruiterDocuments/" + FilePath + "/" + documnetid;
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)InstituteManagementScreenId.Setup.OnlineFormSetup)
            {
                if (context.Session["OnlineFormSetup_UploadType"] != null)
                {
                    if (context.Session["OnlineFormSetup_UploadType"] == "1")
                    {
                        if (context.Session["OnlineFormSetup_TempId"] != null)
                        {
                            strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/TempOnlineFormSetup/Logo/" + context.Session["OnlineFormSetup_TempId"];
                            if (!System.IO.Directory.Exists(strPath))
                                System.IO.Directory.CreateDirectory(strPath);
                            else
                                strPath = strPath + "/";
                        }
                        else if (context.Session["OnlineFormSetup_Id"] != null)
                        {
                            strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/OnlineFormSetup/Logo/" + context.Session["OnlineFormSetup_Id"];
                            if (!System.IO.Directory.Exists(strPath))
                                System.IO.Directory.CreateDirectory(strPath);
                            else
                                strPath = strPath + "/";
                        }
                    }
                    else if (context.Session["OnlineFormSetup_UploadType"] == "2")
                    {
                        if (context.Session["OnlineFormSetup_TempId"] != null)
                        {
                            strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/TempOnlineFormSetup/BackgroundImage/" + context.Session["OnlineFormSetup_TempId"];
                            if (!System.IO.Directory.Exists(strPath))
                                System.IO.Directory.CreateDirectory(strPath);
                            else
                                strPath = strPath + "/";
                        }
                        else if (context.Session["OnlineFormSetup_Id"] != null)
                        {
                            strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/OnlineFormSetup/BackgroundImage/" + context.Session["OnlineFormSetup_Id"];
                            if (!System.IO.Directory.Exists(strPath))
                                System.IO.Directory.CreateDirectory(strPath);
                            else
                                strPath = strPath + "/";
                        }
                    }
                    else if (context.Session["OnlineFormSetup_UploadType"] == "3")
                    {
                        if (context.Session["OnlineFormSetup_TempId"] != null)
                        {
                            strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/TempOnlineFormSetup/Attachment/" + context.Session["OnlineFormSetup_TempId"];
                            if (!System.IO.Directory.Exists(strPath))
                                System.IO.Directory.CreateDirectory(strPath);
                            else
                                strPath = strPath + "/";
                        }
                        else if (context.Session["OnlineFormSetup_Id"] != null)
                        {
                            strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/OnlineFormSetup/Attachment/" + context.Session["OnlineFormSetup_Id"];
                            if (!System.IO.Directory.Exists(strPath))
                                System.IO.Directory.CreateDirectory(strPath);
                            else
                                strPath = strPath + "/";
                        }
                    }
                }
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockInwardWithCopyPaste && context.Request.Form[2].ToString() == "2")
            {
                if (context.Session["TempStockInwardId"] != null)
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/TempStockInward/" + context.Session["TempStockInwardId"];
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }
                else
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/StockInward/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }
            }
            //else if (SecuritySession.UserProfile.CurrentScreenId == (int)RecruitmentScreenId.Recruitment.CandidateMaster)
            //{
            //    if (context.Session["UploadFor"] == "RecruitmentAllDocuments")
            //    {
            //        string documnetid = HttpContext.Current.Request.QueryString["DocId"];
            //        string FilePath = HttpContext.Current.Request.QueryString["FilePath"];
            //        string VacancyId = HttpContext.Current.Request.QueryString["VacancyId"];
            //        string CandidateId = HttpContext.Current.Request.QueryString["CandidateId"];
            //        if (!string.IsNullOrEmpty(documnetid))
            //        {
            //            string Tempimageurl;
            //            Tempimageurl = HttpContext.Current.Server.MapPath("../../Content/" + SecuritySession.UserProfile.OrgId + "/RecruitmentRecruiterDocuments/Temp/" + documnetid);

       //            if ((Directory.Exists(Tempimageurl)))
            //            {
            //                DirectoryInfo dir1 = new DirectoryInfo(Tempimageurl);
            //                dir1.Delete(true);
            //            }
            //            string Studentimageurl;
            //            Studentimageurl = HttpContext.Current.Server.MapPath("../../Content/" + SecuritySession.UserProfile.OrgId + "/RecruitmentRecruiterDocuments/" + FilePath + "/" + documnetid);
            //            if ((Directory.Exists(Studentimageurl)))
            //            {
            //                DirectoryInfo dir = new DirectoryInfo(Studentimageurl);
            //                dir.Delete(true);

       //            }
            //            Sapphire.Ohu.BaseFramework.Utilities.CommonFunctions cf = new Sapphire.Ohu.BaseFramework.Utilities.CommonFunctions();
            //            DataSet ds = cf.GetDataset("DELETE FROM  sStudent.tStudentDocument WHERE SubmitDocumentMasterId=" + documnetid + " AND StudentId=" + StudentManagementSession.StudentList[0].Id.ToString() + "");

       //            strPath = strPath + SecuritySession.UserProfile.OrgId + "/StudentAllDocuments/Temp/" + documnetid;
            //            if (!System.IO.Directory.Exists(strPath))
            //            {
            //                System.IO.Directory.CreateDirectory(strPath);
            //                strPath = strPath + "/";
            //            }
            //            else
            //                strPath = strPath + "/";
            //        }
            //        else
            //            strPath = strPath + "/";
            //    }
            //    else
            //    {
            //        strPath = strPath + SecuritySession.UserProfile.OrgId + "/RecruitmentRecruiterDocuments/Temp";
            //        if (!System.IO.Directory.Exists(strPath))
            //        {
            //            System.IO.Directory.CreateDirectory(strPath);
            //            strPath = strPath + "/";
            //        }
            //        else
            //            strPath = strPath + "/";
            //    }
            //}
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)HostelScreenId.Hostel.VisitorGatePass)
            {
                strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempPhotos/";
                if (!System.IO.Directory.Exists(strPath))
                    System.IO.Directory.CreateDirectory(strPath);
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.LessonPlan)
            {
                if (context.Session["LessonPlanId"] != null)// && context.Session["IsAssetEdit"] == "0")
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "OG/LessonPlan/TempLessonPlan/" + context.Session["LessonPlanId"];
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }

            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.VendorMaster) // changes for mantis id :32619
            {
                strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempVendorMaster";
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";

                }
                else
                    strPath = strPath + "/";
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)TransportScreenId.Transport.VehicleMaster) // Mantis Id :0032433
            {
                string DocumentId = HttpContext.Current.Request.QueryString["DocId"];
                if (DocumentId != null)
                {
                    strPath = strPath + SecuritySession.UserProfile.OrgGroupId + "/VehicleDocuments/Temp/" + DocumentId;

                    if ((Directory.Exists(strPath)))
                    {
                        DirectoryInfo dir = new DirectoryInfo(strPath);
                        dir.Delete(true);
                    }
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }
            }
            else if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentImport) // changes for mantis id :32619
            {
                strPath = strPath + SecuritySession.UserProfile.OrgId + "/TempStudentImport";
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";

                }
                else
                    strPath = strPath + "/";
            }
            else
            {
                strPath = strPath + SecuritySession.UserProfile.OrgId;
                if (!System.IO.Directory.Exists(strPath))
                {
                    System.IO.Directory.CreateDirectory(strPath);
                    strPath = strPath + "/";
                }
                else
                    strPath = strPath + "/";
            }


        }
        for (int i = 0; i < postedFile.Count; i++)
        {
            HttpPostedFile file = postedFile[i];
            filename = file.FileName;
            string fileExt1 = System.IO.Path.GetExtension(filename).Replace(".", "");

            if (SecuritySession.UserProfile.CurrentScreenId == (int)ComponentsScreenId.Alert.SMSToAll)
            {
                //filename = Path.GetFileNameWithoutExtension(filename) + "_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                if (context.Session["IsWhatsappAlertSMSToAll"] != null && Convert.ToBoolean(context.Session["IsWhatsappAlertSMSToAll"]) == true)
                {
                    bool IsValidFileName = !System.Text.RegularExpressions.Regex.IsMatch(Path.GetFileNameWithoutExtension(filename).Trim(), @"[^a-zA-Z0-9\.\s\-_~`!@$^&()=-\[\]{};'.]");
                    filename = (IsValidFileName ? Path.GetFileNameWithoutExtension(filename) : "SmsToAll_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now)) + "." + fileExt1.ToString();
                }
                else
                {
                    filename = Path.GetFileNameWithoutExtension(filename) + "." + fileExt1.ToString();
                }
            }
            if (SecuritySession.UserProfile != null)
            {

                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportEmployee)
                {
                    filename = "ImportEmployee_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportDynamicEmployee)
                {
                    filename = "ImportDynamicEmployee_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportDynamicStudent)
                {
                    filename = "ImportDynamicStudent_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStudent)
                {
                    filename = "ImportStudent_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStudentOldDetail)
                {
                    filename = "ImportStudentOldDetail_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStockItem)
                {
                    filename = "ImportStockItem_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.FeeAllocation)
                {
                    filename = "FeeAllocation_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportBook)
                {
                    filename = "ImportBook_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportHostel)
                {
                    filename = "ImportHostel_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportAdmissionInquiry)
                {
                    filename = "ImportAdmissionInquiry_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportUser)
                {
                    filename = "ImportUser_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportEvent)
                {
                    filename = "ImportEvent_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportFee)
                {
                    filename = "ImportFee_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportSubjectActivity)
                {
                    filename = "ImportSubjectActivity_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportSubjectActivityIndicator)
                {
                    filename = "ImportSubjectActivityIndicator_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportCoScholasticIndicator)
                {
                    filename = "ImportCoScholasticIndicator_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportAdmissionForm)
                {
                    filename = "ImportAdmissionForm_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentDataUpdate)
                {
                    filename = "StudentDataUpdate_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)TransportScreenId.Transport.QuickTransportEntry)
                {
                    filename = "QuickTransportEntry_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)AttendanceScreenId.Attendance.DivisionRegister)
                {
                    filename = "DivisionRegister_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.FeeInvoiceImport)
                {
                    filename = "FeeInvoiceImport_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.FeeReceiptImport)
                {
                    filename = "FeeReceiptImport_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)FinancialManagementScreenId.Accounting.VoucherEntry)
                {
                    filename = "VoucherEntry_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)TimeTableScreenId.TimeTable.TimeTableAdmin)
                {
                    filename = "TimeTableImport_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryOtherDetail)
                {
                    filename = "MarkEntryOtherDetail_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.StudentResultRemark)
                {
                    filename = "StudentResultRemark_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.SUIDGeneration)
                {
                    filename = "SuIdGeneratrion_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.IDNoGeneration)
                {
                    filename = "IDNoGeneration_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.SubjectRemark)
                {
                    filename = "SubjectRemark_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSIndicatorMaster)
                {
                    filename = "CSIndicatorMaster_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSExamScoreBulk)
                {
                    filename = "CSExamScoreBulk_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSExamMarkEntryBulk)
                {
                    filename = "CSExamMarkEntryBulk_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSExamIndicator)
                {
                    filename = "CSExamIndicator_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.SubjectIndicator)
                {
                    filename = "SubjectIndicator_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.SubjectActivityIndicatorMaster)
                {
                    filename = "SubjectActivityIndicator_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.SubjectActivityGradeScoreBulk)
                {
                    filename = "SubjectActivityGradeScoreBulk_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.SubjectActivityMarkEntryBulk)
                {
                    filename = "SubjectActivityMarkEntryBulk_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockIssueNew)
                {
                    filename = "StockIssueNew_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockInwardNew)
                {
                    filename = "StockInwardNew_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockInwardBulk)
                {
                    filename = "StockInwardBulk_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                //if (SecuritySession.UserProfile.CurrentScreenId == (int)ComponentsScreenId.Alert.SMSToAll)
                //{
                //    filename = "SmsToAll_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                //}
                if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockInwardWithCopyPaste)
                {
                    filename = "StockInwardWithCopyPaste_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)FinancialManagementScreenId.AssetManagement.AssetIncharge)
                {
                    filename = "AssetIncharge_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockAdjustment)
                {
                    filename = "StockAdjustment_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.EmployeeDataUpdate)
                {
                    filename = "EmployeeDataUpdate_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.MonthlyAttendance)
                {
                    filename = "MonthlyAttendance_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.BulkUpdate)
                {
                    filename = "BulkUpdate_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.ClubHouseCommiteeBulk)
                {
                    filename = "ClubHouseCommiteeBulk" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.TopicMaster)
                {
                    filename = "TopicMaster_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }

                if (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryAllSubject)
                {
                    filename = "MarkEntryAllSubject_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }

                if (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryForAll)
                {
                    filename = "MarkEntry_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentICard)
                {
                    filename = "StudentICard_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.EmployeeICard)
                {
                    filename = "EmployeeICard_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)ComponentsScreenId.Boimetric.ImportStudentCloud)
                {
                    filename = "ImportStudentCloud_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }

                //if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Circular)
                //{

                //    filename = "Circular_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();

                //}

                if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.VendorMaster)
                {
                    filename = "VendorMaster_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentImport)
                {
                    filename = "StudentImport_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Administration.ImageRepository)
                {
                    if (HttpContext.Current.Request.QueryString["FolderName"] == "TempImageRepository")
                        filename = "TemplateImage_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                    else if (HttpContext.Current.Request.QueryString["FolderName"] == "Admission")
                        filename = "Admission" + HttpContext.Current.Request.QueryString["DocId"] + "." + fileExt1.ToString();
                    else if (HttpContext.Current.Request.QueryString["FolderName"] == "Inquiry")
                        filename = "Inquiry" + HttpContext.Current.Request.QueryString["DocId"] + "." + fileExt1.ToString();
                    //mantisid - 0029643
                    else if (HttpContext.Current.Request.QueryString["FolderName"] == "EmployeeBirthdayCard")
                        filename = "EmployeeBirthdayCard" + HttpContext.Current.Request.QueryString["DocId"] + "." + fileExt1.ToString();
                    else
                        filename = "StudentBirthdayCard" + HttpContext.Current.Request.QueryString["DocId"] + "." + fileExt1.ToString();
                }

                //if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Assignment)
                //{
                //    filename = "Assignment_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                //}
                if (SecuritySession.UserProfile.CurrentScreenId == (int)ComponentsScreenId.Alert.SMSFromExcel && context.Request.Form[2].ToString() != "2")
                {
                    filename = "SMSOrMail" + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Administration.ImportMasterData)
                {

                    filename = "ImportMasterData_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.ReceiptBookMaster)
                {

                    filename = "ReceiptBookMaster_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.Payroll.PayrollMaster)
                {

                    filename = "PayrollMaster_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.ChargeReceiptBookMaster)
                {

                    filename = "ChargeReceiptBookMaster_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)ComponentsScreenId.Alert.AdVendorMaster)
                    filename = "AdBanner" + "." + fileExt1.ToString();

                //if (SecuritySession.UserProfile.CurrentScreenId == (int)SupportScreenId.Utility.ViewPhoto)
                //{
                //    if (context.Session["Cata"] != null)
                //    {

                //        filename = "ViewPhoto_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                //    }
                //}
                if (SecuritySession.UserProfile.CurrentScreenId == (int)OnlineLearningScreenId.OnlineLearning.MeetingAccountMaster)
                {
                    filename = "MeetingAccount_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportLessonPlan)
                {
                    filename = "ImportLessonPlan_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportInwardRegister)
                {
                    filename = "ImportInwardRegister_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportOutwardRegister)
                {
                    filename = "ImportOutwardRegister_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)AttendanceScreenId.Attendance.AttendanceMonthly)
                {
                    // MantisId : 0034075
                    if (context.Session["MonthlyAttendanceUpload"] == "MonthlyAttendanceImport")
                        filename = "MonthlyAttendanceRegister_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                    else
                        filename = "MonthlyAttendanceRegisterDateWise_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)CertificateScreenId.Certificate.FirstTrialBulk)
                {
                    filename = "FirstTrialBulk_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)TransportScreenId.Transport.FuelLogs)
                {
                    filename = "FuelLogBulk_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)HostelScreenId.Hostel.VisitorGatePass)
                {
                    filename = "VisitorGatePass_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadOrganizationPhoto)
                {

                    if (context.Session["UploadFor"] == "LoginBG")
                    {
                        filename = "LoginBG" + "." + fileExt1.ToString();
                    }
                    else if (context.Session["UploadFor"] == "PrincipalSignature")
                    {
                        filename = "PrincipalSignature" + "." + fileExt1.ToString();
                    }
                    else if (context.Session["UploadFor"] == "OrganizationHead")
                    {
                        filename = "OrganizationHead" + "." + fileExt1.ToString();
                    }
                    else if (context.Session["UploadFor"] == "OrganizationHeadA4Landscape")
                    {
                        filename = "OrganizationHeadA4Landscape" + "." + fileExt1.ToString();

                    }
                    else if (context.Session["UploadFor"] == "CertificateHead")
                    {
                        filename = "CertificateHead" + "." + fileExt1.ToString();

                    }
                    else if (context.Session["UploadFor"] == "MarkSheetHead")
                    {
                        filename = "MarkSheetHead" + "." + fileExt1.ToString();

                    }
                    else if (context.Session["UploadFor"] == "PayrollHead")
                    {
                        filename = "PayrollHead" + "." + fileExt1.ToString();

                    }
                    else if (context.Session["UploadFor"] == "IcardBg")
                    {
                        filename = "IcardBg" + "." + fileExt1.ToString();

                    }
                    else if (context.Session["UploadFor"] == "IcardBackBg")
                    {
                        filename = "IcardBackBg" + "." + fileExt1.ToString();
                    }
                    else if (context.Session["UploadFor"] == "MobileAppLogo")
                    {
                        filename = "SchoolLogo" + "." + fileExt1.ToString();
                    }
                    else
                    {

                        filename = "SchoolLogo" + "." + fileExt1.ToString();

                    }
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)CRMScreenId.CRM.LeadMaster)
                {
                    filename = "LeadMaster_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentDetailUpdate)
                {
                    filename = "StudentDetailUpdate_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.Leave)
                {
                    filename = "Leave_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)FinancialManagementScreenId.Accounting.MyExpense)
                {
                    filename = "Expense_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.MyLeave)
                {
                    filename = "MyLeave_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)LibraryScreenId.Library.BookMaster)
                {
                    filename = "Book" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)AdmissionScreenId.Admission.AdmissionFormDetail)
                {
                    filename = "AdmissionFormDetail" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.RecieptChequeClear)
                {
                    filename = "ReceiptChequeClear_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                //if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockInwardWithCopyPaste)
                //{
                //    filename = "StockInward_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                //}
                if (SecuritySession.UserProfile.CurrentScreenId == (int)FinancialManagementScreenId.AssetManagement.AssetMaster && context.Request.Form[2].ToString() == "1")
                {
                    filename = "Asset" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                //change start for manits: 32679
                if (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.ChargeReceiptImport)
                {
                    filename = "ChargeReceiptImport_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
                //change end for manits: 32679

                //change start for manits: 0033029
                if (SecuritySession.UserProfile.CurrentScreenId == (int)ComponentsScreenId.Alert.SMSPredefine)
                {
                    if (context.Session["IsWhatsappAlertSMSPredefine"] != null && Convert.ToBoolean(context.Session["IsWhatsappAlertSMSPredefine"]) == true)
                    {
                        bool IsValidFileName = !System.Text.RegularExpressions.Regex.IsMatch(Path.GetFileNameWithoutExtension(filename).Trim(), @"[^a-zA-Z0-9\.\s\-_~`!@$^&()=-\[\]{};'.]");
                        filename = (IsValidFileName ? Path.GetFileNameWithoutExtension(filename) : "SMSPredefine_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now)) + "." + fileExt1.ToString();
                    }
                    else
                    {
                        filename = Path.GetFileNameWithoutExtension(filename) + "." + fileExt1.ToString();
                    }
                }
                if (SecuritySession.UserProfile.CurrentScreenId == (int)ComponentsScreenId.Alert.SMSFromExcel && context.Request.Form[2].ToString() == "2")
                {
                    if (context.Session["IsWhatsappAlertSMSFromExcel"] != null && Convert.ToBoolean(context.Session["IsWhatsappAlertSMSFromExcel"]) == true)
                    {
                        bool IsValidFileName = !System.Text.RegularExpressions.Regex.IsMatch(Path.GetFileNameWithoutExtension(filename).Trim(), @"[^a-zA-Z0-9\.\s\-_~`!@$^&()=-\[\]{};'.]");
                        filename = (IsValidFileName ? Path.GetFileNameWithoutExtension(filename) : "SMSFromExcel_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now)) + "." + fileExt1.ToString();
                    }
                    else
                    {
                        filename = Path.GetFileNameWithoutExtension(filename) + "." + fileExt1.ToString();
                    }
                }
                //change end for manits: 0033029

                // Mantis Id :  0034680
                if (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntry)
                {
                    filename = "MarkEntrySingleSubject_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
                }
            }
            if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadStudentPhoto
                || SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentDocuments
                || SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentOtherPhoto
                || SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.EmployeeDocument
                || SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadEmployeePhoto
                || SecuritySession.UserProfile.CurrentScreenId == (int)SupportScreenId.Utility.ViewPhoto
                || SecuritySession.UserProfile.CurrentScreenId == (int)SupportScreenId.Utility.ViewGallery)
            {
                var t = postedFile[i].ContentLength / 1024;
                var t1 = (t / 1024) * 100 / 100;
                if (t1 < 1)
                {
                    if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadStudentPhoto)
                    {
                        string StudentCode = Path.GetFileNameWithoutExtension(file.FileName);
                        Int64 StudentId = 0;
                        string sql_query = "SELECT Id FROM sStudent.tStudentMaster WHERE Code='" + StudentCode + "' AND OrgId=" + SecuritySession.UserProfile.OrgId;
                        Sapphire.Ohu.BaseFramework.Utilities.CommonFunctions cf1 = new Sapphire.Ohu.BaseFramework.Utilities.CommonFunctions();
                        DataSet GetStudentIdDS = cf1.GetDataset(sql_query);
                        if (GetStudentIdDS != null && GetStudentIdDS.Tables.Count > 0 && GetStudentIdDS.Tables[0].Rows.Count > 0)
                        {
                            StudentId = Convert.ToInt64(GetStudentIdDS.Tables[0].Rows[0][0].ToString());
                            filename = StudentId.ToString() + Path.GetExtension(postedFile[i].FileName).ToLower();
                        }
                    }
                    if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadEmployeePhoto)
                    {
                        string EmployeeCode = Path.GetFileNameWithoutExtension(file.FileName);
                        Int64 EmployeeId = 0;
                        string sql_query = "SELECT Id FROM sHrm.tEmployeeMaster WHERE Code='" + EmployeeCode + "' AND OrgId=" + SecuritySession.UserProfile.OrgId + " AND  ISNULL(IsOtherUser,0) = 0";
                        Sapphire.Ohu.BaseFramework.Utilities.CommonFunctions cf1 = new Sapphire.Ohu.BaseFramework.Utilities.CommonFunctions();
                        DataSet GetEmployeeIdDS = cf1.GetDataset(sql_query);
                        if (GetEmployeeIdDS != null && GetEmployeeIdDS.Tables.Count > 0 && GetEmployeeIdDS.Tables[0].Rows.Count > 0)
                        {
                            EmployeeId = Convert.ToInt64(GetEmployeeIdDS.Tables[0].Rows[0][0].ToString());
                            filename = EmployeeId.ToString() + Path.GetExtension(postedFile[i].FileName).ToLower();
                        }
                    }

                    context.Session["FileName"] = filename;

                    if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentOtherPhoto)
                    {
                        if (Path.GetExtension(postedFile[i].FileName).ToLower() == ".jpg" || Path.GetExtension(postedFile[i].FileName).ToLower() == ".jpeg" || Path.GetExtension(postedFile[i].FileName).ToLower() == ".bmp" || Path.GetExtension(postedFile[i].FileName).ToLower() == ".png")
                        {
                            if (IsImageOptimize == true)
                            {
                                byte[] ImgArray = null;
                                using (var binaryReader = new BinaryReader(postedFile[i].InputStream))
                                {
                                    ImgArray = binaryReader.ReadBytes(postedFile[i].ContentLength);
                                }
                                ImageConverter converter = new ImageConverter();

                                using (MemoryStream StartMemoryStream = new MemoryStream(),
                                                        NewMemoryStream = new MemoryStream())
                                {
                                    StartMemoryStream.Write(ImgArray, 0, ImgArray.Length);

                                    if (ImgArray.Length > 4)
                                    {
                                        Bitmap startBitmap = new Bitmap(StartMemoryStream);
                                        System.Drawing.Image image = System.Drawing.Image.FromStream(new System.IO.MemoryStream(ImgArray));

                                        int newHeight = image.Height;
                                        int newWidth = image.Width;

                                        Bitmap newBitmap = new Bitmap(newWidth, newHeight);
                                        newBitmap = ResizeImage(startBitmap, newWidth, newHeight);

                                        newBitmap.Save(NewMemoryStream, System.Drawing.Imaging.ImageFormat.Jpeg);

                                        ImgArray = NewMemoryStream.ToArray();

                                        File.WriteAllBytes(strPath + "/" + filename, ImgArray);

                                    }
                                }
                            }
                            else
                            {

                                file.SaveAs(strPath + "/" + filename);

                                if (System.IO.File.Exists(strPath))
                                {

                                }
                            }
                        }
                        else
                        {

                            file.SaveAs(strPath + "/" + filename);

                            if (System.IO.File.Exists(strPath))
                            {

                            }
                        }
                    }
                    else
                    {

                        file.SaveAs(strPath + "/" + filename);

                        if (System.IO.File.Exists(strPath))
                        {

                        }
                    }
                }
            }
            else
            {
                if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.Leave
                    || SecuritySession.UserProfile.CurrentScreenId == (int)FrontOfficeScreenId.AppointmentScheduling.InwardRegister
                    || SecuritySession.UserProfile.CurrentScreenId == (int)FrontOfficeScreenId.AppointmentScheduling.OutwardRegister
                    || SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.UploadEBookView
                    || SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Circular
                    || SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Assignment
                    || SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.Classwork
                    || SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.MyLeaveRequest
                    || SecuritySession.UserProfile.CurrentScreenId == (int)FrontOfficeScreenId.AppointmentScheduling.LostFoundRegister
                    || SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Behaviour
                    || SecuritySession.UserProfile.CurrentScreenId == (int)OnlineLearningScreenId.OnlineLearning.OnlinelearningStudentView
                    || SecuritySession.UserProfile.CurrentScreenId == (int)OnlineLearningScreenId.OnlineLearning.OnlineLearning
                    || SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadOrganizationPhoto)
                {
                    if (Path.GetExtension(postedFile[i].FileName).ToLower() == ".jpg" || Path.GetExtension(postedFile[i].FileName).ToLower() == ".jpeg" || Path.GetExtension(postedFile[i].FileName).ToLower() == ".bmp" || Path.GetExtension(postedFile[i].FileName).ToLower() == ".png")
                    {
                        if (IsImageOptimize == true)
                        {
                            byte[] ImgArray = null;
                            using (var binaryReader = new BinaryReader(postedFile[i].InputStream))
                            {
                                ImgArray = binaryReader.ReadBytes(postedFile[i].ContentLength);
                            }
                            ImageConverter converter = new ImageConverter();

                            using (MemoryStream StartMemoryStream = new MemoryStream(),
                                                    NewMemoryStream = new MemoryStream())
                            {
                                StartMemoryStream.Write(ImgArray, 0, ImgArray.Length);

                                if (ImgArray.Length > 4)
                                {
                                    Bitmap startBitmap = new Bitmap(StartMemoryStream);
                                    System.Drawing.Image image = System.Drawing.Image.FromStream(new System.IO.MemoryStream(ImgArray));

                                    int newHeight = image.Height;
                                    int newWidth = image.Width;

                                    Bitmap newBitmap = new Bitmap(newWidth, newHeight);
                                    newBitmap = ResizeImage(startBitmap, newWidth, newHeight);

                                    newBitmap.Save(NewMemoryStream, System.Drawing.Imaging.ImageFormat.Jpeg);

                                    ImgArray = NewMemoryStream.ToArray();

                                    //String path = HttpContext.Current.Server.MapPath("../../Content/" + SecuritySession.UserProfile.OrgId + "/StudentPhoto/Temp/" + filename);

                                    //if (System.IO.File.Exists(path))
                                    //{
                                    //    System.IO.File.Delete(path);
                                    //}
                                    File.WriteAllBytes(strPath + "/" + filename, ImgArray);

                                }
                            }
                        }
                        else
                        {

                            file.SaveAs(strPath + "/" + filename);

                            if (System.IO.File.Exists(strPath))
                            {

                            }
                        }
                    }
                    else
                    {
                        file.SaveAs(strPath + "/" + filename);

                        if (System.IO.File.Exists(strPath))
                        {

                        }
                    }
                }
                else
                {
                    context.Session["FileName"] = filename;

                    file.SaveAs(strPath + "/" + filename);

                    if (System.IO.File.Exists(strPath))
                    {

                    }
                }
            }
        }

        //else
        //{
        //    str = "Session not created yet";
        //}
        //context.Response.Write(str);
        //context.Response.ContentType = "text";
    }
    //string filename = postedFile.FileName;

    string str = "";

    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)ClinicalInformationScreenId.Examination.TestUpdate)
    //{
    //    filename = "TestUpdate_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportEmployee)
    //{
    //    filename = "ImportEmployee_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportDependent)
    //{
    //    filename = "ImportDependent_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStockItem)
    //{
    //    filename = "ImportStockItem_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStockItemResticate)
    //{
    //    filename = "ImportStockItemRestrictive_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportTestUpdate)
    //{
    //    filename = "ImportTestUpdateExaminationAll_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportLocation)
    //{
    //    filename = "ImportLocation_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportUsers)
    //{
    //    filename = "ImportUsers_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportAsset)
    //{
    //    filename = "ImportAssets_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportFirstAid)
    //{
    //    filename = "ImportFirstAid_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Configuration.ImportMaster)
    //{
    //    filename = "ImportMasterData_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.EmployeeDataUpdate)
    //{
    //    filename = "EmployeeDataUpdate_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)ClinicalInformationScreenId.Examination.VitalBulkUpdate)
    //{
    //    filename = "VitalBulkUpdate_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)ClinicalInformationScreenId.Examination.PeriodicFreeze)
    //{
    //    filename = "PeriodicFreeze_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)ClinicalInformationScreenId.Examination.PulmonaryUpdate)
    //{
    //    filename = "PulmonaryUpdate_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)ClinicalInformationScreenId.Examination.AudiometryUpdate)
    //{
    //    filename = "AudiometryUpdate_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockInward_New)
    //{
    //    strPath = strPath + "/TempStockInword_New";

    //    if (!System.IO.Directory.Exists(strPath))
    //    {
    //        System.IO.Directory.CreateDirectory(strPath);
    //        strPath = strPath + "/";
    //    }
    //    else
    //    {
    //        strPath = strPath + "/";
    //    }

    //    filename = "StockInward_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockInwardBulk)
    //{
    //    strPath = strPath + "/TempStockInword";
    //    if (!System.IO.Directory.Exists(strPath))
    //    {
    //        System.IO.Directory.CreateDirectory(strPath);
    //        strPath = strPath + "/";
    //    }
    //    else
    //    {
    //        strPath = strPath + "/";
    //    }

    //    filename = "StockInwardBulk_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockIssue_New)
    //{
    //    strPath = strPath + "/TempStockIssue_New";
    //    if (!System.IO.Directory.Exists(strPath))
    //    {
    //        System.IO.Directory.CreateDirectory(strPath);
    //        strPath = strPath + "/";
    //    }
    //    else
    //    {
    //        strPath = strPath + "/";
    //    }

    //    filename = "StockIssueNew_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockAdjustment)
    //{
    //    strPath = strPath + "/TempStockAdjustment";
    //    if (!System.IO.Directory.Exists(strPath))
    //    {
    //        System.IO.Directory.CreateDirectory(strPath);
    //        strPath = strPath + "/";
    //    }
    //    else
    //    {
    //        strPath = strPath + "/";
    //    }

    //    filename = "StockAdjustment_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}
    //else if (SecuritySession.UserProfile.CurrentScreenId == (int)SupportScreenId.Other.HealthCounselling)
    //{
    //    filename = "HealthCounselling_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + fileExt1.ToString();
    //}



    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
    private static Bitmap ResizeImage(Bitmap image, int width, int height)
    {
        var destRect = new Rectangle(0, 0, width, height);
        Bitmap resizedImage = new Bitmap(width, height);
        using (Graphics gfx = Graphics.FromImage(resizedImage))
        {
            gfx.CompositingMode = CompositingMode.SourceCopy;
            gfx.CompositingQuality = CompositingQuality.HighQuality;
            gfx.InterpolationMode = InterpolationMode.HighQualityBicubic;
            gfx.SmoothingMode = SmoothingMode.HighQuality;
            gfx.PixelOffsetMode = PixelOffsetMode.HighQuality;

            using (var wrapMode = new ImageAttributes())
            {
                wrapMode.SetWrapMode(WrapMode.TileFlipXY);
                gfx.DrawImage(image, destRect, 0, 0, image.Width, image.Height, GraphicsUnit.Pixel, wrapMode);
            }

        }
        return resizedImage;
    }
}