﻿/* @license
morris.js v0.5.0
Copyright 2014 Olly Smith All rights reserved.
Licensed under the BSD-2-Clause License.
*/
(function(){var t,n,r,u,e=[].slice,i=function(n,t){return function(){return n.apply(t,arguments)}},o={}.hasOwnProperty,f=function(n,t){function r(){this.constructor=n}for(var i in t)o.call(t,i)&&(n[i]=t[i]);return r.prototype=t.prototype,n.prototype=new r,n.__super__=t.prototype,n},s=[].indexOf||function(n){for(var t=0,i=this.length;t<i;t++)if(t in this&&this[t]===n)return t;return-1};n=window.Morris={};t=jQuery;n.EventEmitter=function(){function n(){}return n.prototype.on=function(n,t){return this.handlers==null&&(this.handlers={}),this.handlers[n]==null&&(this.handlers[n]=[]),this.handlers[n].push(t),this},n.prototype.fire=function(){var u,f,t,n,o,i,r;if(t=arguments[0],u=2<=arguments.length?e.call(arguments,1):[],this.handlers!=null&&this.handlers[t]!=null){for(i=this.handlers[t],r=[],n=0,o=i.length;n<o;n++)f=i[n],r.push(f.apply(null,u));return r}},n}();n.commas=function(n){var r,t,i,u;return n!=null?(i=n<0?"-":"",r=Math.abs(n),t=Math.floor(r).toFixed(0),i+=t.replace(/(?=(?:\d{3})+$)(?!^)/g,","),u=r.toString(),u.length>t.length&&(i+=u.slice(t.length)),i):"-"};n.pad2=function(n){return(n<10?"0":"")+n};n.Grid=function(r){function u(n){this.resizeHandler=i(this.resizeHandler,this);var r=this;if(this.el=typeof n.element=="string"?t(document.getElementById(n.element)):t(n.element),this.el==null||this.el.length===0)throw new Error("Graph container element not found");this.el.css("position")==="static"&&this.el.css("position","relative");this.options=t.extend({},this.gridDefaults,this.defaults||{},n);typeof this.options.units=="string"&&(this.options.postUnits=n.units);this.raphael=new Raphael(this.el[0]);this.elementWidth=null;this.elementHeight=null;this.dirty=!1;this.selectFrom=null;this.init&&this.init();this.setData(this.options.data);this.el.bind("mousemove",function(n){var i,u,f,e,t;return u=r.el.offset(),t=n.pageX-u.left,r.selectFrom?(i=r.data[r.hitTest(Math.min(t,r.selectFrom))]._x,f=r.data[r.hitTest(Math.max(t,r.selectFrom))]._x,e=f-i,r.selectionRect.attr({x:i,width:e})):r.fire("hovermove",t,n.pageY-u.top)});this.el.bind("mouseleave",function(){return r.selectFrom&&(r.selectionRect.hide(),r.selectFrom=null),r.fire("hoverout")});this.el.bind("touchstart touchmove touchend",function(n){var t,i;return i=n.originalEvent.touches[0]||n.originalEvent.changedTouches[0],t=r.el.offset(),r.fire("hovermove",i.pageX-t.left,i.pageY-t.top)});this.el.bind("click",function(n){var t;return t=r.el.offset(),r.fire("gridclick",n.pageX-t.left,n.pageY-t.top)});this.options.rangeSelect&&(this.selectionRect=this.raphael.rect(0,0,0,this.el.innerHeight()).attr({fill:this.options.rangeSelectColor,stroke:!1}).toBack().hide(),this.el.bind("mousedown",function(n){var t;return t=r.el.offset(),r.startRange(n.pageX-t.left)}),this.el.bind("mouseup",function(n){var t;return t=r.el.offset(),r.endRange(n.pageX-t.left),r.fire("hovermove",n.pageX-t.left,n.pageY-t.top)}));this.options.resize&&t(window).bind("resize",function(){return r.timeoutId!=null&&window.clearTimeout(r.timeoutId),r.timeoutId=window.setTimeout(r.resizeHandler,100)});this.el.css("-webkit-tap-highlight-color","rgba(0,0,0,0)");this.postInit&&this.postInit()}return f(u,r),u.prototype.gridDefaults={dateFormat:null,axes:!0,grid:!0,gridLineColor:"#aaa",gridStrokeWidth:.5,gridTextColor:"#888",gridTextSize:12,gridTextFamily:"sans-serif",gridTextWeight:"normal",hideHover:!1,yLabelFormat:null,xLabelAngle:0,numLines:5,padding:25,parseTime:!0,postUnits:"",preUnits:"",ymax:"auto",ymin:"auto 0",goals:[],goalStrokeWidth:1,goalLineColors:["#666633","#999966","#cc6666","#663333"],events:[],eventStrokeWidth:1,eventLineColors:["#005a04","#ccffbb","#3a5f0b","#005502"],rangeSelect:null,rangeSelectColor:"#eef",resize:!1},u.prototype.setData=function(t,i){var w,c,s,l,a,r,h,v,o,y,b,f,e,u,p;if(i==null&&(i=!0),this.options.data=t,t==null||t.length===0){this.data=[];this.raphael.clear();this.hover!=null&&this.hover.hide();return}return f=this.cumulative?0:null,e=this.cumulative?0:null,this.options.goals.length>0&&(a=Math.min.apply(Math,this.options.goals),l=Math.max.apply(Math,this.options.goals),e=e!=null?Math.min(e,a):a,f=f!=null?Math.max(f,l):l),this.data=function(){var i,a,l;for(l=[],s=i=0,a=t.length;i<a;s=++i)h=t[s],r={src:h},r.label=h[this.options.xkey],this.options.parseTime?(r.x=n.parseDate(r.label),this.options.dateFormat?r.label=this.options.dateFormat(r.x):typeof r.label=="number"&&(r.label=new Date(r.label).toString())):(r.x=s,this.options.xLabelFormat&&(r.label=this.options.xLabelFormat(r))),o=0,r.y=function(){var n,r,t,i;for(t=this.options.ykeys,i=[],c=n=0,r=t.length;n<r;c=++n)b=t[c],u=h[b],typeof u=="string"&&(u=parseFloat(u)),u!=null&&typeof u!="number"&&(u=null),u!=null&&(this.cumulative?o+=u:f!=null?(f=Math.max(u,f),e=Math.min(u,e)):f=e=u),this.cumulative&&o!=null&&(f=Math.max(o,f),e=Math.min(o,e)),i.push(u);return i}.call(this),l.push(r);return l}.call(this),this.options.parseTime&&(this.data=this.data.sort(function(n,t){return(n.x>t.x)-(t.x>n.x)})),this.xmin=this.data[0].x,this.xmax=this.data[this.data.length-1].x,this.events=[],this.options.events.length>0&&(this.events=this.options.parseTime?function(){var t,u,i,r;for(i=this.options.events,r=[],t=0,u=i.length;t<u;t++)w=i[t],r.push(n.parseDate(w));return r}.call(this):this.options.events,this.xmax=Math.max(this.xmax,Math.max.apply(Math,this.events)),this.xmin=Math.min(this.xmin,Math.min.apply(Math,this.events))),this.xmin===this.xmax&&(this.xmin-=1,this.xmax+=1),this.ymin=this.yboundary("min",e),this.ymax=this.yboundary("max",f),this.ymin===this.ymax&&(e&&(this.ymin-=1),this.ymax+=1),((p=this.options.axes)===!0||p==="both"||p==="y"||this.options.grid===!0)&&(this.options.ymax===this.gridDefaults.ymax&&this.options.ymin===this.gridDefaults.ymin?(this.grid=this.autoGridLines(this.ymin,this.ymax,this.options.numLines),this.ymin=Math.min(this.ymin,this.grid[0]),this.ymax=Math.max(this.ymax,this.grid[this.grid.length-1])):(v=(this.ymax-this.ymin)/(this.options.numLines-1),this.grid=function(){var n,r,t,i;for(i=[],y=n=r=this.ymin,t=this.ymax;v>0?n<=t:n>=t;y=n+=v)i.push(y);return i}.call(this))),this.dirty=!0,i?this.redraw():void 0},u.prototype.yboundary=function(n,t){var i,r;return i=this.options["y"+n],typeof i=="string"?i.slice(0,4)==="auto"?i.length>5?(r=parseInt(i.slice(5),10),t==null)?r:Math[n](t,r):t!=null?t:0:parseInt(i,10):i},u.prototype.autoGridLines=function(n,t,i){var u,f,s,h,c,r,e,o,l;return c=t-n,l=Math.floor(Math.log(c)/Math.log(10)),e=Math.pow(10,l),f=Math.floor(n/e)*e,u=Math.ceil(t/e)*e,r=(u-f)/(i-1),e===1&&r>1&&Math.ceil(r)!==r&&(r=Math.ceil(r),u=f+r*(i-1)),f<0&&u>0&&(f=Math.floor(n/r)*r,u=Math.ceil(t/r)*r),r<1?(h=Math.floor(Math.log(r)/Math.log(10)),s=function(){var n,t;for(t=[],o=n=f;r>0?n<=u:n>=u;o=n+=r)t.push(parseFloat(o.toFixed(1-h)));return t}()):s=function(){var n,t;for(t=[],o=n=f;r>0?n<=u:n>=u;o=n+=r)t.push(o);return t}(),s},u.prototype._calc=function(){var f,e,n,t,i,o,r,u;return i=this.el.width(),n=this.el.height(),(this.elementWidth!==i||this.elementHeight!==n||this.dirty)&&(this.elementWidth=i,this.elementHeight=n,this.dirty=!1,this.left=this.options.padding,this.right=this.elementWidth-this.options.padding,this.top=this.options.padding,this.bottom=this.elementHeight-this.options.padding,((r=this.options.axes)===!0||r==="both"||r==="y")&&(o=function(){var n,r,t,i;for(t=this.grid,i=[],n=0,r=t.length;n<r;n++)e=t[n],i.push(this.measureText(this.yAxisFormat(e)).width);return i}.call(this),this.left+=Math.max.apply(Math,o)),((u=this.options.axes)===!0||u==="both"||u==="x")&&(f=function(){var n,i,r;for(r=[],t=n=0,i=this.data.length;0<=i?n<i:n>i;t=0<=i?++n:--n)r.push(this.measureText(this.data[t].text,-this.options.xLabelAngle).height);return r}.call(this),this.bottom-=Math.max.apply(Math,f)),this.width=Math.max(1,this.right-this.left),this.height=Math.max(1,this.bottom-this.top),this.dx=this.width/(this.xmax-this.xmin),this.dy=this.height/(this.ymax-this.ymin),this.calc)?this.calc():void 0},u.prototype.transY=function(n){return this.bottom-(n-this.ymin)*this.dy},u.prototype.transX=function(n){return this.data.length===1?(this.left+this.right)/2:this.left+(n-this.xmin)*this.dx},u.prototype.redraw=function(){return this.raphael.clear(),this._calc(),this.drawGrid(),this.drawGoals(),this.drawEvents(),this.draw?this.draw():void 0},u.prototype.measureText=function(n,t){var r,i;return t==null&&(t=0),i=this.raphael.text(100,100,n).attr("font-size",this.options.gridTextSize).attr("font-family",this.options.gridTextFamily).attr("font-weight",this.options.gridTextWeight).rotate(t),r=i.getBBox(),i.remove(),r},u.prototype.yAxisFormat=function(n){return this.yLabelFormat(n)},u.prototype.yLabelFormat=function(t){return typeof this.options.yLabelFormat=="function"?this.options.yLabelFormat(t):""+this.options.preUnits+n.commas(t)+this.options.postUnits},u.prototype.drawGrid=function(){var i,r,n,o,u,f,e,t;if(this.options.grid!==!1||(u=this.options.axes)===!0||u==="both"||u==="y"){for(f=this.grid,t=[],n=0,o=f.length;n<o;n++)i=f[n],r=this.transY(i),((e=this.options.axes)===!0||e==="both"||e==="y")&&this.drawYAxisLabel(this.left-this.options.padding/2,r,this.yAxisFormat(i)),this.options.grid?t.push(this.drawGridLine("M"+this.left+","+r+"H"+(this.left+this.width))):t.push(void 0);return t}},u.prototype.drawGoals=function(){var u,f,n,t,e,i,r;for(i=this.options.goals,r=[],n=t=0,e=i.length;t<e;n=++t)f=i[n],u=this.options.goalLineColors[n%this.options.goalLineColors.length],r.push(this.drawGoal(f,u));return r},u.prototype.drawEvents=function(){var u,f,n,t,e,i,r;for(i=this.events,r=[],n=t=0,e=i.length;t<e;n=++t)f=i[n],u=this.options.eventLineColors[n%this.options.eventLineColors.length],r.push(this.drawEvent(f,u));return r},u.prototype.drawGoal=function(n,t){return this.raphael.path("M"+this.left+","+this.transY(n)+"H"+this.right).attr("stroke",t).attr("stroke-width",this.options.goalStrokeWidth)},u.prototype.drawEvent=function(n,t){return this.raphael.path("M"+this.transX(n)+","+this.bottom+"V"+this.top).attr("stroke",t).attr("stroke-width",this.options.eventStrokeWidth)},u.prototype.drawYAxisLabel=function(n,t,i){return this.raphael.text(n,t,i).attr("font-size",this.options.gridTextSize).attr("font-family",this.options.gridTextFamily).attr("font-weight",this.options.gridTextWeight).attr("fill",this.options.gridTextColor).attr("text-anchor","end")},u.prototype.drawGridLine=function(n){return this.raphael.path(n).attr("stroke",this.options.gridLineColor).attr("stroke-width",this.options.gridStrokeWidth)},u.prototype.startRange=function(n){return this.hover.hide(),this.selectFrom=n,this.selectionRect.attr({x:n,width:0}).show()},u.prototype.endRange=function(n){var t,i;if(this.selectFrom)return i=Math.min(this.selectFrom,n),t=Math.max(this.selectFrom,n),this.options.rangeSelect.call(this.el,{start:this.data[this.hitTest(i)].x,end:this.data[this.hitTest(t)].x}),this.selectFrom=null},u.prototype.resizeHandler=function(){return this.timeoutId=null,this.raphael.setSize(this.el.width(),this.el.height()),this.redraw()},u}(n.EventEmitter);n.parseDate=function(n){var e,o,c,s,u,r,h,i,t,f,l;return typeof n=="number"?n:(o=n.match(/^(\d+) Q(\d)$/),s=n.match(/^(\d+)-(\d+)$/),u=n.match(/^(\d+)-(\d+)-(\d+)$/),h=n.match(/^(\d+) W(\d+)$/),i=n.match(/^(\d+)-(\d+)-(\d+)[ T](\d+):(\d+)(Z|([+-])(\d\d):?(\d\d))?$/),t=n.match(/^(\d+)-(\d+)-(\d+)[ T](\d+):(\d+):(\d+(\.\d+)?)(Z|([+-])(\d\d):?(\d\d))?$/),o?new Date(parseInt(o[1],10),parseInt(o[2],10)*3-1,1).getTime():s?new Date(parseInt(s[1],10),parseInt(s[2],10)-1,1).getTime():u?new Date(parseInt(u[1],10),parseInt(u[2],10)-1,parseInt(u[3],10)).getTime():h?(f=new Date(parseInt(h[1],10),0,1),f.getDay()!==4&&f.setMonth(0,1+(11-f.getDay())%7),f.getTime()+parseInt(h[2],10)*6048e5):i?i[6]?(r=0,i[6]!=="Z"&&(r=parseInt(i[8],10)*60+parseInt(i[9],10),i[7]==="+"&&(r=0-r)),Date.UTC(parseInt(i[1],10),parseInt(i[2],10)-1,parseInt(i[3],10),parseInt(i[4],10),parseInt(i[5],10)+r)):new Date(parseInt(i[1],10),parseInt(i[2],10)-1,parseInt(i[3],10),parseInt(i[4],10),parseInt(i[5],10)).getTime():t?(l=parseFloat(t[6]),e=Math.floor(l),c=Math.round((l-e)*1e3),t[8]?(r=0,t[8]!=="Z"&&(r=parseInt(t[10],10)*60+parseInt(t[11],10),t[9]==="+"&&(r=0-r)),Date.UTC(parseInt(t[1],10),parseInt(t[2],10)-1,parseInt(t[3],10),parseInt(t[4],10),parseInt(t[5],10)+r,e,c)):new Date(parseInt(t[1],10),parseInt(t[2],10)-1,parseInt(t[3],10),parseInt(t[4],10),parseInt(t[5],10),e,c).getTime()):new Date(parseInt(n,10),0,1).getTime())};n.Hover=function(){function i(i){i==null&&(i={});this.options=t.extend({},n.Hover.defaults,i);this.el=t("<div class='"+this.options["class"]+"'><\/div>");this.el.hide();this.options.parent.append(this.el)}return i.defaults={"class":"morris-hover morris-default-style"},i.prototype.update=function(n,t,i){return n?(this.html(n),this.show(),this.moveTo(t,i)):this.hide()},i.prototype.html=function(n){return this.el.html(n)},i.prototype.moveTo=function(n,t){var r,f,e,u,o,i;return o=this.options.parent.innerWidth(),u=this.options.parent.innerHeight(),f=this.el.outerWidth(),r=this.el.outerHeight(),e=Math.min(Math.max(0,n-f/2),o-f),t!=null?(i=t-r-10,i<0&&(i=t+10,i+r>u&&(i=u/2-r/2))):i=u/2-r/2,this.el.css({left:e+"px",top:parseInt(i)+"px"})},i.prototype.show=function(){return this.el.show()},i.prototype.hide=function(){return this.el.hide()},i}();n.Line=function(t){function r(t){if(this.hilight=i(this.hilight,this),this.onHoverOut=i(this.onHoverOut,this),this.onHoverMove=i(this.onHoverMove,this),this.onGridClick=i(this.onGridClick,this),!(this instanceof n.Line))return new n.Line(t);r.__super__.constructor.call(this,t)}return f(r,t),r.prototype.init=function(){if(this.options.hideHover!=="always"){this.hover=new n.Hover({parent:this.el});this.on("hovermove",this.onHoverMove);this.on("hoverout",this.onHoverOut);return this.on("gridclick",this.onGridClick)}},r.prototype.defaults={lineWidth:3,pointSize:4,lineColors:["#0b62a4","#7A92A3","#4da74d","#afd8f8","#edc240","#cb4b4b","#9440ed"],pointStrokeWidths:[1],pointStrokeColors:["#ffffff"],pointFillColors:[],smooth:!0,xLabels:"auto",xLabelFormat:null,xLabelMargin:24,hideHover:!1},r.prototype.calc=function(){return this.calcPoints(),this.generatePaths()},r.prototype.calcPoints=function(){var n,t,i,f,r,u;for(r=this.data,u=[],i=0,f=r.length;i<f;i++)n=r[i],n._x=this.transX(n.x),n._y=function(){var i,f,u,r;for(u=n.y,r=[],i=0,f=u.length;i<f;i++)t=u[i],t!=null?r.push(this.transY(t)):r.push(t);return r}.call(this),u.push(n._ymax=Math.min.apply(Math,[this.bottom].concat(function(){var i,f,r,u;for(r=n._y,u=[],i=0,f=r.length;i<f;i++)t=r[i],t!=null&&u.push(t);return u}())));return u},r.prototype.hitTest=function(n){var t,u,i,f,r;if(this.data.length===0)return null;for(r=this.data.slice(1),t=i=0,f=r.length;i<f;t=++i)if(u=r[t],n<(u._x+this.data[t]._x)/2)break;return t},r.prototype.onGridClick=function(n,t){var i;return i=this.hitTest(n),this.fire("click",i,this.data[i].src,n,t)},r.prototype.onHoverMove=function(n){var t;return t=this.hitTest(n),this.displayHoverForRow(t)},r.prototype.onHoverOut=function(){if(this.options.hideHover!==!1)return this.displayHoverForRow(null)},r.prototype.displayHoverForRow=function(n){var t;return n!=null?((t=this.hover).update.apply(t,this.hoverContentForRow(n)),this.hilight(n)):(this.hover.hide(),this.hilight())},r.prototype.hoverContentForRow=function(n){var i,r,t,e,u,o,f;for(t=this.data[n],i="<div class='morris-hover-row-label'>"+t.label+"<\/div>",f=t.y,r=u=0,o=f.length;u<o;r=++u)e=f[r],i+="<div class='morris-hover-point' style='color: "+this.colorFor(t,r,"label")+"'>\n  "+this.options.labels[r]+":\n  "+this.yLabelFormat(e)+"\n<\/div>";return typeof this.options.hoverCallback=="function"&&(i=this.options.hoverCallback(n,this.options,i,t.src)),[i,t._x,t._ymax]},r.prototype.generatePaths=function(){var r,t,i,u;return this.paths=function(){var f,e,h,o;for(o=[],t=f=0,e=this.options.ykeys.length;0<=e?f<e:f>e;t=0<=e?++f:--f)u=typeof this.options.smooth=="boolean"?this.options.smooth:(h=this.options.ykeys[t],s.call(this.options.smooth,h)>=0),r=function(){var n,f,r,u;for(r=this.data,u=[],n=0,f=r.length;n<f;n++)i=r[n],i._y[t]!==void 0&&u.push({x:i._x,y:i._y[t]});return u}.call(this),r.length>1?o.push(n.Line.createPath(r,u,this.bottom)):o.push(null);return o}.call(this)},r.prototype.draw=function(){var n;return((n=this.options.axes)===!0||n==="both"||n==="x")&&this.drawXAxis(),this.drawSeries(),this.options.hideHover===!1?this.displayHoverForRow(this.data.length-1):void 0},r.prototype.drawXAxis=function(){var h,e,i,r,u,o,c,f,l,s,t=this;for(c=this.bottom+this.options.padding/2,u=null,r=null,h=function(n,i){var e,f,o,s,h;return e=t.drawXAxisLabel(t.transX(i),c,n),h=e.getBBox(),e.transform("r"+-t.options.xLabelAngle),f=e.getBBox(),e.transform("t0,"+f.height/2+"..."),t.options.xLabelAngle!==0&&(s=-.5*h.width*Math.cos(t.options.xLabelAngle*Math.PI/180),e.transform("t"+s+",0...")),f=e.getBBox(),(u==null||u>=f.x+f.width||r!=null&&r>=f.x)&&f.x>=0&&f.x+f.width<t.el.width()?(t.options.xLabelAngle!==0&&(o=1.25*t.options.gridTextSize/Math.sin(t.options.xLabelAngle*Math.PI/180),r=f.x-o),u=f.x-t.options.xLabelMargin):e.remove()},i=this.options.parseTime?this.data.length===1&&this.options.xLabels==="auto"?[[this.data[0].label,this.data[0].x]]:n.labelSeries(this.xmin,this.xmax,this.width,this.options.xLabels,this.options.xLabelFormat):function(){var n,r,t,i;for(t=this.data,i=[],n=0,r=t.length;n<r;n++)o=t[n],i.push([o.label,o.x]);return i}.call(this),i.reverse(),s=[],f=0,l=i.length;f<l;f++)e=i[f],s.push(h(e[0],e[1]));return s},r.prototype.drawSeries=function(){var n,t,i,r,u,f;for(this.seriesPoints=[],n=t=r=this.options.ykeys.length-1;r<=0?t<=0:t>=0;n=r<=0?++t:--t)this._drawLineFor(n);for(f=[],n=i=u=this.options.ykeys.length-1;u<=0?i<=0:i>=0;n=u<=0?++i:--i)f.push(this._drawPointFor(n));return f},r.prototype._drawPointFor=function(n){var r,t,i,e,u,f;for(this.seriesPoints[n]=[],u=this.data,f=[],i=0,e=u.length;i<e;i++)t=u[i],r=null,t._y[n]!=null&&(r=this.drawLinePoint(t._x,t._y[n],this.colorFor(t,n,"point"),n)),f.push(this.seriesPoints[n].push(r));return f},r.prototype._drawLineFor=function(n){var t;return t=this.paths[n],t!==null?this.drawLinePath(t,this.colorFor(null,n,"line"),n):void 0},r.createPath=function(t,i,r){var u,l,h,f,o,a,s,e,v,y,p,w,c,b;for(s="",i&&(h=n.Line.gradients(t)),e={y:null},f=c=0,b=t.length;c<b;f=++c)u=t[f],u.y!=null&&(e.y!=null?i?(l=h[f],a=h[f-1],o=(u.x-e.x)/4,v=e.x+o,p=Math.min(r,e.y+o*a),y=u.x-o,w=Math.min(r,u.y-o*l),s+="C"+v+","+p+","+y+","+w+","+u.x+","+u.y):s+="L"+u.x+","+u.y:i&&h[f]==null||(s+="M"+u.x+","+u.y)),e=u;return s},r.gradients=function(n){var f,e,i,r,u,o,s,t;for(e=function(n,t){return(n.y-t.y)/(n.x-t.x)},t=[],i=o=0,s=n.length;o<s;i=++o)f=n[i],f.y!=null?(r=n[i+1]||{y:null},u=n[i-1]||{y:null},u.y!=null&&r.y!=null?t.push(e(u,r)):u.y!=null?t.push(e(u,f)):r.y!=null?t.push(e(f,r)):t.push(null)):t.push(null);return t},r.prototype.hilight=function(n){var t,i,r,u,f;if(this.prevHilight!==null&&this.prevHilight!==n)for(t=i=0,u=this.seriesPoints.length-1;0<=u?i<=u:i>=u;t=0<=u?++i:--i)this.seriesPoints[t][this.prevHilight]&&this.seriesPoints[t][this.prevHilight].animate(this.pointShrinkSeries(t));if(n!==null&&this.prevHilight!==n)for(t=r=0,f=this.seriesPoints.length-1;0<=f?r<=f:r>=f;t=0<=f?++r:--r)this.seriesPoints[t][n]&&this.seriesPoints[t][n].animate(this.pointGrowSeries(t));return this.prevHilight=n},r.prototype.colorFor=function(n,t,i){return typeof this.options.lineColors=="function"?this.options.lineColors.call(this,n,t,i):i==="point"?this.options.pointFillColors[t%this.options.pointFillColors.length]||this.options.lineColors[t%this.options.lineColors.length]:this.options.lineColors[t%this.options.lineColors.length]},r.prototype.drawXAxisLabel=function(n,t,i){return this.raphael.text(n,t,i).attr("font-size",this.options.gridTextSize).attr("font-family",this.options.gridTextFamily).attr("font-weight",this.options.gridTextWeight).attr("fill",this.options.gridTextColor)},r.prototype.drawLinePath=function(n,t,i){return this.raphael.path(n).attr("stroke",t).attr("stroke-width",this.lineWidthForSeries(i))},r.prototype.drawLinePoint=function(n,t,i,r){return this.raphael.circle(n,t,this.pointSizeForSeries(r)).attr("fill",i).attr("stroke-width",this.pointStrokeWidthForSeries(r)).attr("stroke",this.pointStrokeColorForSeries(r))},r.prototype.pointStrokeWidthForSeries=function(n){return this.options.pointStrokeWidths[n%this.options.pointStrokeWidths.length]},r.prototype.pointStrokeColorForSeries=function(n){return this.options.pointStrokeColors[n%this.options.pointStrokeColors.length]},r.prototype.lineWidthForSeries=function(n){return this.options.lineWidth instanceof Array?this.options.lineWidth[n%this.options.lineWidth.length]:this.options.lineWidth},r.prototype.pointSizeForSeries=function(n){return this.options.pointSize instanceof Array?this.options.pointSize[n%this.options.pointSize.length]:this.options.pointSize},r.prototype.pointGrowSeries=function(n){return Raphael.animation({r:this.pointSizeForSeries(n)+3},25,"linear")},r.prototype.pointShrinkSeries=function(n){return Raphael.animation({r:this.pointSizeForSeries(n)},25,"linear")},r}(n.Grid);n.labelSeries=function(i,r,u,f,e){var s,y,p,w,c,l,o,a,h,b,v;if(p=200*(r-i)/u,y=new Date(i),o=n.LABEL_SPECS[f],o===void 0)for(v=n.AUTO_LABEL_ORDER,h=0,b=v.length;h<b;h++)if(w=v[h],l=n.LABEL_SPECS[w],p>=l.span){o=l;break}for(o===void 0&&(o=n.LABEL_SPECS.second),e&&(o=t.extend({},o,{fmt:e})),s=o.start(y),c=[];(a=s.getTime())<=r;)a>=i&&c.push([o.fmt(s),a]),o.incr(s);return c};r=function(t){return{span:t*6e4,start:function(n){return new Date(n.getFullYear(),n.getMonth(),n.getDate(),n.getHours())},fmt:function(t){return""+n.pad2(t.getHours())+":"+n.pad2(t.getMinutes())},incr:function(n){return n.setUTCMinutes(n.getUTCMinutes()+t)}}};u=function(t){return{span:t*1e3,start:function(n){return new Date(n.getFullYear(),n.getMonth(),n.getDate(),n.getHours(),n.getMinutes())},fmt:function(t){return""+n.pad2(t.getHours())+":"+n.pad2(t.getMinutes())+":"+n.pad2(t.getSeconds())},incr:function(n){return n.setUTCSeconds(n.getUTCSeconds()+t)}}};n.LABEL_SPECS={decade:{span:1728e8,start:function(n){return new Date(n.getFullYear()-n.getFullYear()%10,0,1)},fmt:function(n){return""+n.getFullYear()},incr:function(n){return n.setFullYear(n.getFullYear()+10)}},year:{span:1728e7,start:function(n){return new Date(n.getFullYear(),0,1)},fmt:function(n){return""+n.getFullYear()},incr:function(n){return n.setFullYear(n.getFullYear()+1)}},month:{span:24192e5,start:function(n){return new Date(n.getFullYear(),n.getMonth(),1)},fmt:function(t){return""+t.getFullYear()+"-"+n.pad2(t.getMonth()+1)},incr:function(n){return n.setMonth(n.getMonth()+1)}},week:{span:6048e5,start:function(n){return new Date(n.getFullYear(),n.getMonth(),n.getDate())},fmt:function(t){return""+t.getFullYear()+"-"+n.pad2(t.getMonth()+1)+"-"+n.pad2(t.getDate())},incr:function(n){return n.setDate(n.getDate()+7)}},day:{span:864e5,start:function(n){return new Date(n.getFullYear(),n.getMonth(),n.getDate())},fmt:function(t){return""+t.getFullYear()+"-"+n.pad2(t.getMonth()+1)+"-"+n.pad2(t.getDate())},incr:function(n){return n.setDate(n.getDate()+1)}},hour:r(60),"30min":r(30),"15min":r(15),"10min":r(10),"5min":r(5),minute:r(1),"30sec":u(30),"15sec":u(15),"10sec":u(10),"5sec":u(5),second:u(1)};n.AUTO_LABEL_ORDER=["decade","year","month","week","day","hour","30min","15min","10min","5min","minute","30sec","15sec","10sec","5sec","second"];n.Area=function(i){function r(i){var f;if(!(this instanceof n.Area))return new n.Area(i);f=t.extend({},u,i);this.cumulative=!f.behaveLikeLine;f.fillOpacity==="auto"&&(f.fillOpacity=f.behaveLikeLine?.8:1);r.__super__.constructor.call(this,f)}var u;return f(r,i),u={fillOpacity:"auto",behaveLikeLine:!1},r.prototype.calcPoints=function(){var n,i,r,t,e,u,f;for(u=this.data,f=[],t=0,e=u.length;t<e;t++)n=u[t],n._x=this.transX(n.x),i=0,n._y=function(){var t,e,f,u;for(f=n.y,u=[],t=0,e=f.length;t<e;t++)r=f[t],this.options.behaveLikeLine?u.push(this.transY(r)):(i+=r||0,u.push(this.transY(i)));return u}.call(this),f.push(n._ymax=Math.max.apply(Math,n._y));return f},r.prototype.drawSeries=function(){var n,i,t,o,r,u,f,e;for(this.seriesPoints=[],i=this.options.behaveLikeLine?function(){u=[];for(var n=0,t=this.options.ykeys.length-1;0<=t?n<=t:n>=t;0<=t?n++:n--)u.push(n);return u}.apply(this):function(){f=[];for(var n=r=this.options.ykeys.length-1;r<=0?n<=0:n>=0;r<=0?n++:n--)f.push(n);return f}.apply(this),e=[],t=0,o=i.length;t<o;t++)n=i[t],this._drawFillFor(n),this._drawLineFor(n),e.push(this._drawPointFor(n));return e},r.prototype._drawFillFor=function(n){var t;return t=this.paths[n],t!==null?(t=t+("L"+this.transX(this.xmax)+","+this.bottom+"L"+this.transX(this.xmin)+","+this.bottom+"Z"),this.drawFilledPath(t,this.fillForSeries(n))):void 0},r.prototype.fillForSeries=function(n){var t;return t=Raphael.rgb2hsl(this.colorFor(this.data[n],n,"line")),Raphael.hsl(t.h,this.options.behaveLikeLine?t.s*.9:t.s*.75,Math.min(.98,this.options.behaveLikeLine?t.l*1.2:t.l*1.25))},r.prototype.drawFilledPath=function(n,t){return this.raphael.path(n).attr("fill",t).attr("fill-opacity",this.options.fillOpacity).attr("stroke","none")},r}(n.Line);n.Bar=function(r){function u(r){if(this.onHoverOut=i(this.onHoverOut,this),this.onHoverMove=i(this.onHoverMove,this),this.onGridClick=i(this.onGridClick,this),!(this instanceof n.Bar))return new n.Bar(r);u.__super__.constructor.call(this,t.extend({},r,{parseTime:!1}))}return f(u,r),u.prototype.init=function(){if(this.cumulative=this.options.stacked,this.options.hideHover!=="always"){this.hover=new n.Hover({parent:this.el});this.on("hovermove",this.onHoverMove);this.on("hoverout",this.onHoverOut);return this.on("gridclick",this.onGridClick)}},u.prototype.defaults={barSizeRatio:.75,barGap:3,barColors:["#0b62a4","#7a92a3","#4da74d","#afd8f8","#edc240","#cb4b4b","#9440ed"],barOpacity:1,barRadius:[0,0,0,0],xLabelMargin:50},u.prototype.calc=function(){var n;return this.calcBars(),this.options.hideHover===!1?(n=this.hover).update.apply(n,this.hoverContentForRow(this.data.length-1)):void 0},u.prototype.calcBars=function(){var n,t,i,r,e,u,f;for(u=this.data,f=[],n=r=0,e=u.length;r<e;n=++r)t=u[n],t._x=this.left+this.width*(n+.5)/this.data.length,f.push(t._y=function(){var n,f,u,r;for(u=t.y,r=[],n=0,f=u.length;n<f;n++)i=u[n],i!=null?r.push(this.transY(i)):r.push(null);return r}.call(this));return f},u.prototype.draw=function(){var n;return((n=this.options.axes)===!0||n==="both"||n==="x")&&this.drawXAxis(),this.drawSeries()},u.prototype.drawXAxis=function(){var o,t,n,h,c,u,f,s,l,a,i,r,e;for(a=this.bottom+(this.options.xAxisLabelTopPadding||this.options.padding/2),f=null,u=null,e=[],o=i=0,r=this.data.length;0<=r?i<r:i>r;o=0<=r?++i:--i)s=this.data[this.data.length-1-o],t=this.drawXAxisLabel(s._x,a,s.label),l=t.getBBox(),t.transform("r"+-this.options.xLabelAngle),n=t.getBBox(),t.transform("t0,"+n.height/2+"..."),this.options.xLabelAngle!==0&&(c=-.5*l.width*Math.cos(this.options.xLabelAngle*Math.PI/180),t.transform("t"+c+",0...")),(f==null||f>=n.x+n.width||u!=null&&u>=n.x)&&n.x>=0&&n.x+n.width<this.el.width()?(this.options.xLabelAngle!==0&&(h=1.25*this.options.gridTextSize/Math.sin(this.options.xLabelAngle*Math.PI/180),u=n.x-h),e.push(f=n.x-this.options.xLabelMargin)):e.push(t.remove());return e},u.prototype.drawSeries=function(){var n,h,t,i,c,l,v,r,o,u,a,y,f,e,s;return t=this.width/this.options.data.length,r=this.options.stacked?1:this.options.ykeys.length,n=(t*this.options.barSizeRatio-this.options.barGap*(r-1))/r,this.options.barSize&&(n=Math.min(n,this.options.barSize)),y=t-n*r-this.options.barGap*(r-1),v=y/2,s=this.ymin<=0&&this.ymax>=0?this.transY(0):null,this.bars=function(){var r,w,y,p;for(y=this.data,p=[],i=r=0,w=y.length;r<w;i=++r)o=y[i],c=0,p.push(function(){var y,w,p,r;for(p=o._y,r=[],u=y=0,w=p.length;y<w;u=++y)e=p[u],e!==null?(s?(f=Math.min(e,s),h=Math.max(e,s)):(f=e,h=this.bottom),l=this.left+i*t+v,this.options.stacked||(l+=u*(n+this.options.barGap)),a=h-f,this.options.verticalGridCondition&&this.options.verticalGridCondition(o.x)&&this.drawBar(this.left+i*t,this.top,t,Math.abs(this.top-this.bottom),this.options.verticalGridColor,this.options.verticalGridOpacity,this.options.barRadius),this.options.stacked&&(f-=c),this.drawBar(l,f,n,a,this.colorFor(o,u,"bar"),this.options.barOpacity,this.options.barRadius),r.push(c+=a)):r.push(null);return r}.call(this));return p}.call(this)},u.prototype.colorFor=function(n,t,i){var r,u;return typeof this.options.barColors=="function"?(r={x:n.x,y:n.y[t],label:n.label},u={index:t,key:this.options.ykeys[t],label:this.options.labels[t]},this.options.barColors.call(this,r,u,i)):this.options.barColors[t%this.options.barColors.length]},u.prototype.hitTest=function(n){return this.data.length===0?null:(n=Math.max(Math.min(n,this.right),this.left),Math.min(this.data.length-1,Math.floor((n-this.left)/(this.width/this.data.length))))},u.prototype.onGridClick=function(n,t){var i;return i=this.hitTest(n),this.fire("click",i,this.data[i].src,n,t)},u.prototype.onHoverMove=function(n){var t,i;return t=this.hitTest(n),(i=this.hover).update.apply(i,this.hoverContentForRow(t))},u.prototype.onHoverOut=function(){if(this.options.hideHover!==!1)return this.hover.hide()},u.prototype.hoverContentForRow=function(n){var t,i,r,e,o,u,s,f;for(r=this.data[n],t="<div class='morris-hover-row-label'>"+r.label+"<\/div>",f=r.y,i=u=0,s=f.length;u<s;i=++u)o=f[i],t+="<div class='morris-hover-point' style='color: "+this.colorFor(r,i,"label")+"'>\n  "+this.options.labels[i]+":\n  "+this.yLabelFormat(o)+"\n<\/div>";return typeof this.options.hoverCallback=="function"&&(t=this.options.hoverCallback(n,this.options,t,r.src)),e=this.left+(n+.5)*this.width/this.data.length,[t,e]},u.prototype.drawXAxisLabel=function(n,t,i){return this.raphael.text(n,t,i).attr("font-size",this.options.gridTextSize).attr("font-family",this.options.gridTextFamily).attr("font-weight",this.options.gridTextWeight).attr("fill",this.options.gridTextColor)},u.prototype.drawBar=function(n,t,i,r,u,f,e){var o,s;return o=Math.max.apply(Math,e),s=o===0||o>r?this.raphael.rect(n,t,i,r):this.raphael.path(this.roundedRect(n,t,i,r,e)),s.attr("fill",u).attr("fill-opacity",f).attr("stroke","none")},u.prototype.roundedRect=function(n,t,i,r,u){return u==null&&(u=[0,0,0,0]),["M",n,u[0]+t,"Q",n,t,n+u[0],t,"L",n+i-u[1],t,"Q",n+i,t,n+i,t+u[1],"L",n+i,t+r-u[2],"Q",n+i,t+r,n+i-u[2],t+r,"L",n+u[3],t+r,"Q",n,t+r,n,t+r-u[3],"Z"]},u}(n.Grid);n.Donut=function(r){function u(r){this.resizeHandler=i(this.resizeHandler,this);this.select=i(this.select,this);this.click=i(this.click,this);var u=this;if(!(this instanceof n.Donut))return new n.Donut(r);if(this.options=t.extend({},this.defaults,r),this.el=typeof r.element=="string"?t(document.getElementById(r.element)):t(r.element),this.el===null||this.el.length===0)throw new Error("Graph placeholder not found.");r.data!==void 0&&r.data.length!==0&&(this.raphael=new Raphael(this.el[0]),this.options.resize&&t(window).bind("resize",function(){return u.timeoutId!=null&&window.clearTimeout(u.timeoutId),u.timeoutId=window.setTimeout(u.resizeHandler,100)}),this.setData(r.data))}return f(u,r),u.prototype.defaults={colors:["#0B62A4","#3980B5","#679DC6","#95BBD7","#B0CCE1","#095791","#095085","#083E67","#052C48","#042135"],backgroundColor:"#FFFFFF",labelColor:"#000000",formatter:n.commas,resize:!1},u.prototype.redraw=function(){var d,r,u,e,t,o,g,l,a,f,v,i,s,h,y,c,nt,tt,it,p,w,b,k;for(this.raphael.clear(),r=this.el.width()/2,u=this.el.height()/2,s=(Math.min(r,u)-10)/3,v=0,p=this.values,h=0,nt=p.length;h<nt;h++)i=p[h],v+=i;for(l=5/(2*s),d=1.9999*Math.PI-l*this.data.length,o=0,t=0,this.segments=[],w=this.values,e=y=0,tt=w.length;y<tt;e=++y){i=w[e];a=o+l+d*(i/v);f=new n.DonutSegment(r,u,s*2,s,o,a,this.data[e].color||this.options.colors[t%this.options.colors.length],this.options.backgroundColor,t,this.raphael);f.render();this.segments.push(f);f.on("hover",this.select);f.on("click",this.click);o=a;t+=1}for(this.text1=this.drawEmptyDonutLabel(r,u-10,this.options.labelColor,15,800),this.text2=this.drawEmptyDonutLabel(r,u+10,this.options.labelColor,14),g=Math.max.apply(Math,this.values),t=0,b=this.values,k=[],c=0,it=b.length;c<it;c++){if(i=b[c],i===g){this.select(t);break}k.push(t+=1)}return k},u.prototype.setData=function(n){var t;return this.data=n,this.values=function(){var n,u,i,r;for(i=this.data,r=[],n=0,u=i.length;n<u;n++)t=i[n],r.push(parseFloat(t.value));return r}.call(this),this.redraw()},u.prototype.click=function(n){return this.fire("click",n,this.data[n])},u.prototype.select=function(n){var t,u,f,i,e,r;for(r=this.segments,i=0,e=r.length;i<e;i++)u=r[i],u.deselect();return f=this.segments[n],f.select(),t=this.data[n],this.setLabels(t.label,this.options.formatter(t.value,t))},u.prototype.setLabels=function(n,t){var u,s,h,f,i,e,r,o;return u=(Math.min(this.el.width()/2,this.el.height()/2)-10)*2/3,f=1.8*u,h=u/2,s=u/3,this.text1.attr({text:n,transform:""}),i=this.text1.getBBox(),e=Math.min(f/i.width,h/i.height),this.text1.attr({transform:"S"+e+","+e+","+(i.x+i.width/2)+","+(i.y+i.height)}),this.text2.attr({text:t,transform:""}),r=this.text2.getBBox(),o=Math.min(f/r.width,s/r.height),this.text2.attr({transform:"S"+o+","+o+","+(r.x+r.width/2)+","+r.y})},u.prototype.drawEmptyDonutLabel=function(n,t,i,r,u){var f;return f=this.raphael.text(n,t,"").attr("font-size",r).attr("fill",i),u!=null&&f.attr("font-weight",u),f},u.prototype.resizeHandler=function(){return this.timeoutId=null,this.raphael.setSize(this.el.width(),this.el.height()),this.redraw()},u}(n.EventEmitter);n.DonutSegment=function(n){function t(n,t,r,u,f,e,o,s,h,c){this.cx=n;this.cy=t;this.inner=r;this.outer=u;this.color=o;this.backgroundColor=s;this.index=h;this.raphael=c;this.deselect=i(this.deselect,this);this.select=i(this.select,this);this.sin_p0=Math.sin(f);this.cos_p0=Math.cos(f);this.sin_p1=Math.sin(e);this.cos_p1=Math.cos(e);this.is_long=e-f>Math.PI?1:0;this.path=this.calcSegment(this.inner+3,this.inner+this.outer-5);this.selectedPath=this.calcSegment(this.inner+3,this.inner+this.outer);this.hilight=this.calcArc(this.inner)}return f(t,n),t.prototype.calcArcPoints=function(n){return[this.cx+n*this.sin_p0,this.cy+n*this.cos_p0,this.cx+n*this.sin_p1,this.cy+n*this.cos_p1]},t.prototype.calcSegment=function(n,t){var u,f,e,o,s,h,c,l,i,r;return i=this.calcArcPoints(n),u=i[0],e=i[1],f=i[2],o=i[3],r=this.calcArcPoints(t),s=r[0],c=r[1],h=r[2],l=r[3],"M"+u+","+e+("A"+n+","+n+",0,"+this.is_long+",0,"+f+","+o)+("L"+h+","+l)+("A"+t+","+t+",0,"+this.is_long+",1,"+s+","+c)+"Z"},t.prototype.calcArc=function(n){var i,r,u,f,t;return t=this.calcArcPoints(n),i=t[0],u=t[1],r=t[2],f=t[3],"M"+i+","+u+("A"+n+","+n+",0,"+this.is_long+",0,"+r+","+f)},t.prototype.render=function(){var n=this;return this.arc=this.drawDonutArc(this.hilight,this.color),this.seg=this.drawDonutSegment(this.path,this.color,this.backgroundColor,function(){return n.fire("hover",n.index)},function(){return n.fire("click",n.index)})},t.prototype.drawDonutArc=function(n,t){return this.raphael.path(n).attr({stroke:t,"stroke-width":2,opacity:0})},t.prototype.drawDonutSegment=function(n,t,i,r,u){return this.raphael.path(n).attr({fill:t,stroke:i,"stroke-width":3}).hover(r).click(u)},t.prototype.select=function(){if(!this.selected)return this.seg.animate({path:this.selectedPath},150,"<>"),this.arc.animate({opacity:1},150,"<>"),this.selected=!0},t.prototype.deselect=function(){if(this.selected)return this.seg.animate({path:this.path},150,"<>"),this.arc.animate({opacity:0},150,"<>"),this.selected=!1},t}(n.EventEmitter)}).call(this);
//# sourceMappingURL=morris.min.js.map
