﻿var EmployeeDatas;
var EmployeeFullProfile;
$(document).ready(function () {
    toggleFullScreen();
    $.ajax({
        type: "POST",
        url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/GetEmployeeList",
        contentType: "application/json;charset=utf-8",
        dataType: "json",
        success: function (data) {

            EmployeeDatas = $.parseJSON(data.d);
            let params = (new URL(document.location)).searchParams;
            let name = params.get("EmployeeId");
            let pagename = params.get("Page");
            let IsOverview = params.get("IsOverView");
            if (name != null) {
                $.ajax({
                    type: "POST",
                    url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/GetEmployeeListWithEmployeeId",
                    data: '{"Employee":"' + name + '"}',
                    contentType: "application/json;charset=utf-8",
                    dataType: "json",
                    success: function (data) {
                        var Employee = $.parseJSON(data.d);
                        selectEmployee(Employee[0].EmployeeData, true);
                        if (window.parent.location.href.match(/EmployeeId=/)) {
                            if (typeof (history.pushState) != "undefined") {
                                var obj = { Title: document.title, Url: window.parent.location.pathname };
                                history.pushState(obj, obj.Title, obj.Url);
                            } else {
                                window.parent.location = window.parent.location.pathname;
                            }
                            setTimeout(function () {
                                // call your code here that you want to run after all $(document).ready() calls have run
                                // Previous Page Conditions
                                if (IsOverview != null) {
                                    if (IsOverview == 'True') {
                                        OverviewShow();
                                    }
                                } else {
                                    var PreviousPage = document.referrer.split("/").pop();
                                    if (PreviousPage == "UploadEmployeePhoto.aspx" ||
                                        PreviousPage == "UploadEmployeePhoto.aspx" ||
                                        PreviousPage == "EmployeeDocumentUpload.aspx" ||
                                        PreviousPage == "EmployeePassword.aspx" ||
                                        PreviousPage == "BulkEmployeeDataUpdate.aspx" ||
                                        PreviousPage == "EmployeeICard.aspx") {
                                        OverviewShow();
                                    }
                                    else if (PreviousPage == "EmploymentCertificate.aspx" ||
                                        PreviousPage == "ExperienceCertificate.aspx" ||
                                        PreviousPage == "RelievingCertificate.aspx" ||
                                        PreviousPage == "IncrementCertificate.aspx") {
                                        $('#ctl00_CP_CertificateList').click();
                                        CertificateDetailsShow();
                                    }

                                    else if (PreviousPage == "EmployeeRegister.aspx" ||
                                        PreviousPage == "MonthlyAttendanceRegister.aspx" ||
                                        PreviousPage == "MonthlyAttendance.aspx") {
                                        $('#ctl00_CP_AttendanceList').click();
                                        AttendanceDetailsShow();
                                    }
                                    else if (PreviousPage == "PayProcessPreview.aspx" ||
                                    PreviousPage == "PayProcessEmployee.aspx" ||
                                    PreviousPage == "PayrollEmployee.aspx") {
                                        $('#ctl00_CP_PayrollList').click();
                                        PayrollDetailsShow();
                                    }
                                    else if (PreviousPage == "Leave.aspx" ||
                                        PreviousPage == "LeaveBalanceAdd.aspx") {
                                        $('#ctl00_CP_LeaveList').click();
                                        LeaveDetailsShow();
                                    }
                                    if (pagename != null) {
                                        if (pagename == 'SelectPayRoll') {
                                            alert('PayRoll not assigned');
                                            OverviewShow();
                                        }

                                    }
                                }
                            }, 100);
                        }
                    }
                });
            }
        }
    });
});

$(window).load(function () {

});

document.addEventListener('keydown', function (e) {
    var tag = $(e.target).attr("id");
    var tag1 = $(e.target).attr('class');
    switch (e.keyCode) {
        case 37: case 39: case 38: case 40: e.preventDefault();
    }
    if ((tag == "ctl00_CP_EmployeeAutoSearchTextBox" || e.keyCode == 13) || (e.keyCode == 13 || tag1 == "item")) {
        Focus();
    }
});

$(document).mouseup(function (e) {
    var container = $("#ctl00_CP_AutoSearchSuggestion");

    // if the target of the click isn't the container nor a descendant of the container
    if (!container.is(e.target) && container.has(e.target).length === 0) {
        document.getElementById("AutoSearchSuggestion").hidden = true;
    }
});

function Search(obj) {
    if ($(obj).val().length < 2)
        return;
    var AutoCompleteData = '<ul id="EmployeeData" style="padding:5px;background-color:#eee;display:inline-block;z-index:200;position:absolute;width: 262px; height: 150px; overflow: auto">';
    if (EmployeeDatas != '' && $(obj).val() != '') {
        for (var i = 0; i < EmployeeDatas.length; i++) {
            if (EmployeeDatas[i].EmployeeData.includes($(obj).val())) {
                AutoCompleteData += '<li class="item" tabindex="' + (i + 1) + '" onClick="selectEmployee(\'' + EmployeeDatas[i].EmployeeData + '\',false);">' + EmployeeDatas[i].EmployeeData + '</li>';
            }
        }
    }
    AutoCompleteData += '</ul>';
    document.getElementById("AutoSearchSuggestion").innerHTML = AutoCompleteData;
    if (document.getElementById("AutoSearchSuggestion").innerHTML != '')
        document.getElementById("AutoSearchSuggestion").hidden = false;
}

function Focus() {

    var keyCode = window.event.keyCode;
    if (keyCode !== 38 && keyCode !== 40 && keyCode !== 13) return;

    var current = document.activeElement;
    let items = [];
    for (i = 0; i < document.getElementsByClassName('item').length; i++) {
        items[i] = document.getElementsByClassName('item')[i];
    }
    var currentIndex = items.indexOf(current);
    var newIndex;

    if (keyCode == 13) {
        selectEmployee(items[currentIndex].innerHTML, true);
    }
    else {
        if (currentIndex === -1) {
            newIndex = 0
        } else {
            if (keyCode === 38) newIndex = (currentIndex + items.length - 1) % items.length
            else newIndex = (currentIndex + 1) % items.length

        }
        items[newIndex].focus();
    }
}

function selectEmployee(val, IsEnter) {
    $("#ctl00_CP_EmployeeAutoSearchTextBox").val(val);
    var str = $("#ctl00_CP_EmployeeAutoSearchTextBox").val();
    if (!IsEnter)
        str = str.substring(0, str.length);

    $("#ctl00_CP_EmployeeAutoSearchTextBox").val(str);
    document.getElementById("AutoSearchSuggestion").hidden = true;
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/EmployeeProfileGet",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                var HTMLstring = '';
                var Datas = $.parseJSON(data.d);
                var EmployeeProfile = $.parseJSON(Datas.EmployeeDetail);
                var Attendance = $.parseJSON(Datas.Attendance);
                var TimeSheet = $.parseJSON(Datas.TimeSheet);
                var TimeTable = $.parseJSON(Datas.Timetable);
                var MyLeave = $.parseJSON(Datas.Leave);
                var Payroll = $.parseJSON(Datas.Payroll);
                var OnlineLecture = $.parseJSON(Datas.OnlineLecture);
                var Subjects = $.parseJSON(Datas.Subjects);
                var ExamSchedules = $.parseJSON(Datas.ExamSchedules);
                if (EmployeeProfile.length > 0) {
                    $('#EmployeeRightPane').show();
                    $('#ButtonList').show();
                    EmployeeFullProfileGet();
                    $("#ctl00_CP_OverviewList").click();

                    //Employee Header Details
                    $("#NameLabel").text(EmployeeProfile[0].EmployeeName);
                    $("#GenderLabel").text(EmployeeProfile[0].Gender);
                    $("#CodeLabel").text(EmployeeProfile[0].Code);
                    if (DateTimeConverter(EmployeeProfile[0].DateOfBirth) != '0NaN/0NaN/NaN') {

                        $("#BirthDateLabel").text(DateTimeConverter(EmployeeProfile[0].DateOfBirth));
                    }
                    else {
                        $("#BirthDateLabel").text("");
                    }
                    $("#DepartmentMainLabel").text(EmployeeProfile[0].OrganizationDepartment);
                    $("#EmployeeTypeMainLabel").text(EmployeeProfile[0].EmployeeType);
                    $("#DesignationMainLabel").text(EmployeeProfile[0].EmployeeDesignation);

                    //General Details

                    if (EmployeeProfile[0].EmployeePhoto.length > 4)
                        $("#EmployeeImage").attr('src', 'data:image/jpg;base64,' + arrayBufferToBase64(EmployeeProfile[0].EmployeePhoto));
                    else {
                        if (EmployeeProfile[0].Gender == "Male")
                            $("#EmployeeImage").attr('src', "../../../Images/BoyNoImage.png");
                        else if (EmployeeProfile[0].Gender == "Female")
                        $("#EmployeeImage").attr('src',"../../../Images/GirlNoImage.png");
                    }
                    $("#QRCodeImage").attr('src', generateQrCode(EmployeeProfile[0].Code));
                    $("#BarcodeImage").attr('src', textToBase64Barcode(EmployeeProfile[0].Code));

                    //My Attendance
                    if (Attendance.length > 0) {
                        if (Attendance[0].TodayAttendance == true)
                            $("#TodaysStatusLabel").html('<span id="" class="label label-success">Present</span>');
                        else if (Attendance[0].TodayAttendance != null)
                            $("#TodaysStatusLabel").html("<span class='label label-danger'>Absent</span>");
                        else
                            $("#TodaysStatusLabel").text("No Record Found!!!");
                        if (Attendance[0].YesterdayAttendance == true)
                            $("#YesterdayStatusLabel").html('<span id="" class="label label-success">Present</span>');
                        else if (Attendance[0].YesterdayAttendance != null)
                            $("#YesterdayStatusLabel").html("<span class='label label-danger'>Absent</span>");
                        else {
                            $("#YesterdayStatusLabel").text("No Record Found!!!");
                        }
                        $("#MonthlyAttendanceLabel").html('<b>Total Days: </b>' + Attendance[0].TotalDays + '<br/> <b>Working Days: </b>' + Attendance[0].WorkingDays + '<br/> <b>Present Days: </b>' + Attendance[0].MonthlyPresence + '<br/> <b>Absent Days: </b>' + Attendance[0].MonthlyAbsence);
                    }
                    //My Timesheet
                    if (TimeSheet.length > 0) {
                        $("#TimesheetTodaysStatusLabel").html("<b>In :</b>" + TimeSheet[0].FirstIn + "<br/><b> Out : </b>" + TimeSheet[0].FirstIn + "<br/><b> Late : </b>" + TimeSheet[0].LastOut + "<br/><b> Early : </b>" + TimeSheet[0].Early + "<br/> <b>Total : </b>" + TimeSheet[0].Duration);

                    } else {
                        $("#TimesheetTodaysStatusLabel").text("No Data Found");
                    }
                    if (TimeSheet.length == 2) {
                        $("#TimesheeYesterdayStatusLabel").html("<b>In :</b>" + TimeSheet[1].FirstIn + "<br/> <b>Out : </b>" + TimeSheet[1].FirstIn + "<br/> <b>Late : </b>" + TimeSheet[1].LastOut + "<br/> <b>Early : </b>" + TimeSheet[1].Early + "<br/> <b>Total : </b>" + TimeSheet[1].Duration);
                    }
                    else {
                        $("#TimesheeYesterdayStatusLabel").text("No Data Found!!!");
                    }
                    // My Leave
                    if (MyLeave.length > 0) {
                        for (var i = 0; i < MyLeave.length; i++) {
                            HTMLstring += "<tr><td>";
                            if (DateTimeConverter(MyLeave[i].ReportDate) != '0NaN/0NaN/NaN')
                                HTMLstring += DateTimeConverter(MyLeave[i].ReportDate) + "</td><td>";
                            else
                                HTMLstring += " </td><td>";
                            if (DateTimeConverter(MyLeave[i].FromDate) != '0NaN/0NaN/NaN')
                                HTMLstring += DateTimeConverter(MyLeave[i].FromDate) + "</td><td>";
                            else
                                HTMLstring += " </td><td>";
                            if (DateTimeConverter(MyLeave[i].ToDate) != '0NaN/0NaN/NaN')
                                HTMLstring += DateTimeConverter(MyLeave[i].ToDate) + "</td><td>";
                            else
                                HTMLstring += " </td><td>";
                            HTMLstring += MyLeave[i].NoOfLeave + "</td><td>" + MyLeave[i].LeaveType + "</td><td>" + MyLeave[i].LeaveReason + "</td><td>";
                            if (MyLeave[i].StatusName == "Approved") // Completed
                            {
                                HTMLstring += "<span class='label label-success'>Approved</span>";
                            }
                            else if (MyLeave[i].StatusName == "Pending") // Pending
                            {
                                HTMLstring += "<span class='label label-warning'>Pending</span>";
                            }
                            else if (MyLeave[i].StatusName == "Rejected") // Cancel
                            {
                                HTMLstring += "<span class='label label-danger'>Rejected</span>";
                            }

                            HTMLstring += "</td></tr>";
                        }
                    } else {
                        HTMLstring += "<tr><td colspan='7'>No Record Found!!!</td></tr>"
                    }
                    $('#dvMyLeaveGridDiv').html(HTMLstring);

                    //My Payroll 
                    if (Payroll[0].LastMonthPayrollStatus == 0) {
                        $("#LatMonthPayrollLabel").html('<span id="" class="label label-warning">Pending</span>');
                    } else {
                        $("#LatMonthPayrollLabel").html('<span id="" class="label label-success">Generated</span>');
                    }
                    if (Payroll[0].CurrentMonthPayrollStatus == 0) {
                        $("#CurrentMontPayrollLabel").html('<span id="" class="label label-warning">Pending</span>');
                    } else {
                        $("#CurrentMontPayrollLabel").html('<span id="" class="label label-success">Generated</span>');
                    }

                    // My Timetable
                    HTMLstring = '';
                    if (TimeTable.length > 0) {
                        for (var i = 0; i < TimeTable.length; i++) {
                            HTMLstring += "<tr><td>";
                            HTMLstring += TimeTable[i].LactureNumber + "</td><td>" + TimeTable[i].ClassDivisionName + "</td><td>" + TimeTable[i].Subject + "</td><td>";

                            HTMLstring += TimeTable[i].Time + "</td></tr>";


                        }
                    } else {
                        HTMLstring += "<tr><td colspan='4'>No Record Found!!!</td></tr>"
                    }
                    $('#dvTimetableGridDiv').html(HTMLstring);

                    //My Lecture
                    HTMLstring = '';
                    if (OnlineLecture.length > 0) {
                        for (var i = 0; i < OnlineLecture.length; i++) {
                            HTMLstring += "<tr><td>";
                            HTMLstring += OnlineLecture[i].ClassName + "</td><td>" + OnlineLecture[i].SubjectName + "</td><td>" + OnlineLecture[i].Title + "</td><td>";

                            HTMLstring += OnlineLecture[i].StartTime + "</td><td>";

                            HTMLstring += OnlineLecture[i].EndTime + "</td><td>";

                            HTMLstring += OnlineLecture[i].Source + "</td>";
                            if (OnlineLecture[i].Status == "1") // Completed
                            {
                                HTMLstring += "<td align='center'><span class='label label-success'>Completed</span></td></tr>";
                            }
                            else if (OnlineLecture[i].Status == "0") // Pending
                            {
                                HTMLstring += "<td align='center'><span class='label label-warning'>Pending</span></td></tr>";
                            }
                            else if (OnlineLecture[i].Status == "721") // Cancel
                            {
                                HTMLstring += "<td align='center'><span class='label label-danger'>Cancel</span></td></tr>";
                            }
                        }
                    } else {
                        HTMLstring += "<tr><td colspan='7'>No Record Found!!!</td></tr>";
                    }
                    $('#dvmyLectureDiv').html(HTMLstring);

                    // My Subjects
                    HTMLstring = '';
                    if (Subjects.length > 0) {
                        for (var i = 0; i < Subjects.length; i++) {
                            if (i % 2 == 0) {
                                HTMLstring += "<tr><td >" + Subjects[i].SubjectName + "</td>";
                            }
                            else {
                                HTMLstring += "<td>" + Subjects[i].SubjectName + "</td></tr>"
                            }

                        }
                    }
                    else {
                        HTMLstring += "<tr><td colspan='2'>No Record Found!!!</td></tr>";
                    }
                    $('#divMySubjectDiv').html(HTMLstring);


                    //My Exam Schedules
                    HTMLstring = '';
                    if (ExamSchedules.length > 0) {
                        for (var i = 0; i < ExamSchedules.length; i++) {
                            HTMLstring += "<tr><td>";
                            HTMLstring += ExamSchedules[i].ExamName + "</td><td>" + ExamSchedules[i].ClassName + "</td><td>" + ExamSchedules[i].Subject + "</td><td>";

                            if (DateTimeConverter(ExamSchedules[i].ExamDate) != '0NaN/0NaN/NaN')
                                HTMLstring += DateTimeConverter(ExamSchedules[i].ExamDate) + "</td><td>";
                            else
                                HTMLstring += " </td><td>";

                            HTMLstring += ExamSchedules[i].ExamTime + "</td></tr>";

                        }
                    } else {
                        HTMLstring += "<tr><td colspan='7'>No Record Found!!!</td></tr>"
                    }
                    $('#dvMyExamSchedulesGridDiv').html(HTMLstring);

                    $("#TimesheetTodaysStatusLabel").text(EmployeeProfile[0].TimesheetTodaysStatus);
                    $("#TimesheeYesterdayStatusLabel").text(EmployeeProfile[0].TimesheeYesterdayStatus);
                    $("#TimesheetTodaysStatusLabel").text(EmployeeProfile[0].TimesheetTodaysStatus);
                    $("#TimesheeYesterdayStatusLabel").text(EmployeeProfile[0].TimesheeYesterdayStatus);


                }
            }
        });
    }
}

function EmployeeFullProfileGet() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/EmployeeFullProfileGet",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                EmployeeFullProfile = $.parseJSON(data.d);
                var name = EmployeeFullProfile[0].EmployeeName.split(' ');
                if (name.length > 0) {
                    EmployeeFullProfile[0].FirstName = name[0];
                    EmployeeFullProfile[0].MiddleName = name[1];
                    EmployeeFullProfile[0].LastName = name[2];

                    EmployeeFullProfile[0].MiddleName = name[1];
                    EmployeeFullProfile[0].LastName = name[2];
                }

            }
        });
    }
}

function OverviewShow() {
    //$('#ctl00_CP_DashBoardDiv').show();
    //$('#ctl00_CP_EmployeeFullProfileDiv').hide();
    //$('#ctl00_CP_AttendanceDiv').hide();
    //$('#ctl00_CP_LeaveDiv').hide();
    //$('#ctl00_CP_PayrollDiv').hide();
    //$('#ctl00_CP_CertificateDiv').hide();

    //$("#ctl00_CP_OverviewList").addClass("active");
    //$("#ctl00_CP_EmployeeFullProfileDiv").removeClass("active");
    //$("#ctl00_CP_AttendanceDiv").removeClass("active");
    //$("#ctl00_CP_LeaveDiv").removeClass("active");
    //$("#ctl00_CP_PayrollDiv").removeClass("active");
    //$("#ctl00_CP_CertificateDiv").removeClass("active");
}

function EmployeeFullProfileShow() {


    document.getElementById("AutoSearchSuggestion").hidden = true;
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        if (EmployeeFullProfile.length > 0) {
            //Basic Details
            //document.getElementById("FullProfileEmployeeImage").src = 'data:image/jpg;base64,' + arrayBufferToBase64(EmployeeFullProfile[0].StudentPhoto);
            $("#ctl00_CP_EmployeeCodeLabel").text(EmployeeFullProfile[0].Code);
            $("#ctl00_CP_NumberLabel").text(EmployeeFullProfile[0].Number);
            $("#ctl00_CP_ShortNameLabel").text(EmployeeFullProfile[0].ShortName);
            $("#ctl00_CP_FirstNameLabel").text(EmployeeFullProfile[0].FirstName);
            $("#ctl00_CP_MiddleNameLabel").text(EmployeeFullProfile[0].MiddleName);
            $("#ctl00_CP_LastNameLabel").text(EmployeeFullProfile[0].LastName);
            $("#ctl00_CP_EmployeeTypeLabel").text(EmployeeFullProfile[0].EmployeeType);
            $("#ctl00_CP_EmployeeGroupLabel").text(EmployeeFullProfile[0].EmployeeGroup);
            $("#ctl00_CP_EmployeeGradeLabel").text(EmployeeFullProfile[0].EmployeeGrade);
            $("#ctl00_CP_DepartmentLabel").text(EmployeeFullProfile[0].OrganizationDepartment);
            $("#ctl00_CP_DesignationLabel").text(EmployeeFullProfile[0].EmployeeDesignation);
            $("#ctl00_CP_GenderLabel1").text(EmployeeFullProfile[0].Gender);
            if (DateTimeConverter(EmployeeFullProfile[0].DateOfBirth) != '0NaN/0NaN/NaN') {

                $("#ctl00_CP_DateofBirthLabel").text(DateTimeConverter(EmployeeFullProfile[0].DateOfBirth));
            }
            else {
                $("#ctl00_CP_DateofBirthLabel").text("");
            }
            if (EmployeeFullProfile[0].DateofJoining == 'undefined' && DateTimeConverter(EmployeeFullProfile[0].DateofJoining) != '0NaN/0NaN/NaN') {

                $("#ctl00_CP_DateofJoiningLabel").text(DateTimeConverter(EmployeeFullProfile[0].DateofJoining));
            }
            else {
                $("#ctl00_CP_DateofJoiningLabel").text("");
            }
            $("#ctl00_CP_StatusLabel").text(EmployeeFullProfile[0].Status);
            if (EmployeeFullProfile[0].StatusId == 7)
                $("#ctl00_CP_StatusLabel").text("Active");
            else if (EmployeeFullProfile[0].StatusId == 8)
                $("#ctl00_CP_StatusLabel").text("Suspended");
            else if (EmployeeFullProfile[0].StatusId == 9)
                $("#ctl00_CP_StatusLabel").text("Left");
            else if (EmployeeFullProfile[0].StatusId == 10)
                $("#ctl00_CP_StatusLabel").text("Unknown");
            else if (EmployeeFullProfile[0].StatusId == 738)
                $("#ctl00_CP_StatusLabel").text("Retired");

            //Job Information
            if (DateTimeConverter(EmployeeFullProfile[0].DateOfLeaving) != '0NaN/0NaN/NaN') {

                $("#ctl00_CP_DateofLeavingLabel").text(DateTimeConverter(EmployeeFullProfile[0].DateOfLeaving));
            }
            else {
                $("#ctl00_CP_DateofLeavingLabel").text("");
            }
            $("#ctl00_CP_ReasonForLeavingLabel").text(EmployeeFullProfile[0].ReasonOfleaving);
            $("#ctl00_CP_JobRemarkLabel").text(EmployeeFullProfile[0].JobRemark);
            $("#ctl00_CP_OrganizationLabel").text(EmployeeFullProfile[0].OrgTitle);
            $("#ctl00_CP_EmployeeManagerLabel").text(EmployeeFullProfile[0].EmployeeManager);
            $("#ctl00_CP_OrganizationHeadLabel").text(EmployeeFullProfile[0].OrganizationHead);
            $("#ctl00_CP_OrganizationHeadManagerLabel").text(EmployeeFullProfile[0].OrganizationHeadManager);
            $("#ctl00_CP_ProbationDaysLabel").text(EmployeeFullProfile[0].ProbationDays);
            $("#ctl00_CP_SubjectsLabel").text(EmployeeFullProfile[0].TeachingSubject);
            $("#ctl00_CP_OrgGroupDepartmentLabel").text(EmployeeFullProfile[0].OrgGroupDepartment);
            if (DateTimeConverter(EmployeeFullProfile[0].ProbationUptoDate) != '0NaN/0NaN/NaN') {

                $("#ctl00_CP_ProbationUptoDateLabel").text(DateTimeConverter(EmployeeFullProfile[0].ProbationUptoDate));
            }
            else {
                $("#ctl00_CP_ProbationUptoDateLabel").text("");
            }
            if (DateTimeConverter(EmployeeFullProfile[0].AhdocUptoDate) != '0NaN/0NaN/NaN') {

                $("#ctl00_CP_AhdocUptoDateLabel").text(DateTimeConverter(EmployeeFullProfile[0].AhdocUptoDate));
            }
            else {
                $("#ctl00_CP_AhdocUptoDateLabel").text("");
            }
            if (DateTimeConverter(EmployeeFullProfile[0].PermanentDate) != '0NaN/0NaN/NaN') {

                $("#ctl00_CP_PermanentDateLabel").text(DateTimeConverter(EmployeeFullProfile[0].PermanentDate));
            }
            else {
                $("#ctl00_CP_PermanentDateLabel").text("");
            }
            if (DateTimeConverter(EmployeeFullProfile[0].DateOfResignation) != '0NaN/0NaN/NaN') {

                $("#ctl00_CP_DateOfResignationLabel").text(DateTimeConverter(EmployeeFullProfile[0].DateOfResignation));
            }
            else {
                $("#ctl00_CP_DateOfResignationLabel").text("");
            }

            //Personal Detail
            $("#ctl00_CP_UIDNumberLabel").text(EmployeeFullProfile[0].UIDNumber);
            $("#ctl00_CP_AgeLabel").text(EmployeeFullProfile[0].Age);
            $("#ctl00_CP_QualificationLabel").text(EmployeeFullProfile[0].Qualification);
            $("#ctl00_CP_BloodGroupLabel").text(EmployeeFullProfile[0].BloodGroup);
            $("#ctl00_CP_MaritalStatusLabel").text(EmployeeFullProfile[0].MeritalStatus);
            $("#ctl00_CP_ReligionLabel").text(EmployeeFullProfile[0].Religion);
            $("#ctl00_CP_CasteCategoryLabel").text(EmployeeFullProfile[0].CasteCategory);
            $("#ctl00_CP_FamilyCasteLabel").text(EmployeeFullProfile[0].FamilyCast);
            $("#ctl00_CP_IDMark1Label").text(EmployeeFullProfile[0].IdentificationMark1);
            $("#ctl00_CP_AdhaarNumberLabel").text(EmployeeFullProfile[0].AdhaarNumber);

            //Communication Details
            $("#ctl00_CP_CompanyPhoneNoLabel").text(EmployeeFullProfile[0].PhoneNoCompany);
            $("#ctl00_CP_ExtensionNoLabel").text(EmployeeFullProfile[0].ExtensionNo);
            $("#ctl00_CP_CompanyEmailLabel").text(EmployeeFullProfile[0].CompanyEmail);
            $("#ctl00_CP_PersonalEmailLabel").text(EmployeeFullProfile[0].PersonalEmail);
            $("#ctl00_CP_MobileNumberLabel").text(EmployeeFullProfile[0].MobileNumber);
            $("#ctl00_CP_WhatsAppContactNoLabel").text(EmployeeFullProfile[0].WhatsAppContactNo);

            $("#ctl00_CP_CommunicationPresentAddressLabel").text(EmployeeFullProfile[0].PresentAddress);
            $("#ctl00_CP_PresentCityLabel").text(EmployeeFullProfile[0].PresentCity);
            $("#ctl00_CP_PresentStateLabel").text(EmployeeFullProfile[0].PresentState);
            $("#ctl00_CP_PresentZipCodeLabel").text(EmployeeFullProfile[0].PresentZipCode);
            $("#ctl00_CP_CommunicationPresentContactNoLabel").text(EmployeeFullProfile[0].PresentContactNo);
            $("#ctl00_CP_EmergencyAddressLabel").text(EmployeeFullProfile[0].EmergencyAddress);
            $("#ctl00_CP_EmergencyCityLabel").text(EmployeeFullProfile[0].EmergencyCity);
            $("#ctl00_CP_EmergencyStateLabel").text(EmployeeFullProfile[0].EmergencyState);
            $("#ctl00_CP_EmergencyZipCodeLabel").text(EmployeeFullProfile[0].EmergencyState);
            $("#ctl00_CP_EmergencyContactNoLabel").text(EmployeeFullProfile[0].EmergencyContactNo);
            $("#ctl00_CP_PermanentAddressLabel").text(EmployeeFullProfile[0].PermanentAddress);
            $("#ctl00_CP_PermanentCityLabel").text(EmployeeFullProfile[0].PermanentCity);
            $("#ctl00_CP_PermanentStateLabel").text(EmployeeFullProfile[0].PermanentState);
            $("#ctl00_CP_PermanentZipCodeLabel").text(EmployeeFullProfile[0].PermanentZipCode);
            $("#ctl00_CP_PermanentContactNoLabel").text(EmployeeFullProfile[0].PermanentContactNo);

            //Statutory Detail
            if (DateTimeConverter(EmployeeFullProfile[0].EPFJoinDate) != '0NaN/0NaN/NaN') {

                $("#ctl00_CP_EPFJoinDateLabel").text(DateTimeConverter(EmployeeFullProfile[0].EPFJoinDate));
            }
            else {
                $("#ctl00_CP_EPFJoinDateLabel").text("");
            }
            $("#ctl00_CP_EPFNumberLabel").text(EmployeeFullProfile[0].EPFNumber);
            //$("ctl00_CP_EPFJoinDateLabel").text(EmployeeFullProfile[0].EPFJoinDate);
            $("#ctl00_CP_ESINumberLabel").text(EmployeeFullProfile[0].ESINumber);
            $("#ctl00_CP_BankNameLabel").text(EmployeeFullProfile[0].BankName);
            $("#ctl00_CP_BranchLabel").text(EmployeeFullProfile[0].BankBranch);
            $("#ctl00_CP_AccountNumberLabel").text(EmployeeFullProfile[0].AccountNumber);
            $("#ctl00_CP_AccountHolderNameLabel").text(EmployeeFullProfile[0].AccountHolderName);
            $("#ctl00_CP_IFSCNumberLabel").text(EmployeeFullProfile[0].IFSCNumber);
            $("#ctl00_CP_PanNumberLabel").text(EmployeeFullProfile[0].PanNumber);
            if (DateTimeConverter(EmployeeFullProfile[0].IncrementDate) != '0NaN/0NaN/NaN') {

                $("#ctl00_CP_IncrementDateLabel").text(DateTimeConverter(EmployeeFullProfile[0].IncrementDate));
            }
            else {
                $("#ctl00_CP_IncrementDateLabel").text("");
            }
            if (DateTimeConverter(EmployeeFullProfile[0].RetirementDate) != '0NaN/0NaN/NaN') {

                $("#ctl00_CP_RetirementDateLabel").text(DateTimeConverter(EmployeeFullProfile[0].RetirementDate));
            }
            else {
                $("#ctl00_CP_RetirementDateLabel").text("");
            }

            $("#ctl00_CP_PayrollLabel").text(EmployeeFullProfile[0].PayRollTitle);
            $("#ctl00_CP_PayrollGroupLabel").text(EmployeeFullProfile[0].PayRollGroupTitle);
            $("#ctl00_CP_BasicPayLabel").text(EmployeeFullProfile[0].BasicPay);
            $("#ctl00_CP_UANLabel").text(EmployeeFullProfile[0].UAN);
            $("#EmployeeImage2").attr('src', 'data:image/jpg;base64,' + arrayBufferToBase64(EmployeeFullProfile[0].EmployeePhoto));
            $("#SignImage2").attr('src', 'data:image/jpg;base64,' + arrayBufferToBase64(EmployeeFullProfile[0].EmployeeSign));
            //$("ctl00_CP_TransportDropRouteConductorMobileNoLabel").text(EmployeeFullProfile[0].DropRouteConductorMobileNo;

        }
    }
}

function LeaveDetailsShow() {

    document.getElementById("AutoSearchSuggestion").hidden = true;
    if ($("#ctl00_CP_StudentAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/EmployeeLeaveGet",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {

                var HTMLstring = '';
                var HTMLLeavetypestring = '';
                var datas = $.parseJSON(data.d);
                //$('#Atddiv').hide();
                // $('#Subjectatdiv').show();
                if (datas.EmployeeLeave == '[]') {
                    $('#dvLeaveGridDiv').html('<tr><td colspan="7">No Record found !</td><tr>');
                }
                else {
                    var EmployeeLeave = $.parseJSON(datas.EmployeeLeave);
                    $.each(EmployeeLeave, function () {
                        HTMLstring += "<tr><td>";
                        if (DateTimeConverter(this["ReportDate"]) != '0NaN/0NaN/NaN')
                            HTMLstring += DateTimeConverter(this["ReportDate"]) + "</td><td>";
                        else
                            HTMLstring += " </td><td>";
                        if (DateTimeConverter(this["FromDate"]) != '0NaN/0NaN/NaN')
                            HTMLstring += DateTimeConverter(this["FromDate"]) + "</td><td>";
                        else
                            HTMLstring += " </td><td>";
                        if (DateTimeConverter(this["ToDate"]) != '0NaN/0NaN/NaN')
                            HTMLstring += DateTimeConverter(this["ToDate"]) + "</td><td>";
                        else
                            HTMLstring += " </td><td>";

                        HTMLstring += this["NoOfLeave"] + "</td><td>" +
                           this["LeaveType"] + "</td><td>" + this["LeaveReason"] + "</td><td>";
                        if (this["StatusName"] == "Approved") // Completed
                        {
                            HTMLstring += "<span class='label label-success'>Approved</span>";
                        }
                        else if (this["StatusName"] == "Pending") // Pending
                        {
                            HTMLstring += "<span class='label label-warning'>Pending</span>";
                        }
                        else if (this["StatusName"] == "Rejected") // Cancel
                        {
                            HTMLstring += "<span class='label label-danger'>Rejected</span>";
                        }

                        HTMLstring += "</td></tr>";

                        //alert(this);
                    });
                    $('#dvLeaveGridDiv').html(HTMLstring);
                }
                if (datas.LeaveBalence == '[]') {
                    $('#dvLeaveBalencedGridDiv').html('<tr><td colspan="3">No Record found !</td><tr>');
                } else {


                    var LeaveBalence = $.parseJSON(datas.LeaveBalence);
                    $.each(LeaveBalence, function () {
                        HTMLLeavetypestring += "<tr><td>";
                        HTMLLeavetypestring += this["LeaveType"] + "</td><td>" + this["TotalBalance"] + "</td><td>" + this["UsedBalance"] + "</td><td>" + this["PendingBalance"] + "</td><td>" + this["AvailableBalance"] + "</td></tr>";
                        //alert(this);
                    });
                    //HTMLLeavetypestring +="CL</td><td>10</td><td>1</td><td>0</td><td>0</td>";
                    $('#dvLeaveBalencedGridDiv').html(HTMLLeavetypestring);
                }

            },
            error: function (xhr, status, error) {

                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}


function AttendanceDetailsShow() {



    GetAttedanceDeatil();
}


function PayrollDetailsShow() {
    GetPayrollYear();
}
function GetPayrollYear() {
    $('#ctl00_CP_PayrollYearDropDownList').empty();
    $.ajax({
        type: "POST",
        url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/GetPayrollYear",
        data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '"}',
        contentType: "application/json;charset=utf-8",
        dataType: "json",
        success: function (data) {
            var datas = "[" + (data.d) + "]";
            datas = $.parseJSON(datas);
            if (datas != "") {
                $('#ctl00_CP_PayrollYearDropDownList').html(datas[0].Result);
            }
            GetPayrollDetail();
        },
        error: function (xhr, status, error) {
            var err = eval("(" + xhr.responseText + ")");
            console.log(err.Message);
        }
    });
}

function GetPayrollDetail() {
    var PayrollYearId = $('#ctl00_CP_PayrollYearDropDownList').val();
    document.getElementById("AutoSearchSuggestion").hidden = true;
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '' && PayrollYearId != null) {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/GetEmployeePayrollDetail",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '","PayrollYearId":' + parseInt(PayrollYearId) + '}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.setTimeout(function () {
                    var datas = $.parseJSON(data.d);
                    if (datas.EmpGrid == '') {
                        $('#dvPayrollGridDiv').html('<tr><td colspan="10">No Record found !</td><tr>');
                    }
                    else {
                        var PayRollReport = '<td><input type="button" id="Primt" value="&#xf02f;" onclick="PrintPayrollReport(this);" class="fas btn btn-report " /></td>';
                        PayRollReport += '<td><input type="button" id="Upload" value="&#xf093;" onclick="UploadPayrollReport(this);" class="fas btn btn-report " /></td>';
                        datas = datas.EmpGrid.replaceAll('</tr>', PayRollReport + '</tr>')
                        $('#dvPayrollGridDiv').html(datas);

                    }
                }, 500);
            },
            error: function (xhr, status, error) {

                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    } else {
        $('#dvPayrollGridDiv').html('<tr><td colspan="10">No Record found !</td><tr>');
    }
}

function CertificateDetailsShow() {

    document.getElementById("AutoSearchSuggestion").hidden = true;
    if ($("#ctl00_CP_StudentAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/GetCertificateDetails",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {

                var HTMLstring = '';
                var HTMLLeavetypestring = '';
                //$('#Atddiv').hide();
                // $('#Subjectatdiv').show();
                if (data.d == '') {
                    $('#dvPayrollGridDiv').html('<tr class="text-center"><td colspan="3">No Record found !</td><tr>');
                }
                else {

                    var CertificateDetails = $.parseJSON(data.d);
                    if (CertificateDetails.length > 0) {
                        for (var i = 0; i < CertificateDetails.length; i++) {
                            HTMLstring += "<tr><td>";
                            HTMLstring += CertificateDetails[i].CertificateName + "</td><td>";
                            if (DateTimeConverter(CertificateDetails[i].CreatedDateTime) != '0NaN/0NaN/NaN')
                                HTMLstring += DateTimeConverter(CertificateDetails[i].CreatedDateTime) + "</td><td>";
                            else
                                HTMLstring += " </td><td>";

                            HTMLstring += '<input type="button" id="' + i + ' ' + CertificateDetails[i].CertificateName + '" value="&#xf02f; Print Certificate" onclick="PrintCertificate(this);" class="fas btn btn-report " /></td>';
                            HTMLstring += '<td style="display:none;">' + CertificateDetails[i].CertificateNumber + '</td></tr>';
                        }
                    } else {
                        HTMLstring = '<tr class="text-center"><td colspan="3">No Record found !</td><tr>';
                    }
                    $('#dvCertificateGridDiv').html(HTMLstring);
                }


            },
            error: function (xhr, status, error) {

                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}
function Closepopup() {
    $('.hls-bg').hide();
    $('#dvresultpopup').hide();
}
function openpopup() {
    LoadingMsg('Loading Details', '<b>Please Wait ...</b>');
    window.setTimeout(function () {
        CloseLoading();
        $('.hls-bg').show();
        $('#dvresultpopup').show();
    }, 500);
}

function DateTimeConverter(DateTime) {
    var obj = { DOB: DateTime };
    var DOBValue = parseInt(obj.DOB.replace(/\/Date\((\d+)\)\//g, "$1"));
    obj.DOB = new Date(DOBValue);
    obj.DOB = ((obj.DOB.getDate() > 9) ? obj.DOB.getDate() : ('0' + obj.DOB.getDate())) + '/' + ((obj.DOB.getMonth() > 8) ? (obj.DOB.getMonth() + 1) : ('0' + (obj.DOB.getMonth() + 1))) + '/' + obj.DOB.getFullYear();
    return obj.DOB;
}

function DateTimeConverterWithTime(DateTime) {
    var obj = { DOB: DateTime };
    var DOBValue = parseInt(obj.DOB.replace(/\/Date\((\d+)\)\//g, "$1"));
    obj.DOB = new Date(DOBValue);
    obj.DOB = ((obj.DOB.getMonth() > 8) ? (obj.DOB.getMonth() + 1) : ('0' + (obj.DOB.getMonth() + 1))) + '/' + ((obj.DOB.getDate() > 9) ? obj.DOB.getDate() : ('0' + obj.DOB.getDate())) + '/' + obj.DOB.getFullYear() + ' ' + obj.DOB.getHours() + ':' + obj.DOB.getMinutes() + ':' + obj.DOB.getSeconds();
    return obj.DOB;
}

function arrayBufferToBase64(buffer) {
    var binary = '';
    var bytes = new Uint8Array(buffer);
    var len = bytes.byteLength;
    for (var i = 0; i < len; i++) {
        binary += String.fromCharCode(bytes[i]);
    }
    return window.btoa(binary);
}

function GetAttedanceDeatil() {
    //Based on Attendance Type dropdown change event        
    //var AttendanceTypeId = document.getElementById("ctl00_CP_AttendanceTypeDropDownList").value;
    if ($("#ctl00_CP_StudentAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/EmployeeAttendanceGet",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {

                var HTMLstring = '';
                var datas = $.parseJSON(data.d);
                //$('#Atddiv').hide();
                // $('#Subjectatdiv').show();
                if (datas == '') {
                    $('#dvAttedanceGridDiv').html('<tr><td colspan="3">No Record found !</td><tr>');
                }
                else {
                    $.each(datas, function () {
                        HTMLstring += "<tr><td>" + this["Month"] + "-" + this["ForYear"] + "</td><td>" + this["WorkingDays"] + "</td><td>" + this["PresentDays"] + "</td><td>" +
                           this["LWP"] + "</td><td>" + this["PaidLeave"] + "</td><td>" + this["UnPaidLeave"] + "</td></tr>";
                        //alert(this);
                    });
                    $('#dvAttedanceGridDiv').html(HTMLstring);
                }

            },
            error: function (xhr, status, error) {

                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}

function SelectPayrollDetail(obj, SalaryMonth, SalaryYear, PayrollYearId) {
    debugger;
    $.ajax({

        type: "POST",
        url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SelectPayrollDetail",
        data: '{"SalaryMonth":"' + SalaryMonth + '", "SalaryYear":"' + SalaryYear + '", "PayrollYearId":"' + PayrollYearId + '","Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '"}',
        contentType: "application/json;charset=utf-8",
        dataType: "json",
        success: function (data) {
            var datas = $.parseJSON(data.d)
            openpopup();
            $('#ctl00_CP_PayrollMonthDetaillbl').text(" Detailed Salary of " + $(obj.closest('tr')).find("td:first").text() + " " + $(obj.closest('tr')).find("td:eq(1)").text());
            if (datas[0].EmpEarning == '') {
                $('#PayrollEarningDetailDiv').show();
                $('#dvearningDetailsGridDiv').html('<tr><td colspan="2">No Record found !</td><tr>');
            }
            else {
                $('#PayrollEarningDetailDiv').show();
                $('#dvearningDetailsGridDiv').html(datas[0].EmpEarning);
            }

            if (datas.EmpDeduction == '') {

                $('#PayrollDeductionDetailDiv').show();
                $('#dvdeductionDetailsGridDiv').html('<tr><td colspan="2">No Record found !</td><tr>');
            }
            else {
                $('#PayrollDeductionDetailDiv').show();
                $('#dvdeductionDetailsGridDiv').html(datas[0].EmpDeduction);
            }
            //$('#ctl00_CP_HostelMasterTabContainer_AttedanceTabPanel_AttendanceTypeDropDownList').empty();
            //$('#Atddiv').hide();
            //$('#Subjectatdiv').hide();
        },
        error: function (xhr, status, error) {

            var err = eval("(" + xhr.responseText + ")");
            console.log(err.Message);
        }
    });
}
function UploadPayrollReport(obj) {
    var PayrollYearId = $('#ctl00_CP_PayrollYearDropDownList').val();
    var SalaryMonth = new Date(Date.parse($(obj.closest('tr')).find("td:first").text() + " 1, 2012")).getMonth() + 1;
    var SalaryYear = $(obj.closest('tr')).find("td:eq(1)").text()
    $.ajax({

        type: "POST",
        url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/UploadPaySlip",
        data: '{"SalaryMonth":"' + SalaryMonth + '", "SalaryYear":"' + SalaryYear + '", "PayrollYearId":"' + PayrollYearId + '","Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '"}',
        contentType: "application/json;charset=utf-8",
        dataType: "json",
        success: function (data) {
            if (data.d == "1") {
                alert('Upload Sucsessfully!!!');
            }
            else if (data.d == "0") {
                alert('Payslip Uploaded Successfully');
            }
            else {
                alert(data.d);
            }
        },
        error: function (xhr, status, error) {

            var err = eval("(" + xhr.responseText + ")");
            console.log(err.Message);
        }
    });
}
function PrintPayrollReport(obj) {
    var PayrollYearId = $('#ctl00_CP_PayrollYearDropDownList').val();
    var SalaryMonth = new Date(Date.parse($(obj.closest('tr')).find("td:first").text() + " 1, 2012")).getMonth() + 1;
    var SalaryYear = $(obj.closest('tr')).find("td:eq(1)").text()
    $.ajax({

        type: "POST",
        url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/PayrollReportPrint",
        data: '{"SalaryMonth":"' + SalaryMonth + '", "SalaryYear":"' + SalaryYear + '", "PayrollYearId":"' + PayrollYearId + '","Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '"}',
        contentType: "application/json;charset=utf-8",
        dataType: "json",
        success: function (data) {
            if (data.d == "1") {
                var e = "../../Common/Report/ReportPDF.aspx"
                return window.open(e, '', "height=1500px,width=1500px,left=0px,top=0px,toolbar=no,directories=no,status=no, menubar=no,scrollbars=yes,resizable=yes ,modal=yes"), !1;
            }
            else if (data.d == "0") {
                alert('No records found');
            }
        },
        error: function (xhr, status, error) {

            var err = eval("(" + xhr.responseText + ")");
            console.log(err.Message);
        }
    });
}

function PrintCertificate(obj) {
    var CertificateNumber = obj.parentNode.parentNode.cells[3].innerHTML;
    var CertificateType = obj.id.split(' ')[1];
    $.ajax({

        type: "POST",
        url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/CertificatePrint",
        data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "CertificateNumber":"' + CertificateNumber + '","CertificateType":"' + CertificateType + '"}',
        contentType: "application/json;charset=utf-8",
        dataType: "json",
        success: function (data) {
            if (data.d == "1") {
                var e = "../../Common/Report/ReportPDF.aspx"
                return window.open(e, '', "height=1500px,width=1500px,left=0px,top=0px,toolbar=no,directories=no,status=no, menubar=no,scrollbars=yes,resizable=yes ,modal=yes"), !1;
            }
            else if (data.d == "0") {
                alert('No records found');
            }
        },
        error: function (xhr, status, error) {

            var err = eval("(" + xhr.responseText + ")");
            console.log(err.Message);
        }
    });
}

//Binding AttendanceType DropDown
function GetAttedanceType() {
    $('#ctl00_CP_AttendanceTypeDropDownList').empty();
    $.ajax({
        type: "POST",
        url: "/Pages/StudentManagement/StudentDetailForm.aspx/GetAttedanceType",
        data: '{"Student":"' + $("#ctl00_CP_StudentAutoSearchTextBox").val() + '"}',
        contentType: "application/json;charset=utf-8",
        dataType: "json",
        success: function (data) {
            var ddlCustomers = $("#ctl00_CP_AttendanceTypeDropDownList");
            $('#ctl00_CP__AttendanceTypeDropDownList').empty();
            $.each(data.d, function () {
                ddlCustomers.append($("<option></option>").val(this['Value']).html(this['Text']));
            });
            GetAttedanceDeatil();
        },
        error: function (xhr, status, error) {
            var err = eval("(" + xhr.responseText + ")");
            console.log(err.Message);
        }
    });
}

//Employee Overview
function MyTimeSheetRedirect() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"MyTimeSheet"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Components/Biometric/MyTimeSheet.aspx";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}
function TimesheetListRedirect() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"TimesheetList"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Components/Biometric/TimeSheetList.aspx";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}
function UpdateEmployeeRedirect() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"UpdateEmployee"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Hrm/Employee/BulkEmployeeDataUpdate.aspx";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}
function EmployeeICardReport() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/EmployeeICardReport",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"EmployeeICard"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                if (data.d == "1") {
                    var e = "../../Common/Report/ReportPDF.aspx"
                    return window.open(e, '', "height=1500px,width=1500px,left=0px,top=0px,toolbar=no,directories=no,status=no, menubar=no,scrollbars=yes,resizable=yes ,modal=yes"), !1;
                }
                else if (data.d == "0") {
                    alert('No records found');
                }
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}
function UploadEmployeePhotosRedirect() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"UploadEmployeePhotos"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/BaseFramework/Utilities/UploadEmployeePhoto.aspx";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}
function ChangeEmployeeIdRedirect() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"ChangeEmployeeId"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Hrm/Employee/IDNoGeneration.aspx";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}
function UploadDocumentsRedirect() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"UploadDocuments"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Hrm/Employee/EmployeeDocumentUpload.aspx";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}
function ChangePasswordRedirect() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"ChangePassword"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Baseframework/Security/EmployeePassword.aspx";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}
//Eployee Attendence div
function EmployeeEntryRedirect(IsOverview) {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"EmployeeRegister:' + Boolean(IsOverview) + '" }',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Hrm/Employee/EmployeeRegister.aspx";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}

function MonthlyAttendanceRegisterRedirect() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"MonthlyAttendanceRegister"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Hrm/Employee/MonthlyAttendanceRegister.aspx";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}

function MonthlyAttendanceRedirect() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"MonthlyAttendance"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Hrm/Employee/MonthlyAttendance.aspx";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}


//Leave Div
function AddLeaveEntryRedirect(IsOverview) {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"AddLeaveEntry:' + Boolean(IsOverview) + '" }',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Hrm/Employee/Leave.aspx";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}
function AddLeaveBalanceRedirect(IsOverview) {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"AddLeaveBalance:' + Boolean(IsOverview) + '" }',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Hrm/Employee/LeaveBalanceAdd.aspx";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}

//PayRoll Div
function PayProcessPreviewRedirect() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"PayProcessPreview"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Hrm/Payroll/SelectPayroll.aspx?MenuID=23";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}
function PayProcessEmployeeRedirect(IsOverview) {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"PayProcessEmployee:' + Boolean(IsOverview) + '" }',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Hrm/Payroll/SelectPayroll.aspx?MenuID=23";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}
function PayrollAttendanceRedirect() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"PayrollAttendance"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Hrm/Payroll/SelectPayroll.aspx?MenuID=23";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}
//My Certificate div
function EmployeementCertificateRedirect() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"EmployeementCertificate"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Hrm/Employee/EmploymentCertificate.aspx";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}
function ExperienceCertificateRedirect() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"ExperienceCertificate"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Hrm/Employee/ExperienceCertificate.aspx";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}
function RelievingCertificateRedirect() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"RelievingCertificate"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Hrm/Employee/RelievingCertificate.aspx";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}
function IncrementCertificateRedirect() {
    if ($("#ctl00_CP_EmployeeAutoSearchTextBox").val() != '') {
        $.ajax({
            type: "POST",
            url: "/Pages/Hrm/Employee/EmployeeDetailForm.aspx/SetSession",
            data: '{"Employee":"' + $("#ctl00_CP_EmployeeAutoSearchTextBox").val() + '", "SessionValue":"IncrementCertificate"}',
            contentType: "application/json;charset=utf-8",
            dataType: "json",
            success: function (data) {
                window.location = "/Pages/Hrm/Employee/IncrementCertificate.aspx";
            },
            error: function (xhr, status, error) {
                var err = eval("(" + xhr.responseText + ")");
                console.log(err.Message);
            }
        });
    }
}




function textToBase64Barcode(text) {
    var canvas = document.createElement("canvas");
    JsBarcode(canvas, text, { format: "CODE39" });
    return canvas.toDataURL("image/png");
}

function toggleFullScreen() {
    $("body").toggleClass("sidebar-collapse");
}

function generateQrCode(text) {
    var div = document.createElement("div");
    div.style = "";
    var qrcode = new QRCode(div, {
        text: text,
        width: 137, //128
        height: 137,
        colorDark: "#000000",
        colorLight: "#ffffff",
        correctLevel: QRCode.CorrectLevel.H
    });
    return div.childNodes[0].toDataURL();
}