<%@ page language="C#" autoeventwireup="true" inherits="Login, App_Web_gm4kokkr" title="Login" stylesheettheme="Default" uiculture="auto" meta:resourcekey="PageResource1" enableEventValidation="false" viewStateEncryptionMode="Never" %>

<%@ Register Src="~/UserControls/ConfirmationBox/ConfirmationBoxControl.ascx" TagName="ConfirmationBoxControl" TagPrefix="uc1" %>
<%@ Register Src="~/UserControls/Security/ForgotPassword.ascx" TagName="ForgotPasswordControl" TagPrefix="fpc" %>

<!DOCTYPE html>
<html>
<head id="Head1" runat="server">
    <%-- <title>Login Page</title>--%>
    <link rel="shortcut icon" href="~/ContentTemplates/Brand/favicon.png" type="image/x-icon" />

    <%--Sahil Start for SEO purpose--%>
    <meta property="og:type" content="website" />
    <meta property="og:url" content="https://onlinevidyalaya.net/" />
    <meta property="og:site_name" content="Online Vidyalaya - Login Portal" />
    <script type="application/ld+json">
{
  "@context" : "https://schema.org",
  "@type" : "WebSite",
  "name" : "Online Vidyalaya - Login Portal",
  "url" : "https://onlinevidyalaya.net/"
}
    </script>
    <title>Login - Vidyalaya</title>
    <meta name="description" content="Online Vidyalaya is the best School Portal Trusted by 1600+ Schools and awarded as 'Most Innovative School Management ERP', Go online with Vidyalaya School Portal.">
    <meta name="author" content="">
    <meta name="keywords" content="Online Vidyalaya - Login Portal">
    <%--Sahil End for SEO purpose--%>

    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link href="https://fonts.googleapis.com/css?family=Montserrat|Poppins|Roboto" rel="stylesheet">
    <link href="~/App_Themes/newTheme/css/bootstrap.css" rel="stylesheet" />
    <link href="~/App_Themes/newTheme/css/fontawesome.min.css" rel="stylesheet" type="text/css" />
    <!-- Theme style -->
    <link href="../../../App_Themes/newTheme/css/login_new.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript">
        // declare a new JavaScript variable
        var popWindow;
        // declare a new function, newWindow
        function newWindow(winID) {

            // declare variable winURL, setting it to the name of the PHP file
            // and accompanying data.
            var winURL = "ForgotPassword.aspx";
            // If the popup window does not exist, or it is currently closed,
            // open it.
            if (!popWindow || popWindow.closed) {
                popWindow = window.open(winURL, 'Forgot_Password', 'dependent,width=400,height=180,left=150,top=100');
            }
                // If the popup window is already open, make it active and update
                // its location to winURL.
            else {
                popWindow.focus();
                popWindow.location = winURL;
            }
        }

        function LogoImageButtonClick() {
            popwindow = null;
            var left = (screen.width / 2) - (1000 / 2);
            var top = (screen.height / 2) - (500 / 2);

            if (popwindow == null) {
                popwindow = window.open('http://www.vidyalayaschoolsoftware.com', '', 'height=600,width=1000,toolbar=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=no,modal=yes' + ', top=' + top + ', left=' + left)

            }
            else {
                popwindow.close();
                popwindow = window.open('http://www.vidyalayaschoolsoftware.com', '', 'height=600,width=1000,toolbar=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=no,modal=yes' + ', top=' + top + ', left=' + left)
            }
        }
    </script>
</head>
<body id="bodytag" runat="server" data-open="click" data-menu="vertical-menu" data-col="1-column">
    <section class="center">
        <form method="post" id="form1" runat="server">
            <asp:ScriptManager ID="LoginScriptManager" runat="server" EnablePageMethods="True">
            </asp:ScriptManager>
            <%--<div id="bannerContainer" runat="server" visible="false"></div>--%>
            <div class="maincontainer" id="mainDiv" runat="server">
                <div class="bothsidebox">
                    <div class="leftcard">
                        <div class="leftcardbox">
                            <div class="cardinside">
                                <a class="card_a" runat="server" id="BrandWebsite" target="_blank">
                                    <img class="cardinsideimg" src="../../../ContentTemplates/Brand/vidyalaya_logo.png" alt="logo">
                                </a>
                            </div>
                            <div>
                                <asp:Label runat="server" ID="ErrorLabel" CssClass="errmsg" Style="display: none" meta:resourcekey="ErrorLabelResource1"></asp:Label>
                                <asp:Label runat="server" ID="SuccessLabel" CssClass="errmsg" Style="display: none" meta:resourcekey="SuccessLabelResource1"></asp:Label>
                            </div>
                            <div class="selectmaindiv select-wrapper" id="selectldiv" runat="server">
                                <asp:DropDownList ID="OrgDropDownList" runat="server"
                                    AutoPostBack="true" OnSelectedIndexChanged="OrgDropDownList_OnSelectedIndexChanged">
                                </asp:DropDownList>
                                <img src="../../../ContentTemplates/Brand/arrowdown.png" class="selectimg" alt="" />
                            </div>
                            <div class="selectmaindiv select-wrapper" id="selectdiv">
                                <asp:DropDownList ID="BatchDropDownList" runat="server" Style="font-family: 'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif">
                                </asp:DropDownList>
                                <img src="../../../ContentTemplates/Brand/arrowdown.png" class="selectimg" alt="" />
                            </div>
                            <div class="iconz">
                                <div class="container p-0">
                                    <div class="box">
                                        <img src="../../../ContentTemplates/Brand/ic_user.png" class="usrimg" alt="usericon" />
                                        <asp:TextBox ID="userNameTextBox" MaxLength="100" runat="server" AutoPostBack="false" autocomplete="false"
                                            SkinID="" meta:resourcekey="userNameTextBoxResource1"></asp:TextBox>
                                        <label for="userNameTextBox">Username</label>
                                    </div>
                                    <div class="box mb-1 passwordfield">
                                        <img src="../../../ContentTemplates/Brand/ic_pwd.png" class="pwdimg" alt="pwd" />
                                        <asp:TextBox ID="passwordTextBox" MaxLength="100" TextMode="Password" runat="server" autocomplete="off" AutoCompleteType="Disabled"
                                            meta:resourcekey="passwordTextBoxResource1"></asp:TextBox>
                                        <label for="passwordTextBox">Password</label>
                                    </div>
                                    <div class="box logincaptcha">
                                        <div runat="server" visible="false" id="captchacodediv" class="inputcaptcha">
                                            <asp:TextBox ID="txtCaptcha" runat="server" placeholder="Enter Below Code"></asp:TextBox>

                                        </div>
                                        <div id="Captchadiv" runat="server" visible="false" class="displaycaptcha" onmousedown="return false" onselectstart="return false">
                                            <asp:TextBox ID="imgCaptcha" runat="server" onpaste="return false;" oncut="return false;" oncopy="return false;" Enabled="false" />
                                            <asp:Button type="button" ID="btnRefresh" runat="server" SkinID="0" OnClick="btnRefresh_Click" CssClass="btn-refresh btn fas" Style="font-size: 15px; padding: 8px; margin-top: 6px; float: right; background-color: steelblue !important; border-color: steelblue !important" Text="&#xf2f9;" />
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="formessentials">
                                <div class="check">
                                    <asp:CheckBox ID="chkRememberMe" runat="server" Text="Remember Login?" />
                                </div>
                                <div class="pass">
                                    <asp:LinkButton ID="ForgotPasswordLink" runat="server" OnClick="ForgotPasswordLink_Click" OnClientClick="window.document.forms[0].target='_blank';">Forgot Password ?</asp:LinkButton>
                                </div>
                            </div>

                            <asp:UpdatePanel ID="ConfirmationBoxUpdatePanel" runat="server" RenderMode="Inline">
                                <ContentTemplate>
                                    <uc1:ConfirmationBoxControl ID="LoginConfirmBox" runat="server" OnOkClick="ConfirmBox_OK"
                                        OnCancelClick="ConfirmBox_Cancel" Visible="false" />
                                </ContentTemplate>
                            </asp:UpdatePanel>

                            <div class="sbtn">
                                <asp:LinkButton ID="loginButton" runat="server" CssClass="loginbtn" data-target="#myModal"
                                    meta:resourcekey="loginButtonResource1" OnClick="loginButton_Click">Login
                                </asp:LinkButton>
                            </div>

                            <div id="myModal" class="modal" role="dialog" runat="server">
                                <div class="modal-dialog">

                                    <!-- Modal content-->
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <asp:Button type="button" ID="close" class="close" data-dismiss="modal" runat="server" SkinID="0" OnClick="close_Click" CssClass="btn btn-close modal-close fas pull-right" Text="&#xf00d;" />
                                            <h4 class="modal-title">Status</h4>
                                        </div>
                                        <div class="modal-body">
                                            <asp:Label ID="ErrorMsg" runat="server" Text=""></asp:Label>
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <asp:UpdatePanel ID="ForgotPasswordUpdatePanel" runat="server" RenderMode="Inline">
                                <ContentTemplate>
                                    <fpc:ForgotPasswordControl ID="ForgotPasswordBox" runat="server" Visible="false" />
                                </ContentTemplate>
                            </asp:UpdatePanel>

                            <asp:HiddenField ID="hiddenMsg" runat="server" />
                        </div>
                    </div>
                    <div class="rightcard rightFullsizeSchoolImage" id="rightcardImage" runat="server">
                        <div class="rightimage">
                            <img src="../../../ContentTemplates/Brand/schoolImage.png" alt="rightbanner" class="SchoolImage" runat="server" id="LoginBgImage" />
                            <img src="../../../ContentTemplates/Brand/img_right.png" alt="rightbanner" class="DefaultImage" />
                        </div>
                        <div class="rightitems">
                            <p>
                                Licenced No : <span class="spanblack" runat="server" id="LicenceNo"></span>
                                | Licenced To : <span class="spanblack" runat="server" id="LicenceTo"></span>
                                | IP Address : <span class="spanblack" runat="server" id="IPAddress"></span>
                                |<br>
                                Version Number : <span class="spanblack" runat="server" id="VersionNo"></span>
                                <span runat="server" id="ContactusDiv">| Powered By : <a target="_blank" class="spanblack" runat="server" id="ContacatusHyperLink"></a></span>
                                <span runat="server" id="DevelopByDiv">| Developed By : <a target="_blank" class="spanblack" runat="server" id="DevelopedByHyperLink"></a></span>
                                |<br>
                                <asp:Label ID="SupportPhoneNoLabel" runat="server" CssClass="spanblack"></asp:Label>
                            </p>
                        </div>
                    </div>
                    <asp:ImageButton Visible="false" runat="server" ID="LogoImageButton" ImageUrl="../../../Images/LogoNew.png" />
                    <asp:HiddenField ID="TokenIdHiddenField" runat="server" />
                    <asp:HiddenField ID="OrgGroupIdHiddenField" runat="server" />
                </div>
            </div>
        </form>
    </section>
    <%--nidhi js file start here --%>
    <script src="../../../App_Themes/newTheme/js/jquery-3.3.1.min.js"></script>
    <%--<script src="../../../App_Themes/newTheme/js/constellation.js"></script>--%>
    <script src="../../../App_Themes/newTheme/js/materialize.js" type="text/javascript"></script>
    <script src="../../../App_Themes/newTheme/js/init.js" type="text/javascript"></script>
    <%--nidhi js file ends here --%>
    <%-- nidhi js--%>
    <script src="https://www.gstatic.com/firebasejs/7.15.1/firebase-app.js"></script>
    <script src="https://www.gstatic.com/firebasejs/7.15.1/firebase-messaging.js"></script>
    <script>

        $(document).ready(function () {
            $("input").each(function (e) {
                if ($(this).val() == '') {
                    $(this).closest('.box').removeClass('username');
                } else {
                    $(this).closest('.box').addClass('username');
                }
            });

            $(document).on('focus blur', 'input', function () {
                if ($(this).val() == '') {
                    $(this).closest('.box').removeClass('username');
                } else {
                    $(this).closest('.box').addClass('username');
                }
            });

            if ($('#ErrorLabel').text() != "") {
                $("#ErrorLabel").show();
                $(".card-subtitle").css({ "padding-top": "32px" });
            }
            else {
                $("#ErrorLabel").hide();
                $(".card-subtitle").css({ "padding-top": "0px" });
            }

            if ($('#SuccessLabel').text() != "") {
                $("#SuccessLabel").show();
                $(".card-subtitle").css({ "padding-top": "32px" });
            }
            else {
                $("#SuccessLabel").hide();
                $(".card-subtitle").css({ "padding-top": "0px" });
            }

            //for web Push Notification
            $.ajax({
                type: "POST",
                url: "/Pages/BaseFramework/Security/Login.aspx/GetConfigValues",
                data: '{"OrgGroupId":"' + $("#OrgGroupIdHiddenField").val() + '"}',
                contentType: "application/json; charset=utf-8",
                dataType: "json",
                success: function (data) {
                    var datas = data.d;

                    localStorage.setItem("apiKey", JSON.parse(datas).apiKey);
                    localStorage.setItem("authDomain", JSON.parse(datas).authDomain);
                    localStorage.setItem("projectId", JSON.parse(datas).projectId);
                    localStorage.setItem("storageBucket", JSON.parse(datas).storageBucket);
                    localStorage.setItem("messagingSenderId", JSON.parse(datas).messagingSenderId);
                    localStorage.setItem("appId", JSON.parse(datas).appId);
                    localStorage.setItem("measurementId", JSON.parse(datas).measurementId);
                },
                error: function (jqXHR, Status, errorMsg) {
                }
            });

            const firebaseConfig = {
                apiKey: localStorage.getItem("apiKey"),
                authDomain: localStorage.getItem("authDomain"),
                projectId: localStorage.getItem("projectId"),
                storageBucket: localStorage.getItem("storageBucket"),
                messagingSenderId: localStorage.getItem("messagingSenderId"),
                appId: localStorage.getItem("appId"),
                measurementId: localStorage.getItem("measurementId")
            };

            firebase.initializeApp(firebaseConfig);
            const messaging = firebase.messaging();

            function IntitalizeFireBaseMessaging() {
                messaging
                    .requestPermission()
                    .then(function () {
                        return messaging.getToken();
                    })
                    .then(function (token) {
                        $("#TokenIdHiddenField").val(token);
                    })
                    .catch(function (reason) {
                    });
            }
            messaging.onTokenRefresh(function () {
                messaging.getToken()
                    .then(function (newtoken) {
                        $("#TokenIdHiddenField").val(token);
                    })
                    .catch(function (reason) {
                    })
            })
            IntitalizeFireBaseMessaging();
        });


        function disp_confirm(obj) {
            var StatusFlag = '';
            alert(obj);
        }
    </script>
    <%-- nidhi js--%>
    <!-- jQuery 2.1.3 -->
    <script src="../../../App_Themes/BlackTheme/plugins/jQuery/jQuery-2.1.3.min.js" type="text/javascript"></script>
    <!-- Bootstrap 3.3.2 JS -->
    <script src="../../../App_Themes/BlackTheme/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
</body>
</html>
