﻿<%@ page language="C#" autoeventwireup="true" inherits="Pages_Capture, App_Web_0trrukcu" enableEventValidation="false" viewStateEncryptionMode="Never" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <form id="form1" runat="server">
        <div id="ImageCapture" runat="server">
            <asp:Button ID="BackButton" Text="Back" TabIndex="3" runat="Server" SkinID="0" class="fas fa-arrow-left" OnClick="BackButton_Click" />
            <table border="0" cellpadding="0" cellspacing="0">                
                <tr>                    
                    <th align="center"><u>Live Camera</u></th>
                    <th align="center"><u>Captured Picture</u></th>
                </tr>
                <tr>
                    <td>
                        <div id="webcam"></div>
                    </td>
                    <td>
                        <img id="imgCapture" /></td>
                </tr>
            </table>
            <br />            
            <input type="button" id="btnCapture" value="Capture" />
            <input type="button" id="SaveButton" value="Save"/>            
            <asp:HiddenField ID="EmployeeIdHiddenField" runat="server" />
            <br />
            <span id="camStatus"></span>
        </div>
        <div id="ButtonCapture" runat="server">
            <asp:Button Text="Check In" ID="CheckInButton" CssClass="Initial fas transparenttab" SkinID="0" OnClick="CheckInButton_Click" runat="server" />
        </div>
        <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js"></script>
        <script src="../../../JavaScript/Webcam_Plugin/WebCam.js"></script>
        <script src='<%=ResolveUrl("~/Javascript/Webcam_Plugin/jquery.webcam.js") %>' type="text/javascript"></script>
        <script type="text/javascript">
            var pageUrl = '<%=ResolveUrl("~/Pages/Capture.aspx") %>';
            $(function () {
                Webcam.set({
                    width: 320,
                    height: 240,
                    image_format: 'jpeg',
                    jpeg_quality: 90
                });
                if ($("#ImageCapture").is(":visible"))
                    Webcam.attach('#webcam');

                $("#btnCapture").click(function () {
                    Webcam.snap(function (data_uri) {
                        $("#imgCapture")[0].src = data_uri;
                    });
                });
            });

            $("#SaveButton").click(function () {
                $.ajax({
                    type: "POST",
                    url: "Capture.aspx/SaveCapturedImage",
                    data: '{"data":"' + $("#imgCapture")[0].src + '","EmployeeId":"' + $('#EmployeeIdHiddenField').val() + '"}',
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (r) {
                        if (r.d == false) {
                            alert('Already Checked In')
                            $("#imgCapture")[0].src = '';
                        }
                        else {
                            alert('Check In Successfull');
                            myurl = window.location.search;
                            var keyval = myurl.split('?')[1];
                            window.location.href = "BaseFramework/Security/EmployeeLogin.aspx?" + keyval + "&ManualPunch=CheckIn";
                        }
                    }
                });

            });
        </script>
    </form>

</body>
</html>
