﻿<%@ page language="C#" masterpagefile="~/Pages/Common/MasterPages/MainMasterPage_new.master" autoeventwireup="true" inherits="Pages_Hrm_Employee_TimeSheetUpdate, App_Web_bjjodavj" uiculture="auto" enableEventValidation="false" viewStateEncryptionMode="Never" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<%@ Register Src="~/UserControls/GridViewPager/GridViewPager.ascx" TagName="GridViewPager"
    TagPrefix="uc1" %>
<%@ Register Src="~/UserControls/Common/ScreenGroup/ScreenGroup.ascx" TagName="ScreenGroupControl"
    TagPrefix="ScreenGroup" %>
<%@ Register Src="~/UserControls/DatePicker/DatePickerControl.ascx" TagName="DatePickerControl"
    TagPrefix="Date" %>
<%@ Register Src="~/UserControls/Common/EmployeeSearch/EmployeeSearch.ascx" TagName="EmployeeSearchControl"
    TagPrefix="hims" %>
<%@ Register Assembly="TimePicker" Namespace="MKB.TimePicker" TagPrefix="timePicker" %>
<%@ Register Src="~/UserControls/Common/CommonSearch/CommonSearch.ascx" TagName="CommonSearchUserControl"
    TagPrefix="uc2" %>
<asp:Content ID="Content1" ContentPlaceHolderID="CP" runat="Server">
    <asp:UpdatePanel ID="ResonMasterUpdatePanel" runat="server" UpdateMode="Always">
        <ContentTemplate>
            <uc2:CommonSearchUserControl ID="CommonSearchControl" Visible="false" runat="server" />
            <hims:EmployeeSearchControl ID="EmployeeSearch" Visible="false" runat="server" />
            <div id="divContentPage" class="divcontentpagemargin">

                <div class="dashBoardLeftCont">
                    <div class="himssuHeader3WireBox">
                        <table>
                            <tr>
                                <td>
                                    <div class="himsBoxContent">
                                        <div class="leftUlMenu">
                                            <ScreenGroup:ScreenGroupControl EnableViewState="true" ID="ScreenGroupControl" ScreenGroupId="166"
                                                Visible="true" runat="server" />
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="whiteboxpaddingleft row">
                    <div class="himssuHeader5WireBox card card-box" id="SearchDiv" runat="server">
                        <div class="himsBoxHeader card-head">
                            <asp:Panel ID="TopPanel" runat="server">

                                <div class="himsBoxTitle">
                                    <div class="headerText">
                                        <header>
                                            <i class="fas fa-search"></i>
                                            <asp:Label ID="headerTextLabel" runat="server" Text="Search"></asp:Label>
                                        </header>
                                    </div>
                                </div>
                            </asp:Panel>
                        </div>
                        <asp:Panel ID="DetailPanel" runat="Server">
                            <div class="himsBoxContent card-body">
                                <div class="contentHolder">
                                    <asp:Panel ID="PanelSearch" runat="server">
                                        <div class="outerBox pTop5 col-md-4">
                                            <div class="controlLabelWidth">
                                                <asp:Label ID="SearchEmployeeCodeLabel" runat="server" Text="Employee Code" SkinID="MandatoryLabel"></asp:Label>
                                            </div>
                                            <div class="fLeft pRight5 display-flex">
                                                <asp:TextBox ID="SearchEmployeeCodeTextBox" SkinID="CustomWidthTextBox"
                                                    runat="server" MaxLength="100"> </asp:TextBox>
                                                <asp:ImageButton SkinID="FindImage" ToolTip="Search" ID="SearchEmployeeCodeImageButton"
                                                    runat="server" OnClick="SearchEmployeeCodeImageButton_Click" ImageUrl="../../../../Images/icons/icon_find.gif" />
                                                <asp:HiddenField ID="EmployeeIdHiddenField" runat="server" />
                                                <asp:HiddenField ID="DateHiddenField" runat="server" />                                                
                                            </div>
                                        </div>
                                        <div id="ForYearDiv" runat="server">
                                            <div class="outerBox pTop5 col-md-4">
                                                <div class="controlLabelWidth">
                                                    <asp:Label ID="ForYearLabel" runat="server" Text="For Year" SkinID="MandatoryLabel"></asp:Label>
                                                </div>
                                                <div class="fLeft pRight5">
                                                    <asp:DropDownList runat="server" ID="ForYearDropDownList" SkinID="CustomWidthDropDownList"
                                                        CssClass="form-control" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()" AutoPostBack="true"
                                                        OnSelectedIndexChanged="ForYearDropDownList_SelectedIndexChanged">
                                                    </asp:DropDownList>
                                                </div>
                                            </div>
                                        </div>

                                        <div id="ForMonthDiv" runat="server">
                                            <div class="outerBox pTop5 col-md-4">
                                                <div class="controlLabelWidth">
                                                    <asp:Label ID="ForMonthLabel" runat="server" Text="For Month" SkinID="MandatoryLabel"></asp:Label>
                                                </div>
                                                <div class="fLeft pRight5">
                                                    <asp:DropDownList runat="server" ID="ForMonthDropDownList" SkinID="CustomWidthDropDownList"
                                                        CssClass="form-control" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()" AutoPostBack="false">
                                                    </asp:DropDownList>
                                                </div>
                                            </div>
                                        </div>
                                        <div align="right" class="fRight col-md-12" id="ApplyAllDiv" runat="server" visible="false" style="height: 70px; padding-top: 20px;">
                                            <div class="fleft" style="width: 100px; float: right; padding-top: -1px; padding-right: 10px">
                                                <asp:Button ID="ApplyButton" runat="server" SkinID="0" Text="Apply All" OnClick="ApplyButton_Click" CssClass="btn btn-assign fas" />
                                            </div>
                                            <div class="fleft" style="width: 100px; float: right; padding-top: 7px; padding-right: 10px">
                                                <asp:TextBox ID="ApplyTextBox" runat="server" SkinID="CustomWidthTextBox" Visible="true" onkeypress="return ApplyAllIsNumber(this);" onkeyup="ApplyFieldChange(this);"></asp:TextBox>
                                            </div>
                                            <div class="fleft" style="width: 207px; float: right; padding-top: 10px; padding-right: 10px">
                                                <asp:DropDownList ID="ApplyFieldsDropDownList" runat="server" SkinID="CustomWidthDropDownList" CssClass="form-control" AutoPostBack="true" OnSelectedIndexChanged="ApplyFieldsDropDownList_SelectedIndexChanged">
                                                    <asp:ListItem Text="FirstIn" Value="1"></asp:ListItem>
                                                    <asp:ListItem Text="LastOut" Value="2"></asp:ListItem>
                                                    <asp:ListItem Text="LateBy" Value="3"></asp:ListItem>
                                                    <asp:ListItem Text="EarlyBy" Value="4"></asp:ListItem>
                                                    <asp:ListItem Text="OverTime" Value="5"></asp:ListItem>
                                                    <asp:ListItem Text="Status" Value="6"></asp:ListItem>
                                                    <asp:ListItem Text="Shift" Value="7"></asp:ListItem>
                                                </asp:DropDownList>
                                            </div>
                                        </div>
                                        <div class="alignCenter col-md-12 center">
                                            <asp:Button ID="SearchButton" Text="&#xf002; Search" TabIndex="3" runat="Server" SkinID="0"
                                                class="btn-search btn fas" OnClick="SearchButton_Click" />
                                            <asp:Button ID="ResetButton" runat="server" TabIndex="4" Text="&#xf0e2; Reset" OnClick="ResetButton_Click"
                                                SkinID="0" class="btn-reset btn fas" />
                                        </div>
                                        <div class="col-md-12">
                                            <asp:Label ID="HtmlStringLabel" runat="server"></asp:Label>
                                        </div>
                                    </asp:Panel>
                                    <asp:UpdatePanel ID="MenuPlanDetailUpdatePanel" runat="server" UpdateMode="Always">
                                        <ContentTemplate>
                                            <div class="table-responsive col-md-12">
                                                <asp:GridView ID="LeaveMasterGridView" OnRowDataBound="LeaveMasterGridView_RowDataBound"
                                                    OnPageIndexChanging="LeaveMasterGridView_PageIndexChanging" runat="server" AutoGenerateColumns="False"
                                                    Width="100%" AllowPaging="false"
                                                    PagerSettings-Visible="false" EmptyDataText="No records available for the search criteria"
                                                    ShowHeader="True" CssClass="table table-striped table-bordered table-hover">
                                                    <Columns>
                                                        <asp:BoundField HeaderText="Date" DataField="Attn_Date" DataFormatString="{0:d}"
                                                            HeaderStyle-HorizontalAlign="Left">
                                                            <ItemStyle Width="10%" />
                                                        </asp:BoundField>
                                                        <asp:TemplateField HeaderText="FirstIn" ItemStyle-Width="10%" ItemStyle-Wrap="true"
                                                            HeaderStyle-HorizontalAlign="Left">
                                                            <ItemTemplate>
                                                                <asp:TextBox ID="FirstInTextBox" CssClass="col-md-3 !important" runat="server" onmouseleave="showHideTooltip()" Width="150px" onmouseenter="showHideTooltip()" onkeypress="return isNumberKey(event)" onkeyup="FormatIt(this);" onchange="validateHhMm(this);" MaxLength="5"
                                                                    SkinID="CustomWidthTextbox" Text='<%#Eval("FirstIn") %>'></asp:TextBox>
                                                            </ItemTemplate>
                                                        </asp:TemplateField>
                                                        <asp:TemplateField HeaderText="LastOut" ItemStyle-Width="10%" ItemStyle-Wrap="true"
                                                            HeaderStyle-HorizontalAlign="Left">
                                                            <ItemTemplate>
                                                                <asp:TextBox ID="LastOutTextBox" CssClass="col-md-3 !important" runat="server" onmouseleave="showHideTooltip()" Width="150px" onmouseenter="showHideTooltip()" onkeypress="return isNumberKey(event)" onkeyup="FormatIt(this);" onchange="validateHhMm(this);" MaxLength="5"
                                                                    SkinID="CustomWidthTextbox" Text='<%#Eval("LastOut") %>'></asp:TextBox>
                                                            </ItemTemplate>
                                                        </asp:TemplateField>
                                                        <asp:TemplateField HeaderText="LateBy" ItemStyle-Width="10%" ItemStyle-Wrap="true"
                                                            HeaderStyle-HorizontalAlign="Left">
                                                            <ItemTemplate>
                                                                <asp:TextBox ID="LateByTextBox" CssClass="col-md-3 !important" runat="server" onmouseleave="showHideTooltip()" Width="150px" onmouseenter="showHideTooltip()" onkeypress="return isNumberKey(event)" onkeyup="FormatIt(this);" onchange="validateHhMm(this);" MaxLength="5"
                                                                    SkinID="CustomWidthTextbox" Text='<%#Eval("LateBy") %>'></asp:TextBox>
                                                            </ItemTemplate>
                                                        </asp:TemplateField>
                                                        <asp:TemplateField HeaderText="EarlyBy" ItemStyle-Width="10%" ItemStyle-Wrap="true"
                                                            HeaderStyle-HorizontalAlign="Left">
                                                            <ItemTemplate>
                                                                <asp:TextBox ID="EarlyByTextBox" CssClass="col-md-3 !important" runat="server" onmouseleave="showHideTooltip()" Width="150px" onmouseenter="showHideTooltip()" onkeypress="return isNumberKey(event)" onkeyup="FormatIt(this);" onchange="validateHhMm(this);" MaxLength="5"
                                                                    SkinID="CustomWidthTextbox" Text='<%#Eval("EarlyBy") %>'></asp:TextBox>
                                                            </ItemTemplate>
                                                        </asp:TemplateField>
                                                        <asp:TemplateField HeaderText="OverTime" ItemStyle-Width="10%" ItemStyle-Wrap="true"
                                                            HeaderStyle-HorizontalAlign="Left">
                                                            <ItemTemplate>
                                                                <asp:TextBox ID="OverTimeTextBox" CssClass="col-md-3 !important" runat="server" onmouseleave="showHideTooltip()" Width="150px" onmouseenter="showHideTooltip()" onkeypress="return isNumberKey(event)" onkeyup="FormatIt(this);" onchange="validateHhMm(this);" MaxLength="5"
                                                                    SkinID="CustomWidthTextbox" Text='<%#Eval("OverTime") %>'></asp:TextBox>
                                                            </ItemTemplate>
                                                        </asp:TemplateField>
                                                        <asp:TemplateField HeaderText="Duration" ItemStyle-Width="10%" ItemStyle-Wrap="true"
                                                            HeaderStyle-HorizontalAlign="Left">
                                                            <ItemTemplate>
                                                                <asp:HiddenField ID="DurationHiddenField" runat="server" Value='<%# Bind("Duration") %>' />
                                                                <asp:Label ID="DurationLabel" runat="server" Text='<%# Bind("Duration") %>'>' </asp:Label>
                                                            </ItemTemplate>
                                                        </asp:TemplateField>
                                                        <asp:TemplateField HeaderText="Status" ItemStyle-Width="10%" ItemStyle-Wrap="true"
                                                            HeaderStyle-HorizontalAlign="Left">
                                                            <ItemTemplate>
                                                                <asp:Label ID="PresentStatusLabel" runat="server" Text='<%# Bind("PresentStatus") %>' Visible="false">' </asp:Label>
                                                                <asp:DropDownList ID="LeaveStatusDropDownList" Width="200px " runat="server" onmouseleave="showHideTooltip()"
                                                                    onmouseenter="showHideTooltip()" SkinID="CustomWidthDropDownList" CssClass="form-control !important">
                                                                </asp:DropDownList>
                                                            </ItemTemplate>
                                                        </asp:TemplateField>
                                                        <asp:TemplateField HeaderText="Shift" ItemStyle-Width="10%" ItemStyle-Wrap="true"
                                                            HeaderStyle-HorizontalAlign="Left">
                                                            <ItemTemplate>
                                                                <asp:TextBox ID="ShiftTextBox" CssClass="col-md-3 !important" runat="server" onmouseleave="showHideTooltip()" Width="150px" onmouseenter="showHideTooltip()"
                                                                    SkinID="CustomWidthTextbox" Text='<%#Eval("Shift") %>'></asp:TextBox>
                                                            </ItemTemplate>
                                                        </asp:TemplateField>
                                                    </Columns>
                                                </asp:GridView>
                                            </div>
                                        </ContentTemplate>
                                    </asp:UpdatePanel>
                                </div>
                            </div>
                    </div>
                </div>
            </div>
            </asp:Panel>
                </div>

            </div>
            </div>
         
        </ContentTemplate>
    </asp:UpdatePanel>
    <script type="text/javascript">
        function isNumberKey(evt) {
            var charCode = (evt.which) ? evt.which : event.keyCode;
            if (charCode > 31 && (charCode < 48 || charCode > 57))
                return false;
            return true;
        }
        function FormatIt(obj) {
            if (obj.value.length == 2)
                obj.value = obj.value + ":";


            var row = obj.parentNode.parentNode.rowIndex + 1;
            if (row < 10)
                row = "0" + row;
            var starttime = $('#ctl00_CP_LeaveMasterGridView_ctl' + row + '_FirstInTextBox')[0].value;
            var endtime = $('#ctl00_CP_LeaveMasterGridView_ctl' + row + '_LastOutTextBox')[0].value;

            var t1 = starttime.split(":")[0] * 60 + starttime.split(":")[1] * 1;
            var t2 = endtime.split(":")[0] * 60 + endtime.split(":")[1] * 1;
            var t3 = 0;
            if (t2 > t1) {
                t3 = t2 - t1
            }

            var hours = Math.floor(t3 / 60);
            var minutes = t3 % 60;

            if (hours < 10)
                hours = "0" + hours;
            if (minutes < 10)
                minutes = "0" + minutes;
            $('#ctl00_CP_LeaveMasterGridView_ctl' + row + '_DurationLabel')[0].innerText = hours + ":" + minutes;
            $('#ctl00_CP_LeaveMasterGridView_ctl' + row + '_DurationHiddenField')[0].value = hours + ":" + minutes;
        }
        function ApplyFieldChange(obj) {
            var ApplyFieldsDropDown = document.getElementById('<%=ApplyFieldsDropDownList.ClientID %>').value;
            if (ApplyFieldsDropDown != '7' && ApplyFieldsDropDown != '6')
                if (obj.value.length == 2)
                    obj.value = obj.value + ":";
        }

        function ApplyAllIsNumber(obj) {
            var charCode = (obj.which) ? obj.which : event.keyCode;
            var ApplyFieldsDropDown = document.getElementById('<%=ApplyFieldsDropDownList.ClientID %>').value;
            if (ApplyFieldsDropDown != '7' && ApplyFieldsDropDown != '6') {                
                    if (charCode > 31 && (charCode < 48 || charCode > 57))
                        return false;
                    if (obj.value.length > 4)
                        return false;                
            }
            return true;
        }

        function KeyUpCall() {
            var table = document.getElementById('<%=LeaveMasterGridView.ClientID %>');
            for (var i = 1; i <= table.rows.length; i++) {
                var rowindex = table.rows[i].rowIndex + 1;
                if (rowindex < 10)
                    rowindex = "0" + rowindex;
                var starttime = $('#ctl00_CP_LeaveMasterGridView_ctl' + rowindex + '_FirstInTextBox')[0].value;
                var endtime = $('#ctl00_CP_LeaveMasterGridView_ctl' + rowindex + '_LastOutTextBox')[0].value;

                var t1 = starttime.split(":")[0] * 60 + starttime.split(":")[1] * 1;
                var t2 = endtime.split(":")[0] * 60 + endtime.split(":")[1] * 1;
                var t3 = 0;
                if (t2 > t1) {
                    t3 = t2 - t1
                }

                var hours = Math.floor(t3 / 60);
                var minutes = t3 % 60;

                if (hours < 10)
                    hours = "0" + hours;
                if (minutes < 10)
                    minutes = "0" + minutes;
                $('#ctl00_CP_LeaveMasterGridView_ctl' + rowindex + '_DurationLabel')[0].innerText = hours + ":" + minutes;
                $('#ctl00_CP_LeaveMasterGridView_ctl' + rowindex + '_DurationHiddenField')[0].value = hours + ":" + minutes;
            }
        }

        function validateHhMm(inputField) {
            var isValid = /^([0-1]?[0-9]|2[0-3]):([0-5][0-9])(:[0-5][0-9])?$/.test(inputField.value);
            if (!isValid) {
                alert('Enter Valid Time');
                inputField.value = '00:00'
            }
            return isValid;
        }
    </script>    
    <script data-main='<%=ResolveUrl("~/JavaScript/rjs/leave")%>' src='<%=ResolveUrl("~/JavaScript/rjs/require.js")%>'></script>
</asp:Content>
