﻿<%@ page language="C#" autoeventwireup="true" inherits="Pages_FinancialManagement_Accounting_AccountSummaryDashboard, App_Web_hq2xnsm5" title="Account Summary Dashboard" masterpagefile="~/Pages/Common/MasterPages/MainMasterPage_new.master" enableEventValidation="false" viewStateEncryptionMode="Never" %>

<%@ Register Src="~/UserControls/DatePicker/DatePickerControl.ascx" TagName="DatePickerControl" TagPrefix="Date" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<%@ Register Src="~/UserControls/Common/ScreenGroup/ScreenGroup.ascx" TagName="ScreenGroupControl" TagPrefix="ScreenGroup" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CP" runat="Server">
    <asp:UpdatePanel ID="updPnlSearchGridView" runat="server">
        <ContentTemplate>
            <style>
                .customscrolltable tr th:first-child,
                .customscrolltable tr td:first-child {
                    width: 150px;
                }
            </style>
            <div id="divContentPage" class="divcontentpagemargin">
                <div class="dashBoardLeftCont">
                    <div class="himssuHeader3WireBox">
                        <table>
                            <tr>
                                <td>
                                    <div class="himsBoxContent">
                                        <div class="leftUlMenu">
                                            <ScreenGroup:ScreenGroupControl EnableViewState="true" ID="ScreenGroupControl" ScreenGroupId="173"
                                                Visible="true" runat="server" />
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="whiteboxpaddingleft row">
                    <div class="himssuHeader5WireBox card card-box">
                        <asp:Panel ID="SearchDetailPanel" runat="server" meta:resourcekey="SearchDetailPanelResource1">
                            <div class="himsBoxContent card-body">
                                <div class="contentHolder">
                                    <div class="himssuHeader1WireBox col-md-12 pTop5">
                                        <div class="himsBoxHeader  card-head inner">
                                            <div class="leftdiv">
                                            </div>
                                            <div class="himsBoxTitle">
                                                <div class="headerText fLeft">
                                                    <header>
                                                        <asp:Label ID="Dashboard_Label" runat="server" Text="Account Summary Dashboard" Font-Bold="true"></asp:Label>
                                                    </header>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="outerBox pTop5 col-md-3">
                                            <div class="controlLabelWidth">
                                                <asp:Label ID="AccountingYearLabel" runat="server" Text="Accounting Year" SkinID="MandatoryLabel"></asp:Label>
                                            </div>
                                            <div class="fLeft pRight5">
                                                <asp:DropDownList runat="server" ID="AccountingYearDropDownList" SkinID="CustomWidthDropDownList" onmouseleave="showHideTooltip()" AutoPostBack="true"
                                                    CssClass="form-control" onmouseenter="showHideTooltip()" OnSelectedIndexChanged="AccountingYearDropDownList_SelectedIndexChanged">
                                                </asp:DropDownList>
                                            </div>
                                        </div>

                                        <div class="himsBoxContent table-responsive customscrolltable">
                                            <asp:GridView ID="AccountDashboardGridView" runat="server" AutoGenerateColumns="False"
                                                CssClass="table table-striped table-bordered table-hover" Visible="false"
                                                OnRowDataBound="AccountDashboardGridView_RowDataBound" DataKeyNames="AccountId"
                                                ShowHeader="true" EmptyDataText="No records found">
                                                <PagerSettings Visible="False" />
                                            </asp:GridView>
                                        </div>

                                        <div class="himsBoxContent table-responsive pTop15">
                                            <asp:GridView ID="AccountDetailGridView" runat="server" Width="100%" AutoGenerateColumns="False" ShowFooter="true"
                                                CssClass="table table-striped table-bordered table-hover" Visible="false" EmptyDataText="No records found"
                                                OnRowDataBound="AccountDetailGridView_RowDataBound" SkinID="" ShowHeader="true" PagerSettings-Visible="false">
                                                <Columns>
                                                    <asp:TemplateField HeaderText="Ledger" ItemStyle-Width="18%" meta:resourcekey="TemplateFieldResource1" HeaderStyle-HorizontalAlign="Left"
                                                        FooterStyle-BackColor="#38445a" FooterStyle-ForeColor="White">
                                                        <ItemTemplate>
                                                            <asp:Label ID="LedgerLabel" runat="server" CssClass="boxEllips"
                                                                Text='<%#Bind("LedgerName")%>'></asp:Label>
                                                        </ItemTemplate>
                                                        <FooterTemplate>
                                                            <asp:Label ID="TotalLabel" ClientIDMode="Static" runat="server" Text="Total" Font-Bold="true"></asp:Label>
                                                        </FooterTemplate>
                                                    </asp:TemplateField>
                                                    <asp:TemplateField HeaderText="Opening Balance" ItemStyle-Width="8%" meta:resourcekey="TemplateFieldResource1"
                                                        HeaderStyle-HorizontalAlign="Right" ItemStyle-HorizontalAlign="Right" FooterStyle-HorizontalAlign="Right">
                                                        <ItemTemplate>
                                                            <asp:Label ID="OpBalanceLabel" runat="server" CssClass="boxEllips"
                                                                Text='<%#Bind("OpeningBalance")%>'></asp:Label>
                                                        </ItemTemplate>
                                                        <FooterTemplate>
                                                            <asp:Label ID="TotalOpBalanceLabel" ClientIDMode="Static" runat="server" Text="Total" Font-Bold="true"></asp:Label>
                                                        </FooterTemplate>
                                                    </asp:TemplateField>
                                                    <asp:TemplateField HeaderText="Dr Balance" ItemStyle-Width="10%" meta:resourcekey="TemplateFieldResource1"
                                                        HeaderStyle-HorizontalAlign="Right" ItemStyle-HorizontalAlign="Right" FooterStyle-HorizontalAlign="Right">
                                                        <ItemTemplate>
                                                            <asp:Label ID="DrBalanceLabel" runat="server" CssClass="boxEllips"
                                                                Text='<%#Bind("DebitBalance")%>'></asp:Label>
                                                        </ItemTemplate>
                                                        <FooterTemplate>
                                                            <asp:Label ID="TotalDrBalanceLabel" ClientIDMode="Static" runat="server" Text="Total" Font-Bold="true"></asp:Label>
                                                        </FooterTemplate>
                                                    </asp:TemplateField>
                                                    <asp:TemplateField HeaderText="Cr Balance" ItemStyle-Width="10%" meta:resourcekey="TemplateFieldResource1"
                                                        HeaderStyle-HorizontalAlign="Right" ItemStyle-HorizontalAlign="Right" FooterStyle-HorizontalAlign="Right">
                                                        <ItemTemplate>
                                                            <asp:Label ID="CrBalanceLabel" runat="server" CssClass="boxEllips"
                                                                Text='<%#Bind("CreditBalance")%>'></asp:Label>
                                                        </ItemTemplate>
                                                        <FooterTemplate>
                                                            <asp:Label ID="TotalCrBalanceLabel" ClientIDMode="Static" runat="server" Text="Total" Font-Bold="true"></asp:Label>
                                                        </FooterTemplate>
                                                    </asp:TemplateField>
                                                    <asp:TemplateField HeaderText="Closing Balance" ItemStyle-Width="10%" meta:resourcekey="TemplateFieldResource1" HeaderStyle-HorizontalAlign="Right"
                                                        ItemStyle-HorizontalAlign="Right" FooterStyle-HorizontalAlign="Right">
                                                        <ItemTemplate>
                                                            <asp:Label ID="ClBalanceLabel" runat="server" CssClass="boxEllips"
                                                                Text='<%#Bind("ClosingBalance")%>'></asp:Label>
                                                        </ItemTemplate>
                                                        <FooterTemplate>
                                                            <asp:Label ID="TotalClosingBalanceLabel" ClientIDMode="Static" runat="server" Text="Total" Font-Bold="true"></asp:Label>
                                                        </FooterTemplate>
                                                    </asp:TemplateField>
                                                </Columns>
                                            </asp:GridView>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </asp:Panel>
                    </div>
                </div>
            </div>
        </ContentTemplate>
    </asp:UpdatePanel>
    <script data-main='<%=ResolveUrl("~/JavaScript/rjs/account-dashboard")%>' src='<%=ResolveUrl("~/JavaScript/rjs/require.js")%>'></script>
</asp:Content>
