﻿<%@ WebService Language="C#" Class="BiometricSyncWebService" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using Sapphire.Vidyalaya.BusinessLogic.Business.TimeTable.TimeTableBL;
using Sapphire.Vidyalaya.BusinessLogic.Component.BiometricBL;
using Sapphire.Ohu.BaseFramework.Utilities;
using Sapphire.Ohu.BusinessEntity.Framework.BaseFrameworkBE;
using System.Data;
using System.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Data.Configuration;
using System.IO;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
// [System.Web.Script.Services.ScriptService]
public class BiometricSyncWebService : System.Web.Services.WebService
{


    // vs command prompt wsdl http://localhost:5568/Services/BiometricSyncWebService.asmx?wsdl
    // browse the service and put /service before part of url in config file
    //string SyncServiceUrl = System.Configuration.ConfigurationManager.AppSettings["SyncServiceUrl"];
    ///// <remarks/>
    //public TimeTableSyncWebService()
    //{
    //    this.Url = SyncServiceUrl + "/Services/TimeTableSyncWebService.asmx";
    //}
    
    
    #region Service Client

    //TimeTable Synch Service
    private BiometricConfigurationService BiometricSyncWebServiceClient
    {
        get { return new BiometricConfigurationService(); }
    }

    private CommonFunctions CommonFunctionServiceClient
    {
        get { return new CommonFunctions(); }
    }
 
    
    #endregion
    [WebMethod]
    public string HelloWorld()
    {
        return "Hello World";
    }


    // ***** Time Table Data Synch *****
    
    #region Time Table Data Synch

    [WebMethod]
    public DataSet GetDataSetList(string sQuesry)
    {
        DataSet ds = new DataSet();
        try
        {
            CommonHelper.LogWriter("GetDataSetList : \n" + sQuesry, 6, "Biometric Service", "GetDataSetList");
            ds = CommonFunctionServiceClient.GetDataset(sQuesry);
        }
        catch(Exception ex)
        {
            CommonHelper.LogWriter(ex.ToString(), 6, "Biometric Service", "GetDataSetList");            
        }
        return ds;
    }
     
    [WebMethod]
    public Int64 CreateStudentAttendance(string StrXML)
    {
        try
        {
            CommonHelper.LogWriter("CreateStudentAttendance : \n" + StrXML, 6, "Biometric Service", "CreateStudentAttendance");
            return BiometricSyncWebServiceClient.CreateStudentAttendance(StrXML);
        }
        catch(Exception ex)
        {
            CommonHelper.LogWriter(ex.ToString(), 6, "Biometric Service", "CreateStudentAttendance");
            return -1;
        }
    }
    [WebMethod]
    public Int64 CreateEmployeeAttendance(string StrXML)
    {
        try
        {
            CommonHelper.LogWriter("CreateEmployeeAttendance : \n" + StrXML, 6, "Biometric Service", "CreateEmployeeAttendance");
            return BiometricSyncWebServiceClient.CreateEmployeeAttendance(StrXML);
        }
        catch (Exception ex)
        {
            CommonHelper.LogWriter(ex.ToString(), 6, "Biometric Service", "CreateEmployeeAttendance");
            return -1;
        }
    }
    //Schedular Method
    [WebMethod]
    public Int64 AutoAttendanceStudent(string StrXML)
    {
        try
        {
            CommonHelper.LogWriter("AutoAttendanceStudent : \n" + StrXML, 6, "Biometric Service", "AutoAttendanceStudent");
            return BiometricSyncWebServiceClient.AutoAttendanceStudent(StrXML);
        }
        catch (Exception ex)
        {
            CommonHelper.LogWriter(ex.ToString(), 6, "Biometric Service", "AutoAttendanceStudent");
            return -1;
        }
    }
    [WebMethod]
    public Int64 AutoAttendanceEmployee(string StrXML)
    {
        try
        {
            CommonHelper.LogWriter("AutoAttendanceEmployee : \n" + StrXML, 6, "Biometric Service", "AutoAttendanceEmployee");
            return BiometricSyncWebServiceClient.AutoAttendanceEmployee(StrXML);
        }
        catch (Exception ex)
        {
            CommonHelper.LogWriter(ex.ToString(), 6, "Biometric Service", "AutoAttendanceEmployee");
            return -1;
        }
    }

    [WebMethod]
    public void BulkCopyDataSet(DataSet Ds)
    {
        try
        {
            // string DefaultDb = System.Configuration.ConfigurationManager.AppSettings["DefaultDatabase"];
            //  string connstr = System.Configuration.ConfigurationManager.ConnectionStrings[DefaultDb].ConnectionString;
            DatabaseSettings dbSettings = (DatabaseSettings)ConfigurationManager.GetSection("dataConfiguration");
            string connectionString = ConfigurationManager.ConnectionStrings[dbSettings.DefaultDatabase].ConnectionString;
            BiometricSyncWebServiceClient.BulkCopyDataSet(connectionString, Ds);
            CommonHelper.LogWriter("BulkCopyDataSet : TimeSheetSynced", 6, "Biometric Service", "BulkCopyDataSet");
        }
        catch (Exception ex)
        {
            CommonHelper.LogWriter(ex.ToString(), 6, "Biometric Service", "BulkCopyDataSet");            
        }
    }
    #endregion    
}