﻿<%@ WebService Language="C#" Class="OfflineSyncDataWebService" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using Sapphire.Vidyalaya.BusinessLogic.Business.InstituteManagement.SetupBL;
using Sapphire.Vidyalaya.BusinessLogic.Business.Library.LibraryBL;
using Sapphire.Vidyalaya.BusinessLogic.Business.Attendance.AttendanceBL;
using Sapphire.Ohu.BaseFramework.Utilities;
using Sapphire.Ohu.BusinessEntity.Framework.BaseFrameworkBE;
using System.Data;
using Sapphire.Ohu.BusinessEntity.Component.AlertBE;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
// [System.Web.Script.Services.ScriptService]
public class OfflineSyncDataWebService : WebService
{


    // vs command prompt wsdl http://localhost:5568/Services/OfflineSyncDataWebService.asmx?wsdl
    // browse the service and put /service before part of url in config file
    //string SyncServiceUrl = System.Configuration.ConfigurationManager.AppSettings["OfflineSyncServiceUrl"];
    ///// <remarks/>
    //public OfflineSyncDataWebService()
    //{
    //    this.Url = SyncServiceUrl + "/Services/OfflineSyncDataWebService.asmx";
    //}


    #region Service Client

    //Portal Synch Service
    private PortalSynchDataService PortalSynchDataServiceClient
    {
        get { return new PortalSynchDataService(); }
    }

    //Offline Synch Service
    private OfflineSynchDataService OfflineSynchDataServiceClient
    {
        get { return new OfflineSynchDataService(); }
    }


    private CommonFunctions CommonFunctionServiceClient
    {
        get { return new CommonFunctions(); }
    }

    #endregion
    //[WebMethod]
    //public string HelloWorld()
    //{
    //    return "Hello World";
    //}

    //#region Student Data Synch

    ////Student Synch

    //[WebMethod]
    //public DataSet PortalStudentMaxDateGet(int orgId, int divisionId, int batchId)
    //{
    //    return PortalSynchDataServiceClient.StudentMaxDateGet(orgId, divisionId, batchId);

    //}

    //[WebMethod]
    //public int PortalStudentDetailsUpdate(string strXMLStudentMaster, string strXMLStudentAcademic, string strXMLcommunication, string strXMLOther, string strXMLStudentImages, int DivisionId, int OrgGroupBatchId, int OrgGroupId)
    //{
    //    return PortalSynchDataServiceClient.PortalStudentDetailsUpdate(strXMLStudentMaster, strXMLStudentAcademic, strXMLcommunication, strXMLOther, strXMLStudentImages, DivisionId, OrgGroupBatchId, OrgGroupId);
    //}

    //#endregion

    //// ***** Master Data Synch *****

    //#region Master Synch

    //// * OrgGroupMaster *
    //[WebMethod]
    //public int PortalOrgGroupMasterUpdate(string strxml, int OrgGroupId)
    //{
    //    return PortalSynchDataServiceClient.PortalOrgGroupMasterUpdate(strxml, OrgGroupId);
    //}

    //// * OrgGroupBatchMaster *
    //[WebMethod]
    //public int PortalOrgGroupBatchMasterUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalOrgGroupBatchMasterUpdate(strxml, orgId);
    //}

    //// * OrganizationMaster *
    //[WebMethod]
    //public int PortalOrganizationMasterUpdate(string strXML, Int32 OrgId, Int32 OrgGroupId)
    //{
    //    return PortalSynchDataServiceClient.PortalOrganizationMasterUpdate(strXML, OrgId, OrgGroupId);
    //}

    //// * BatchMaster *
    //[WebMethod]
    //public int PortalBatchMasterUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalBatchMasterUpdate(strxml, orgId);
    //}

    //// * ClassMaster *
    //[WebMethod]
    //public int PortalClassMasterUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalClassMasterUpdate(strxml, orgId);
    //}

    //// * BatchClass *
    //[WebMethod]
    //public int PortalBatchClassUpdate(string strxml, int BatchId)
    //{
    //    return PortalSynchDataServiceClient.PortalBatchClassUpdate(strxml, BatchId);
    //}

    //// * DivisionMaster *
    //[WebMethod]
    //public int PortalDivisionMasterUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalDivisionMasterUpdate(strxml, orgId);
    //}

    //// * ClassSubject *
    //[WebMethod]
    //public int PortalClassSubjectUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalClassSubjectUpdate(strxml, orgId);
    //}

    //// * DepartmentMaster *
    //[WebMethod]
    //public int PortalDepartmentMasterUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalDepartmentMasterUpdate(strxml, orgId);
    //}

    //// * OrgMainGroupMaster *
    //[WebMethod]
    //public int PortalOrgMainGroupMasterUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalOrgMainGroupMasterUpdate(strxml, orgId);
    //}

    //// * OrgSubGroupMaster *
    //[WebMethod]
    //public int PortalOrgSubGroupMasterUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalOrgSubGroupMasterUpdate(strxml, orgId);
    //}

    //// * SubjectMaster *
    //[WebMethod]
    //public int PortalSubjectMasterUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalSubjectMasterUpdate(strxml, orgId);
    //}

    //// * TermMaster *
    //[WebMethod]
    //public int PortalTermMasterUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalTermMasterUpdate(strxml, orgId);
    //}

    //// * UserAccess *
    //[WebMethod]
    //public int PortalUserAccessAdd(string strxml, Int64 UserId)
    //{
    //    return PortalSynchDataServiceClient.PortalUserAccessAdd(strxml, UserId);
    //}

    //// * UserOrganization *
    //[WebMethod]
    //public int PortalUserOrganizationAdd(string strxml, Int64 UserId)
    //{
    //    return PortalSynchDataServiceClient.PortalUserOrganizationAdd(strxml, UserId);
    //}

    //// * EventTypeMaster *
    //[WebMethod]
    //public int PortalEventTypeMasterUpdate(string strxml)
    //{
    //    return PortalSynchDataServiceClient.PortalEventTypeMasterUpdate(strxml);
    //}

    //#endregion

    //// ***** EmployeeMaster Data Synch *****

    //#region Master Synch

    //[WebMethod]
    //public DataSet PortalEmployeeMaxDateGet(int OrgId, Int32 BatchId)
    //{
    //    return PortalSynchDataServiceClient.EmployeeMaxDateGet(OrgId, BatchId);
    //}

    //// * EmployeeMaster *
    //[WebMethod]
    //public int PortalEmployeeMasterUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalEmployeeMasterUpdate(strxml, orgId);
    //}

    //// * EmployeePersonalDetail *
    //[WebMethod]
    //public int PortalEmployeePersonalDetailUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalEmployeePersonalDetailUpdate(strxml, orgId);
    //}

    //// * EmployeeJobDetail *
    //[WebMethod]
    //public int PortalEmployeeJobDetailUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalEmployeeJobDetailUpdate(strxml, orgId);
    //}

    //// * EmployeeImages *
    //[WebMethod]
    //public int PortalEmployeeImagesUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalEmployeeImagesUpdate(strxml, orgId);
    //}

    //// * EmployeeGradeMaster *
    //[WebMethod]
    //public int PortalEmployeeGradeMasterUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalEmployeeGradeMasterUpdate(strxml, orgId);
    //}

    //// * EmployeeDesignationMaster *
    //[WebMethod]
    //public int PortalEmployeeDesignationMasterUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalEmployeeDesignationMasterUpdate(strxml, orgId);
    //}

    //// * EmployeeTypeMaster *
    //[WebMethod]
    //public int PortalEmployeeTypeMasterUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalEmployeeTypeMasterUpdate(strxml, orgId);
    //}

    //// * EmployeeCommunications *
    //[WebMethod]
    //public int PortalEmployeeCommunicationsUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalEmployeeCommunicationsUpdate(strxml, orgId);
    //}

    //#endregion

    //// * Presence Synch *
    //#region Presence Synch
    //[WebMethod]
    //public int PortalMonthlyRegisterUpdate(string StrXML, int DivisionId)
    //{
    //    return PortalSynchDataServiceClient.PortalMonthlyRegisterUpdate(StrXML, DivisionId);
    //}

    //[WebMethod]
    //public DataSet PortalAttendanceMaxDateGet(int OrgId, Int32 DivisionId, Int32 BatchId)
    //{
    //    return PortalSynchDataServiceClient.AttendanceMaxDateGet(OrgId, DivisionId, BatchId);
    //}

    //#endregion


    //#region Library Synch

    //// * Library Synch *
    //[WebMethod]
    //public int PortalUploadBookLogUpdate(string strxml, int orgId)
    //{
    //    return PortalSynchDataServiceClient.PortalUploadBookLogUpdate(strxml, orgId);
    //}

    //#endregion

    //#region Result Synch

    //// * Result Synch *
    //[WebMethod]
    //public Int32 PortalViewResultAdd(string strXML, Int32 BatchId, Int32 ClassId, Int32 DivisionId, Int16 ExamTypeId, Int32 ExamId)
    //{
    //    return PortalSynchDataServiceClient.PortalViewResultAdd(strXML, BatchId, ClassId, DivisionId, ExamTypeId, ExamId);
    //}

    //[WebMethod]
    //public Int32 PortalViewResultDetailAdd(string strXML, Int32 BatchId, Int32 ClassId, Int32 DivisionId, Int16 ExamTypeId, Int32 ExamId)
    //{
    //    return PortalSynchDataServiceClient.PortalViewResultDetailAdd(strXML, BatchId, ClassId, DivisionId, ExamTypeId, ExamId);
    //}

    //#endregion

    //// * Daily Presence Synch *
    //#region Daily Presence Synch
    //[WebMethod]
    //public int PortalDailyPresenceAdd(string strXML, Int32 OrgId, Int32 DivisionId, Int32 BatchId, Int32 ClassId, Int16 AttendanceTypeId, DateTime FromDate, DateTime ToDate, Int32 SubjectId, bool IsAlertOnAutoSyncAttendanceWithPortal)
    //{
    //    int Result = PortalSynchDataServiceClient.PortalDailyPresenceAdd(strXML, OrgId, DivisionId);

    //    if (Result == 1 && IsAlertOnAutoSyncAttendanceWithPortal == true)
    //    {
    //        DataSet Ds = new DataSet();
    //        Ds = CommonFunctionServiceClient.GetDataset("SELECT EventId FROM sAlert.tEventTemplate WHERE IsAutoSend = 1 AND OrgId =" + OrgId + " AND ( EventId = 13 OR EventId = 26)");
    //        if (Ds != null && Ds.Tables.Count > 0 && Ds.Tables[0].Rows.Count > 0)
    //        {
    //            SMSHelper SMSHelperObject = new SMSHelper();
    //            SMSPredefine Data = new SMSPredefine();
    //            Data.ScriptType = "StoredProcedure";
    //            Data.BatchId = BatchId;
    //            Data.OrgId = OrgId;
    //            Data.ClassId = ClassId;
    //            Data.DivisionId = DivisionId;
    //            Data.AttendanceTypeId = AttendanceTypeId;
    //            Data.FromDate = FromDate;
    //            Data.ToDate = ToDate;
    //            Data.SubjectId = SubjectId;
    //            Data.SourceEvent = "Transactional";

    //            Data.IsPresent = false;
    //            Data.IsMobileNotification = true;
    //            SMSHelperObject.SendAlert(13, Data, OrgId); //Absent Student

    //            Data.IsPresent = true;
    //            Data.IsMobileNotification = true;
    //            SMSHelperObject.SendAlert(26, Data, OrgId); //Present Student
    //        }
    //    }
    //    return Result;
    //}
    //#endregion

    //// * Configuration Setting Synch *
    //#region Configuration Setting Synch
    //[WebMethod]
    //public int PortalConfigurationSetupAdd(string strXML, Int32 OrgId)
    //{
    //    return PortalSynchDataServiceClient.PortalConfigurationSetupAdd(strXML, OrgId);
    //}

    //[WebMethod]
    //public int PortalEmailConfigurationAdd(string strXML, Int32 OrgId)
    //{
    //    return PortalSynchDataServiceClient.PortalEmailConfigurationAdd(strXML, OrgId);
    //}

    //[WebMethod]
    //public int PortalSMSConfigurationAdd(string strXML, Int32 OrgId)
    //{
    //    return PortalSynchDataServiceClient.PortalSMSConfigurationAdd(strXML, OrgId);
    //}
    //#endregion

    //#region Event Synch

    //// * Event Attendances Synch *
    //[WebMethod]
    //public int PortalEventAttendancesUpdate(string strxml, int BatchId)
    //{
    //    return PortalSynchDataServiceClient.PortalEventAttendancesUpdate(strxml, BatchId);
    //}

    //// * Event Assign Synch *
    //[WebMethod]
    //public int PortalEventAssignUpdate(string strxml, int BatchId)
    //{
    //    return PortalSynchDataServiceClient.PortalEventAssignUpdate(strxml, BatchId);
    //}

    //// * Event Schedule Synch *
    //[WebMethod]
    //public int PortalEventScheduleUpdate(string strxml, int BatchId)
    //{
    //    return PortalSynchDataServiceClient.PortalEventScheduleUpdate(strxml, BatchId);
    //}

    //#endregion

    //#region Event Sync

    //// * Teacher Subject *
    //[WebMethod]
    //public int PortalTeacherSubjectUpdate(string strxml, int OrgId)
    //{
    //    return PortalSynchDataServiceClient.PortalTeacherSubjectUpdate(strxml, OrgId);
    //}

    //// * Teacher Subject Division *
    //[WebMethod]
    //public int PortalTeacherSubjectDivisionUpdate(string strxml, int OrgId)
    //{
    //    return PortalSynchDataServiceClient.PortalTeacherSubjectDivisionUpdate(strxml, OrgId);
    //}

    //#endregion

    //[WebMethod]
    //public string CheckNetVidyalayaPortalInConfigFile()
    //{
    //    return PortalSynchDataServiceClient.CheckNetVidyalayaPortalInConfigFile();
    //}

    //[WebMethod]
    //public int PortalFeeCollectionGroupUpdate(string strxml, int OrgGroupBatchId)
    //{
    //    return PortalSynchDataServiceClient.PortalFeeCollectionGroupUpdate(strxml, OrgGroupBatchId);
    //}

    //[WebMethod]
    //public int PortalExemptionTypeDetailUpdate(string strxml)
    //{
    //    return PortalSynchDataServiceClient.PortalExemptionTypeDetailUpdate(strxml);
    //}

    //[WebMethod]
    //public int PortalExemptionTypeMasterUpdate(string strxml, Int16 OrgGroupId)
    //{
    //    return PortalSynchDataServiceClient.PortalExemptionTypeMasterUpdate(strxml, OrgGroupId);
    //}

    //[WebMethod]
    //public int ReceiptBookOrgwiseUpdate(string strxml, Int16 OrgId)
    //{
    //    return PortalSynchDataServiceClient.ReceiptBookOrgwiseUpdate(strxml, OrgId);
    //}


    //[WebMethod]
    //public int PortalReceiptBookMasterUpdate(string strxml, Int16 OrgGroupId)
    //{
    //    return PortalSynchDataServiceClient.PortalReceiptBookMasterUpdate(strxml, OrgGroupId);
    //}

    //[WebMethod]
    //public int PortalReceiptUpdate(string strxml, Int32 DivisionId)
    //{
    //    return PortalSynchDataServiceClient.PortalReceiptUpdate(strxml, DivisionId);
    //}

    //[WebMethod]
    //public int PortalReceiptDelete(string ReceiptId)
    //{
    //    return PortalSynchDataServiceClient.PortalReceiptDelete(ReceiptId);
    //}

    //[WebMethod]
    //public int PortalReceiptDetailUpdate(string strxml, Int32 DivisionId)
    //{
    //    return PortalSynchDataServiceClient.PortalReceiptDetailUpdate(strxml, DivisionId);
    //}
    //[WebMethod]
    //public int PortalReceiptDetailDelete(string ReceiptId)
    //{
    //    return PortalSynchDataServiceClient.PortalReceiptDetailDelete(ReceiptId);
    //}


    //[WebMethod]
    //public int PortalFeeAllocationUpdate(string strxml, Int32 BatchId, Int32 DivisionId)
    //{
    //    return PortalSynchDataServiceClient.PortalFeeAllocationUpdate(strxml, BatchId, DivisionId);
    //}

    //[WebMethod]
    //public int PortalFeeDiscountUpdate(string strxml)
    //{
    //    return PortalSynchDataServiceClient.PortalFeeDiscountUpdate(strxml);
    //}

    //[WebMethod]
    //public int PortalFeeOptionalUpdate(string strxml, Int32 BatchId, Int32 DivisionId)
    //{
    //    return PortalSynchDataServiceClient.PortalFeeOptionalUpdate(strxml, BatchId, DivisionId);
    //}


    //[WebMethod]
    //public int PortalHeadMasterUpdate(string strxml, Int16 OrgGroupId)
    //{
    //    return PortalSynchDataServiceClient.PortalHeadMasterUpdate(strxml, OrgGroupId);
    //}

    //[WebMethod]
    //public int PortalHeadOrgwiseUpdate(string strxml, Int16 OrgId)
    //{
    //    return PortalSynchDataServiceClient.PortalHeadOrgwiseUpdate(strxml, OrgId);
    //}

    //[WebMethod]
    //public int PortalMainGroupMasterUpdate(string strxml)
    //{
    //    return PortalSynchDataServiceClient.PortalMainGroupMasterUpdate(strxml);
    //}

    //[WebMethod]
    //public int PortalMainGroupOrgGroupwise(string strxml, Int32 OrgId)
    //{
    //    return PortalSynchDataServiceClient.PortalMainGroupOrgGroupwise(strxml, OrgId);
    //}

    //[WebMethod]
    //public int PortalMainGroupOptionalFee(string strxml, Int32 OrgId)
    //{
    //    return PortalSynchDataServiceClient.PortalMainGroupOptionalFee(strxml, OrgId);
    //}

    //[WebMethod]
    //public int PortalFeeMaster(string strxml, Int16 OrgGroupId)
    //{
    //    return PortalSynchDataServiceClient.PortalFeeMaster(strxml, OrgGroupId);
    //}
    //[WebMethod]
    //public int PortalFeeSetup(string strxml, Int32 BatchId)
    //{
    //    return PortalSynchDataServiceClient.PortalFeeSetup(strxml, BatchId);
    //}


    //#region Master Synch

    //// * TransportMaster *
    //[WebMethod]
    //public int PortalTransportMasterUpdate(string strxml)
    //{
    //    return PortalSynchDataServiceClient.PortalTransportMasterUpdate(strxml);
    //}

    //// * BusRouteMaster *
    //[WebMethod]
    //public int PortalBusRouteMasterUpdate(string strxml)
    //{
    //    return PortalSynchDataServiceClient.PortalBusRouteMasterUpdate(strxml);
    //}

    //// * BusRouteDestinationMaster *
    //[WebMethod]
    //public int PortalBusRouteDestinationMasterUpdate(string strxml)
    //{
    //    return PortalSynchDataServiceClient.PortalBusRouteDestinationMasterUpdate(strxml);
    //}

    //// * FuelTypeMaster *
    //[WebMethod]
    //public int PortalFuelTypeMasterUpdate(string strxml)
    //{
    //    return PortalSynchDataServiceClient.PortalFuelTypeMasterUpdate(strxml);
    //}

    //// * VehicleTypeMaster *
    //[WebMethod]
    //public int PortalVehicleTypeMasterUpdate(string strxml)
    //{
    //    return PortalSynchDataServiceClient.PortalVehicleTypeMasterUpdate(strxml);
    //}

    //// * VehicleMaster *
    //[WebMethod]
    //public int PortalVehicleMasterUpdate(string strxml)
    //{
    //    return PortalSynchDataServiceClient.PortalVehicleMasterUpdate(strxml);
    //}


    //#endregion

    //#region Assign Route

    //// * AssignRoute *
    //[WebMethod]
    //public int PortalAssignRouteUpdate(string strxml, int OrgGroupBatchId)
    //{
    //    return PortalSynchDataServiceClient.PortalAssignRouteUpdate(strxml, OrgGroupBatchId);
    //}


    //#endregion

    //#region Assign Transport Org

    //// * AssignRoute *
    //[WebMethod]
    //public int PortalAssignTransportOrgUpdate(string strxml, int TransportId, int OrgId)
    //{
    //    return PortalSynchDataServiceClient.PortalAssignTransportOrgUpdate(strxml, TransportId, OrgId);
    //}


    //#endregion

    #region Master Sync

    // * OrgGroupMaster *
    [WebMethod]
    public DataSet OnlineOrgGroupMasterGet(Int32 OrgGroupId)
    {
        string SQLString = "Select * FROM sSetup.tOrgGroupMaster WHERE Id =" + OrgGroupId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    // * OrgGroupBatchMaster *
    [WebMethod]
    public DataSet OnlineOrgGroupBatchMasterGet(Int32 OrgGroupId)
    {
        string SQLString = "Select * FROM sSetup.tOrgGroupBatchMaster WHERE OrgGroupId =" + OrgGroupId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    // * OrganizationMaster *
    [WebMethod]
    public DataSet OnlineOrganizationMasterGet(Int32 OrgGroupId)
    {
        string SQLString = "Select * FROM sSetup.tOrganizationMaster WHERE OrgGroupId =" + OrgGroupId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    // * BatchMaster *
    [WebMethod]
    public DataSet OnlineBatchMasterGet(int OrgGroupId)
    {
        string SQLString = "Select BM.* FROM sSetup.tBatchMaster BM INNER JOIN sSetup.tOrganizationMaster OM ON BM.OrgId = OM.Id WHERE OM.OrgGroupId=" + OrgGroupId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    // * ClassMaster *
    [WebMethod]
    public DataSet OnlineClassMasterGet(int OrgGroupId)
    {
        string SQLString = "Select CM.* FROM sSetup.tClassMaster CM INNER JOIN sSetup.tOrganizationMaster OM ON CM.OrgId = OM.Id WHERE OM.OrgGroupId=" + OrgGroupId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    // * BatchClass *
    [WebMethod]
    public DataSet OnlineBatchClassGet(int OrgGroupId)
    {
        string SQLString = "SELECT BC.* FROM sSetup.tBatchClass BC INNER JOIN sSetup.tBatchMaster BM ON BC.BatchId = BM.Id INNER JOIN sSetup.tOrganizationMaster OM ON OM.Id  = BM.OrgId WHERE OM.OrgGroupId=" + OrgGroupId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    // * DivisionMaster *
    [WebMethod]
    public DataSet OnlineDivisionMasterGet(int OrgGroupId)
    {
        string SQLString = "SELECT DM.* FROM sSetup.tDivisionMaster DM INNER JOIN sSetup.tOrganizationMaster OM ON DM.OrgId = OM.Id WHERE OM.OrgGroupId =" + OrgGroupId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    // * ClassSubject *
    [WebMethod]
    public DataSet OnlineClassSubjectGet(int OrgGroupId)
    {
        string SQLString = "SELECT CS.* FROM  sSetup.tClassSubject CS INNER JOIN sSetup.tOrganizationMaster OM ON CS.OrgId = OM.Id WHERE OM.OrgGroupId = " + OrgGroupId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    // * DepartmentMaster *
    [WebMethod]
    public DataSet OnlineDepartmentMasterGet(int OrgGroupId)
    {
        string SQLString = "SELECT DM.* FROM  sSetup.tDepartmentMaster DM INNER JOIN sSetup.tOrganizationMaster OM ON DM.OrgId = OM.Id WHERE OM.OrgGroupId =" + OrgGroupId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    // * OrgMainGroupMaster *
    [WebMethod]
    public DataSet OnlineOrgMainGroupMasterGet(int OrgGroupId)
    {
        string SQLString = "Select * FROM sSetup.tOrgMainGroupMaster WHERE OrgGroupId =" + OrgGroupId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    // * OrgSubGroupMaster *
    [WebMethod]
    public DataSet OnlineOrgSubGroupMasterGet(int OrgGroupId)
    {
        string SQLString = "Select * FROM sSetup.tOrgSubGroupMaster WHERE OrgGroupId =" + OrgGroupId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    // * SubjectMaster *
    [WebMethod]
    public DataSet OnlineSubjectMasterGet(int OrgGroupId)
    {
        string SQLString = "SELECT SM.* FROM  sSetup.tSubjectMaster SM INNER JOIN sSetup.tOrganizationMaster OM ON SM.OrgId = OM.Id WHERE OM.OrgGroupId =" + OrgGroupId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    // * TermMaster *
    [WebMethod]
    public DataSet OnlineTermMasterGet(int OrgGroupId)
    {
        string SQLString = "SELECT TM.* FROM  sSetup.tTermMaster TM INNER JOIN sSetup.tOrganizationMaster OM ON TM.OrgId = OM.Id WHERE OM.OrgGroupId =" + OrgGroupId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    // * UserAccess *
    [WebMethod]
    public DataSet OnlineUserAccessGet(Int64 UserId)
    {
        string SQLString = "Select * FROM sSecurity.tUserAccess WHERE UserId =" + UserId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    // * UserOrganization *
    [WebMethod]
    public DataSet OnlineUserOrganizationGet(Int64 UserId)
    {
        string SQLString = "Select * FROM sSecurity.tUserOrganization WHERE UserId =" + UserId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    // * EventTypeMaster *
    [WebMethod]
    public DataSet OnlineEventTypeMasterGet(int OrgGroupId)
    {
        string SQLString = "Select * FROM sActivity.tEventTypeMaster WHERE OrgGroupId =" + OrgGroupId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    #endregion

    // * Configuration Setting Synch *
    #region Configuration Setting Synch
    [WebMethod]
    public DataSet OnlineConfigurationSetupGet()
    {
        string SQLString = "SELECT * FROM sConfig.tConfigurationSetup";
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    [WebMethod]
    public DataSet OnlineEmailConfigurationGet(Int32 OrgId)
    {
        string SQLString = "SELECT * FROM sAlert.tSMSConfiguration WHERE OrgId=" + OrgId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }

    [WebMethod]
    public DataSet OnlineSMSConfigurationGet(Int32 OrgId)
    {
        string SQLString = "SELECT * FROM sAlert.tEmailConfiguration WHERE OrgId=" + OrgId;
        DataSet MasterDs = CommonFunctionServiceClient.GetDataset(SQLString);
        return MasterDs;
    }
    #endregion

    #region Student Data Synch
    [WebMethod]
    public DataSet OnlineStudentListGet(Int32 DivisionId, Int32 BatchId, Int32 OrgId, DateTime CreatedDateTime, DateTime UpdatedDateTime, Int64 StudentMaxId)
    {
        return OfflineSynchDataServiceClient.OnlineStudentListGet(DivisionId, BatchId, OrgId, CreatedDateTime, UpdatedDateTime, StudentMaxId);
    }

    [WebMethod]
    public DataSet OnlineAcademicListGet(Int32 DivisionId, Int32 BatchId, Int32 OrgId, DateTime CreatedDateTime, DateTime UpdatedDateTime, Int64 StudentMaxId)
    {
        return OfflineSynchDataServiceClient.OnlineAcademicListGet(DivisionId, BatchId, OrgId, CreatedDateTime, UpdatedDateTime, StudentMaxId);
    }

    [WebMethod]
    public DataSet OnlineStudentCommunicationListGet(Int32 DivisionId, Int32 BatchId, Int32 OrgId, DateTime CreatedDateTime, DateTime UpdatedDateTime, Int64 StudentMaxId)
    {
        return OfflineSynchDataServiceClient.OnlineStudentCommunicationListGet(DivisionId, BatchId, OrgId, CreatedDateTime, UpdatedDateTime, StudentMaxId);
    }

    [WebMethod]
    public DataSet OnlineOtherListGet(Int32 DivisionId, Int32 BatchId, Int32 OrgId, DateTime CreatedDateTime, DateTime UpdatedDateTime, Int64 StudentMaxId)
    {
        return OfflineSynchDataServiceClient.OnlineOtherListGet(DivisionId, BatchId, OrgId, CreatedDateTime, UpdatedDateTime, StudentMaxId);
    }

    [WebMethod]
    public DataSet OnlineStudentImagesListGet(Int32 DivisionId, Int32 BatchId, Int32 OrgId, DateTime CreatedDateTime, DateTime UpdatedDateTime, Int64 StudentMaxId)
    {
        return OfflineSynchDataServiceClient.OnlineStudentImagesListGet(DivisionId, BatchId, OrgId, CreatedDateTime, UpdatedDateTime, StudentMaxId);
    }
    #endregion

    #region Emplotee Data Synch

    // * EmployeeGradeMaster *
    [WebMethod]
    public DataSet OnlineEmployeeGradeMasterGet(int OrgId, DateTime CreatedDate, DateTime UpdatedDateTime)
    {
        string SQLString = "Select * FROM sHrm.tEmployeeGradeMaster WHERE OrgId =" + OrgId + " AND (CreatedDateTime > '" + CreatedDate.ToString("yyyy/MM/dd HH:mm:ss") + "') OR (UpdatedDateTime > '" + UpdatedDateTime.ToString("yyyy/MM/dd HH:mm:ss") + "')";
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * EmployeeDesignationMaster *
    [WebMethod]
    public DataSet OnlineEmployeeDesignationMasterGet(int OrgId, DateTime CreatedDate, DateTime UpdatedDateTime)
    {
        string SQLString = "Select * FROM sHrm.tEmployeeDesignationMaster WHERE OrgId =" + OrgId + " AND (CreatedDateTime > '" + CreatedDate.ToString("yyyy/MM/dd HH:mm:ss") + "') OR (UpdatedDateTime > '" + UpdatedDateTime.ToString("yyyy/MM/dd HH:mm:ss") + "')";
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * EmployeeTypeMaster *
    [WebMethod]
    public DataSet OnlineEmployeeTypeMasterGet(int OrgId, DateTime CreatedDate, DateTime UpdatedDateTime)
    {
        string SQLString = "Select * FROM sHrm.tEmployeeTypeMaster WHERE OrgId =" + OrgId + " AND (CreatedDateTime > '" + CreatedDate.ToString("yyyy/MM/dd HH:mm:ss") + "') OR (UpdatedDateTime > '" + UpdatedDateTime.ToString("yyyy/MM/dd HH:mm:ss") + "')";
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * EmployeeMaster *
    [WebMethod]
    public DataSet OnlineEmployeeMasterGet(int OrgId, DateTime CreatedDate, DateTime UpdatedDateTime)
    {
        string SQLString = "Select * FROM sHrm.tEmployeeMaster WHERE OrgID = " + OrgId + " AND  ISNULL(IsOtherUser,0) = 0 AND (CreatedDateTime > '" + CreatedDate.ToString("yyyy/MM/dd HH:mm:ss") + "') OR (UpdatedDateTime > '" + UpdatedDateTime.ToString("yyyy/MM/dd HH:mm:ss") + "')";
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * EmployeePersonalDetail *
    [WebMethod]
    public DataSet OnlineEmployeePersonalDetailGet(int OrgId, DateTime UpdatedDateTime)
    {
        string SQLString = "Select * FROM sHrm.tEmployeePersonalDetail WHERE OrgId =" + OrgId + " AND (UpdatedDateTime > '" + UpdatedDateTime.ToString("yyyy/MM/dd HH:mm:ss") + "')";
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * EmployeeJobDetail *
    [WebMethod]
    public DataSet OnlineEmployeeJobDetailGet(int OrgId, DateTime UpdatedDateTime)
    {
        string SQLString = "Select * FROM sHrm.tEmployeeJobDetail WHERE OrgId =" + OrgId + " AND (UpdatedDateTime > '" + UpdatedDateTime.ToString("yyyy/MM/dd HH:mm:ss") + "')";
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * EmployeeCommunications *
    [WebMethod]
    public DataSet OnlineEmployeeCommunicationsGet(int OrgId, DateTime UpdatedDateTime)
    {
        string SQLString = "Select EC.* FROM sHrm.tEmployeeCommunications EC INNER JOIN sHrm.tEmployeeMaster EM ON EM.Id = EC.EmployeeId WHERE EM.OrgId =" + OrgId + " AND  ISNULL(EM.IsOtherUser,0) = 0 AND (EC.UpdatedDateTime > '" + UpdatedDateTime.ToString("yyyy/MM/dd HH:mm:ss") + "')";
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * EmployeeImages *
    [WebMethod]
    public DataSet OnlineEmployeeImagesGet(int OrgId, DateTime UpdatedDateTime)
    {
        string SQLString = "Select EI.EmployeeId,EI.EmployeePhoto,EI.UpdatedDateTime FROM sHrm.tEmployeeImages EI INNER JOIN sHrm.tEmployeeMaster EM ON EM.Id = EI.EmployeeId WHERE EM.OrgId =" + OrgId + " AND  ISNULL(EM.IsOtherUser,0) = 0 AND ((ISNULL(EI.UpdatedDateTime,'1900/01/02 00:00:00') > '" + UpdatedDateTime.ToString("yyyy/MM/dd HH:mm:ss") + "'))";
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    #endregion


    #region Fee Data Sync

    // * CollectionGroupMaster *
    [WebMethod]
    public DataSet OnlineCollectionGroupMasterGet(int OrgGroupBatchId)
    {
        string SQLString = "SELECT * FROM sFee.tCollectionGroupMaster WHERE OrgGroupBatchId=" + OrgGroupBatchId;
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * ExemptionTypeDetail *
    [WebMethod]
    public DataSet OnlineExemptionTypeDetailGet(int OrgGroupId)
    {
        string SQLString = "SELECT * FROM sFee.tExemptionTypeDetail Ed INNER JOIN sFee.tExemptionTypeMaster EM On Em.Id=ED.ExemptionTypeId Where Em.OrgGroupId=" + OrgGroupId;
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * ExemptionTypeMaster *
    [WebMethod]
    public DataSet OnlineExemptionTypeMasterGet(int OrgGroupId)
    {
        string SQLString = "SELECT * FROM sFee.tExemptionTypeMaster WHERE  OrgGroupId=" + OrgGroupId;
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * ReceiptBookOrgwise *
    [WebMethod]
    public DataSet OnlineReceiptBookOrgwiseGet(int OrgId)
    {
        string SQLString = "SELECT * FROM sFee.tReceiptBookOrgwise WHERE  OrgId=" + OrgId;
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * ReceiptBookMaster *
    [WebMethod]
    public DataSet OnlineReceiptBookMasterGet(int OrgGroupId)
    {
        string SQLString = "SELECT * FROM sFee.tReceiptBookMaster WHERE  OrgGroupId=" + OrgGroupId;
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * FeeHeadOrgwise *
    [WebMethod]
    public DataSet OnlineFeeHeadOrgwiseGet(int OrgId)
    {
        string SQLString = "SELECT * FROM sFee.tFeeHeadOrgwise WHERE  OrgId=" + OrgId;
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * FeeMainGroupOptionalFee *
    [WebMethod]
    public DataSet OnlineFeeMainGroupOptionalFeeGet(int OrgId)
    {
        string SQLString = "SELECT * FROM  sFee.tFeeMainGroupOptionalFee where OrgId=" + OrgId;
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * FeeMainGroupOrgGroupwise *
    [WebMethod]
    public DataSet OnlineFeeMainGroupOrgGroupwiseGet(int OrgGroupId)
    {
        string SQLString = "SELECT * FROM sFee.tFeeMainGroupOrgGroupwise where OrgGroupId=" + OrgGroupId;
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * FeeMainGroupMaster *
    [WebMethod]
    public DataSet OnlineFeeMainGroupMasterGet()
    {
        string SQLString = "SELECT * FROM sFee.tFeeMainGroupMaster";
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * FeeSetup *
    [WebMethod]
    public DataSet OnlineFeeSetupGet(int BatchId)
    {
        string SQLString = "SELECT * FROM sFee.tFeeSetup WHERE BatchId=" + BatchId;
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * FeeMaster *
    [WebMethod]
    public DataSet OnlineFeeMasterGet(int OrgGroupId)
    {
        string SQLString = "SELECT * FROM sFee.tFeeMaster WHERE OrgGroupId=" + OrgGroupId;
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * FeeMaster *
    [WebMethod]
    public DataSet OnlineFeeHeadMasterGet(int OrgGroupId)
    {
        string SQLString = "SELECT * FROM sFee.tFeeHeadMaster WHERE  OrgGroupId=" + OrgGroupId;
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }


    // * FeeAllocation *
    [WebMethod]
    public DataSet OnlineFeeAllocationGet(int BatchId)
    {
        string SQLString = "SELECT * FROM sFee.tFeeAllocation RT INNER JOIN sFee.tFeeSetup RE ON Re.Id =RT.FeeSetupId WHERE  RE.BatchId=" + BatchId;
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * FeeOptional *
    [WebMethod]
    public DataSet OnlineFeeOptionalGet(int BatchId)
    {
        string SQLString = "SELECT * FROM sFee.tFeeOptional WHERE BatchId=" + BatchId;
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * ReceiptDeleted *
    [WebMethod]
    public DataSet OnlineReceiptDeletedGet(int OrgGroupBatchId, int BatchId)
    {
        string SQLString = "SELECT Id FROM sFee.tReceiptDeleted WHERE  OrgGroupBatchId=" + OrgGroupBatchId + " AND BatchId=" + BatchId;
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * Receipt *
    [WebMethod]
    public DataSet OnlineReceiptGet(int OrgGroupBatchId, int BatchId)
    {
        string SQLString = "SELECT * FROM sFee.tReceipt WHERE  OrgGroupBatchId=" + OrgGroupBatchId + " AND BatchId=" + BatchId
                        + "  AND (Select max(convert(date,CreatedDateTime)) from sFee.tReceipt WHERE  OrgGroupBatchId=" + OrgGroupBatchId + " AND BatchId=" + BatchId + ")<='" + DateTime.Now.ToString("yyyy-MM-dd") + "'";
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * ReceiptDetailDeleted *
    [WebMethod]
    public DataSet OnlineReceiptDetailDeletedGet(int OrgGroupBatchId, int BatchId)
    {
        string SQLString = "Select ReceiptId,FeeSetupId from sFee.tReceiptDetailDeleted RT INNER JOIN sFee.tReceiptDeleted RE ON Re.Id =RT.ReceiptId Where RE.OrgGroupBatchId=" + OrgGroupBatchId + " AND RE.BatchId=" + BatchId;
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    // * ReceiptDetail *
    [WebMethod]
    public DataSet OnlineReceiptDetailGet(int OrgGroupBatchId, int BatchId)
    {
        string SQLString = "Select * from sFee.tReceiptDetail RT INNER JOIN sFee.tReceipt RE ON Re.Id =RT.ReceiptId Where RE.OrgGroupBatchId=" + OrgGroupBatchId + " AND RE.BatchId=" + BatchId;
        DataSet DS = CommonFunctionServiceClient.GetDataset(SQLString);
        return DS;
    }

    #endregion
}
