﻿<%@ WebService Language="C#" Class="PortalSyncWebService" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using Sapphire.Vidyalaya.BusinessLogic.Business.InstituteManagement.SetupBL;
using Sapphire.Vidyalaya.BusinessLogic.Business.Library.LibraryBL;
using Sapphire.Vidyalaya.BusinessLogic.Business.Attendance.AttendanceBL;
using Sapphire.Ohu.BaseFramework.Utilities;
using Sapphire.Ohu.BusinessEntity.Framework.BaseFrameworkBE;
using System.Data;
using Sapphire.Ohu.BusinessEntity.Component.AlertBE;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
// [System.Web.Script.Services.ScriptService]
public class PortalSyncWebService : System.Web.Services.WebService
{


    // vs command prompt wsdl http://localhost:5568/Services/PortalSyncWebService.asmx?wsdl
    // browse the service and put /service before part of url in config file
    //string SyncServiceUrl = System.Configuration.ConfigurationManager.AppSettings["SyncServiceUrl"];
    ///// <remarks/>
    //public PortalSyncWebService()
    //{
    //    this.Url = SyncServiceUrl + "/Services/PortalSyncWebService.asmx";
    //}


    #region Service Client

    //Portal Synch Service
    private PortalSynchDataService PortalSynchDataServiceClient
    {
        get { return new PortalSynchDataService(); }
    }

    private CommonFunctions CommonFunctionServiceClient
    {
        get { return new CommonFunctions(); }
    }

    #endregion
    [WebMethod]
    public string HelloWorld()
    {
        return "Hello World";
    }

    #region Student Data Synch

    //Student Synch

    [WebMethod]
    public DataSet PortalStudentMaxDateGet(int orgId, int divisionId, int batchId)
    {
        return PortalSynchDataServiceClient.StudentMaxDateGet(orgId, divisionId, batchId);

    }

    [WebMethod]
    public int PortalStudentDetailsUpdate(string strXMLStudentMaster, string strXMLStudentAcademic, string strXMLcommunication, string strXMLOther, string strXMLStudentImages, int DivisionId, int OrgGroupBatchId, int OrgGroupId)
    {
        return PortalSynchDataServiceClient.PortalStudentDetailsUpdate(strXMLStudentMaster, strXMLStudentAcademic, strXMLcommunication, strXMLOther, strXMLStudentImages, DivisionId, OrgGroupBatchId, OrgGroupId);
    }

    #endregion

    // ***** Master Data Synch *****

    #region Master Synch

    // * OrgGroupMaster *
    [WebMethod]
    public int PortalOrgGroupMasterUpdate(string strxml, int OrgGroupId)
    {
        return PortalSynchDataServiceClient.PortalOrgGroupMasterUpdate(strxml, OrgGroupId);
    }

    // * OrgGroupBatchMaster *
    [WebMethod]
    public int PortalOrgGroupBatchMasterUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalOrgGroupBatchMasterUpdate(strxml, orgId);
    }

    // * OrganizationMaster *
    [WebMethod]
    public int PortalOrganizationMasterUpdate(string strXML, Int32 OrgId, Int32 OrgGroupId)
    {
        return PortalSynchDataServiceClient.PortalOrganizationMasterUpdate(strXML, OrgId, OrgGroupId);
    }

    // * BatchMaster *
    [WebMethod]
    public int PortalBatchMasterUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalBatchMasterUpdate(strxml, orgId);
    }

    // * ClassMaster *
    [WebMethod]
    public int PortalClassMasterUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalClassMasterUpdate(strxml, orgId);
    }

    // * BatchClass *
    [WebMethod]
    public int PortalBatchClassUpdate(string strxml, int BatchId)
    {
        return PortalSynchDataServiceClient.PortalBatchClassUpdate(strxml, BatchId);
    }

    // * DivisionMaster *
    [WebMethod]
    public int PortalDivisionMasterUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalDivisionMasterUpdate(strxml, orgId);
    }

    // * ClassSubject *
    [WebMethod]
    public int PortalClassSubjectUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalClassSubjectUpdate(strxml, orgId);
    }

    // * DepartmentMaster *
    [WebMethod]
    public int PortalDepartmentMasterUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalDepartmentMasterUpdate(strxml, orgId);
    }

    // * OrgMainGroupMaster *
    [WebMethod]
    public int PortalOrgMainGroupMasterUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalOrgMainGroupMasterUpdate(strxml, orgId);
    }

    // * OrgSubGroupMaster *
    [WebMethod]
    public int PortalOrgSubGroupMasterUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalOrgSubGroupMasterUpdate(strxml, orgId);
    }

    // * SubjectMaster *
    [WebMethod]
    public int PortalSubjectMasterUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalSubjectMasterUpdate(strxml, orgId);
    }

    // * TermMaster *
    [WebMethod]
    public int PortalTermMasterUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalTermMasterUpdate(strxml, orgId);
    }

    // * UserAccess *
    [WebMethod]
    public int PortalUserAccessAdd(string strxml, Int64 UserId)
    {
        return PortalSynchDataServiceClient.PortalUserAccessAdd(strxml, UserId);
    }

    // * UserOrganization *
    [WebMethod]
    public int PortalUserOrganizationAdd(string strxml, Int64 UserId)
    {
        return PortalSynchDataServiceClient.PortalUserOrganizationAdd(strxml, UserId);
    }

    // * EventTypeMaster *
    [WebMethod]
    public int PortalEventTypeMasterUpdate(string strxml)
    {
        return PortalSynchDataServiceClient.PortalEventTypeMasterUpdate(strxml);
    }

    #endregion

    // ***** EmployeeMaster Data Synch *****

    #region Master Synch

    [WebMethod]
    public DataSet PortalEmployeeMaxDateGet(int OrgId, Int32 BatchId)
    {
        return PortalSynchDataServiceClient.EmployeeMaxDateGet(OrgId, BatchId);
    }

    // * EmployeeMaster *
    [WebMethod]
    public int PortalEmployeeMasterUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalEmployeeMasterUpdate(strxml, orgId);
    }

    // * EmployeePersonalDetail *
    [WebMethod]
    public int PortalEmployeePersonalDetailUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalEmployeePersonalDetailUpdate(strxml, orgId);
    }

    // * EmployeeJobDetail *
    [WebMethod]
    public int PortalEmployeeJobDetailUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalEmployeeJobDetailUpdate(strxml, orgId);
    }

    // * EmployeeImages *
    [WebMethod]
    public int PortalEmployeeImagesUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalEmployeeImagesUpdate(strxml, orgId);
    }

    // * EmployeeGradeMaster *
    [WebMethod]
    public int PortalEmployeeGradeMasterUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalEmployeeGradeMasterUpdate(strxml, orgId);
    }

    // * EmployeeDesignationMaster *
    [WebMethod]
    public int PortalEmployeeDesignationMasterUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalEmployeeDesignationMasterUpdate(strxml, orgId);
    }

    // * EmployeeTypeMaster *
    [WebMethod]
    public int PortalEmployeeTypeMasterUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalEmployeeTypeMasterUpdate(strxml, orgId);
    }

    // * EmployeeCommunications *
    [WebMethod]
    public int PortalEmployeeCommunicationsUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalEmployeeCommunicationsUpdate(strxml, orgId);
    }

    #endregion

    // * Presence Synch *
    #region Presence Synch
    [WebMethod]
    public int PortalMonthlyRegisterUpdate(string StrXML, int DivisionId)
    {
        return PortalSynchDataServiceClient.PortalMonthlyRegisterUpdate(StrXML, DivisionId);
    }

    [WebMethod]
    public DataSet PortalAttendanceMaxDateGet(int OrgId, Int32 DivisionId, Int32 BatchId)
    {
        return PortalSynchDataServiceClient.AttendanceMaxDateGet(OrgId, DivisionId, BatchId);
    }

    #endregion


    #region Library Synch

    // * Library Synch *
    [WebMethod]
    public int PortalUploadBookLogUpdate(string strxml, int orgId)
    {
        return PortalSynchDataServiceClient.PortalUploadBookLogUpdate(strxml, orgId);
    }

    #endregion

    #region Result Synch

    // * Result Synch *
    [WebMethod]
    public Int32 PortalViewResultAdd(string strXML, Int32 BatchId, Int32 ClassId, Int32 DivisionId, Int16 ExamTypeId, Int32 ExamId)
    {
        return PortalSynchDataServiceClient.PortalViewResultAdd(strXML, BatchId, ClassId, DivisionId, ExamTypeId, ExamId);
    }

    [WebMethod]
    public Int32 PortalViewResultDetailAdd(string strXML, Int32 BatchId, Int32 ClassId, Int32 DivisionId, Int16 ExamTypeId, Int32 ExamId)
    {
        return PortalSynchDataServiceClient.PortalViewResultDetailAdd(strXML, BatchId, ClassId, DivisionId, ExamTypeId, ExamId);
    }

    #endregion

    // * Daily Presence Synch *
    #region Daily Presence Synch
    [WebMethod]
    public int PortalDailyPresenceAdd(string strXML, Int32 OrgId, Int32 DivisionId, Int32 BatchId, Int32 ClassId, Int16 AttendanceTypeId, DateTime FromDate, DateTime ToDate, Int32 SubjectId, bool IsAlertOnAutoSyncAttendanceWithPortal)
    {
        int Result = PortalSynchDataServiceClient.PortalDailyPresenceAdd(strXML, OrgId, DivisionId);

        if (Result == 1 && IsAlertOnAutoSyncAttendanceWithPortal == true)
        {
            DataSet Ds = new DataSet();
            Ds = CommonFunctionServiceClient.GetDataset("SELECT EventId FROM sAlert.tEventTemplate WHERE IsAutoSend = 1 AND OrgId =" + OrgId + " AND ( EventId = 13 OR EventId = 26)");
            if (Ds != null && Ds.Tables.Count > 0 && Ds.Tables[0].Rows.Count > 0)
            {
                SMSHelper SMSHelperObject = new SMSHelper();
                SMSPredefine Data = new SMSPredefine();
                Data.ScriptType = "StoredProcedure";
                Data.BatchId = BatchId;
                Data.OrgId = OrgId;
                Data.ClassId = ClassId;
                Data.DivisionId = DivisionId;
                Data.AttendanceTypeId = AttendanceTypeId;
                Data.FromDate = FromDate;
                Data.ToDate = ToDate;
                Data.SubjectId = SubjectId;
                Data.SourceEvent = "Transactional";

                Data.Template = string.Empty;
                Data.IsPresent = false;
                Data.IsMobileNotification = true;
                SMSHelperObject.SendAlert(13, Data, OrgId); //Absent Student

                Data.Template = string.Empty;
                Data.IsPresent = true;
                Data.IsMobileNotification = true;
                SMSHelperObject.SendAlert(26, Data, OrgId); //Present Student
            }
        }
        return Result;
    }
    #endregion

    // * Configuration Setting Synch *
    #region Configuration Setting Synch
    [WebMethod]
    public int PortalConfigurationSetupAdd(string strXML, Int32 OrgId)
    {
        return PortalSynchDataServiceClient.PortalConfigurationSetupAdd(strXML, OrgId);
    }

    [WebMethod]
    public int PortalEmailConfigurationAdd(string strXML, Int32 OrgId)
    {
        return PortalSynchDataServiceClient.PortalEmailConfigurationAdd(strXML, OrgId);
    }

    [WebMethod]
    public int PortalSMSConfigurationAdd(string strXML, Int32 OrgId)
    {
        return PortalSynchDataServiceClient.PortalSMSConfigurationAdd(strXML, OrgId);
    }
    #endregion

    #region Event Synch

    // * Event Attendances Synch *
    [WebMethod]
    public int PortalEventAttendancesUpdate(string strxml, int BatchId)
    {
        return PortalSynchDataServiceClient.PortalEventAttendancesUpdate(strxml, BatchId);
    }

    // * Event Assign Synch *
    [WebMethod]
    public int PortalEventAssignUpdate(string strxml, int BatchId)
    {
        return PortalSynchDataServiceClient.PortalEventAssignUpdate(strxml, BatchId);
    }

    // * Event Schedule Synch *
    [WebMethod]
    public int PortalEventScheduleUpdate(string strxml, int BatchId)
    {
        return PortalSynchDataServiceClient.PortalEventScheduleUpdate(strxml, BatchId);
    }

    #endregion

    #region Event Sync

    // * Teacher Subject *
    [WebMethod]
    public int PortalTeacherSubjectUpdate(string strxml, int OrgId)
    {
        return PortalSynchDataServiceClient.PortalTeacherSubjectUpdate(strxml, OrgId);
    }

    // * Teacher Subject Division *
    [WebMethod]
    public int PortalTeacherSubjectDivisionUpdate(string strxml, int OrgId)
    {
        return PortalSynchDataServiceClient.PortalTeacherSubjectDivisionUpdate(strxml, OrgId);
    }

    #endregion

    [WebMethod]
    public string CheckNetVidyalayaPortalInConfigFile()
    {
        return PortalSynchDataServiceClient.CheckNetVidyalayaPortalInConfigFile();
    }

    [WebMethod]
    public int PortalFeeCollectionGroupUpdate(string strxml, int OrgGroupBatchId)
    {
        return PortalSynchDataServiceClient.PortalFeeCollectionGroupUpdate(strxml, OrgGroupBatchId);
    }

    [WebMethod]
    public int PortalExemptionTypeDetailUpdate(string strxml)
    {
        return PortalSynchDataServiceClient.PortalExemptionTypeDetailUpdate(strxml);
    }

    [WebMethod]
    public int PortalExemptionTypeMasterUpdate(string strxml, Int16 OrgGroupId)
    {
        return PortalSynchDataServiceClient.PortalExemptionTypeMasterUpdate(strxml, OrgGroupId);
    }

    [WebMethod]
    public int ReceiptBookOrgwiseUpdate(string strxml, Int16 OrgId)
    {
        return PortalSynchDataServiceClient.ReceiptBookOrgwiseUpdate(strxml, OrgId);
    }


    [WebMethod]
    public int PortalReceiptBookMasterUpdate(string strxml, Int16 OrgGroupId)
    {
        return PortalSynchDataServiceClient.PortalReceiptBookMasterUpdate(strxml, OrgGroupId);
    }

    [WebMethod]
    public int PortalReceiptUpdate(string strxml, Int32 DivisionId)
    {
        return PortalSynchDataServiceClient.PortalReceiptUpdate(strxml, DivisionId);
    }

    [WebMethod]
    public int PortalReceiptDelete(string ReceiptId)
    {
        return PortalSynchDataServiceClient.PortalReceiptDelete(ReceiptId);
    }

    [WebMethod]
    public int PortalReceiptDetailUpdate(string strxml, Int32 DivisionId)
    {
        return PortalSynchDataServiceClient.PortalReceiptDetailUpdate(strxml, DivisionId);
    }
    [WebMethod]
    public int PortalReceiptDetailDelete(string ReceiptId)
    {
        return PortalSynchDataServiceClient.PortalReceiptDetailDelete(ReceiptId);
    }


    [WebMethod]
    public int PortalFeeAllocationUpdate(string strxml, Int32 BatchId, Int32 DivisionId)
    {
        return PortalSynchDataServiceClient.PortalFeeAllocationUpdate(strxml, BatchId, DivisionId);
    }

    [WebMethod]
    public int PortalFeeDiscountUpdate(string strxml)
    {
        return PortalSynchDataServiceClient.PortalFeeDiscountUpdate(strxml);
    }

    [WebMethod]
    public int PortalFeeOptionalUpdate(string strxml, Int32 BatchId, Int32 DivisionId)
    {
        return PortalSynchDataServiceClient.PortalFeeOptionalUpdate(strxml, BatchId, DivisionId);
    }


    [WebMethod]
    public int PortalHeadMasterUpdate(string strxml, Int16 OrgGroupId)
    {
        return PortalSynchDataServiceClient.PortalHeadMasterUpdate(strxml, OrgGroupId);
    }

    [WebMethod]
    public int PortalHeadOrgwiseUpdate(string strxml, Int16 OrgId)
    {
        return PortalSynchDataServiceClient.PortalHeadOrgwiseUpdate(strxml, OrgId);
    }

    [WebMethod]
    public int PortalMainGroupMasterUpdate(string strxml)
    {
        return PortalSynchDataServiceClient.PortalMainGroupMasterUpdate(strxml);
    }

    [WebMethod]
    public int PortalMainGroupOrgGroupwise(string strxml, Int32 OrgId)
    {
        return PortalSynchDataServiceClient.PortalMainGroupOrgGroupwise(strxml, OrgId);
    }

    [WebMethod]
    public int PortalMainGroupOptionalFee(string strxml, Int32 OrgId)
    {
        return PortalSynchDataServiceClient.PortalMainGroupOptionalFee(strxml, OrgId);
    }

    [WebMethod]
    public int PortalFeeMaster(string strxml, Int16 OrgGroupId)
    {
        return PortalSynchDataServiceClient.PortalFeeMaster(strxml, OrgGroupId);
    }
    [WebMethod]
    public int PortalFeeSetup(string strxml, Int32 BatchId)
    {
        return PortalSynchDataServiceClient.PortalFeeSetup(strxml, BatchId);
    }


    #region Master Synch

    // * TransportMaster *
    [WebMethod]
    public int PortalTransportMasterUpdate(string strxml)
    {
        return PortalSynchDataServiceClient.PortalTransportMasterUpdate(strxml);
    }

    // * BusRouteMaster *
    [WebMethod]
    public int PortalBusRouteMasterUpdate(string strxml)
    {
        return PortalSynchDataServiceClient.PortalBusRouteMasterUpdate(strxml);
    }

    // * BusRouteDestinationMaster *
    [WebMethod]
    public int PortalBusRouteDestinationMasterUpdate(string strxml)
    {
        return PortalSynchDataServiceClient.PortalBusRouteDestinationMasterUpdate(strxml);
    }

    // * FuelTypeMaster *
    [WebMethod]
    public int PortalFuelTypeMasterUpdate(string strxml)
    {
        return PortalSynchDataServiceClient.PortalFuelTypeMasterUpdate(strxml);
    }

    // * VehicleTypeMaster *
    [WebMethod]
    public int PortalVehicleTypeMasterUpdate(string strxml)
    {
        return PortalSynchDataServiceClient.PortalVehicleTypeMasterUpdate(strxml);
    }

    // * VehicleMaster *
    [WebMethod]
    public int PortalVehicleMasterUpdate(string strxml)
    {
        return PortalSynchDataServiceClient.PortalVehicleMasterUpdate(strxml);
    }


    #endregion

    #region Assign Route

    // * AssignRoute *
    [WebMethod]
    public int PortalAssignRouteUpdate(string strxml, int OrgGroupBatchId)
    {
        return PortalSynchDataServiceClient.PortalAssignRouteUpdate(strxml, OrgGroupBatchId);
    }


    #endregion

    #region Assign Transport Org

    // * AssignRoute *
    [WebMethod]
    public int PortalAssignTransportOrgUpdate(string strxml, int TransportId, int OrgId)
    {
        return PortalSynchDataServiceClient.PortalAssignTransportOrgUpdate(strxml, TransportId, OrgId);
    }


    #endregion

}