﻿<%@ WebService Language="C#" Class="TimeTableSyncWebService" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using Sapphire.Vidyalaya.BusinessLogic.Business.TimeTable.TimeTableBL;
using Sapphire.Vidyalaya.BusinessLogic.Business.Library.LibraryBL;
using Sapphire.Vidyalaya.BusinessLogic.Business.Attendance.AttendanceBL;
using Sapphire.Ohu.BaseFramework.Utilities;
using Sapphire.Ohu.BusinessEntity.Framework.BaseFrameworkBE;
using System.Data;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
// [System.Web.Script.Services.ScriptService]
public class TimeTableSyncWebService  : System.Web.Services.WebService {


    // vs command prompt wsdl http://localhost:5568/Services/TimeTableSyncWebService.asmx?wsdl
    // browse the service and put /service before part of url in config file
    //string SyncServiceUrl = System.Configuration.ConfigurationManager.AppSettings["SyncServiceUrl"];
    ///// <remarks/>
    //public TimeTableSyncWebService()
    //{
    //    this.Url = SyncServiceUrl + "/Services/TimeTableSyncWebService.asmx";
    //}
    
    
    #region Service Client

    //TimeTable Synch Service
    private TimeTableSynchDataService TimeTableSynchDataServiceClient
    {
        get { return new TimeTableSynchDataService(); }
    }

    private CommonFunctions CommonFunctionServiceClient
    {
        get { return new CommonFunctions(); }
    }
 
    
    #endregion
    [WebMethod]
    public string HelloWorld()
    {
        return "Hello World";
    }


    // ***** Time Table Data Synch *****
    
    #region Time Table Data Synch

    // * Assign Class Room *
    [WebMethod]
    public DataSet TimeTableAssignClassRoomGet(Int32 TimeTableSchemaId)
    {
        return TimeTableSynchDataServiceClient.TimeTableAssignClassRoomGet(TimeTableSchemaId);
    }

    // * Assign Organization *
    [WebMethod]
    public DataSet TimeTableAssignOrganizationGet(Int32 TimeTableSchemaId)
    {
        return TimeTableSynchDataServiceClient.TimeTableAssignOrganizationGet(TimeTableSchemaId);
    }

    // * Assign Batch Master *
    [WebMethod]
    public DataSet TimeTableBatchMasterGet(Int32 OrgGroupId)
    {
        return TimeTableSynchDataServiceClient.TimeTableBatchMasterGet(OrgGroupId);
    }

    // * Assign Class Master *
    [WebMethod]
    public DataSet TimeTableClassMasterGet(Int32 OrgId)
    {
        return TimeTableSynchDataServiceClient.TimeTableClassMasterGet(OrgId);
    }

    // * Assign Class Room *
    [WebMethod]
    public DataSet TimeTableClassRoomGet()
    {
        return TimeTableSynchDataServiceClient.TimeTableClassRoomGet();
    }

    // * Assign ClassRoom Time Off *
    [WebMethod]
    public DataSet TimeTableClassRoomTimeOffGet(Int32 TimeTableSchemaId)
    {
        return TimeTableSynchDataServiceClient.TimeTableClassRoomTimeOffGet(TimeTableSchemaId);
    }
    
    // * Assign Class Subject *
    [WebMethod]
    public DataSet TimeTableClassSubjectGet(Int32 OrgId)
    {
        return TimeTableSynchDataServiceClient.TimeTableClassSubjectGet(OrgId);
    }

    // * Assign Division *
    [WebMethod]
    public DataSet TimeTableDivisionGet(Int32 OrgId)
    {
        return TimeTableSynchDataServiceClient.TimeTableDivisionGet(OrgId);
    }

    // * Assign Division ClassRoom *
    [WebMethod]
    public DataSet TimeTableDivisionClassRoomGet(Int32 TimeTableSchemaId)
    {
        return TimeTableSynchDataServiceClient.TimeTableDivisionClassRoomGet(TimeTableSchemaId);
    }
    
    // * Assign Division Time Off *
    [WebMethod]
    public DataSet TimeTableDivisionTimeOffGet(Int32 TimeTableSchemaId)
    {
        return TimeTableSynchDataServiceClient.TimeTableDivisionTimeOffGet(TimeTableSchemaId);
    }

    // * Assign Division Work Load *
    [WebMethod]
    public DataSet TimeTableDivisionWorkLoadGet(Int32 TimeTableSchemaId)
    {
        return TimeTableSynchDataServiceClient.TimeTableDivisionWorkLoadGet(TimeTableSchemaId);
    }

    // * Organization Master *
    [WebMethod]
    public DataSet TimeTableOrganizationMasterGet(Int32 OrgId)
    {
        return TimeTableSynchDataServiceClient.TimeTableOrganizationMasterGet(OrgId);
    }

    // * Assign Proxysetting*
    [WebMethod]
    public DataSet TimeTableProxySettingGet(Int32 TimeTableSchemaId)
    {
        return TimeTableSynchDataServiceClient.TimeTableProxySettingGet(TimeTableSchemaId);
    }

    // * School Building *
    [WebMethod]
    public DataSet TimeTableSchoolBuildingGet()
    {
        return TimeTableSynchDataServiceClient.TimeTableSchoolBuildingGet();
    }

    // * Subject Master *
    [WebMethod]
    public DataSet TimeTableSubjectGet(Int32 OrgId)
    {
        return TimeTableSynchDataServiceClient.TimeTableSubjectGet(OrgId);
    }

    // * Subject ClassRoom*
    [WebMethod]
    public DataSet TimeTableSubjectClassRoomGet(Int32 TimeTableSchemaId)
    {
        return TimeTableSynchDataServiceClient.TimeTableSubjectClassRoomGet(TimeTableSchemaId);
    }

    // * Subject TimeOff *
    [WebMethod]
    public DataSet TimeTableSubjectTimeOffGet(Int32 TimeTableSchemaId)
    {
        return TimeTableSynchDataServiceClient.TimeTableSubjectTimeOffGet(TimeTableSchemaId);
    }

    // * Teacher Master *
    [WebMethod]
    public DataSet TimeTableTeacherGet(Int32 OrgId)
    {
        return TimeTableSynchDataServiceClient.TimeTableTeacherGet(OrgId);
    }

    // * Time Setup *
    [WebMethod]
    public DataSet TimeTableTimeSetupGet(Int32 TimeTableSchemaId)
    {
        return TimeTableSynchDataServiceClient.TimeTableTimeSetupGet(TimeTableSchemaId);
    }

    // * Teacher Time Off *
    [WebMethod]
    public DataSet TimeTableTeacherTimeOffGet(Int32 TimeTableSchemaId)
    {
        return TimeTableSynchDataServiceClient.TimeTableTeacherTimeOffGet(TimeTableSchemaId);
    }

    // * TimeTable *
    [WebMethod]
    public DataSet TimeTableGet(Int32 TimeTableSchemaId)
    {
        return TimeTableSynchDataServiceClient.TimeTableGet(TimeTableSchemaId);
    }

    // * TimeTable Detail *
    [WebMethod]
    public DataSet TimeTableDetailGet(Int32 TimeTableSchemaId)
    {
        return TimeTableSynchDataServiceClient.TimeTableDetailGet(TimeTableSchemaId);
    }
   
    
     // * TimeTable Add *
    [WebMethod]
    public Int32 TimeTableAdd(string XMLDoc,Int32 OrgGroupId )
    {
        return TimeTableSynchDataServiceClient.TimeTableAdd(XMLDoc,OrgGroupId);
    }

    //* TimeTable Detail Add *
    [WebMethod]
    public Int32 TimeTableDetailAdd(string XMLDoc, Int32 OrgGroupId)
    {
        return TimeTableSynchDataServiceClient.TimeTableDetailAdd(XMLDoc, OrgGroupId);
    }
    
    // * TimeTable *
    [WebMethod]
    public DataSet TimeTableSchemaGet()
    {
        return TimeTableSynchDataServiceClient.TimeTableSchemaGet();
    }

    // * Assign Teacher Work Load *
    [WebMethod]
    public DataSet TimeTableTeacherWorkLoadGet(Int32 TimeTableSchemaId)
    {
        return TimeTableSynchDataServiceClient.TimeTableTeacherWorkLoadGet(TimeTableSchemaId);
    }

    
    #endregion


   
    


}