﻿<%@ WebService Language="C#" Class="eExamSyncWebService" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using Sapphire.Ohu.BaseFramework.Utilities;
using Sapphire.Ohu.BusinessEntity.Framework.BaseFrameworkBE;
using System.Data;
using System.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Data.Configuration;
using Sapphire.Vidyalaya.BusinessLogic.Business.EExam.EExamBL;
using Sapphire.Vidyalaya.BusinessEntity.Business.EExamBE;
using System.Collections.Generic;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
public class eExamSyncWebService : System.Web.Services.WebService
{
    // vs command prompt wsdl http://localhost:5568/Services/eExamSyncWebService.asmx?wsdl
    // browse the service and put /service before part of url in config file
    //string SyncServiceUrl = System.Configuration.ConfigurationManager.AppSettings["SyncServiceUrl"];
    ///// <remarks/>
    //public eExamSyncWebService()
    //{
    //    this.Url = SyncServiceUrl + "/Services/eExamSyncWebService.asmx";
    //}

    #region Service Client
    private QuestionService QuestionServiceServiceClient
    {
        get { return new QuestionService(); }
    }

    private TestQuestionService TestQuestionServiceClient
    {
        get { return new TestQuestionService(); }
    }
    private TestService TestServiceClient
    {
        get
        {
            return new TestService();
        }
    }
    private CommonFunctions CommonFunctionServiceClient
    {
        get { return new CommonFunctions(); }
    }
    #endregion

    #region eExam Data Synch

    [WebMethod]
    public string HelloWorld()
    {
        return "Hello World";
    }
    
    [WebMethod]
    public DataSet GetDataSetList(string sQuesry)
    {
        return CommonFunctionServiceClient.GetDataset(sQuesry);
    }

    [WebMethod]
    public Int64 CreateQuestion(Question QuestionData, List<QuestionOption> QuestionOptionList)
    {
        return QuestionServiceServiceClient.CreateQuestion(QuestionData, QuestionOptionList);
    }
    
    [WebMethod]
    public Int64 CreateQuestionParegraph(Question QuestionData, List<QuestionOption> QuestionOptionList, ref Int64 QuestionId)
    {
        return QuestionServiceServiceClient.CreateQuestionParegraph(QuestionData, QuestionOptionList, ref QuestionId);
    }
    
    [WebMethod]
    public List<Question> GetQuestionList(Question QuestionData)
    {
        return QuestionServiceServiceClient.GetQuestionList(QuestionData);
    }
    
    [WebMethod]
    public List<QuestionOption> GetQuestionOptionList(QuestionOption QuestionOptionData)
    {
        return QuestionServiceServiceClient.GetQuestionOptionList(QuestionOptionData);
    }

    [WebMethod]
    public Int32 DeleteTestQuestion(Int64 Id)
    {
        return TestQuestionServiceClient.DeleteTestQuestion(Id);
    }

    [WebMethod]
    public List<Test> GetTestMaster(Test TestMasterList)
    {
        return TestServiceClient.GetTestMaster(TestMasterList);
    } 
    
    #endregion
}