﻿using System;
using System.Collections.Generic;
using paytm;
using System.IO;
using System.Web;
using System.Linq;
public partial class GenerateChecksum : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request.Form.AllKeys.Length > 0)
        {
            try
            {

                string MERCHANT_KEY = Request.QueryString["MERCHANT_KEY"];
                string MID = Request.QueryString["MID"];
                string ORDER_ID = Request.QueryString["ORDER_ID"];
                string CUST_ID = Request.QueryString["CUST_ID"];
                string CHANNEL_ID = Request.QueryString["CHANNEL_ID"];
                string INDUSTRY_TYPE_ID = Request.QueryString["INDUSTRY_TYPE_ID"];
                string WEBSITE = Request.QueryString["WEBSITE"];
                string TXN_AMOUNT = Request.QueryString["TXN_AMOUNT"];

                Dictionary<string, string> parameters = new Dictionary<string, string>();
                parameters.Add("MID", MID);
                parameters.Add("ORDER_ID", ORDER_ID);
                parameters.Add("CUST_ID", CUST_ID);
                parameters.Add("CHANNEL_ID", CHANNEL_ID);
                parameters.Add("INDUSTRY_TYPE_ID", INDUSTRY_TYPE_ID);
                parameters.Add("WEBSITE", WEBSITE);
                parameters.Add("TXN_AMOUNT", TXN_AMOUNT);

                string paytmChecksum = "";
                foreach (string key in Request.Form.Keys)
                {
                    // below code snippet is mandatory, so that no one can use your checksumgeneration url for other purpose .
                    if (Request.Form[key].Trim().ToUpper().Contains("REFUND") || Request.Form[key].Trim().Contains("|"))
                    {
                        continue;
                    }

                    if (parameters.ContainsKey(key.Trim()))
                    {
                        parameters[key.Trim()] = Request.Form[key].Trim();
                    }
                    else
                    {
                        parameters.Add(key.Trim(), Request.Form[key].Trim());
                    }
                }

                string Params = string.Join(";", parameters.Select(x => x.Key + "=" + x.Value).ToArray());
                paytmChecksum = CheckSum.generateCheckSum(MERCHANT_KEY, parameters);
                CommonHelper.LogWriter("parameters : " + Params + "\n checksum : " + paytmChecksum, 1, "PayTM CheckSum", HttpContext.Current.Request.Url.AbsoluteUri);                

                if (parameters.ContainsKey("ORDER_ID") && parameters.ContainsKey("MID"))
                {
                    Response.AddHeader("Content-type", "application/json");
                    Response.Write("{\"ORDER_ID\":\"" + parameters["ORDER_ID"] + "\",\"CHECKSUMHASH\":\"" + paytmChecksum + "\",\"payt_STATUS\":\"1\"}");
                }
                else
                {
                    Response.AddHeader("Content-type", "application/json");
                    Response.Write("{\"ORDER_ID\":\"" + parameters["ORDER_ID"] + "\",\"CHECKSUMHASH\":\"" + paytmChecksum + "\",\"payt_STATUS\":\"2\"}");
                }
            }
            catch (Exception)
            {
            }
        }
    }   
}
