﻿<%@ page title="Employee Search" language="C#" masterpagefile="~/Pages/Common/MasterPages/MainMasterPage_new.master" autoeventwireup="true" inherits="Pages_Communication_LostAndFound, App_Web_tuzlk5r4" enableEventValidation="false" viewStateEncryptionMode="Never" %>


<%@ Register Src="~/UserControls/DatePicker/DatePickerControl.ascx" TagName="DatePickerControl" TagPrefix="Date" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register Src="~/UserControls/Common/ScreenGroup/ScreenGroup.ascx" TagName="ScreenGroupControl" TagPrefix="ScreenGroup" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CP" runat="Server">
    <asp:UpdatePanel ID="HREmployeeMasterSearchUpdatePanel" runat="server">
        <ContentTemplate>
            <div id="divContentPage" class="divcontentpagemargin">

                <div class="dashBoardLeftCont" runat="server" id="ScreenGroupTableId">
                    <div class="himssuHeader3WireBox">
                        <table>
                            <tr>
                                <td>
                                    <div class="himsBoxContent">
                                        <div class="leftUlMenu">
                                            <ScreenGroup:ScreenGroupControl EnableViewState="true" ID="ScreenGroupControl1" ScreenGroupId="114"
                                                Visible="true" runat="server" />
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="whiteboxpaddingleft row">
                    <div class="himssuHeader5WireBox card card-box">
                        <div class="himsBoxHeader card-head">
                            <asp:Panel ID="SearchHeaderPanel" runat="server" meta:resourcekey="SearchHeaderPanelResource1">

                                <div class="himsBoxTitle">
                                    <div class="headerText">
                                        <header>
                                            <i class="fas fa-bookmark"></i>
                                            <asp:Label ID="SearchHeaderLabel" runat="server" Text="Lost And Found"></asp:Label>
                                        </header>
                                    </div>
                                </div>
                            </asp:Panel>
                        </div>
                        <asp:Panel ID="SearchDetailPanel" runat="server" meta:resourcekey="SearchDetailPanelResource1">
                            <div class="outerBox pTop5 col-md-3">
                                <div class="controlLabelWidth">
                                    <asp:Label ID="FromDateLabel" runat="server" Text="From Date" Visible="True"></asp:Label>
                                </div>
                                <div class="fLeft pRight5">
                                    <Date:DatePickerControl DisplayDatePicker="true" ID="FromDatePickerControl" Visible="True"
                                        runat="server" />
                                </div>
                            </div>
                            <div class="outerBox pTop5 col-md-3">
                                <div class="controlLabelWidth">
                                    <asp:Label ID="ToDateLabel" runat="server" Text="To Date" Visible="True"></asp:Label>
                                </div>
                                <div class="fLeft pRight5">
                                    <Date:DatePickerControl DisplayDatePicker="True" ID="ToDatePickerControl" Visible="True"
                                        runat="server" />
                                </div>
                            </div>

                            <div class="alignCenter pTop5 col-md-12 center">
                                <asp:Button ID="SearchButton" runat="server" Text="&#xf002; Search"
                                    OnClick="SearchButton_Click" SkinID="0" class="btn-search btn fas" />
                                <asp:Button ID="ClearButton" runat="server" Text="&#xf0e2; Clear"
                                    OnClick="ClearSearch_Click" SkinID="0" class="btn-reset btn fas" />
                            </div>

                            <div class="himsBoxContent card-body">
                                <div class="contentHolder">

                                    <div class="outerBox pTop5 col-md-12">
                                        <div class="alert alert-info">
                                            <i class="material-icons">info</i>
                                            <asp:Label ID="CodeNoteLabel" runat="server" Text="<B> Note : </B> Here, only Found Items will be displayed."></asp:Label>
                                        </div>
                                    </div>

                                    <div id="LostAndFoundGridViewDiv" runat="server" visible="false">

                                        <div class="himssuHeader7WireBox  col-md-12">
                                            <div class="himsBoxContent table-responsive">
                                                <asp:GridView ID="LostAndFoundGridView" runat="server" AutoGenerateColumns="False"
                                                    CssClass="table table-striped table-bordered table-hover" EmptyDataText="No records available for the seacrh criteria!"
                                                    ShowHeader="True">
                                                    <Columns>
                                                        <asp:BoundField DataField="FoundDate" HeaderStyle-HorizontalAlign="Left" HeaderText="Found Date" ItemStyle-Width="10%" />
                                                        <asp:BoundField DataField="ItemType" HeaderStyle-HorizontalAlign="Left" HeaderText="Item Type" ItemStyle-Width="20%" />
                                                        <asp:BoundField DataField="ItemDescription" HeaderStyle-HorizontalAlign="Left" HeaderText="Item Description" ItemStyle-Width="60%" />

                                                        <asp:TemplateField HeaderText="Item Photo" ItemStyle-Width="10%" HeaderStyle-HorizontalAlign="Center"
                                                            ItemStyle-HorizontalAlign="Center" ItemStyle-Wrap="true">
                                                            <ItemTemplate>
                                                                <asp:Image ID="ItemPhotoURLPhoto" Height="100px" Width="100px" runat="server" ImageUrl='<%# Eval("ItemPhotoURL")%>' />
                                                            </ItemTemplate>
                                                        </asp:TemplateField>
                                                    </Columns>
                                                </asp:GridView>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="FileGridViewDiv" runat="server" visible="false">

                                        <div class="himssuHeader7WireBox  col-md-12">
                                            <div class="himsBoxContent table-responsive">
                                                <asp:GridView ID="FileGridView" runat="server" AutoGenerateColumns="False"
                                                    CssClass="table table-striped table-bordered table-hover" EmptyDataText="No records available for the seacrh criteria!" DataKeyNames="LostFoundRegisterId,OrgGroupId"
                                                    ShowHeader="True">
                                                    <Columns>
                                                        <asp:BoundField DataField="FoundDate" HeaderStyle-HorizontalAlign="Left" HeaderText="Found Date" ItemStyle-Width="10%" />
                                                        <asp:BoundField DataField="ItemType" HeaderStyle-HorizontalAlign="Left" HeaderText="Item Type" ItemStyle-Width="20%" />
                                                        <asp:BoundField DataField="ItemDescription" HeaderStyle-HorizontalAlign="Left" HeaderText="Item Description" ItemStyle-Width="60%" />

                                                        <asp:TemplateField ItemStyle-Width="80%" HeaderStyle-HorizontalAlign="Left"
                                                            ItemStyle-HorizontalAlign="Left" ItemStyle-Wrap="true">
                                                            <ItemTemplate>
                                                                <asp:Label ID="FileNameLabel" runat="server" CssClass="boxEllips" ToolTip='<%#Bind("FileName")%>'
                                                                    Text='<%#Bind("FileName")%>'></asp:Label>
                                                            </ItemTemplate>
                                                        </asp:TemplateField>
                                                        <asp:TemplateField HeaderText="" ItemStyle-Width="10%" HeaderStyle-HorizontalAlign="Left"
                                                            ItemStyle-HorizontalAlign="Left" ItemStyle-Wrap="true">
                                                            <ItemTemplate>
                                                                <asp:LinkButton ID="DownloadLinkButton" runat="server" CommandName="Download" Visible='<%#Eval("FileName").ToString() == "" ? false : true %>' Text="Download" OnClick="DownloadLinkButton_Click"
                                                                    CausesValidation="false"></asp:LinkButton>

                                                            </ItemTemplate>
                                                        </asp:TemplateField>

                                                    </Columns>
                                                </asp:GridView>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </asp:Panel>
                    </div>

                </div>
                </tr>
                    </table>
            </div>
            </div>
        </ContentTemplate>
    </asp:UpdatePanel>
    <%-- <script data-main="../../JavaScript/rjs/encrypt/assign-organization-encrypt" src="../../JavaScript/rjs/require.js"></script>--%>
    <script data-main='<%=ResolveUrl("~/JavaScript/rjs/assign-organization")%>' src='<%=ResolveUrl("~/JavaScript/rjs/require.js")%>'></script>
</asp:Content>
