﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="StudentOnlineRegistrationForm.aspx.cs" Inherits="Pages_StudentManagement_StudentOnlineRegistrationForm" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">

    <title></title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.2.0/css/solid.css" integrity="sha384-wnAC7ln+XN0UKdcPvJvtqIH3jOjs9pnKnq9qX68ImXvOGz2JuFoEiCjT8jyZQX2z" crossorigin="anonymous" />
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.2.0/css/fontawesome.css" integrity="sha384-HbmWTHay9psM8qyzEKPc8odH4DsOuzdejtnr+OFtDmOcIVnhgReQ4GZBH7uwcjf6" crossorigin="anonymous" />
    <link href="../../App_Themes/admission/css/bootstrap.css" rel="stylesheet" />
    <link href="../../App_Themes/admission/css/style.css" rel="stylesheet" />
    <link href="../../App_Themes/admission/css/jquery-ui.css" rel="stylesheet" />
    <link href="http://fonts.googleapis.com/css?family=PT+Sans:400,400i,700,700i" rel="stylesheet" />
    <%@ Register Src="~/UserControls/DatePicker/DatePickerControl.ascx" TagName="DatePickerControl"
    TagPrefix="Date" %>
</head>
<body class="">
    <div class="w3l-main">
        <div class="row">
            <div class="col-lg-12">
                <div class="page-header">
                    <h3>
                        <asp:Label ID="schoolnameLabel" runat="server" Text=""></asp:Label>
                    </h3>
                    <h4 class="pTop6">Student Online Registration Form</h4>
                </div>
            </div>
        </div>
        <form id="form1" runat="server" class="w3l-from container">
            <div class="col-lg-12 padd-0 mt1" runat="server" id="failuremessage" visible="false">
                <div class="alert alert-danger">
                    <i class="fas fa-times"></i>&nbsp;&nbsp;&nbsp;Error ! Please check all the inputs.
                </div>
            </div>
            <div class="col-lg-12 padd-0 mt1">
                <div runat="server" id="successmessageDiv" visible="false">
                    <div class="alert alert-success" style="margin-bottom: 0px !important; font-size: small">
                        <strong>
                            <asp:Label runat="server" ID="SuccessLabel"></asp:Label></strong>
                    </div>
                </div>
            </div>
            <div class="col-lg-12 padd-0 mt1" runat="server" id="failurebdaymessage" visible="false">
                <div class="alert alert-danger">
                    <asp:Label runat="server" ID="BirthDateErrorLabel"></asp:Label>
                </div>
            </div>
            <div class="col-lg-12 padd-0 mt1">
                <div class="alert alert-danger">
                    <i class="fa fa-asterisk "></i>&nbsp;&nbsp;&nbsp;Required Field      
                </div>
            </div>
            <div class="col-lg-12 padd-0 mt1" id="PaymentRemarkDiv" runat="server" style="display:none">
                <div class="alert alert-info">
                    <h6>
                        <asp:Label ID="PaymentRemarkLabel" runat="server" Text="Use Mozilla or Internet Explorer Browser for Better Experience."></asp:Label>
                    </h6>
                </div>
            </div>

            <asp:HiddenField ID="CheckPaymentRemarkHiddenField" runat="server" />
             <asp:HiddenField ID="StudentIdhiddn" runat="server" />
            <div class="col-lg-12 padd-0 mt1" id="remarkdiv" runat="server" visible="false">
                <div class="alert alert-info">
                    <h6>
                        <asp:Label ID="AdmissionRemarkLabel" runat="server" Text=""></asp:Label>

                    </h6>
                </div>
            </div>
            <div class="form-group" id="SchoolInformationDiv">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header ">
                        <h5>
                            <span id="SchoolInformationLabel" runat="server" class=""><i class="fas fa-school bg-bgreen"></i>&nbsp;School Information</span>
                        </h5>
                    </div>


                    <div class="col-md-4">
                        <div class="bg-white">
                            <label for="InputName" id="SchoolLabel" runat="server" class="mandatory">School Name</label>
                            <div class="input-group">
                                <asp:DropDownList ID="OrgDropDownList" runat="server" CssClass="form-control" AutoPostBack="true" OnSelectedIndexChanged="OrgDropDownList_OnSelectedIndexChanged">
                                </asp:DropDownList>
                                <div id="orgnull" class="null-message" style="display: none">Select School</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="bg-white">
                            <label for="InputName" class="mandatory">Batch</label>
                            <div class="input-group">
                                <asp:DropDownList ID="BatchDropDownList" CssClass="form-control" runat="server" AutoPostBack="true" OnSelectedIndexChanged="BatchDropDownList_OnSelectedIndexChanged">
                                </asp:DropDownList>
                                <div id="batchnull" class="null-message" style="display: none">Select Batch</div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4" id="ClassDiv">
                        <div class="bg-white">
                            <label for="ClassIdDropDownList" >Class</label>
                            <asp:Label ID="ClassIdlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="ClassIdDropDownList" AutoPostBack="true" OnSelectedIndexChanged="ClassIdDropDownList_SelectedIndexChanged"  runat="server">
                                </asp:DropDownList>
                                <div id="ClassIdnull" class="null-message" style="display: none">Select Class</div>
                            </div>
                        </div>
                    </div>
                     <div class="col-md-4" id="MobileNoDiv" runat="server">
                        <div class="bg-white">
                            <label for="MobileNoLable">MobileNo</label>
                            <asp:Label ID="MobileNoLabel1" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="MobileNoTextBox" CssClass="form-control" runat="server" placeholder="MobileNo" onkeypress="return isNumberKey(event)"></asp:TextBox>
                               
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="OTPDiv1" runat="server">
                        <asp:Button ID="OTPButton" runat="server" CssClass="btn green fas" Text="Send OTP"  OnClick="OTPButton_Click"/>
                    </div>
                    <div class="col-md-4 w-100"></div>
                 <div >
                   <%-- <div id="VerifyOTPDiv" runat="server">--%>
                     <div class="col-md-4" id="OTPDiv2" runat="server">
                        <div class="bg-white">
                            <label for="OTPLable">OTP</label>
                            <asp:Label ID="Label1" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="OTPTextBox" CssClass="form-control" runat="server" placeholder="OTP" onkeypress="return isNumberKey(event)" Enabled="false"></asp:TextBox>
                               
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="OTPDiv3" runat="server">
                        <asp:Button ID="VerifyOTPButton" runat="server" CssClass="btn green fas" Text="Verify OTP" OnClick="VerifyOTPButton_Click" Enabled="false"/>
                    </div>
                  <%--</div>--%>
                  </div>
                </div>
            </div>
            <div class="form-group" id="StudentDetailDiv" runat="server" visible="false">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="Label5" runat="server" class=""><i class="fas fa-user-graduate bg-yellow"></i>&nbsp;Student Detail</span>
                        </h5>
                    </div>
                    <div class="col-md-4" id="IdNoDiv" >
                        <div class="bg-white">
                            <label for="IdNoTextBox" class="mandatory">ID NO</label>
                            <div class="input-group">
                                <asp:TextBox ID="IdNoTextBox" CssClass="form-control" runat="server" placeholder="Id No" onkeypress="return isNumberKey(event)"></asp:TextBox>
                                <%--<div id="IdNonull" class="null-message" style="display: none">ID NO is required</div>--%>
                            </div>
                        </div>
                    </div>
                    
                   <%-- <div class="col-md-4" id="InquiryNumberDiv">
                        <div class="bg-white">
                            <label for="InquiryNumberTextBox" >Inquiry Number</label>
                            <div class="input-group">
                                <asp:TextBox ID="InquiryNumberTextBox" CssClass="form-control" runat="server" placeholder="Inquiry Number" MaxLength="100" onkeypress="return isNumberKey(event)"></asp:TextBox>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FormNumberDiv" runat="server">
                        <div class="bg-white">
                            <label for="FormNumberTextBox">Form Number</label>
                            <asp:Label ID="FormNumberlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FormNumberTextBox" CssClass="form-control" runat="server" placeholder="Form Number" MaxLength="100" onkeypress="return isNumberKey(event)"></asp:TextBox>
                                <div id="FormNumbernull" class="null-message" style="display: none">Form Number is required</div>
                            </div>
                        </div>--%>
                
                    <div class="col-md-4" id="NameDiv">
                        <div class="bg-white">
                            <label for="FirstNameTextBox">Name</label>
                            <asp:Label ID="FirstNamelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FirstNameTextBox" CssClass="form-control" runat="server" placeholder="First Name" onkeypress="NumberNotAlllow()"></asp:TextBox>
                                <div id="FirstNamenull" class="null-message" style="display: none">Name is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="MiddleNameDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="MiddleNameTextBox">Father Name</label>
                            <asp:Label ID="MiddleNamelbl" runat="server" class="mandatory"  visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="MiddleNameTextBox" CssClass="form-control" runat="server" placeholder="Father Name" onkeypress="NumberNotAlllow()"></asp:TextBox>
                                <div id="MiddleNamenull" class="null-message" style="display: none">Father Name is required</div>
                            </div>
                        </div>
                    </div>
                    <%--Changed for Mantis : 34798 by Nilesh--%>
                    <div class="col-md-4" id="SurnameDiv" runat="server" >
                        <div class="bg-white">
                            <label for="SurnameTextBox">Surname</label>
                            <asp:Label ID="Surnamelbl" runat="server" class="mandatory" Visible ="False"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="SurnameTextBox" CssClass="form-control" runat="server" placeholder="Surname" onkeypress="NumberNotAlllow()"></asp:TextBox>
                                <div id="Surnamenull" class="null-message" style="display: none">Surname is required</div>
                            </div>
                        </div>
                    </div>
                     <div class="col-md-4" id="RegistrationNumberDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="RegistrationNumberTextBox">Registration Number</label>
                            <asp:Label ID="RegistrationNumberlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="RegistrationNumberTextBox" CssClass="form-control" runat="server" placeholder="Registration Number" onkeypress="return isNumberKey(event)"></asp:TextBox>
                                <div id="RegistrationNumbernull" class="null-message" style="display: none">Registration Number is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="DepartmentDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="DepartmentDropDownList">Department</label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="DepartmentDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="Departmentnull" class="null-message" style="display: none">Select Department</div>
                            </div>
                        </div>
                    </div>
                    <%--<div class="col-md-4" id="ClassDiv">
                        <div class="bg-white">
                            <label for="ClassIdDropDownList" >Class</label>
                            <asp:Label ID="ClassIdlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="ClassIdDropDownList" AutoPostBack="true" OnSelectedIndexChanged="ClassIdDropDownList_SelectedIndexChanged"  runat="server">
                                </asp:DropDownList>
                                <div id="ClassIdnull" class="null-message" style="display: none">Select Class</div>
                            </div>
                        </div>
                    </div>--%>
                    <div class="col-md-4" id="DivisionDiv">
                        <div class="bg-white">
                            <label for="DivisionIdDropDownList">Division</label>
                            <asp:Label ID="Divisionlbl" runat="server" class="mandatory" Visible="true"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="DivisionIdDropDownList" AutoPostBack="false"  runat="server">
                                </asp:DropDownList>
                                <div id="DivisionIdnull" class="null-message" style="display: none">Select Division</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="RollNoDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="RollNoTextBox">Roll No</label>
                            <asp:Label ID="RollNolbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" placeHolder="Roll No" CssClass="form-control" ID="RollNoTextBox" />
                                <div id="RollNonull" class="null-message" style="display: none">Roll No is required</div>
                            </div>
                        </div>
                    </div>
                  
                    <div class="col-md-4" id="StatusDiv" runat="server">
                        <div class="bg-white">
                            <label for="StatusDropDownList">Status</label>
                            <asp:Label ID="Statuslbl" runat="server" class="mandatory"></asp:Label>
                             <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="StatusDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                               <%-- <div id="Statusnull" class="null-message" style="display: none">Select Status</div>--%>
                            </div>
                        </div>
                    </div>
                    <%--<div class="col-md-4" id="ClassStatusDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="ClassStatusDropDownList" >Class Status</label>
                            <asp:Label ID="ClassStatuslbl" runat="server" class="mandatory"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="ClassStatusDropDownList" AutoPostBack="true" OnSelectedIndexChanged="ClassStatusDropDownList_SelectedIndexChanged" runat="server">
                                </asp:DropDownList>
                                <div id="ClassStatusnnull" class="null-message" style="display: none">Select Class Status</div>
                            </div>
                        </div>
                    </div>--%>
                    <div class="col-md-4" id="RecordTagDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="RecordTagDropDownList">Record Tag</label>
                            <asp:Label ID="RecordTaglbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="RecordTagDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="RecordTagnull" class="null-message" style="display: none">Select Record Tag</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FeesCategoryDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="FeesCategoryDropDownList">Fees Category</label>
                            <asp:Label ID="FeesCategorylbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="FeesCategoryDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="FeesCategorynull" class="null-message" style="display: none">Select Fees Category</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="AdmissionStandardDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="AdmissionStandardDropDownList" >Admission Standard</label>
                            <asp:Label ID="AdmissionStandardlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="AdmissionStandardDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="AdmissionStandardnull" class="null-message" style="display: none">Select Admission Standard</div>
                            </div>
                        </div>
                    </div>
                   
                    <div class="col-md-4" id="AdmissionDateDiv"  visible="false" runat="server" >
                        <div class="bg-white">
                            <label for="AdmissionDateDatePickerControl">Admission Date</label>
                            <asp:Label ID="AdmissionDatelbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                             <div class="input-group">
                                <asp:TextBox runat="server" CssClass="form-control DatePickerControl" ID="AdmissionDateDatePickerControl" placeholder="dd/mm/yyyy"  onkeyup="FormatIt(this);" AutoPostBack="false" />
                                <div id="AdmissionDatenull" class="null-message" style="display: none">Admission Date is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="AdmissionYearDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="AdmissionYearTextBox">Admission Year</label>
                            <asp:Label ID="AdmissionYearlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="AdmissionYearTextBox" CssClass="form-control" runat="server" placeholder="Admission Year" MaxLength="4" oonkeypress="return isNumberKey(event)" ></asp:TextBox>
                                <div id="AdmissionYearnull" class="null-message" style="display: none">Admission Year is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="InActiveDateDiv"  visible="false" runat="server" >
                        <div class="bg-white">
                            <label for="InActiveDateDatePickerControl">InActive Date</label>
                            <asp:Label ID="InActiveDatelbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" CssClass="form-control DatePickerControl" ID="InActiveDateDatePickerControl" placeholder="dd/mm/yyyy"  onkeyup="FormatIt(this);" AutoPostBack="false" />
                                <div id="InActiveDatenull" class="null-message" style="display: none">InActive Date is required</div>
                            </div>
                        </div>
                    </div>
                   
                    <div class="col-md-4" id="LeftStandardDiv" visible="false" runat="server" >
                        <div class="bg-white">
                            <label for="LeftStandardIdDropDownList">Left Standard</label>
                            <asp:Label ID="LeftStandardlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="LeftStandardIdDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="LeftStandardnull" class="null-message" style="display: none">Select Left Standard</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="LeftDatedDiv"  visible="false" runat="server" >
                        <div class="bg-white">
                            <label for="LeftDateDatePickerControl" >Left Date</label>
                            <asp:Label ID="LeftDatedlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server"  CssClass="form-control DatePickerControl" ID="LeftDateDatePickerControl" placeholder="dd/mm/yyyy"  onkeyup="FormatIt(this);" AutoPostBack="false" />
                                <div id="LeftDatedenull" class="null-message" style="display: none">Left Dated is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="LeftYearDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="LeftYearTextBox">Left Year</label>
                            <asp:Label ID="LeftYearlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="LeftYearTextBox" CssClass="form-control" runat="server" placeholder="Left Year" MaxLength="4"  onkeypress="return isNumberKey(event)"></asp:TextBox>
                                <div id="LeftYearnull" class="null-message" style="display: none">Left Year is required</div>
                            </div>
                        </div>
                    </div>
                    <asp:HiddenField ID="AttachmentSizeHiddenField" runat="server" />
                    <div class="col-md-4" runat="server" visible="false" id="StudentPhotoDiv">
                        <div class="bg-white">
                            <label for="StudentPhotoFileUpload">Student's Photo</label>
                            <asp:Label ID="StudentPhotolbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <div class="file-upload">
                                    <div class="file-select">
                                     <%--   <asp:HiddenField ID="ImageMaxSize" runat="server" />
                                        <asp:HiddenField ID="HiddenField6" runat="server" />--%>
                                        <div class="file-select-button">Choose File</div>
                                        <asp:FileUpload ID="StudentPhotoFileUpload" CssClass="inputfile" runat="server" onchange="ValidateFileSize1(this);" />
                                        <label class="file-select-name"><span></span>No file chosen...</label>

                                    </div>
                                </div>
                                <img runat="server" id="StudentImage" height="50" width="50" style="margin-top: 10px; width: 78px; height: 69px" />
                                <asp:Label ID="StudentImageLabel" Text="" runat="server" ForeColor="BlueViolet" />
                                <asp:Label ID="StudentSuccessImageLabel" Text="Uploaded Successfully" runat="server" Style="display: none"></asp:Label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="StudentGroupDiv" visible="false" runat="server" >
                        <div class="bg-white">
                            <label for="StudentGroupDropDownList">Student Group</label>
                            <asp:Label ID="StudentGrouplbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="StudentGroupDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="StudentGroupnull" class="null-message" style="display: none">Select Student Group</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="StudentOtherGroupDiv" visible="false" runat="server" >
                        <div class="bg-white">
                            <label for="StudentOtherGroupDropDownList" class="mandatory">Student Other Group</label>
                            <asp:Label ID="StudentOtherGrouplbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="StudentOtherGroupDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="StudentOtherGroupnull" class="null-message" style="display: none">Select Student Other Group</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group" id="AdmissionDetailDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="AdmissionDetail" runat="server" class=""><i class="fas fa-graduation-cap bg-lav"></i>&nbsp;Admission Detail</span>
                        </h5>
                    </div>
                    <div class="col-md-4" id="PreviousStudentIdDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="PreviousStudentIdTextBox">PreviousStudentId</label>
                            <asp:Label ID="PreviousStudentIdlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="PreviousStudentIdTextBox" CssClass="form-control" runat="server" placeholder="Previous StudentId No" onkeypress="NumberNotAlllow()" ></asp:TextBox>
                                <div id="PreviousStudentIdnull" class="null-message" style="display: none">Previous StudentId is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="PreviousSchoolDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="PreviousSchoolTextBox">Previous School/Board</label>
                            <asp:Label ID="PreviousSchoollbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="PreviousSchoolTextBox" CssClass="form-control" runat="server" placeholder="Previous School/Board"></asp:TextBox>
                                <div id="PreviousSchoolnull" class="null-message" style="display: none">Previous School/Board is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="PreviousSchoolTypeDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="PreviousSchoolTypeDropDownList">Previous School Type</label>
                            <asp:Label ID="PreviousSchoolTypelbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="PreviousSchoolTypeDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="PreviousSchoolTypenull" class="null-message" style="display: none">Select Previous School Type</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="PreviousStandardDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="PreviousStandardTextBox" >Previous Standard</label>
                            <asp:Label ID="PreviousStandardlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="PreviousStandardTextBox" CssClass="form-control" placeholder="Previous Standard" runat="server"></asp:TextBox>
                                <div id="PreviousStandardnull" class="null-message" style="display: none">Previous Standard is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="PassingYearDiv" runat="server" Visible="false">
                        <div class="bg-white">
                            <label for="PassingYearTextBox">Passing Year</label>
                            <asp:Label ID="PassingYearlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="PassingYearTextBox" CssClass="form-control" runat="server" placeholder="Passing Year" onkeypress="return isNumberKey(event)"></asp:TextBox>
                                <div id="PassingYearnull" class="null-message" style="display: none">Passing Year is required</div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4" id="AdmissionFormNumberDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="AdmissionFormNumberTextBox">Admission Form Number</label>
                            <asp:Label ID="AdmissionFormNumberlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="AdmissionFormNumberTextBox" CssClass="form-control" runat="server" placeholder="Admission Form Number" onkeypress="return isNumberKey(event)"></asp:TextBox>
                                <div id="AdmissionFormNumbernull" class="null-message" style="display: none">Admission Form Number is required</div>
                            </div>
                        </div>
                    </div>
                    
                    
                    <div class="col-md-4" id="AdmissionQuotaDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="AdmissionQuotaDropDownList">Admission Quota</label>
                            <asp:Label ID="AdmissionQuotalbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="AdmissionQuotaDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="AdmissionQuotanull" class="null-message" style="display: none">Select Admission Quota</div>
                            </div>
                        </div>
                    </div>
                   
                    <div class="col-md-4" id="AdmissionNumberDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="AdmissionNumberTextBox" >Admission Number</label>
                            <asp:Label ID="AdmissionNumberlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" placeHolder="Admission Number" CssClass="form-control" ID="AdmissionNumberTextBox" onkeypress="return isNumberKey(event)"/>
                                <div id="AdmissionNumbernull" class="null-message" style="display: none">Roll No is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="InActiveReasonDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="InActiveReasonTextBox" >InActive Reason</label>
                            <asp:Label ID="InActiveReasonlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" placeHolder="InActive Reason" CssClass="form-control" ID="InActiveReasonTextBox" />
                                <div id="InActiveReasonnull" class="null-message" style="display: none">InActive Reason is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="LCBookDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="LCBookTextBox">LC Book</label>
                            <asp:Label ID="LCBooklbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" placeHolder="LC Book" CssClass="form-control" ID="LCBookTextBox" />
                                <div id="LCBooknull" class="null-message" style="display: none">LC Book is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="LCNumberDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="LCNumberTextBox">LC Number</label>
                            <asp:Label ID="LCNumberlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" placeHolder="LC Number" CssClass="form-control" ID="LCNumberTextBox" onkeypress="return isNumberKey(event)"/>
                                <div id="LCNumbernull" class="null-message" style="display: none">LC Number is required</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4" id="LCDateDiv"  visible="false" runat="server" >
                        <div class="bg-white">
                            <label for="LCDateDatePickerControl" >LC Date</label>
                            <asp:Label ID="LCDatelbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" CssClass="form-control DatePickerControl" ID="LCDateDatePickerControl" placeholder="dd/mm/yyyy" onkeyup="FormatIt(this);" AutoPostBack="false" />
                                <div id="LCDatenull" class="null-message" style="display: none">Admission Date is required</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4" id="LCCopyDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="LCCopyDropDownList">LC Copy</label>
                            <asp:Label ID="LCCopylbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                               <%-- <asp:DropDownList CssClass="form-control" ID="LCCopyDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>--%>
                                 <asp:TextBox runat="server" placeHolder="LC Copy" CssClass="form-control" ID="LCCopyText" onkeypress="return isNumberKey(event)"/>
                                <div id="LCCopynull" class="null-message" style="display: none">Select LC Copy</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="LcIdDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="LcIdTextBox" >Lc Id</label>
                            <asp:Label ID="LcIdlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" placeHolder="Lc Id" CssClass="form-control" ID="LcIdTextBox" onkeypress="return isNumberKey(event)"/>
                                <div id="LcIdnull" class="null-message" style="display: none">Lc Id is required</div>
                            </div>
                        </div>

                    </div>
                    <div class="col-md-4" id="LeftReasonDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="LeftReasonTextBox" >Left Reason</label>
                            <asp:Label ID="LeftReasonlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" placeHolder="Left Reason" CssClass="form-control" ID="LeftReasonTextBox" />
                                <div id="LeftReasonnull" class="null-message" style="display: none">LC Number is required</div>
                            </div>
                        </div>

                    </div>
                    <div class="col-md-4" id="LCProgressDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="LCProgressTextBox" >LC Progress</label>
                            <asp:Label ID="LCProgresslbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" placeHolder="LC Progress" CssClass="form-control" ID="LCProgressTextBox" />
                                <div id="LCProgressnull" class="null-message" style="display: none">LC Progress is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="LCConductDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="LCConductTextBox">LC Conduct</label>
                            <asp:Label ID="LCConductlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" placeHolder="LC Conduct" CssClass="form-control" ID="LCConductTextBox" />
                                <div id="LCConductnull" class="null-message" style="display: none">LC Conduct is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="LCRemarkDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="LCRemarkTextBox">LC Remark</label>
                            <asp:Label ID="LCRemarklbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" placeHolder="LC Remark" CssClass="form-control" ID="LCRemarkTextBox" />
                                <div id="LCRemarknull" class="null-message" style="display: none">LC Remark is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="ExamSeatNoDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="ExamSeatNoTextBox">Exam Seat No</label>
                            <asp:Label ID="ExamSeatNolbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" placeHolder="Exam Seat No" CssClass="form-control" ID="ExamSeatNoTextBox" />
                                <div id="ExamSeatNonull" class="null-message" style="display: none">Exam Seat No is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="AddOptionSubjectDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <asp:CheckBox ID="AddOptionSubjectLinkButton" runat="server" SkinID="CustomWidthTextBox" Text="Assign Optional Subject"
                                onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()" AutoPostBack="true"
                                OnCheckedChanged="AddOptionSubjectLinkButton_CheckedChanged"></asp:CheckBox>
                        </div>
                        <div id="DivClassCheckBoxList" class="fLeft pRight5 chck-dropdown-onclick bg-lghtgrey outerBox11 col-md-3 overflow-x-hidden padd-0" runat="server" visible="false">
                            <div class="select">
                                <asp:CheckBox ID="SubjectCheckBox" runat="server" AutoPostBack="True" OnCheckedChanged="SubjectCheckBox_CheckedChanged" />
                                <asp:Label ID="ApplyForAllLabel" AssociatedControlID="SubjectCheckBox" runat="server" Text="Select All"></asp:Label>
                            </div>
                            <div id="ClassDivisionDiv" runat="server">
                                <asp:CheckBoxList ID="SubjectCheckBoxList" runat="server">
                                </asp:CheckBoxList>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="PreviousLCDateDiv"  visible="false" runat="server" >
                        <div class="bg-white">
                            <label for="PreviousLCDateDatePickerControl" >Previous LC Date</label>
                            <asp:Label ID="PreviousLCDatelbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" CssClass="form-control DatePickerControl" ID="PreviousLCDateDatePickerControl" placeholder="dd/mm/yyyy"  onkeyup="FormatIt(this);" AutoPostBack="false" />
                                <div id="PreviousLCDatenull" class="null-message" style="display: none">Previous LC Date is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="PreviousLCNumberDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="LCNumberTextBox">Previous LC Number</label>
                            <asp:Label ID="PreviousLCNumberlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" placeHolder="Previous LC Number" CssClass="form-control" ID="PreviousLCNumberTextBox" />
                                <div id="PreviousLCNumbernull" class="null-message" style="display: none">Previous LC Number is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="PreviousResultDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="PreviousResultTextBox">Previous Result</label>
                            <asp:Label ID="PreviousResultlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" placeHolder="Previous Result" CssClass="form-control" ID="PreviousResultTextBox" />
                                <div id="PreviousResultnull" class="null-message" style="display: none">Previous Result is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="ProofOfDOBDiv" runat="server" visible="false">
                        <div class="bg-white">
                            <label for="ProofOfDOBTextBox">Proof Of DOB</label>
                            <asp:Label ID="ProofOfDOBlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" placeHolder="Proof Of DOB" CssClass="form-control" ID="ProofOfDOBTextBox" />
                                <div id="ProofOfDOBnull" class="null-message" style="display: none">Proof Of DOB is required</div>
                            </div>
                        </div>
                    </div>
                    
                    
                </div>
            </div>
            <div class="form-group" id="CollegeAdmissionDetailDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="CollegeAdmissionDetail" runat="server" class=""><i class="fas fa-user-graduate bg-yellow"></i>&nbsp;College Admission Detail</span>
                        </h5>
                    </div>
                    <div class="col-md-4" id="IsTransferDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label class="material-checkbox">
                                <asp:CheckBox ID="IsTransferCheckBox" runat="server"
                                                        AutoPostBack="false" />
                                <span>Transfer</span>
                               <%-- <asp:Label ID="IsTransferlbl" runat="server" class="mandatory" ></asp:Label>--%>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-4" id="TransferFromDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="TransferFromTextBox">Transfer From</label>
                            <asp:Label ID="TransferFromlbl" runat="server" Visible="false" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="TransferFromTextBox" CssClass="form-control" runat="server" placeholder="Transfer From" onkeypress="NumberNotAlllow()"></asp:TextBox>
                                <div id="TransferFromnull" class="null-message" style="display: none">Transfer From is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="IsTFWSDiv" visible="false" runat="server">
                        <div class="bg-white">
                             <label class="material-checkbox">

                                <asp:CheckBox ID="IsTFWSCheckBox" runat="server" 
                                                        AutoPostBack="false"  />
                                  <span>TFWS</span>
                                <%--<asp:Label ID="IsTFWSlbl" runat="server" class="mandatory" ></asp:Label>--%>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-4" id="IsCertificateHolderDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label class="material-checkbox">
                                <asp:CheckBox ID="IsCertificateHolderCheckBox" runat="server" OnCheckedChanged="IsCertificateHolderCheckBox_CheckedChanged"
                                                        AutoPostBack="false" />
                                <span>IsCertificateHolder</span>
                                <%--<asp:Label ID="IsCertificateHolderlbl" runat="server" class="mandatory" ></asp:Label>--%>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-4" id="CertificateNameDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="CertificateNameTextBox">Certificate Name</label>
                            <asp:Label ID="CertificateNamelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="CertificateNameTextBox" CssClass="form-control" runat="server" placeholder="Certificate Name"></asp:TextBox>
                                <div id="CertificateNamenull" class="null-message" style="display: none">Certificate is required</div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4" id="MaritalStatusDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="MaritalStatusDropDownList" >Marital Status</label>
                            <asp:Label ID="MaritalStatuslbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="MaritalStatusDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="MaritalStatusnull" class="null-message" style="display: none">Select Marital Status</div>
                            </div>
                        </div>
                    </div>

                 </div>
            </div>
            <div class="form-group" id="GovRegNumberDetailDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="GovRegNumberDetail" runat="server" class=""><i class="fas fa-user-graduate bg-yellow"></i>&nbsp;Gov. Reg. Number Detail</span>
                        </h5>
                    </div>
                    <div class="col-md-4" id="UIDNumberDiv"  visible="false" runat="server">
                        <div class="bg-white">
                            <label for="UIDNumberTextBox">UID Number</label>
                            <asp:Label ID="UIDNumberlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="UIDNumberTextBox" CssClass="form-control" runat="server" placeholder="UID Number" onkeypress="return isNumberKey(event)"></asp:TextBox>
                                <div id="UIDNumbernull" class="null-message" style="display: none">UID Number is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="AadhaarNumberDiv"  visible="false" runat="server">
                        <div class="bg-white">
                            <label for="AadhaarNumberTextBox">Aadhaar Number</label>
                            <asp:Label ID="AadhaarNumberlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="AadhaarNumberTextBox" CssClass="form-control" runat="server" placeholder="Aadhaar Number" MaxLength="14" onkeypress="return isNumberKey(event)"></asp:TextBox>
                                <div id="AadhaarNumbernull" class="null-message" style="display: none">Aadhaar Number is required</div>
                            </div>
                        </div>
                    </div>
                 </div>
            </div>
            <div class="form-group" id="DemographicDetailDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="DemographicDetail" runat="server" class=""><i class="fas fa-info-circle bg-pink"></i>&nbsp;Demographic Detail</span>
                        </h5>
                    </div>
                    <div class="col-md-4" id="DateofBirthDiv"  visible="true" runat="server" >
                        <div class="bg-white">
                            <label for="DateofBirthDatePickerControl" >Date of Birth</label>
                            <asp:Label ID="DateofBirthlbl" runat="server" class="mandatory" Visible="true"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" CssClass="form-control DatePickerControl" ID="DateofBirthDatePickerControl" placeholder="dd/mm/yyyy"  onkeyup="FormatIt(this);" AutoPostBack="false" />
                                <div id="DateofBirthnull" class="null-message" style="display: none">Date of Birth is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="BirthdateinwordDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="BirthdateinwordTextBox">Birthdate in word</label>
                            <asp:Label ID="Birthdateinwordlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="BirthdateinwordTextBox" CssClass="form-control" runat="server" placeholder="Birthdate in word" onkeypress="NumberNotAlllow()"></asp:TextBox>
                                <div id="Birthdateinwordnull" class="null-message" style="display: none">Birthdate in word is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="GenderDiv" visible="true"  runat="server">
                        <div class="bg-white">
                            <label for="GenderDropDownList" runat="server" id="GenderDropDownListLabel">Gender</label>
                            <label for="GenderTextBox" runat="server" id="GenderTextBoxLabel" visible="false">Gender</label>
                            <asp:Label ID="Genderlbl" runat="server" class="mandatory" Visible="true"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="GenderDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <asp:TextBox ID="GenderTextBox" runat="server" SkinID="CustomWidthTextBox" Visible="false" Enabled="false"></asp:TextBox>
                                <div id="Gendernull" class="null-message" style="display: none">Select Gender</div>
                            </div>
                        </div>
                    </div>
                    <%--<div class="col-md-4" id="StudentAadharNoDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="StudentAadharNoTextBox">Aadhar No.</label>
                            <asp:Label ID="StudentAadharNolbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="StudentAadharNoTextBox" CssClass="form-control" runat="server" placeholder="0000 0000 0000" MaxLength="100" ></asp:TextBox>
                                <div id="StudentAadharNonull" class="null-message" style="display: none">Student Aadhar No. is required</div>

                            </div>
                        </div>
                    </div>--%>
                    <div class="col-md-4" id="ReligionDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="ReligionDropDownList" >Religion</label>
                            <asp:Label ID="Religionlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="ReligionDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="Religionnull" class="null-message" style="display: none">Select Religion</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="BloodGroupDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="BloodGroupDropDownList" >Blood Group</label>
                            <asp:Label ID="BloodGrouplbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="BloodGroupDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="BloodGroupnull" class="null-message" style="display: none">Select Blood Group</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="HobbyDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="HobbyTextBox">Hobby</label>
                            <asp:Label ID="Hobbylbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="HobbyTextBox" CssClass="form-control" runat="server" placeholder="Hobby"></asp:TextBox>
                                <div id="Hobbynull" class="null-message" style="display: none">Hobby is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="BirthPlaceDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="BirthPlaceTextBox">Birth Place</label>
                            <asp:Label ID="BirthPlacelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="BirthPlaceTextBox" CssClass="form-control" runat="server" placeholder="Birth Place"></asp:TextBox>
                                <div id="BirthPlacenull" class="null-message" style="display: none">Birth Place is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="BirthTalukaDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="BirthTalukaTextBox">Birth Taluka</label>
                            <asp:Label ID="BirthTalukalbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="BirthTalukaTextBox" CssClass="form-control" runat="server" placeholder="Birth Taluka"></asp:TextBox>
                                <div id="BirthTalukanull" class="null-message" style="display: none">Birth Taluka is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="BirthDistrictDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="BirthDistrictTextBox">Birth District</label>
                            <asp:Label ID="BirthDistrictlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="BirthDistrictTextBox" CssClass="form-control" runat="server" placeholder="Birth District"></asp:TextBox>
                                <div id="BirthDistrictnull" class="null-message" style="display: none">Birth District is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="BirthStateDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="BirthStateTextBox">Birth State</label>
                            <asp:Label ID="BirthStatelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="BirthStateTextBox" CssClass="form-control" runat="server" placeholder="Birth State"></asp:TextBox>
                                <div id="BirthStatenull" class="null-message" style="display: none">Birth State is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="BirthCountryDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="BirthCountryTextBox">Birth Country</label>
                            <asp:Label ID="BirthCountrylbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="BirthCountryTextBox" CssClass="form-control" runat="server" placeholder="Birth Country"></asp:TextBox>
                                <div id="BirthCountrynull" class="null-message" style="display: none">Birth Country is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FamilyCasteDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FamilyCasteTextBox">Family Caste</label>
                            <asp:Label ID="FamilyCastelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FamilyCasteTextBox" CssClass="form-control" runat="server" placeholder="Family Caste"></asp:TextBox>
                                <div id="FamilyCastenull" class="null-message" style="display: none">Family Caste is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FamilySubCasteDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FamilySubCasteTextBox">Family Sub Caste</label>
                            <asp:Label ID="FamilySubCastelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FamilySubCasteTextBox" CssClass="form-control" runat="server" placeholder="Family Sub Caste"></asp:TextBox>
                                <div id="FamilySubCastenull" class="null-message" style="display: none">Family Sub Caste is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="CasteCategoryDiv" visible="false"  runat="server">
                        <div class="bg-white">
                            <label for="CasteCategoryDropDownList" >Caste Category</label>
                            <asp:Label ID="CasteCategorylbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="CasteCategoryDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="CasteCategorynull" class="null-message" style="display: none">Select Caste Category</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="HouseDiv" visible="false"  runat="server">
                        <div class="bg-white">
                            <label for="HouseDropDownList" >House</label>
                            <asp:Label ID="Houselbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="HouseDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="Housenull" class="null-message" style="display: none">Select House</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4" id="MotherTongueDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="MotherTongueTextBox">Mother Tongue</label>
                            <asp:Label ID="MotherTonguelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList runat="server" ID="MotherTongueDropDownList" SkinID="CustomWidthDropDownList"
                                    onmouseleave="showHideTooltip()" CssClass="form-control" onmouseenter="showHideTooltip()">
                                </asp:DropDownList>
                                <div id="MotherTonguenull" class="null-message" style="display: none">Mother Tongue is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="NationalityDiv" visible="false"  runat="server">
                        <div class="bg-white">
                            <label for="NationalityDropDownList" >Nationality</label>
                            <asp:Label ID="Nationalitylbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="NationalityDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="Nationalitynull" class="null-message" style="display: none">Select Nationality</div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4" id="ReferenceRemarkDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="ReferenceRemarkTextBox">Reference Remark</label>
                            <asp:Label ID="ReferenceRemarklbl" runat="server" class="mandatory" Visible="false"></asp:Label>

                            <div class="input-group">
                                <asp:TextBox ID="ReferenceRemarkTextBox" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()" placeholder="Reference Remark"
                                    SkinID="MultiLineTextBox" TextMode="MultiLine" Height="40px" runat="server"> </asp:TextBox>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="IsSelectCustomTagDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <div class="select-hover">
                                <div class="controlLabelWidth select">
                                    <asp:CheckBox ID="CustomTagCheckBox" runat="server" AutoPostBack="True" Text="Select All Custom Tag" />
                                    <%--  <asp:Label ID="ApplyForAllCustomTagLabel" runat="server" Text="Select All Custom Tag"
                                    class="pLeft5"></asp:Label>--%>
                                </div>
                                <div class="bg-lghtgrey">
                                    <div id="CustomTagDiv" runat="server" class="fLeft pRight5 chck-dropdown">
                                        <asp:CheckBoxList ID="CustomTagCheckBoxList" runat="server">
                                        </asp:CheckBoxList>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="TransportDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="TransportDropDownList" >Transport</label>
                            <asp:Label ID="Transportlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="TransportDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="Transportnull" class="null-message" style="display: none">Select Transport</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="QuotaDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="QuotaDropDownList" >Quota</label>
                            <asp:Label ID="Quotalbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="QuotaDropDownList" AutoPostBack="false" runat="server">
                                </asp:DropDownList>
                                <div id="Quotanull" class="null-message" style="display: none">Select Quota</div>
                            </div>
                        </div>
                    </div>
                 </div>
            </div>
            <div class="form-group" id="CommunicationDetailDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="CommunicationDetail" runat="server" class=""><i class="fas fa-info-circle bg-pink"></i>&nbsp;Communication Detail</span>
                        </h5>
                    </div>
                    <div class="col-md-4" id="ParentContactNoDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="ParentContactNoTextBox">Parent Contact No</label>
                            <asp:Label ID="ParentContactNolbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="ParentContactNoTextBox" CssClass="form-control" runat="server" placeholder="Parent Contact No" onkeypress="return isNumberKey(event)"></asp:TextBox>
                                <div id="ParentContactNonull" class="null-message" style="display: none">Parent Contact No is required</div>
                                <br />
                                <asp:Label ID="ParentContactNoDsp" runat="server" ForeColor="BlueViolet" Text="(Used for getting SMS Alert)"></asp:Label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="ParentEmailDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="ParentEmailTextBox">Parent Email</label>
                            <asp:Label ID="ParentEmaillbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="ParentEmailTextBox" CssClass="form-control" runat="server"  placeholder="Parent Email" onchange="validateEmail(this)"></asp:TextBox>
                                <div id="ParentEmailnull" class="null-message" style="display: none">Parent Email is required</div>
                                <br />
                                <asp:Label ID="ParentEmailDsp" runat="server" ForeColor="BlueViolet" Text="(Used for getting Email Alert)"></asp:Label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="IsBlockAlertDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <asp:CheckBox ID="BlockAllAlertCheckBox" runat="server" Text="Block All Alert" />
                        </div>
                    </div>
                    <div class="col-md-4" id="StudentContactNoDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="StudentContactNoTextBox">Student Contact No</label>
                            <asp:Label ID="StudentContactNolbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="StudentContactNoTextBox" CssClass="form-control" runat="server" placeholder="Student Contact No"  onkeypress="return isNumberKey(event)"></asp:TextBox>
                                <div id="StudentContactNonull" class="null-message" style="display: none">Student Contact No is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="StudentEmailDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="StudentEmailTextBox">Student Email</label>
                            <asp:Label ID="StudentEmaillbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="StudentEmailTextBox" CssClass="form-control" runat="server" placeholder="Student Email" onchange="validateEmail(this)" ></asp:TextBox>
                                <div id="StudentEmailnull" class="null-message" style="display: none">Student Email is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="DistanceFromSchoolDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="DistanceFromSchoolTextBox">Distance From School</label>
                            <asp:Label ID="DistanceFromSchoollbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="DistanceFromSchoolTextBox" CssClass="form-control" runat="server" placeholder="Distance From School"></asp:TextBox>
                                <div id="DistanceFromSchoolnull" class="null-message" style="display: none">Distance From School is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="WhatsAppContactNoDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="WhatsAppContactNoTextBox">WhatsApp Contact No</label>
                            <asp:Label ID="WhatsAppContactNolbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="WhatsAppContactNoTextBox" CssClass="form-control" runat="server" placeholder="WhatsApp Contact No"  onkeypress="return isNumberKey(event)"></asp:TextBox>
                                <div id="WhatsAppContactNonull" class="null-message" style="display: none">WhatsApp Contact No is required</div>
                                <br />
                                <asp:Label ID="WhatsAppContactNoDsp" runat="server" ForeColor="BlueViolet" Text="(Used for getting WhatsApp Alert)"></asp:Label>
                            </div>
                        </div>
                    </div>
                    <div id="LocalAddressDiv" visible="false" runat="server">
                        <label class="col-md-12">Local Address</label>
                        <div class="col-md-4" id="LocalAddressAddress1Div" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="LocalAddressAddress1TextBox">Address 1</label>
                                <asp:Label ID="LocalAddressAddress1lbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="LocalAddressAddress1TextBox" CssClass="form-control" runat="server" placeholder="Address 1"></asp:TextBox>
                                    <div id="LocalAddressAddress1null" class="null-message" style="display: none">Address 1 is required</div>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="LocalAddressAddress2Div" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="LocalAddressAddress1TextBox">Address 2</label>
                                <asp:Label ID="LocalAddressAddress2lbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="LocalAddressAddress2TextBox" CssClass="form-control" runat="server" placeholder="Address 2"></asp:TextBox>
                                    <div id="LocalAddressAddress2null" class="null-message" style="display: none">Address 2 is required</div>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="LocalAddressAddress3Div" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="LocalAddressAddress3TextBox">Address 3</label>
                                <asp:Label ID="LocalAddressAddress3lbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="LocalAddressAddress3TextBox" CssClass="form-control" runat="server" placeholder="Address 3"></asp:TextBox>
                                    <div id="LocalAddressAddress3null" class="null-message" style="display: none">Address 3 is required</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="LocalAddressCityDiv" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="LocalAddressCityTextBox">City</label>
                                <asp:Label ID="LocalAddressCitylbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="LocalAddressCityTextBox" CssClass="form-control" runat="server" placeholder="City"></asp:TextBox>
                                    <div id="LocalAddressCitynull" class="null-message" style="display: none">City is required</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="LocalAddressStateDiv" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="LocalAddressStateTextBox">State</label>
                                <asp:Label ID="LocalAddressStatelbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="LocalAddressStateTextBox" CssClass="form-control" runat="server" placeholder="State"></asp:TextBox>
                                    <div id="LocalAddressStatenull" class="null-message" style="display: none">State is required</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="LocalAddressCountryDiv" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="LocalAddressCountryTextBox">Country</label>
                                <asp:Label ID="LocalAddressCountrylbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="LocalAddressCountryTextBox" CssClass="form-control" runat="server" placeholder="Country"></asp:TextBox>
                                    <div id="LocalAddressCountrynull" class="null-message" style="display: none">Country is required</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="LocalAddressPINCodeDiv" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="LocalAddressPINCodeTextBox">PIN Code</label>
                                <asp:Label ID="LocalAddressPINCodelbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="LocalAddressPINCodeTextBox" CssClass="form-control" runat="server" placeholder="PIN Code" MaxLength="6" ></asp:TextBox>
                                    <div id="LocalAddressPINCodenull" class="null-message" style="display: none">PIN Code is required</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="LocalAddressContactNoDiv" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="LocalAddressContactNoTextBox">Contact No</label>
                                <asp:Label ID="LocalAddressContactNolbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="LocalAddressContactNoTextBox" CssClass="form-control" runat="server" placeholder="Contact No"  onkeypress="return isNumberKey(event)"></asp:TextBox>
                                    <div id="LocalAddressContactNonull" class="null-message" style="display: none">Contact No is required</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="PermanentAddressDiv" visible="false" runat="server">
                        <label class="col-md-12">Permanent Address</label>
                        <div class="col-md-4" id="PermanentAddressAddress1Div" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="PermanentAddressAddress1TextBox">Address 1</label>
                                <asp:Label ID="PermanentAddressAddress1lbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="PermanentAddressAddress1TextBox" CssClass="form-control" runat="server" placeholder="Address 1"></asp:TextBox>
                                    <div id="PermanentAddressAddress1null" class="null-message" style="display: none">Address 1 is required</div>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="PermanentAddressAddress2Div" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="PermanentAddressAddress1TextBox">Address 2</label>
                                <asp:Label ID="PermanentAddressAddress2lbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="PermanentAddressAddress2TextBox" CssClass="form-control" runat="server" placeholder="Address 2"></asp:TextBox>
                                    <div id="PermanentAddressAddress2null" class="null-message" style="display: none">Address 2 is required</div>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="PermanentAddressAddress3Div" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="PermanentAddressAddress3TextBox">Address 3</label>
                                <asp:Label ID="PermanentAddressAddress3lbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="PermanentAddressAddress3TextBox" CssClass="form-control" runat="server" placeholder="Address 3"></asp:TextBox>
                                    <div id="PermanentAddressAddress3null" class="null-message" style="display: none">Address 3 is required</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="PermanentAddressCityDiv" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="PermanentAddressCityTextBox">City</label>
                                <asp:Label ID="PermanentAddressCitylbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="PermanentAddressCityTextBox" CssClass="form-control" runat="server" placeholder="City"></asp:TextBox>
                                    <div id="PermanentAddressCitynull" class="null-message" style="display: none">City is required</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="PermanentAddressStateDiv" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="PermanentAddressStateTextBox">State</label>
                                <asp:Label ID="PermanentAddressStatelbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="PermanentAddressStateTextBox" CssClass="form-control" runat="server" placeholder="State"></asp:TextBox>
                                    <div id="PermanentAddressStatenull" class="null-message" style="display: none">State is required</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="PermanentAddressCountryDiv" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="PermanentAddressCountryTextBox">Country</label>
                                <asp:Label ID="PermanentAddressCountrylbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="PermanentAddressCountryTextBox" CssClass="form-control" runat="server" placeholder="Country"></asp:TextBox>
                                    <div id="PermanentAddressCountrynull" class="null-message" style="display: none">Country is required</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="PermanentAddressPINCodeDiv" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="PermanentAddressPINCodeTextBox">PIN Code</label>
                                <asp:Label ID="PermanentAddressPINCodelbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="PermanentAddressPINCodeTextBox" CssClass="form-control" runat="server" placeholder="PIN Code" MaxLength="6" ></asp:TextBox>
                                    <div id="PermanentAddressPINCodenull" class="null-message" style="display: none">PIN Code is required</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="PermanentAddressContactNoDiv" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="PermanentAddressContactNoTextBox">Contact No</label>
                                <asp:Label ID="PermanentAddressContactNolbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="PermanentAddressContactNoTextBox" CssClass="form-control" runat="server" placeholder="Contact No"  onkeypress="return isNumberKey(event)"></asp:TextBox>
                                    <div id="PermanentAddressContactNonull" class="null-message" style="display: none">Contact No is required</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="EmergencyAddressDiv" visible="false" runat="server">
                        <label class="col-md-12">Emergency Address</label>
                        <div class="col-md-4" id="EmergencyAddressAddress1Div" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="EmergencyAddressAddress1TextBox">Address 1</label>
                                <asp:Label ID="EmergencyAddressAddress1lbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="EmergencyAddressAddress1TextBox" CssClass="form-control" runat="server" placeholder="Address 1"></asp:TextBox>
                                    <div id="EmergencyAddressAddress1null" class="null-message" style="display: none">Address 1 is required</div>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="EmergencyAddressAddress2Div" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="EmergencyAddressAddress1TextBox">Address 2</label>
                                <asp:Label ID="EmergencyAddressAddress2lbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="EmergencyAddressAddress2TextBox" CssClass="form-control" runat="server" placeholder="Address 2"></asp:TextBox>
                                    <div id="EmergencyAddressAddress2null" class="null-message" style="display: none">Address 2 is required</div>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="EmergencyAddressAddress3Div" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="EmergencyAddressAddress3TextBox">Address 3</label>
                                <asp:Label ID="EmergencyAddressAddress3lbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="EmergencyAddressAddress3TextBox" CssClass="form-control" runat="server" placeholder="Address 3"></asp:TextBox>
                                    <div id="EmergencyAddressAddress3null" class="null-message" style="display: none">Address 3 is required</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="EmergencyAddressCityDiv" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="EmergencyAddressCityTextBox">City</label>
                                <asp:Label ID="EmergencyAddressCitylbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="EmergencyAddressCityTextBox" CssClass="form-control" runat="server" placeholder="City"></asp:TextBox>
                                    <div id="EmergencyAddressCitynull" class="null-message" style="display: none">City is required</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="EmergencyAddressStateDiv" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="EmergencyAddressStateTextBox">State</label>
                                <asp:Label ID="EmergencyAddressStatelbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="EmergencyAddressStateTextBox" CssClass="form-control" runat="server" placeholder="State"></asp:TextBox>
                                    <div id="EmergencyAddressStatenull" class="null-message" style="display: none">State is required</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="EmergencyAddressCountryDiv" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="EmergencyAddressCountryTextBox">Country</label>
                                <asp:Label ID="EmergencyAddressCountrylbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="EmergencyAddressCountryTextBox" CssClass="form-control" runat="server" placeholder="Country"></asp:TextBox>
                                    <div id="EmergencyAddressCountrynull" class="null-message" style="display: none">Country is required</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="EmergencyAddressPINCodeDiv" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="EmergencyAddressPINCodeTextBox">PIN Code</label>
                                <asp:Label ID="EmergencyAddressPINCodelbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="EmergencyAddressPINCodeTextBox" CssClass="form-control" runat="server" placeholder="PIN Code"></asp:TextBox>
                                    <div id="EmergencyAddressPINCodenull" class="null-message" style="display: none">PIN Code is required</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4" id="EmergencyAddressContactNoDiv" visible="false" runat="server">
                            <div class="bg-white">
                                <label for="EmergencyAddressContactNoTextBox">Contact No</label>
                                <asp:Label ID="EmergencyAddressContactNolbl" runat="server" class="mandatory" ></asp:Label>
                                <div class="input-group">
                                    <asp:TextBox ID="EmergencyAddressContactNoTextBox" CssClass="form-control" runat="server" placeholder="Contact No"  onkeypress="return isNumberKey(event)"></asp:TextBox>
                                    <div id="EmergencyAddressContactNonull" class="null-message" style="display: none">Contact No is required</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="ISStopApplicationAccessDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <asp:CheckBox ID="ISStopApplicationAccessCheckBox1" runat="server" Text="Stop Application Access" />
                        </div>
                    </div>
                    <div class="col-md-4" id="StudentCustomAlertDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="StudentCustomAlertTextBox">Student Custom Alert</label>
                            <asp:Label ID="StudentCustomAlertlbl" runat="server" class="mandatory" Visible="false"></asp:Label>

                            <div class="input-group">
                                <asp:TextBox ID="StudentCustomAlertTextBox" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()" placeholder ="Student Custom Alert"
                                    SkinID="MultiLineTextBox" TextMode="MultiLine" Height="40px" runat="server"> </asp:TextBox>
                            </div>
                        </div>
                    </div>
                 </div>
            </div>
            <div class="form-group" id="FamilyDetailDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="FamilyDetail" runat="server" class=""><i class="fas fa-user-graduate bg-yellow"></i>&nbsp;Family Detail</span>
                        </h5>
                    </div>
                    <div class="col-md-4" id="IsSingleChildDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label class="material-checkbox">
                            <asp:CheckBox ID="IsSingleChildCheckBox" runat="server" />
                                <span>IsSingleChild</span>
                            <%--<asp:Label ID="ISRelativeExStudentlbl" runat="server" class="mandatory" ></asp:Label>--%>
                                </label>
                        </div>
                    </div>
                    <div class="col-md-4" id="FamilyDetailFatherNameDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FatherNameTextBox">Father Name</label>
                            <asp:Label ID="FamilyDetailFatherNamelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FamilyDetailFatherNameTextBox" CssClass="form-control" placeholder="Father Name" runat="server"></asp:TextBox>
                                <div id="FamilyDetailFatherNamenull" class="null-message" style="display: none">Father Name is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FatherDateofBirthDiv"  visible="false" runat="server" >
                        <div class="bg-white">
                            <label for="FatherDateofBirthTextBox" >Father Date of Birth</label>
                            <asp:Label ID="FatherDateofBirthlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" CssClass="form-control DatePickerControl" ID="FatherDateofBirthDatePickerControl" placeholder="dd/mm/yyyy" onkeyup="FormatIt(this);" AutoPostBack="false" />
                                <div id="FatherDateofBirthnull" class="null-message" style="display: none">Father Date of Birth is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FatherOccupationDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FatherOccupationTextBox">Father Occupation</label>
                            <asp:Label ID="FatherOccupationlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FatherOccupationTextBox" CssClass="form-control" runat="server" placeholder="Father Occupation"></asp:TextBox>
                                <div id="FatherOccupationnull" class="null-message" style="display: none">Father Occupation is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FatherQualificationDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FatherQualificationTextBox">Father Qualification</label>
                            <asp:Label ID="FatherQualificationlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FatherQualificationTextBox" CssClass="form-control" runat="server" placeholder="Father Qualification"></asp:TextBox>
                                <div id="FatherQualificationnull" class="null-message" style="display: none">Father Qualification is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FatherContactNoDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FatherContactNoTextBox">Father Contact No</label>
                            <asp:Label ID="FatherContactNolbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FatherContactNoTextBox" CssClass="form-control" runat="server" placeholder="Father Contact No" onkeypress="return isNumberKey(event)"></asp:TextBox>
                                <div id="FatherContactNonull" class="null-message" style="display: none">Father Contact No is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FatherMailDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FatherMailTextBox">Father Mail</label>
                            <asp:Label ID="FatherMaillbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FatherMailTextBox" CssClass="form-control" runat="server" placeholder="Father Mail"></asp:TextBox>
                                <div id="FatherMailnull" class="null-message" style="display: none">Father Mail is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FatherDesignationDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FatherDesignationTextBox">Father Designation</label>
                            <asp:Label ID="FatherDesignationlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FatherDesignationTextBox" CssClass="form-control" runat="server" placeholder="Father Designation"></asp:TextBox>
                                <div id="FatherDesignationnull" class="null-message" style="display: none">Father Designation is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FatherOfficeContactNoDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FatherOfficeContactNoTextBox">Father Office Contact No</label>
                            <asp:Label ID="FatherOfficeContactNolbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FatherOfficeContactNoTextBox" CssClass="form-control" runat="server" placeholder="Father Office Contact No"  onkeypress="return isNumberKey(event)"></asp:TextBox>
                                <div id="FatherOfficeContactNonull" class="null-message" style="display: none">Father Office Contact No is required</div>

                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4" id="FatherOfficeAddressDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FatherOfficeAddressTextBox">Father Office Address</label>
                            <asp:Label ID="FatherOfficeAddresslbl" runat="server" class="mandatory" Visible="false"></asp:Label>

                            <div class="input-group">
                                <asp:TextBox ID="FatherOfficeAddressTextBox" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()"
                                    SkinID="MultiLineTextBox" TextMode="MultiLine" Height="40px" runat="server" placeholder="Father Office Address"> </asp:TextBox>
                                <div id="FatherOfficeAddressnull" class="null-message" style="display: none">Father Office Address is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FatherOrganizationDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FatherOrganizationTextBox">Father Organization</label>
                            <asp:Label ID="FatherOrganizationlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FatherOrganizationTextBox" CssClass="form-control" runat="server" placeholder="Father Organization"></asp:TextBox>
                                <div id="FatherOrganizationnull" class="null-message" style="display: none">Father Organization is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FatherAadharNoDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FatherAadharNoTextBox">Father Aadhar No.</label>
                            <asp:Label ID="FatherAadharNolbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FatherAadharNoTextBox" CssClass="form-control" runat="server" placeholder="0000 0000 0000" MaxLength="12" ></asp:TextBox>
                                <div id="FatherAadharNonull" class="null-message" style="display: none">Father Aadhar No. is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FatherIncomeDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FatherIncomeTextBox">Father Annual Income</label>
                            <asp:Label ID="FatherIncomelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FatherIncomeTextBox" CssClass="form-control" runat="server" placeholder="Father Anuual Income"></asp:TextBox>
                                <div id="FatherIncomenull" class="null-message" style="display: none">Father Annual Income is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="ISFatherExStudentDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label class="material-checkbox">
                            <asp:CheckBox ID="ISFatherExStudentCheckBox" runat="server" />
                            <span>FatherExStudent</span>
                            <%--<asp:Label ID="ISFatherExStudentlbl" runat="server" class="mandatory" ></asp:Label>--%>
                            </label>
                        </div>
                    </div>

                    <div class="col-md-4" id="FatherPassOutYearDiv"  visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FatherPassOutYearTextBox">Father PassOutYear</label>
                            <asp:Label ID="FatherPassOutYearlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FatherPassOutYearTextBox" CssClass="form-control" runat="server" placeholder="Father PassOutYear"></asp:TextBox>
                                <div id="FatherPassOutYearnull" class="null-message" style="display: none">Father PassOutYear is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" runat="server" visible="false" id="FatherPhotoDiv">
                        <div class="bg-white">
                            <label for="FatherPhotoFileUpload">Father's Photo</label>
                            <asp:Label ID="FatherPhotolbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <div class="file-upload">
                                    <div class="file-select">
                                        <asp:HiddenField ID="ImageMaxSize" runat="server" />
                                        <asp:HiddenField ID="IsOrgGroupType" runat="server" />
                                        <div class="file-select-button">Choose File</div>
                                        <asp:FileUpload ID="FatherPhotoFileUpload" CssClass="inputfile" runat="server" onchange="ValidateFileSize1(this);" />
                                        <label class="file-select-name"><span></span>No file chosen...</label>

                                    </div>
                                </div>
                                <img runat="server" id="FatherImage" height="50" width="50" style="margin-top: 10px; width: 78px; height: 69px" />
                                <asp:Label ID="FatherImageLabel" Text="" runat="server" ForeColor="BlueViolet" />
                                <asp:Label ID="FatherSuccessImageLabel" Text="Uploaded Successfully" runat="server" Style="display: none"></asp:Label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="MotherNameDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="MotherNameTextBox">Mother Name</label>
                            <asp:Label ID="MotherNamelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="MotherNameTextBox" CssClass="form-control" runat="server" placeholder="Mother Name"></asp:TextBox>
                                <div id="MotherNamenull" class="null-message" style="display: none">Mother Name is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="MotherDateofBirthDiv"  visible="false" runat="server" >
                        <div class="bg-white">
                            <label for="DateofBirthTextBox" >Mother Date of Birth</label>
                            <asp:Label ID="MotherDateofBirthlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" CssClass="form-control DatePickerControl" ID="MotherDateofBirthDatePickerControl" placeholder="dd/mm/yyyy" onkeyup="FormatIt(this);" AutoPostBack="false" />
                                <div id="MotherDateofBirthnull" class="null-message" style="display: none">Mother Date of Birth is required</div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4" id="MotherOccupationDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="MotherOccupationTextBox">Mother Occupation</label>
                            <asp:Label ID="MotherOccupationlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="MotherOccupationTextBox" CssClass="form-control" runat="server" placeholder="Mother Occupation"></asp:TextBox>
                                <div id="MotherOccupationnull" class="null-message" style="display: none">Mother Occupation is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="MotherQualificationDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="MotherQualificationTextBox">Mother Qualification</label>
                            <asp:Label ID="MotherQualificationlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="MotherQualificationTextBox" CssClass="form-control" runat="server" placeholder="Mother Qualification"></asp:TextBox>
                                <div id="MotherQualificationnull" class="null-message" style="display: none">Mother Qualification is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="MotherContactNoDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="MotherContactNoTextBox">Mother Contact No</label>
                            <asp:Label ID="MotherContactNolbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="MotherContactNoTextBox" CssClass="form-control" runat="server"  onkeypress="return isNumberKey(event)" placeholder="Mother Contact No"></asp:TextBox>
                                <div id="MotherContactNonull" class="null-message" style="display: none">Mother Contact No is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="MotherMailDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="MotherMailTextBox">Mother Mail</label>
                            <asp:Label ID="MotherMaillbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="MotherMailTextBox" CssClass="form-control" runat="server" placeholder="Mother Mail"></asp:TextBox>
                                <div id="MotherMailnull" class="null-message" style="display: none">Mother Mail is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="MotherDesignationDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="MotherDesignationTextBox">Mother Designation</label>
                            <asp:Label ID="MotherDesignationlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="MotherDesignationTextBox" CssClass="form-control" runat="server" placeholder="Mother Designation"></asp:TextBox>
                                <div id="MotherDesignationnull" class="null-message" style="display: none">Mother Designation is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="MotherOfficeContactNoDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="MotherOfficeContactNoTextBox">Mother Office Contact No</label>
                            <asp:Label ID="MotherOfficeContactNolbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="MotherOfficeContactNoTextBox" CssClass="form-control" runat="server"  onkeypress="return isNumberKey(event)" placeholder="Mother Office Contact No"></asp:TextBox>
                                <div id="MotherOfficeContactNonull" class="null-message" style="display: none">Mother Office Contact No is required</div>

                            </div>
                        </div>
                    </div>

                    <div class="col-md-4" id="MotherOfficeAddressDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="MotherOfficeAddressTextBox">Mother Office Address</label>
                            <asp:Label ID="MotherOfficeAddresslbl" runat="server" class="mandatory" Visible="false"></asp:Label>

                            <div class="input-group">
                                <asp:TextBox ID="MotherOfficeAddressTextBox" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()"
                                    SkinID="MultiLineTextBox" TextMode="MultiLine" Height="40px" runat="server" placeholder="Mother Office Address"> </asp:TextBox>
                                <div id="MotherOfficeAddressnull" class="null-message" style="display: none">Mother Office Address is required</div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4" id="MotherOrganizationDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="MotherOrganizationTextBox">Mother Organization</label>
                            <asp:Label ID="MotherOrganizationlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="MotherOrganizationTextBox" CssClass="form-control" runat="server" placeholder="Mother Organization"></asp:TextBox>
                                <div id="MotherOrganizationnull" class="null-message" style="display: none">Mother Organization is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="MotherIncomeDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="MotherIncomeTextBox">Mother Annual Income</label>
                            <asp:Label ID="MotherIncomelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="MotherIncomeTextBox" CssClass="form-control" runat="server" placeholder="Mother Annual Income"></asp:TextBox>
                                <div id="MotherIncomenull" class="null-message" style="display: none">Mother Annual Income is required</div>

                            </div>
                        </div>
                    </div>
                   
                    <div class="col-md-4" id="ISMotherExStudentDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label class="material-checkbox">
                            <asp:CheckBox ID="ISMotherExStudentCheckBox" runat="server"  />
                                <span>Mother ExStudent</span>
                           <%-- <asp:Label ID="ISMotherExStudentlbl" runat="server" class="mandatory" ></asp:Label>--%>
                            </label>
                        </div>
                    </div>
                     <div class="col-md-4" id="MotherPassOutYearDiv"  visible="false" runat="server">
                        <div class="bg-white">
                            <label for="MotherPassOutYearTextBox">Mother PassOutYear</label>
                            <asp:Label ID="MotherPassOutYearlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="MotherPassOutYearTextBox" CssClass="form-control" runat="server" placeholder="Mother PassOutYear"></asp:TextBox>
                                <div id="MotherPassOutYearnull" class="null-message" style="display: none">Mother PassOutYear is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="MotherAadharNoDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="MotherAadharNoTextBox">Mother Aadhar No.</label>
                            <asp:Label ID="MotherAadharNolbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="MotherAadharNoTextBox" CssClass="form-control" runat="server" placeholder="0000 0000 0000" MaxLength="12" ></asp:TextBox>
                                <div id="MotherAadharNonull" class="null-message" style="display: none">Mother Aadhar No. is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" runat="server" visible="false" id="MotherPhotoDiv">
                        <div class="bg-white">
                            <label for="MotherPhotoFileUpload">Mother's Photo</label>
                            <asp:Label ID="MotherPhotolbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <div class="file-upload">
                                    <div class="file-select">
                                        <asp:HiddenField ID="HiddenField1" runat="server" />
                                        <asp:HiddenField ID="HiddenField2" runat="server" />
                                        <div class="file-select-button">Choose File</div>
                                        <asp:FileUpload ID="MotherPhotoFileUpload" CssClass="inputfile" runat="server" onchange="ValidateFileSize1(this);" />
                                        <label class="file-select-name"><span></span>No file chosen...</label>

                                    </div>
                                </div>
                                <img runat="server" id="MotherImage" height="50" width="50" style="margin-top: 10px; width: 78px; height: 69px" />
                                <asp:Label ID="MotherImageLabel" Text="" runat="server" ForeColor="BlueViolet" />
                                <asp:Label ID="MotherSuccessImageLabel" Text="Uploaded Successfully" runat="server" Style="display: none"></asp:Label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="MarriageAnniversaryDateDiv"  visible="false" runat="server" >
                        <div class="bg-white">
                            <label for="MarriageAnniversaryDateDatePickerControl" >Marriage Anniversary Date</label>
                            <asp:Label ID="MarriageAnniversaryDatelbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" CssClass="form-control DatePickerControl" ID="MarriageAnniversaryDateDatePickerControl" placeholder="dd/mm/yyyy"  onkeyup="FormatIt(this);" AutoPostBack="false" />
                                <div id="MarriageAnniversaryDatenull" class="null-message" style="display: none">Marriage Anniversary Date is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="RelationNameDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="RelationNameTextBox">Relation Name</label>
                            <asp:Label ID="RelationNamelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="RelationNameTextBox" CssClass="form-control" runat="server" placeholder="Relation Name"></asp:TextBox>
                                <div id="RelationNamenull" class="null-message" style="display: none">Relation Name is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="RelativeNameDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="RelativeNameTextBox">Relative Name</label>
                            <asp:Label ID="RelativeNamelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="RelativeNameTextBox" CssClass="form-control" runat="server" placeholder="Relative Name"></asp:TextBox>
                                <div id="RelativeNamenull" class="null-message" style="display: none">Relative Name is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="RelativeDateofBirthDiv"  visible="false" runat="server" >
                        <div class="bg-white">
                            <label for="RelativeDateofBirthTextBox" >Relative Date of Birth</label>
                            <asp:Label ID="RelativeDateofBirthlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" CssClass="form-control DatePickerControl" ID="RelativeDateofBirthDatePickerControl" placeholder="dd/mm/yyyy"  onkeyup="FormatIt(this);" AutoPostBack="false" />
                                <div id="RelativeDateofBirthnull" class="null-message" style="display: none">Relative Date of Birth is required</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4" id="RelativeOccupationDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="RelativeOccupationTextBox">Relative Occupation</label>
                            <asp:Label ID="RelativeOccupationlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="RelativeOccupationTextBox" CssClass="form-control" runat="server" placeholder="Relative Occupation"></asp:TextBox>
                                <div id="RelativeOccupationnull" class="null-message" style="display: none">Relative Occupation is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="RelativeQualificationDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="RelativeQualificationTextBox">Relative Qualification</label>
                            <asp:Label ID="RelativeQualificationlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="RelativeQualificationTextBox" CssClass="form-control" runat="server" placeholder="Relative Qualification"></asp:TextBox>
                                <div id="RelativeQualificationnull" class="null-message" style="display: none">Relative Qualification is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="RelativeContactNoDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="RelativeContactNoTextBox">Relative Contact No</label>
                            <asp:Label ID="RelativeContactNolbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="RelativeContactNoTextBox" CssClass="form-control" runat="server"  placeholder="Relative Contact No" onkeypress="return isNumberKey(event)"></asp:TextBox>
                                <div id="RelativeContactNonull" class="null-message" style="display: none">Relative Contact No is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="RelativeMailDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="RelativeMailTextBox">Relative Mail</label>
                            <asp:Label ID="RelativeMaillbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="RelativeMailTextBox" CssClass="form-control" runat="server" placeholder="Relative Mail"  onchange="validateEmail(this)"></asp:TextBox>
                                <div id="RelativeMailnull" class="null-message" style="display: none">Relative Mail is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="RelativeOfficeAddressDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="RelativeOfficeAddressTextBox">Relative Office Address</label>
                            <asp:Label ID="RelativeOfficeAddresslbl" runat="server" class="mandatory" Visible="false"></asp:Label>

                            <div class="input-group">
                                <asp:TextBox ID="RelativeOfficeAddressTextBox" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()"
                                    SkinID="MultiLineTextBox" TextMode="MultiLine" Height="40px" runat="server" placeholder="Relative Office Address"> </asp:TextBox>
                                <div id="RelativeOfficeAddressnull" class="null-message" style="display: none">Relative Office Address is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="RelativeDesignationDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="RelativeDesignationTextBox">Relative Designation</label>
                            <asp:Label ID="RelativeDesignationlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="RelativeDesignationTextBox" CssClass="form-control" runat="server" placeholder="Relative Designation"></asp:TextBox>
                                <div id="RelativeDesignationnull" class="null-message" style="display: none">Relative Designation is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="RelativeOrganizationDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="RelativeOrganizationTextBox">Relative Organization</label>
                            <asp:Label ID="RelativeOrganizationlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="RelativeOrganizationTextBox" CssClass="form-control" runat="server" placeholder="Relative Organization"></asp:TextBox>
                                <div id="RelativeOrganizationnull" class="null-message" style="display: none">Relative Organization is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="RelativeIncomeDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="RelativeIncomeTextBox">Relative Annual Income</label>
                            <asp:Label ID="RelativeIncomelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="RelativeIncomeTextBox" CssClass="form-control" runat="server" placeholder="Relative Annual Income"></asp:TextBox>
                                <div id="RelativeIncomenull" class="null-message" style="display: none">Relative Annual Income is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="ISRelativeExStudentDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label class="material-checkbox">
                            <asp:CheckBox ID="ISRelativeExStudentCheckBox" runat="server" />
                                <span>Relative ExStudent</span>
                            <%--<asp:Label ID="ISRelativeExStudentlbl" runat="server" class="mandatory" ></asp:Label>--%>
                                </label>
                        </div>
                    </div>
                    <div class="col-md-4" id="RelativePassOutYearDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="RelativePassOutYearTextBox">Relative PassOutYear</label>
                            <asp:Label ID="RelativePassOutYearlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="RelativePassOutYearTextBox" CssClass="form-control" runat="server" placeholder="Relative PassOutYear"></asp:TextBox>
                                <div id="RelativePassOutYearnull" class="null-message" style="display: none">Relative PassOutYear is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" runat="server" visible="false" id="RelativePhotoDiv">
                        <div class="bg-white">
                            <label for="RelativePhotoFileUpload">Relative's Photo</label>
                            <asp:Label ID="RelativePhotolbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <div class="file-upload">
                                    <div class="file-select">
                                        <asp:HiddenField ID="HiddenField3" runat="server" />
                                        <asp:HiddenField ID="HiddenField4" runat="server" />
                                        <div class="file-select-button">Choose File</div>
                                        <asp:FileUpload ID="RelativePhotoFileUpload" CssClass="inputfile" runat="server" onchange="ValidateFileSize1(this);" />
                                        <label class="file-select-name"><span></span>No file chosen...</label>

                                    </div>
                                </div>
                                <img runat="server" id="RelativeImage" height="50" width="50" style="margin-top: 10px; width: 78px; height: 69px" />
                                <asp:Label ID="RelativeImageLabel" Text="" runat="server" ForeColor="BlueViolet" />
                                <asp:Label ID="RelativeSuccessImageLabel" Text="Uploaded Successfully" runat="server" Style="display: none"></asp:Label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="LiveWithDiv" visible="false"  runat="server">
                        <div class="bg-white">
                            <label for="LiveWithDropDownList" >Live With</label>
                            <asp:Label ID="LiveWithlbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="LiveWithDropDownList" AutoPostBack="false"  runat="server">
                                </asp:DropDownList>
                                <div id="LiveWithnull" class="null-message" style="display: none">Select Live With</div>
                            </div>
                        </div>
                    </div>
                 </div>
            </div>
            <%--<div class="form-group" id="HealthDetailDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="HealthDetail" runat="server" class=""><i class="fas fa-user-graduate bg-yellow"></i>&nbsp;Health Detail</span>
                        </h5>
                    </div>
                    <div class="col-md-4" id="ISPhysicalDeformityDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <asp:CheckBox ID="ISPhysical DeformityCheckBox1" runat="server" Text="Physical Deformity" />
                        </div>
                    </div>
                    <div class="col-md-4" id="PhysicalDisabilityDiv" visible="false"  runat="server">
                        <div class="bg-white">
                            <label for="PhysicalDisabilityDropDownList" >Physical Disability</label>
                            <asp:Label ID="PhysicalDisabilitylbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="PhysicalDisabilityDropDownList" runat="server">
                                </asp:DropDownList>
                                <div id="PhysicalDisabilitynull" class="null-message" style="display: none">Select Physical Disability</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="PhysicalDisabilityRemarkDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="PhysicalDisabilityRemarkTextBox">Remark</label>
                            <asp:Label ID="PhysicalDisabilityRemarklbl" runat="server" class="mandatory" Visible="false"></asp:Label>

                            <div class="input-group">
                                <asp:TextBox ID="PhysicalDisabilityRemarkTextBox" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()"
                                    SkinID="MultiLineTextBox" TextMode="MultiLine" Height="40px" runat="server" MaxLength="100"> </asp:TextBox>
                                <div id="PhysicalDisabilityRemarknull" class="null-message" style="display: none">Remark is required</div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4" id="MajorIllnessDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <asp:CheckBox ID="ISMajorIllnessCheckBox1" runat="server" Text="Major Illness" />
                        </div>
                    </div>
                    <div class="col-md-4" id="MajorIllnessRemarkDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="MajorIllnessRemarkTextBox">Remark</label>
                            <asp:Label ID="MajorIllnessRemarklbl" runat="server" class="mandatory" Visible="false"></asp:Label>

                            <div class="input-group">
                                <asp:TextBox ID="MajorIllnessRemarkTextBox" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()"
                                    SkinID="MultiLineTextBox" TextMode="MultiLine" Height="40px" runat="server" MaxLength="100"> </asp:TextBox>
                                <div id="MajorIllnessRemarknull" class="null-message" style="display: none">Remark is required</div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4" id="PastHistoryDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <asp:CheckBox ID="ISPastHistoryCheckBox1" runat="server" Text="Past History" />
                        </div>
                    </div>
                    <div class="col-md-4" id="PastHistoryRemarkDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="PastHistoryRemarkTextBox">Remark</label>
                            <asp:Label ID="PastHistoryRemarklbl" runat="server" class="mandatory" Visible="false"></asp:Label>

                            <div class="input-group">
                                <asp:TextBox ID="PastHistoryRemarkTextBox" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()"
                                    SkinID="MultiLineTextBox" TextMode="MultiLine" Height="40px" runat="server" MaxLength="100"> </asp:TextBox>
                                <div id="PastHistoryRemarknull" class="null-message" style="display: none">Remark is required</div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4" id="AllergyDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <asp:CheckBox ID="ISAllergyCheckBox1" runat="server" Text="Allergy" />
                        </div>
                    </div>
                    <div class="col-md-4" id="AllergyRemarkDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="AllergyRemarkTextBox">Remark</label>
                            <asp:Label ID="AllergyRemarklbl" runat="server" class="mandatory" Visible="false"></asp:Label>

                            <div class="input-group">
                                <asp:TextBox ID="AllergyRemarkTextBox" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()"
                                    SkinID="MultiLineTextBox" TextMode="MultiLine" Height="40px" runat="server" MaxLength="100"> </asp:TextBox>
                                <div id="AllergyRemarknull" class="null-message" style="display: none">Remark is required</div>
                            </div>
                        </div>
                    </div>

                   

                    <div class="col-md-4" id="IdentificationMark1Div" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="IdentificationMark1TextBox">Identification Mark1</label>
                            <asp:Label ID="IdentificationMark1lbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="IdentificationMark1TextBox" CssClass="form-control" runat="server" MaxLength="100" ></asp:TextBox>
                                <div id="IdentificationMark1null" class="null-message" style="display: none">Identification Mark1 is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="IdentificationMark2Div" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="IdentificationMark2TextBox">Identification Mark2</label>
                            <asp:Label ID="IdentificationMark2lbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="IdentificationMark2TextBox" CssClass="form-control" runat="server" MaxLength="100" ></asp:TextBox>
                                <div id="IdentificationMark2null" class="null-message" style="display: none">Identification Mark2 is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FamilyDoctorNameDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FamilyDoctorNameTextBox">Family DoctorName</label>
                            <asp:Label ID="FamilyDoctorNamelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FamilyDoctorNameTextBox" CssClass="form-control" runat="server" MaxLength="100" ></asp:TextBox>
                                <div id="FamilyDoctorNamenull" class="null-message" style="display: none">Family DoctorName is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FamilyDoctorContactNoDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FamilyDoctorContactNoTextBox">Family Doctor Contact No</label>
                            <asp:Label ID="FamilyDoctorContactNolbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FamilyDoctorContactNoTextBox" CssClass="form-control" runat="server" MaxLength="100" ></asp:TextBox>
                                <div id="FamilyDoctorContactNonull" class="null-message" style="display: none">Family Doctor Contact No is required</div>

                            </div>
                        </div>
                    </div>

                 </div>
            </div>--%>
             <%-- Addded By Dhananjay for Mantis Start- 0033982  --%>
            <div class="form-group" id="HealthDetailDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="Span1" runat="server" class=""><i class="fas fa-user-graduate bg-yellow"></i>&nbsp;Health Details</span>
                        </h5>
                    </div>
                      
                    <div class="col-md-4" id="ISPhysicalDeformityDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label class="material-checkbox">
                            <asp:CheckBox ID="ISPhysicalDeformityChkbox" runat="server" AutoPostBack="false" onclick="ISPhysicalDeformityChkbox_CheckedChanged()" />
                                <span>Physical Deformity</span>
                                </label>
                        </div>
                    </div>
                     <div class="col-md-4" id="PhysicalDropDownListDiv" visible="false"  runat="server">
                        <div class="bg-white">
                            <label for="PhysicalDropDownListLabel" >Physical Disability</label>
                            <asp:Label ID="Physicallbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:DropDownList CssClass="form-control" ID="PhysicalDropDownList" AutoPostBack="false" runat="server" Enabled="false">
                                </asp:DropDownList>
                            </div>
                        </div>
                    </div>

                     <div class="col-md-4" id="PhysicalDisabilityDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="PhysicalDisabilityLabel">Physical Disability Remark</label>
                            <asp:Label ID="PhysicalDisabilitylbl" runat="server" class="mandatory" Visible="false" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="PhysicalDisabilityTextBox" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()" placeholder="Physical Disability Remark"
                                    SkinID="MultiLineTextBox" TextMode="MultiLine" Height="40px" runat="server"  Enabled="false"> </asp:TextBox>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4" id="MajorIllnesschkDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label class="material-checkbox">
                                <asp:CheckBox ID="MajorIllnessCheckBox" runat="server" AutoPostBack="false" onclick="ISMajorIllnessChkbox_CheckedChanged()"/>
                                <span>Major Illness</span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-8" id="MajorIllnessDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="MajorIllnessLabel">Major Illness Remark</label>
                            <asp:Label ID="MajorIllnesslbl" runat="server" class="mandatory"></asp:Label>
                            <div class="input-group">
                                 <asp:TextBox ID="MajorIllnessTextBox" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()" placeholder="Major Illness Remark"
                                    SkinID="MultiLineTextBox" TextMode="MultiLine" Height="40px" runat="server" Enabled="false"> </asp:TextBox>
                            </div>
                        </div>
                    </div>

                     <div class="col-md-4" id="PastHistorychkDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label class="material-checkbox">
                                <asp:CheckBox ID="PastHistoryCheckBox" runat="server" AutoPostBack="false" onclick="ISPastHistoryChkbox_CheckedChanged()"/>
                                <span>Past History</span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-8" id="PastHistoryDiv" visible="false" runat="server">
                        <div class="bg-white ">
                            <label for="PastHistoryLabel">Past History Remark</label>
                            <asp:Label ID="PastHistorylbl" runat="server" class="mandatory"></asp:Label>
                            <div class="input-group">
                                 <asp:TextBox ID="PastHistoryTextBox" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()" placeholder="Past History Remark"
                                    SkinID="MultiLineTextBox" TextMode="MultiLine" Height="40px" runat="server" Enabled ="false"> </asp:TextBox>

                            </div>
                        </div>
                    </div>

                     <div class="col-md-4" id="AllergychkDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label class="material-checkbox">
                                <asp:CheckBox ID="AllergyCheckBox" runat="server" AutoPostBack="false" onclick="ISAllergyChkbox_CheckedChanged()" />
                                <span>Allergy</span>
                            </label>
                        </div>
                    </div>
                      <div class="col-md-8" id="AllergyDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="AllergyLabel">Allergy Remark</label>
                            <asp:Label ID="Allergylbl" runat="server" class="mandatory"></asp:Label>
                            <div class="input-group">
                              <asp:TextBox ID="AllergyTextBox" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()" placeholder="Allergy Remark"
                                    SkinID="MultiLineTextBox" TextMode="MultiLine" Height="40px" runat="server" Enabled="false"> </asp:TextBox>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4" id="IdentificationMark1Div" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="IdentificationMark1Label">Identification Mark1</label>
                            <asp:Label ID="IdentificationMark1lbl" runat="server" class="mandatory"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="IdentificationMark1TextBox" CssClass="form-control" runat="server" MaxLength="100"></asp:TextBox>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 " id="IdentificationMark2Div" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="IdentificationMark2Label">Identification Mark2</label>
                            <asp:Label ID="IdentificationMark2lbl" runat="server" class="mandatory"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="IdentificationMark2TextBox" CssClass="form-control" runat="server" MaxLength="100"></asp:TextBox>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FamilyDoctorNameDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FamilyDoctorNameLabel">Family Doctor Name</label>
                            <asp:Label ID="FamilyDoctorNamelbl" runat="server" class="mandatory"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FamilyDoctorNameTextBox" CssClass="form-control" runat="server" MaxLength="100"></asp:TextBox>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="FamilyDoctorContactNoDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="FamilyDoctorContactNoLabel">Family Doctor Contact No</label>
                            <asp:Label ID="FamilyDoctorContactNolbl" runat="server" class="mandatory"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="FamilyDoctorContactNoTextBox" CssClass="form-control" runat="server" MaxLength="100"  onkeypress="return isNumberKeys(event)" ></asp:TextBox>
                            </div>
                        </div>
                    </div>
                 </div>
            </div>
             <%-- Addded By Dhananjay for Mantis End- 0033982  --%>




            <div class="form-group" id="BankDetailDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="BankDetail" runat="server" class=""><i class="fas fa-user-graduate bg-yellow"></i>&nbsp;Bank Detail</span>
                        </h5>
                    </div>
                    <div class="col-md-4" id="BankAccountNumberDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="BankAccountNumberTextBox">Bank Account Number</label>
                            <asp:Label ID="BankAccountNumberlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="BankAccountNumberTextBox" CssClass="form-control" runat="server" onkeypress="return isNumberKey(event)" placeholder="Bank Account Number"></asp:TextBox>
                                <div id="BankAccountNumbernull" class="null-message" style="display: none">Bank Account Number is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="BankNameDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="BankNameTextBox">Bank Name</label>
                            <asp:Label ID="BankNamelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="BankNameTextBox" CssClass="form-control" runat="server" placeholder="Bank Name"></asp:TextBox>
                                <div id="BankNamenull" class="null-message" style="display: none">Bank Name is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="BankBranchDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="BankBranchTextBox">Bank Branch</label>
                            <asp:Label ID="BankBranchlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="BankBranchTextBox" CssClass="form-control" runat="server" placeholder="Bank Branch"></asp:TextBox>
                                <div id="BankBranchnull" class="null-message" style="display: none">Bank Branch is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="BankIFSCCodeDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="BankIFSCCodeTextBox">Bank IFSC Code</label>
                            <asp:Label ID="BankIFSCCodelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="BankIFSCCodeTextBox" CssClass="form-control" runat="server" placeholder="Bank IFSC Code"></asp:TextBox>
                                <div id="BankIFSCCodenull" class="null-message" style="display: none">Bank IFSC Code is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="BankAccountHolderNameDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="BankAccountHolderNameTextBox">Bank Account Holder Name</label>
                            <asp:Label ID="BankAccountHolderNamelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="BankAccountHolderNameTextBox" CssClass="form-control" runat="server" placeholder="Bank Account Holder Name"></asp:TextBox>
                                <div id="BankAccountHolderNamenull" class="null-message" style="display: none">Bank Account Holder Name is required</div>

                            </div>
                        </div>
                    </div>
                 </div>
            </div>
            <div class="form-group" id="BoardDetailDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="BoardDetail" runat="server" class=""><i class="fas fa-user-graduate bg-yellow"></i>&nbsp;Board Detail</span>
                        </h5>
                    </div>
                    <div class="col-md-4" id="Class9BoardRegistrationNumberDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="Class9BoardRegistrationNumberTextBox">Class9 Board Registration Number</label>
                            <asp:Label ID="Class9BoardRegistrationNumberlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="Class9BoardRegistrationNumberTextBox" CssClass="form-control" runat="server" placeholder="Class9 Board Registration Number"></asp:TextBox>
                                <div id="Class9BoardRegistrationNumbernull" class="null-message" style="display: none">Class9 Board Registration Number is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="Class11BoardRegistrationNumberDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="Class11BoardRegistrationNumberTextBox">Class11 Board Registration Number</label>
                            <asp:Label ID="Class11BoardRegistrationNumberlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="Class11BoardRegistrationNumberTextBox" CssClass="form-control" runat="server" placeholder="Class11 Board Registration Number"></asp:TextBox>
                                <div id="Class11BoardRegistrationNumbernull" class="null-message" style="display: none">Class11 Board Registration Number is required</div>

                            </div>
                        </div>
                    </div>
                 </div>
            </div>
            <div class="form-group" id="PassportDetailDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="PassportDetail" runat="server" class=""><i class="fas fa-user-graduate bg-yellow"></i>&nbsp;Passport Detail</span>
                        </h5>
                    </div>
                    <div class="col-md-4" id="PassportNumberDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="PassportNumberTextBox">Passport Number</label>
                            <asp:Label ID="PassportNumberlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="PassportNumberTextBox" CssClass="form-control" runat="server" placeholder="Passport Number"></asp:TextBox>
                                <div id="PassportNumbernull" class="null-message" style="display: none">Passport Number is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="PassportTypeDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="PassportTypeTextBox">Passport Type</label>
                            <asp:Label ID="PassportTypelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="PassportTypeTextBox" CssClass="form-control" runat="server" placeholder="Passport Type"></asp:TextBox>
                                <div id="PassportTypenull" class="null-message" style="display: none">Passport Type is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="PassportCountryCodeDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="PassportCountryCodeTextBox">Passport Country Code</label>
                            <asp:Label ID="PassportCountryCodelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="PassportCountryCodeTextBox" CssClass="form-control" runat="server" placeholder="Passport Country Code"></asp:TextBox>
                                <div id="PassportCountryCodenull" class="null-message" style="display: none">Passport Country Code is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="PassportIssueDateDiv"  visible="false" runat="server" >
                        <div class="bg-white">
                            <label for="PassportIssueDateDatePickerControl" >Passport Issue Date</label>
                            <asp:Label ID="PassportIssueDatelbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" CssClass="form-control DatePickerControl" ID="PassportIssueDateDatePickerControl" placeholder="dd/mm/yyyy" onkeyup="FormatIt(this);" AutoPostBack="false" />
                                <div id="PassportIssueDatenull" class="null-message" style="display: none">Passport Issue Date is required</div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="PassportExpiryDateDiv"  visible="false" runat="server" >
                        <div class="bg-white">
                            <label for="PassportExpiryDateDatePickerControl" >Passport Expiry Date</label>
                            <asp:Label ID="PassportExpiryDatelbl" runat="server" class="mandatory" Visible="false"></asp:Label>
                            <div class="input-group">
                                <asp:TextBox runat="server" CssClass="form-control DatePickerControl" ID="PassportExpiryDateDatePickerControl" placeholder="dd/mm/yyyy"  onkeyup="FormatIt(this);" AutoPostBack="false" />
                                <div id="PassportExpiryDatenull" class="null-message" style="display: none">Passport Expiry Date is required</div>
                            </div>
                        </div>
                    </div>
                 </div>
            </div>
            <%--<div class="form-group" id="SiblingDetailDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="SiblingDetail" runat="server" class=""><i class="fas fa-user-graduate bg-yellow"></i>&nbsp;Sibling Detail</span>
                        </h5>
                    </div>

                 </div>
            </div>--%>
            <div class="form-group" id="SSCResultDetailDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="SSCResultDetail" runat="server" class=""><i class="fas fa-user-graduate bg-yellow"></i>&nbsp;SSC Result Detail</span>
                        </h5>
                    </div>
                    <div class="col-md-4" id="SSCBoardDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="SSCBoardTextBox">SSC Board</label>
                            <asp:Label ID="SSCBoardlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="SSCBoardTextBox" CssClass="form-control" runat="server" placeholder="SSC Board"></asp:TextBox>
                                <div id="SSCBoardnull" class="null-message" style="display: none">SSC Board is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="SSCSchoolDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="SSCSchoolTextBox">SSC School</label>
                            <asp:Label ID="SSCSchoollbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="SSCSchoolTextBox" CssClass="form-control" runat="server" placeholder="SSC School"></asp:TextBox>
                                <div id="SSCSchoolnull" class="null-message" style="display: none">SSC School is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="SSCPassingYearDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="SSCPassingYearTextBox">SSC Passing Year</label>
                            <asp:Label ID="SSCPassingYearlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="SSCPassingYearTextBox" CssClass="form-control" runat="server" placeholder="SSC Passing Year"></asp:TextBox>
                                <div id="SSCPassingYearnull" class="null-message" style="display: none">SSC Passing Year is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="SSCObtainMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="SSCObtainMarksTextBox">SSC Obtain Marks</label>
                            <asp:Label ID="SSCObtainMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="SSCObtainMarksTextBox" CssClass="form-control" runat="server" placeholder="SSC Obtain Marks"></asp:TextBox>
                                <div id="SSCObtainMarksnull" class="null-message" style="display: none">SSC Obtain Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="SSCOutOfMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="SSCOutOfMarksTextBox">SSC OutOf Marks</label>
                            <asp:Label ID="SSCOutOfMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="SSCOutOfMarksTextBox" CssClass="form-control" runat="server" placeholder="SSC OutOf Marks"></asp:TextBox>
                                <div id="SSCOutOfMarksnull" class="null-message" style="display: none">SSC OutOf Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="SSCPercentageDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="SSCPercentageTextBox">SSC Percentage</label>
                            <asp:Label ID="SSCPercentagelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="SSCPercentageTextBox" CssClass="form-control" runat="server" placeholder="SSC Percentage"></asp:TextBox>
                                <div id="SSCPercentagenull" class="null-message" style="display: none">SSC Percentage is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="SSCMathMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="SSCMathMarksTextBox">SSC Math Marks</label>
                            <asp:Label ID="SSCMathMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="SSCMathMarksTextBox" CssClass="form-control" runat="server" placeholder="SSC Math Marks"></asp:TextBox>
                                <div id="SSCMathMarksnull" class="null-message" style="display: none">SSC Math Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="SSCMathOutOfMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="SSCMathOutOfMarksTextBox">SSC Math OutOf Marks</label>
                            <asp:Label ID="SSCMathOutOfMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="SSCMathOutOfMarksTextBox" CssClass="form-control" runat="server" placeholder="SSC Math OutOf Marks"></asp:TextBox>
                                <div id="SSCMathOutOfMarksnull" class="null-message" style="display: none">SSC Math OutOf Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="SSCPercentileDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="SSCPercentileTextBox">SSC Percentile</label>
                            <asp:Label ID="SSCPercentilelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="SSCPercentileTextBox" CssClass="form-control" runat="server" placeholder="SSC Percentile"></asp:TextBox>
                                <div id="SSCPercentilenull" class="null-message" style="display: none">SSC Percentile is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="SSCGradeDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="SSCGradeTextBox">SSC Grade</label>
                            <asp:Label ID="SSCGradelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="SSCGradeTextBox" CssClass="form-control" runat="server" placeholder="SSC Grade"></asp:TextBox>
                                <div id="SSCGradenull" class="null-message" style="display: none">SSC Grade is required</div>

                            </div>
                        </div>
                    </div>
                 </div>
            </div>
            <div class="form-group" id="HSCResultDetailDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="HSCResultDetail" runat="server" class=""><i class="fas fa-user-graduate bg-yellow"></i>&nbsp;HSC Result Detail</span>
                        </h5>
                    </div>
                    <div class="col-md-4" id="HSCBoardDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="HSCBoardTextBox">HSC Board</label>
                            <asp:Label ID="HSCBoardlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="HSCBoardTextBox" CssClass="form-control" runat="server" placeholder="HSC Board"></asp:TextBox>
                                <div id="HSCBoardnull" class="null-message" style="display: none">HSC Board is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="HSCSchoolDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="HSCSchoolTextBox">HSC School</label>
                            <asp:Label ID="HSCSchoollbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="HSCSchoolTextBox" CssClass="form-control" runat="server" placeholder="HSC School"></asp:TextBox>
                                <div id="HSCSchoolnull" class="null-message" style="display: none">HSC School is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="HSCPassingYearDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="HSCPassingYearTextBox">HSC Passing Year</label>
                            <asp:Label ID="HSCPassingYearlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="HSCPassingYearTextBox" CssClass="form-control" runat="server" placeholder="HSC Passing Year"></asp:TextBox>
                                <div id="HSCPassingYearnull" class="null-message" style="display: none">HSC Passing Year is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="HSCObtainMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="HSCObtainMarksTextBox">HSC Obtain Marks</label>
                            <asp:Label ID="HSCObtainMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="HSCObtainMarksTextBox" CssClass="form-control" runat="server" placeholder="HSC Obtain Marks"></asp:TextBox>
                                <div id="HSCObtainMarksnull" class="null-message" style="display: none">HSC Obtain Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="HSCOutOfMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="HSCOutOfMarksTextBox">HSC OutOf Marks</label>
                            <asp:Label ID="HSCOutOfMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="HSCOutOfMarksTextBox" CssClass="form-control" runat="server" placeholder="HSC OutOf Marks"></asp:TextBox>
                                <div id="HSCOutOfMarksnull" class="null-message" style="display: none">HSC OutOf Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="HSCPercentageDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="HSCPercentageTextBox">HSC Percentage</label>
                            <asp:Label ID="HSCPercentagelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="HSCPercentageTextBox" CssClass="form-control" runat="server" placeholder="HSC Percentage"></asp:TextBox>
                                <div id="HSCPercentagenull" class="null-message" style="display: none">HSC Percentage is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="HSCPhysicsMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="HSCPhysicsMarksTextBox">HSC Physics Marks</label>
                            <asp:Label ID="HSCPhysicsMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="HSCPhysicsMarksTextBox" CssClass="form-control" runat="server" placeholder="HSC Physics Marks"></asp:TextBox>
                                <div id="HSCPhysicsMarksnull" class="null-message" style="display: none">HSC Physics Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="HSCPhysicsOutOfMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="HSCPhysicsOutOfMarksTextBox">HSC Physics OutOf Marks</label>
                            <asp:Label ID="HSCPhysicsOutOfMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="HSCPhysicsOutOfMarksTextBox" CssClass="form-control" runat="server" placeholder="HSC Physics OutOf Marks"></asp:TextBox>
                                <div id="HSCPhysicsOutOfMarksnull" class="null-message" style="display: none">HSC Physics OutOf Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="HSCChemistryMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="HSCChemistryMarksTextBox">HSC Chemistry Marks</label>
                            <asp:Label ID="HSCChemistryMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="HSCChemistryMarksTextBox" CssClass="form-control" runat="server" placeholder="HSC Chemistry Marks"></asp:TextBox>
                                <div id="HSCChemistryMarksnull" class="null-message" style="display: none">HSC Chemistry Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="HSCChemistryOutOfMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="HSCChemistryOutOfMarksTextBox">HSC Chemistry OutOf Marks</label>
                            <asp:Label ID="HSCChemistryOutOfMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="HSCChemistryOutOfMarksTextBox" CssClass="form-control" runat="server" placeholder="HSC Chemistry OutOf Marks"></asp:TextBox>
                                <div id="HSCChemistryOutOfMarksnull" class="null-message" style="display: none">HSC Chemistry OutOf Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="HSCMathMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="HSCMathMarksTextBox">HSC Math Marks</label>
                            <asp:Label ID="HSCMathMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="HSCMathMarksTextBox" CssClass="form-control" runat="server" placeholder="HSC Math Marks"></asp:TextBox>
                                <div id="HSCMathMarksnull" class="null-message" style="display: none">HSC Math Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="HSCMathOutOfMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="HSCMathOutOfMarksTextBox">HSC Math OutOf Marks</label>
                            <asp:Label ID="HSCMathOutOfMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="HSCMathOutOfMarksTextBox" CssClass="form-control" runat="server" placeholder="HSC Math OutOf Marks"></asp:TextBox>
                                <div id="HSCMathOutOfMarksnull" class="null-message" style="display: none">HSC Math OutOf Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="HSCBiologyMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="HSCBiologyMarksTextBox">HSC Biology Marks</label>
                            <asp:Label ID="HSCBiologyMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="HSCBiologyMarksTextBox" CssClass="form-control" runat="server" placeholder="HSC Biology Marks"></asp:TextBox>
                                <div id="HSCBiologyMarksnull" class="null-message" style="display: none">HSC Biology Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="HSCBiologyOutOfMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="HSCBiologyOutOfMarksTextBox">HSC Biology OutOf Marks</label>
                            <asp:Label ID="HSCBiologyOutOfMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="HSCBiologyOutOfMarksTextBox" CssClass="form-control" runat="server" placeholder="HSC Biology OutOf Marks"></asp:TextBox>
                                <div id="HSCBiologyOutOfMarksnull" class="null-message" style="display: none">HSC Biology OutOf Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="PCMMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="PCMMarksTextBox">PCM Marks</label>
                            <asp:Label ID="PCMMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="PCMMarksTextBox" CssClass="form-control" runat="server" placeholder="PCM Marks"></asp:TextBox>
                                <div id="PCMMarksnull" class="null-message" style="display: none">PCM Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="PCBMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="PCBMarksTextBox">PCB Marks</label>
                            <asp:Label ID="PCBMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="PCBMarksTextBox" CssClass="form-control" runat="server" placeholder="PCB Marks"></asp:TextBox>
                                <div id="PCBMarksnull" class="null-message" style="display: none">PCB Marks is required</div>

                            </div>
                        </div>
                    </div>
                 </div>
            </div>
            <div class="form-group" id="JEEDetailDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="JEEDetail" runat="server" class=""><i class="fas fa-user-graduate bg-yellow"></i>&nbsp;JEE Detail</span>
                        </h5>
                    </div>
                    <div class="col-md-4" id="JEERollNoDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="JEERollNoTextBox">JEE Roll No</label>
                            <asp:Label ID="JEERollNolbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="JEERollNoTextBox" CssClass="form-control" runat="server" placeholder="JEE Roll No"></asp:TextBox>
                                <div id="JEERollNonull" class="null-message" style="display: none">JEE Roll No is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="JEEMeritNoDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="JEEMeritNoTextBox">JEE Merit No</label>
                            <asp:Label ID="JEEMeritNolbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="JEEMeritNoTextBox" CssClass="form-control" runat="server" placeholder="JEE Merit No"></asp:TextBox>
                                <div id="JEEMeritNonull" class="null-message" style="display: none">JEE Merit No is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="JEEMeritMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="JEEMeritMarksTextBox">JEE Merit Marks</label>
                            <asp:Label ID="JEEMeritMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="JEEMeritMarksTextBox" CssClass="form-control" runat="server" placeholder="JEE Merit Marks"></asp:TextBox>
                                <div id="JEEMeritMarksnull" class="null-message" style="display: none">JEE Merit Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="JEEOutOfMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="JEEOutOfMarksTextBox">JEE OutOf Marks</label>
                            <asp:Label ID="JEEOutOfMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="JEEOutOfMarksTextBox" CssClass="form-control" runat="server" placeholder="JEE OutOf Marks"></asp:TextBox>
                                <div id="JEEOutOfMarksnull" class="null-message" style="display: none">JEE OutOf Marks is required</div>

                            </div>
                        </div>
                    </div>
                 </div>
            </div>
            <div class="form-group" id="DiplomaDetailDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="DiplomaDetail" runat="server" class=""><i class="fas fa-user-graduate bg-yellow"></i>&nbsp;Diploma Detail</span>
                        </h5>
                    </div>
                    <div class="col-md-4" id="DiplomaBoardDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="DiplomaBoardTextBox">Diploma Board</label>
                            <asp:Label ID="DiplomaBoardlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="DiplomaBoardTextBox" CssClass="form-control" runat="server" placeholder="Diploma Board"></asp:TextBox>
                                <div id="DiplomaBoardnull" class="null-message" style="display: none">Diploma Board is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="DiplomaCollegeDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="DiplomaCollegeTextBox">Diploma College</label>
                            <asp:Label ID="DiplomaCollegelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="DiplomaCollegeTextBox" CssClass="form-control" runat="server" placeholder="Diploma College"></asp:TextBox>
                                <div id="DiplomaCollegenull" class="null-message" style="display: none">Diploma College is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="DiplomaPassingYearDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="DiplomaPassingYearTextBox">Diploma Passing Year</label>
                            <asp:Label ID="DiplomaPassingYearlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="DiplomaPassingYearTextBox" CssClass="form-control" runat="server" placeholder="Diploma Passing Year"></asp:TextBox>
                                <div id="DiplomaPassingYearnull" class="null-message" style="display: none">Diploma Passing Year is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="DiplomaObtainMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="DiplomaObtainMarksTextBox">Diploma Obtain Marks</label>
                            <asp:Label ID="DiplomaObtainMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="DiplomaObtainMarksTextBox" CssClass="form-control" runat="server" placeholder="Diploma Obtain Marks"></asp:TextBox>
                                <div id="DiplomaObtainMarksnull" class="null-message" style="display: none">Diploma Obtain Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="DiplomaOutOfMarksDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="DiplomaOutOfMarksTextBox">Diploma OutOf Marks</label>
                            <asp:Label ID="DiplomaOutOfMarkslbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="DiplomaOutOfMarksTextBox" CssClass="form-control" runat="server" placeholder="Diploma OutOf Marks"></asp:TextBox>
                                <div id="DiplomaOutOfMarksnull" class="null-message" style="display: none">Diploma OutOf Marks is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="DiplomaPercentageDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="DiplomaPercentageTextBox">Diploma Percentage</label>
                            <asp:Label ID="DiplomaPercentagelbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="DiplomaPercentageTextBox" CssClass="form-control" runat="server" placeholder="Diploma Percentage"></asp:TextBox>
                                <div id="DiplomaPercentagenull" class="null-message" style="display: none">Diploma Percentage is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="ApplicationIdDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="ApplicationIdTextBox">Application Id</label>
                            <asp:Label ID="ApplicationIdlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="ApplicationIdTextBox" CssClass="form-control" runat="server" placeholder="Application Id"></asp:TextBox>
                                <div id="ApplicationIdnull" class="null-message" style="display: none">Application Id is required</div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" id="AdmissionRoundDiv" visible="false" runat="server">
                        <div class="bg-white">
                            <label for="AdmissionRoundTextBox">Admission Round</label>
                            <asp:Label ID="AdmissionRoundlbl" runat="server" class="mandatory" ></asp:Label>
                            <div class="input-group">
                                <asp:TextBox ID="AdmissionRoundTextBox" CssClass="form-control" runat="server" placeholder="Admission Round"></asp:TextBox>
                                <div id="AdmissionRoundnull" class="null-message" style="display: none">Admission Round is required</div>

                            </div>
                        </div>
                    </div>
                 </div>
            </div>
            <%--<div class="form-group" id="AutoAssignFeeDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="AutoAssignFee" runat="server" class=""><i class="fas fa-user-graduate bg-yellow"></i>&nbsp;Auto Assign Fee</span>
                        </h5>
                    </div>

                 </div>
            </div>--%>

            <div class="row form-group">
                <div class="col-md-12" id="OptionalSubjectDiv" runat="server" visible="false" style="height: fit-content">
                    <div class="topic-header">
                        <h5>
                            <span id="OptionalSubjectSpan" runat="server" text=""><i class="fas fa-info-circle bg-dpurp"></i>&nbsp;Assign Optional Subject</span>
                        </h5>
                    </div>
                    <div class="col-lg-12 bg-white">
                        <asp:CheckBoxList ID="AssignOptionalSubjectCheckBoxList" runat="server" RepeatDirection="Horizontal" RepeatColumns="5"  BackColor="White" CellPadding="10" style="color:white"> 
                        </asp:CheckBoxList>
                    </div>
                </div>
            </div>
           
            <div class="form-group" id="OnlineRegistrationCriteriaFormDiv" visible="false" runat="server">
                <div class="col-lg-12 padd-0">
                    <div class="topic-header">
                        <h5>
                            <span id="DynamicOnlineRegistrationFromFiledHeaderLabel" runat="server" text=""><i class="fas fa-info-circle bg-dpurp"></i>&nbsp;More Details</span>
                        </h5>
                    </div>
                    <div class="col-lg-12 bg-white">
                        <div class="table-responsive padd-5">
                            <asp:GridView runat="server" ID="OnlineRegistrationCriteriaFormGridView" AutoGenerateColumns="False"
                                EmptyDataText="No records available for the seacrh criteria!" OnRowDataBound="OnlineRegistrationCriteriaFormGridView_RowDataBound"
                                AllowPaging="false" DataKeyNames="Id,FieldTypeId,FieldList,IsFieldMandatory,OnlineRegistrationFormFieldResponse" ShowHeader="true"
                                CssClass="table table-striped table-bordered table-hover more" Oncol-lg-12DataBound="OnlineRegistrationSetupGridView_col-lg-12DataBound">
                                <Columns>
                                    <asp:BoundField DataField="FieldGroup" ItemStyle-Width="15%" HeaderStyle-HorizontalAlign="Left" />
                                    <asp:BoundField DataField="FieldRemark" ItemStyle-Width="40%" HeaderStyle-HorizontalAlign="Left" />
                                    <asp:TemplateField HeaderText="Mandatory" ItemStyle-Width="5%" SortExpression="IsFieldMandatory"
                                        HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center" ItemStyle-Wrap="true">
                                        <ItemTemplate>
                                            <asp:Label ID="IsFieldMandatoryLabel" runat="server" Text='<%# DataBinder.Eval(Container.DataItem,"IsFieldMandatory").ToString().ToUpper()=="TRUE"?"*":"" %>' class="text-red font-23"></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField ItemStyle-Width="40%" HeaderText="" ItemStyle-HorizontalAlign="Center" ItemStyle-Wrap="true" HeaderStyle-HorizontalAlign="Left">
                                        <ItemTemplate>
                                            <asp:DropDownList ID="FieldTypeDropDownList" runat="server" Visible="false" CssClass="form-control"></asp:DropDownList>
                                            <asp:TextBox ID="FieldTypeTextBox" runat="server" Visible="false" CssClass="form-control" TextMode="MultiLine" Height="50px"></asp:TextBox>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                </Columns>
                                <PagerSettings Visible="False" />
                            </asp:GridView>

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12 text-center">
                <asp:Button ID="RegisterButton" runat="server" CssClass="btn green fas" Text="&#xf044; Submit" OnClick="RegisterButton_Click" OnClientClick="return confirm('Are you sure you want to Register ?')" />
                <asp:Button ID="CancelButton" Text="&#xf00d; Clear" CssClass="btn red fas" runat="server" OnClick="CancelButton_Click" />
            </div>
        </form>
    </div>
</body>
</html>
<script src='<%# ResolveUrl("~/App_Themes/BlackTheme/plugins/jQueryUI/jquery-ui.min.js")%>' type="text/javascript"></script>
<script src="//code.jquery.com/jquery-1.10.2.js"></script>
<script src="//code.jquery.com/ui/1.11.4/jquery-ui.js"></script>
<script data-main='<%=ResolveUrl("~/JavaScript/rjs/student-all")%>' src='<%=ResolveUrl("~/JavaScript/rjs/require.js")%>'></script>
<script type="text/javascript">
    $(function () {
        var currentYear = (new Date).getFullYear();
        $(".DatePickerControl").datepicker({
            dateFormat: 'dd/mm/yy',
            changeYear: true,
            changeMonth: true,
            yearRange: "1950:currentYear"
        }).val();
    });
    function FormatIt(obj) {
        if (obj.value.length == 2)
            obj.value = obj.value + "/";
        if (obj.value.length == 5)
            obj.value = obj.value + "/";
    }
    function isNumberKeys(evt) {
        var charcode = (evt.which) ? evt.which : event.keycode;
        if ((charcode >= 48 && charcode <= 57) || charcode == 32)
            return true;
        return false;
    }
   
</script>
<script>
    $(function () {
        $("#IsTransferCheckBox").click(function () {
            if ($(this).is(":checked")) {
                $('#TransferFromTextBox').removeAttr("disabled");
            } else {
                $('#TransferFromTextBox').attr("disabled", "disabled");
            }
        });
        $("#IsCertificateHolderCheckBox").click(function () {
            if ($(this).is(":checked")) {
                $('#CertificateNameTextBox').removeAttr("disabled");
            } else {
                $('#CertificateNameTextBox').attr("disabled", "disabled");
            }
        });
    });
   
    //$(function () {
    //    $('#ISFatherExStudentCheckBox').click(function () {
    //        if ($(this).is(':checked')) {
    //           $('#FatherPassOutYearDiv').show();
    //           // $("#FatherPassOutYearTextBox").removeAttr("disabled");
    //        }
    //        else {
    //            $('#FatherPassOutYearDiv').hide();
    //        }
    //    });
    //});
    //$(function () {
    //    $('#ISMotherExStudentCheckBox').click(function () {
    //        if ($(this).is(':checked')) {
    //            $("#MotherPassOutYearDiv").show();
    //            //$("#MotherPassOutyearTextBox").focus();
    //        }
    //        else {
    //            $("#MotherPassOutYearDiv").hide();
    //        }
    //    });
    //});

    //$(function () {
    //    $('#ISRelativeExStudentCheckBox').click(function () {
    //        if ($(this).is(':checked')) {
    //            $("#RelativePassOutYearDiv").show();
    //            //$("#RelativePassOutYearTextBox").focus();
    //        }
    //        else {
    //            $("#RelativePassOutYearDiv").hide();
    //        }
    //    });
    //});

    function ValidateFileSize1(obj) {
        if (Validate(obj)) {

            var id = obj.id;
            var file_size = (document.getElementById(id).files[0].size / 1024);
            var SizeLimit = $('#ImageMaxSize').val();
            
            if ($('#AttachmentSizeHiddenField').val() != '') {
                if (file_size > $('#AttachmentSizeHiddenField').val()) {
                    alert('File should be less than ' + $('#AttachmentSizeHiddenField').val() + ' KB');
                    document.getElementById(id).value = "";
                }

                else {

                    if (id == "StudentPhotoFileUpload") {
                        document.getElementById('StudentImage').src = window.URL.createObjectURL(obj.files[0]);
                        document.getElementById('StudentSuccessImageLabel').style.display = 'inherit';
                    }
                    else if (id == "FatherPhotoFileUpload") {
                        document.getElementById('FatherImage').src = window.URL.createObjectURL(obj.files[0]);
                        document.getElementById('FatherSuccessImageLabel').style.display = 'inherit';
                    }
                    else if (id == "MotherPhotoFileUpload") {
                        document.getElementById('MotherImage').src = window.URL.createObjectURL(obj.files[0]);
                        document.getElementById('MotherSuccessImageLabel').style.display = 'inherit';
                    }
                    else if (id == "RelativePhotoFileUpload") {
                        document.getElementById('RelativeImage').src = window.URL.createObjectURL(obj.files[0]);
                        document.getElementById('RelativeSuccessImageLabel').style.display = 'inherit';
                    }
                }
            }
                
        }

            //else
            //{
            //    document.getElementById("StudentFileUpload").value = '';
            //    document.getElementById("FatherFileUpload").value = '';
            //    document.getElementById("MotherFileUpload").value = '';
            //    document.getElementById("GuardianFileUpload").value = '';

            //}
        

    }

    function Validate(obj) {
        var id = obj.id;
        var file = document.getElementById(id).value;
        var validExtensions = ["jpg", "jpeg", "bmp", "png"]
        var file1 = file.split('.').pop();
        if (validExtensions.indexOf(file1) == -1) {
            alert("Image should be in format : " + validExtensions.join(', '));
            document.getElementById(id).value = "";
            return false;
        }
        else
            return true;
    }
    function validateEmail(email) {
        var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
        if (!filter.test(email.value)) {
            alert('Please provide a valid email address');
            email.focus;
            email.value = "";
            return false;
        }
    }
    //Addded By Dhananjay for Mantis Start- 0033982
    function ISPhysicalDeformityChkbox_CheckedChanged() {
        try {
            var checkbox = document.getElementById('<%= ISPhysicalDeformityChkbox.ClientID %>');
            var dropdown = document.getElementById('<%= PhysicalDropDownList.ClientID %>');
            var textBox = document.getElementById('<%= PhysicalDisabilityTextBox.ClientID %>');

            if (checkbox.checked) {
                dropdown.disabled = false;
                textBox.disabled = false;
                dropdown.focus();
            } else {
                dropdown.disabled = true;
                textBox.disabled = true;
                checkbox.focus();
            }
        } catch (ex) {
            console.error(ex);
        }
    }

    function ISMajorIllnessChkbox_CheckedChanged() {
        try {
            var checkbox = document.getElementById('<%= MajorIllnessCheckBox.ClientID %>');
            var textBox = document.getElementById('<%= MajorIllnessTextBox.ClientID %>');

            if (checkbox.checked) {
                textBox.disabled = false;
                textBox.focus();
            } else {
                textBox.disabled = true;
                checkbox.focus();
            }
        } catch (ex) {
            console.error(ex);
        }
    }

    function ISPastHistoryChkbox_CheckedChanged() {
        try {
            var checkbox = document.getElementById('<%= PastHistoryCheckBox.ClientID %>');
            var textBox = document.getElementById('<%= PastHistoryTextBox.ClientID %>');

            if (checkbox.checked) {
                textBox.disabled = false;
                textBox.focus();
            } else {
                textBox.disabled = true;
                checkbox.focus();
            }
        } catch (ex) {
            console.error(ex);
        }
    }

    function ISAllergyChkbox_CheckedChanged() {
        try {
            var checkbox = document.getElementById('<%= AllergyCheckBox.ClientID %>');
            var textBox = document.getElementById('<%= AllergyTextBox.ClientID %>');

            if (checkbox.checked) {
                textBox.disabled = false;
                textBox.focus();
            } else {
                textBox.disabled = true;
                checkbox.focus();
            }
        } catch (ex) {
            console.error(ex);
        }
    }
    //Addded By Dhananjay for Mantis End- 0033982
</script>