﻿<%@ WebService Language="C#" Class="WindowPortalDataSynchService" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using Sapphire.Vidyalaya.BusinessLogic.Business.InstituteManagement.SetupBL;
using Sapphire.Vidyalaya.BusinessLogic.Business.Library.LibraryBL;
using Sapphire.Vidyalaya.BusinessLogic.Business.Attendance.AttendanceBL;
using Sapphire.Ohu.BaseFramework.Utilities;
using Sapphire.Ohu.BusinessEntity.Framework.BaseFrameworkBE;
using System.Data;
using Sapphire.Ohu.BusinessEntity.Component.AlertBE;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
// [System.Web.Script.Services.ScriptService]
public class WindowPortalDataSynchService : System.Web.Services.WebService
{


    // vs command prompt wsdl http://localhost:5568/Services/WindowPortalDataSynchService.asmx
    // browse the service and put /service before part of url in config file
    //string SyncServiceUrl = System.Configuration.ConfigurationManager.AppSettings["SyncServiceUrl"];
    ///// <remarks/>
    //public WindowPortalDataSynchService()
    //{
    //    this.Url = SyncServiceUrl + "/WindowPortalDataSynchService.asmx";
    //}


    #region Service Client

    private WindowsPortalSynchDataService WindowsPortalSynchDataServiceClient
    {
        get { return new WindowsPortalSynchDataService(); }
    }

    private CommonFunctions CommonFunctionServiceClient
    {
        get { return new CommonFunctions(); }
    }

    #endregion


    #region Data Synch

    [WebMethod]
    public DataSet WindowPortalGetQueryData(string SQL_Query)
    {
        return WindowsPortalSynchDataServiceClient.GetQueryData(SQL_Query);
    }

    [WebMethod]
    public Int32 WindowPortalClassMasterAdd(string strXML, int OrgId)
    {
        return WindowsPortalSynchDataServiceClient.ClassMasterAdd(strXML, OrgId);
    }

    [WebMethod]
    public Int32 WindowPortalDivisionMasterAdd(string strXML, int OrgId)
    {
        return WindowsPortalSynchDataServiceClient.DivisionMasterAdd(strXML, OrgId);
    }

    [WebMethod]
    public Int32 WindowPortalSubjectMasterAdd(string strXML, int OrgId)
    {
        return WindowsPortalSynchDataServiceClient.SubjectMasterAdd(strXML, OrgId);
    }

    [WebMethod]
    public Int32 WindowPortalDesignationMasterAdd(string strXML, int OrgId)
    {
        return WindowsPortalSynchDataServiceClient.DesignationMasterAdd(strXML, OrgId);
    }

    [WebMethod]
    public Int32 WindowPortalClassSubjectAdd(string strXML, int OrgId)
    {
        return WindowsPortalSynchDataServiceClient.ClassSubjectAdd(strXML, OrgId);
    }

    [WebMethod]
    public Int32 WindowPortalEventHoliday(string strXML, int OrgId)
    {
        return WindowsPortalSynchDataServiceClient.EventHoliday(strXML, OrgId);
    }

    [WebMethod]
    public Int32 WindowPortalStudentMasterAdd(string strXML, int OrgId)
    {
        return WindowsPortalSynchDataServiceClient.StudentMasterAdd(strXML, OrgId);
    }
    
    [WebMethod]
    public Int32 WindowPortalStudentAcademicAdd(string strXML, int OrgId)
    {
        return WindowsPortalSynchDataServiceClient.AcademicAdd(strXML, OrgId);
    }

    [WebMethod]
    public Int32 WindowPortalStudentCommunicationAdd(string strXML, int OrgId)
    {
        return WindowsPortalSynchDataServiceClient.StudentCommunicationAdd(strXML, OrgId);
    }

    [WebMethod]
    public Int32 WindowPortalStudentOtherAdd(string strXML, int OrgId)
    {
        return WindowsPortalSynchDataServiceClient.StudentOtherAdd(strXML, OrgId);
    }

    [WebMethod]
    public Int32 WindowPortalFeeDetailAdd(string strXML, int OrgId)
    {
        return WindowsPortalSynchDataServiceClient.FeeDetailAdd(strXML, OrgId);
    }

    [WebMethod]
    public Int32 WindowPortalEmployeeMasterAdd(string strXML, int OrgId)
    {
        return WindowsPortalSynchDataServiceClient.EmployeeMasterAdd(strXML, OrgId);
    }

    [WebMethod]
    public Int32 WindowPortalUploadBookLogAdd(string strXML, int OrgId)
    {
        return WindowsPortalSynchDataServiceClient.UploadBookLogAdd(strXML, OrgId);
    }

    [WebMethod]
    public Int32 WindowPortalDailyPresenceAdd(int OrgId, Int64 ReadDate, int DivisionId, string strXML)
    {
        return WindowsPortalSynchDataServiceClient.DailyPresenceAdd(OrgId, ReadDate, DivisionId, strXML);
    }

    [WebMethod]
    public Int32 WindowPortalViewResultAdd(string strXML, int BatchId, int ClassId, int DivisionId, Int16 ExamTypeId, int ExamId, int OrgId)
    {
        return WindowsPortalSynchDataServiceClient.ViewResultAdd(strXML, BatchId, ClassId, DivisionId, ExamTypeId, ExamId, OrgId);
    }

    [WebMethod]
    public Int32 WindowPortalViewResultDetailAdd(string strXML, int BatchId, int ClassId, int DivisionId, Int16 ExamTypeId, int ExamId, int OrgId)
    {
        return WindowsPortalSynchDataServiceClient.ViewResultDetailAdd(strXML, BatchId, ClassId, DivisionId, ExamTypeId, ExamId, OrgId);
    }
    
    #endregion



}