﻿<%@ page language="C#" autoeventwireup="true" inherits="Pages_BaseFramework_Security_UserAuthentication, App_Web_mpksgccf" stylesheettheme="Default" uiculture="auto" meta:resourcekey="PageResource1" enableEventValidation="false" viewStateEncryptionMode="Never" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>User Authentication</title>
    <link rel="shortcut icon" href="../../../ContentTemplates/Brand/favicon.png" type="image/x-icon" />
    <link href="~/App_Themes/responsiv-popup.css" rel="stylesheet" />
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport" />
    <link href="https://fonts.googleapis.com/css?family=Montserrat|Poppins|Roboto" rel="stylesheet" />
    <link href="~/App_Themes/newTheme/css/bootstrap.css" rel="stylesheet" />
    <link href="~/App_Themes/newTheme/css/fontawesome.min.css" rel="stylesheet" type="text/css" />
    <link href="../../../App_Themes/newTheme/css/userauthentication.css" rel="stylesheet" type="text/css" />
</head>
<body id="bodytag" runat="server">
    <section class="center">
        <form id="form1" autocomplete="off" runat="server" method="post" autocompletetype="disable" x-autocompletetype="disable">
            <div class="maincontainer">
                <div class="bothsidebox">
                    <div class="leftcard">
                        <div class="cardinside">
                            <a runat="server" id="BrandWebsite" target="_blank">
                                <img src="../../../ContentTemplates/Brand/vidyalaya_logo.png" alt="logo" />
                            </a>
                        </div>
                        <div class="logotext">
                            <asp:Label runat="server" ID="ErrorLabel" CssClass="errmsg" Style="display: none" meta:resourcekey="ErrorLabelResource1"></asp:Label>
                            <asp:Label runat="server" ID="SuccessLabel" CssClass="successmsg" Style="display: none" meta:resourcekey="SuccessLabelResource1"></asp:Label>
                            <p><span class="maintxt">User</span> Authentication</p>
                        </div>
                        <div class="iconz">
                            <div class="container">
                                <div class="box">
                                    <img src="../../../ContentTemplates/Brand/ic_user.png" class="usrimg" alt="usericon" />
                                    <asp:TextBox ID="userNameTextBox" MaxLength="100" runat="server" AutoPostBack="false" autocomplete="false" SkinID=""
                                        meta:resourcekey="userNameTextBoxResource1"></asp:TextBox>
                                    <label for="userNameTextBox">Username (Phone / Email)</label>
                                </div>
                            </div>
                            <div class="formessentials">
                                <div class="sbtndiv">
                                    <asp:Button ID="OtpButton" Text="Send OTP" runat="Server" OnClick="OtpButton_Click" CssClass="otpbtn backimg fas btn btn-primary btn-lg btn-block" />
                                </div>
                                <div class="backdiv">
                                    <asp:Button ID="SendCodeButton" Text="Send Code" runat="Server" OnClick="SendCodeButton_Click" CssClass="codebtn backimg fas btn btn-primary btn-lg btn-block" />
                                </div>
                            </div>
                            <div class="container">
                                <div class="box">
                                    <img src="../../../ContentTemplates/Brand/ic_email.png" class="pwdimg" alt="pwd" />
                                    <asp:TextBox ID="OTPTextBox" MaxLength="10" runat="server" AutoPostBack="false" autocomplete="false" SkinID=""
                                        meta:resourcekey="otpTextBoxResource2" CssClass="numberonly"></asp:TextBox>
                                    <label for="OTPTextBox">OTP / Code</label>
                                </div>
                            </div>
                            <div class="formessentials">
                                <div class="sbtndiv">
                                    <asp:Button ID="ValidateButton" Text="&#xf023; VALIDATE" runat="server" CssClass="sbtn backimg fas btn-primary btn-lg btn-block"
                                        OnClick="ValidateButton_Click" SkinID="0" Enabled="false" />
                                </div>
                                <div class="backdiv">
                                    <asp:Button ID="BackButton" Text="&#xf060; BACK" CssClass="back backimg fas btn btn-primary btn-lg btn-block"
                                        runat="Server" OnClick="BackButton_Click" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="rightcard">
                        <div class="rightimage">
                            <img src="../../../ContentTemplates/Brand/img_right.png" alt="rightbanner" />
                        </div>
                        <div class="rightitems">
                            <p>
                                Licenced No : <span class="spanblack" runat="server" id="LicenceNo"></span>
                                | Licenced To : <span class="spanblack" runat="server" id="LicenceTo"></span>
                                | IP Address : <span class="spanblack" runat="server" id="IPAddressLabel"></span>|
                                <br />
                                Version Number : <span class="spanblack" runat="server" id="VersionNo"></span>
                                <span runat="server" id="ContactusDiv">| Powered By : <a target="_blank" class="spanblack" runat="server" id="ContacatusHyperLink"></a></span>
                                <span runat="server" id="DevelopByDiv">| Developed By : <a target="_blank" class="spanblack" runat="server" id="DevelopedByHyperLink"></a></span>
                                |
                                <br />
                                <asp:Label ID="SupportPhoneNoLabel" runat="server" CssClass="spanblack"></asp:Label>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </section>
    <script src="../../../App_Themes/newTheme/js/jquery-3.3.1.min.js"></script>
    <script src="../../../App_Themes/newTheme/js/constellation.js"></script>
    <script src="../../../App_Themes/newTheme/js/materialize.js" type="text/javascript"></script>
    <script src="../../../App_Themes/newTheme/js/init.js" type="text/javascript"></script>
</body>
</html>
<script type="text/javascript" src='<%=ResolveUrl("~/JavaScript/rjs/lib/jquery.js")%>'></script>
<script type="text/javascript" src='<%=ResolveUrl("~/JavaScript/rjs/require.js")%>'></script>
<script>
    $(document).ready(function () {
        $('.numberonly').keypress(function (e) {
            var charCode = (e.which) ? e.which : event.keyCode
            if (String.fromCharCode(charCode).match(/[^0-9]/g))
                return false;
        });

        $("input").each(function (e) {
            if ($(this).val() == '') {
                $(this).closest('.box').removeClass('username');
            } else {
                $(this).closest('.box').addClass('username');
            }
        });

        $(document).on('focus blur', 'input', function () {
            if ($(this).val() == '') {
                $(this).closest('.box').removeClass('username');
            } else {
                $(this).closest('.box').addClass('username');
            }
        });

        if ($('#ErrorLabel').text() != "") {
            $("#ErrorLabel").show();
            $(".card-subtitle").css({ "padding-top": "32px" });
        }
        else {
            $("#ErrorLabel").hide();
            $(".card-subtitle").css({ "padding-top": "0px" });
        }

        if ($('#SuccessLabel').text() != "") {
            $("#SuccessLabel").show();
            $(".card-subtitle").css({ "padding-top": "32px" });
        }
        else {
            $("#SuccessLabel").hide();
            $(".card-subtitle").css({ "padding-top": "0px" });
        }
    });
</script>
