﻿<%@ WebService Language="C#" Class="TallySyncWebService" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using Sapphire.Vidyalaya.BusinessEntity.Business.TallyBE;
using Sapphire.Vidyalaya.BusinessLogic.Business.Tally.TallyBL;
using Sapphire.Ohu.BaseFramework.Utilities;
using Sapphire.Ohu.BusinessEntity.Framework.BaseFrameworkBE;
using System.Data;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
// [System.Web.Script.Services.ScriptService]
public class TallySyncWebService  : System.Web.Services.WebService {


    // vs command prompt wsdl http://localhost:5568/Services/TallySyncWebService.asmx?wsdl
    // browse the service and put /service before part of url in config file
    //string SyncServiceUrl = System.Configuration.ConfigurationManager.AppSettings["SyncServiceUrl"];
    ///// <remarks/>
    //public TallySyncWebService()
    //{
    //    this.Url = SyncServiceUrl + "/Services/TallySyncWebService.asmx";
    //}
    
    
    #region Service Client

    //Tally Synch Service
  
    private CommonFunctions CommonFunctionServiceClient
    {
        get { return new CommonFunctions(); }
    }
    private CompanyMappingService CompanyMappingServiceClient
    {
        get { return new CompanyMappingService(); }
    }
    private FeeLedgerMappingService FeeLedgerMappingServiceClient
    {
        get { return new FeeLedgerMappingService(); }
    }

    //private AccountLedgerMappingService AccountLedgerMappingServiceClient
    //{
    //    get { return new AccountLedgerMappingService(); }
    //}
    private ReceiptTallyPostingService ReceiptTallyPostingServiceClient
    {
        get { return new ReceiptTallyPostingService(); }
    }
    private StudentLedgerMappingService StudentLedgerMappingServiceClient
    {
        get { return new StudentLedgerMappingService(); }
    }
    #endregion
  


    // ***** Tally Data Synch *****
    #region Tally Integration Service
   
    // * Get Company Mapping List *
    [WebMethod]
    public System.Collections.Generic.List<CompanyMapping> GetCompanyMappingList(CompanyMapping CompanyMappingData)
    {
        return CompanyMappingServiceClient.GetCompanyMappingList(CompanyMappingData);
    }

    // * Get Account Company Mapping List *
    [WebMethod]
    public System.Collections.Generic.List<CompanyMapping> AccountCompanyMappingList(CompanyMapping CompanyMappingData)
    {
        return CompanyMappingServiceClient.AccountCompanyMappingList(CompanyMappingData);
    }

    // * Create Company Mapping List *
    [WebMethod]
    public Int64 CreateCompanyMapping(string XMLstr, Int32 OrgGroupBatchId )
    {
        return CompanyMappingServiceClient.CreateCompanyMapping(XMLstr, OrgGroupBatchId);
    }

    // * Create Account Company Mapping List *
    [WebMethod]
    public Int64 CreateAccountCompanyMapping(string XMLstr, Int32 OrgGroupBatchId)
    {
        return CompanyMappingServiceClient.CreateAccountCompanyMapping(XMLstr, OrgGroupBatchId);
    }


    // * Get Fee Head Ledger Mapping List *
    [WebMethod]
    public System.Collections.Generic.List<FeeLedgerMapping> GetFeeLedgerMappingList(FeeLedgerMapping FeeLedgerMappingData)
    {
        return FeeLedgerMappingServiceClient.GetFeeLedgerMappingList(FeeLedgerMappingData);
    }

    // * Create Fee Head Ledger Mapping List *
    [WebMethod]
    public Int64 CreateFeeLedgerMapping(string XMLstr)
    {
        return FeeLedgerMappingServiceClient.CreateFeeLedgerMapping(XMLstr);
    }

    // * Get Account Head Ledger Mapping List *
    [WebMethod]
    public System.Collections.Generic.List<FeeLedgerMapping> AccountLedgerMappingList(FeeLedgerMapping AccountLedgerMappingData)
    {
        return FeeLedgerMappingServiceClient.AccountLedgerMappingList(AccountLedgerMappingData);
    }

    // * Create Account Head Ledger Mapping List *
    [WebMethod]
    public Int64 CreateAccountLedgerMapping(string XMLstr)
    {
        return FeeLedgerMappingServiceClient.CreateAccountLedgerMapping(XMLstr);
    }

    // * Get Fee Receipt Posting List *
    [WebMethod]
    public System.Collections.Generic.List<ReceiptTallyPosting> GetReceiptTallyPostingList(ReceiptTallyPosting FeeLedgerMappingData)
    {
        return ReceiptTallyPostingServiceClient.GetReceiptTallyPostingList(FeeLedgerMappingData);
    }

    // * Get Account List *
    [WebMethod]
    public System.Collections.Generic.List<ReceiptTallyPosting> GetAccountTallyPostingList(ReceiptTallyPosting FeeLedgerMappingData)
    {
        return ReceiptTallyPostingServiceClient.GetAccountTallyPostingList(FeeLedgerMappingData);
    }

    // * Create Fee Receipt Posting List *
    [WebMethod]
    public Int64 CreateReceiptTallyPosting(string XMLstr, Int32 ReceiptId, Int32 OrgGroupBatchId, Int32 VoucherNumber)
    {
        return ReceiptTallyPostingServiceClient.CreateReceiptTallyPosting(XMLstr,  ReceiptId, OrgGroupBatchId, VoucherNumber);
    }

    // * Create Account Posting List *
    [WebMethod]
    public Int64 CreateAccountTallyPosting(string XMLstr, Int32 ReceiptId, Int32 OrgGroupBatchId, Int32 VoucherNumber)
    {
        return ReceiptTallyPostingServiceClient.CreateAccountTallyPosting(XMLstr, ReceiptId, OrgGroupBatchId, VoucherNumber);
    }


    // * Create Fee Receipt List *
    [WebMethod]
    public DataSet GetFeeReceiptList(string sQuesry)
    {
        return CommonFunctionServiceClient.GetDataset(sQuesry);
    }

    //// * Create Account Receipt List *
    [WebMethod]
    public DataSet GetAccountLedgerMappingList(string sQuesry)
    {
        return CommonFunctionServiceClient.GetDataset(sQuesry);
    }

    // * Get Student Ledger Mapping List *
    [WebMethod]
    public System.Collections.Generic.List<StudentLedgerMapping> GetStudentLedgerMappingList(StudentLedgerMapping StudentLedgerMappingData)
    {
        return StudentLedgerMappingServiceClient.GetStudentLedgerMappingList(StudentLedgerMappingData);
    }

    // * Get Voucher Type Mapping List * 
    [WebMethod]
    public System.Collections.Generic.List<StudentLedgerMapping> GetVoucherTypeMappingList(StudentLedgerMapping StudentLedgerMappingData)
    {
        return StudentLedgerMappingServiceClient.GetVoucherTypeMappingList(StudentLedgerMappingData);
    }

    // * Create Student Ledger Mapping List *
    [WebMethod]
    public Int64 CreateStudentLedgerMapping(string XMLstr)
    {
        return StudentLedgerMappingServiceClient.CreateStudentLedgerMapping(XMLstr);
    }

    // * Create VoucherType Mapping List *
    [WebMethod]
    public Int64 CreateVoucherTypeMapping(string XMLstr)
    {
        return StudentLedgerMappingServiceClient.CreateVoucherTypeMapping(XMLstr);
    }
    
    // * Get Payroll Posting List *
    [WebMethod]
    public System.Collections.Generic.List<PayrollTallyPosting> GetPayrollTallyPostingList(PayrollTallyPosting PayrollTallyPostingData)
    {
        return ReceiptTallyPostingServiceClient.GetPayrollTallyPostingList(PayrollTallyPostingData);
    }
    
    #endregion

}