var URL = window.location.href;
var orgId = URL.substr(URL.indexOf('=') + 1);
URL = URL.replace('?OrgId=' + orgId + '', '');
var pattern = '"';
var r = new RegExp(pattern, "g");

function LoadingMessage(msg1, msg2) {
    $('#divLoadingmsg').show();
    $('#msg1').html(msg1);
    $('#msg2').html(msg2);
    $('.hls-bg').show();
}

function CloseHls() {
    $('#divLoadingmsg').hide();
    $('.hls-bg').hide();
    $('.hls-wrap').hide();
}

function ValidateDetails() {
    var fields = '';
    var Title = 'Please fill the following details ___________________ \n\n';
    if ($('#txtUserName').val().trim() == '') {
        fields = fields + 'User Name \n';
    }
    if ($('#txtEmail').val().trim() == '' && $('#txtNumber').val().trim() == '') {
        fields = fields + 'Email Address or Mobile Number \n';
    }
    else if ($('#txtNumber').val().trim() == '') {
        var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        if (!re.test($('#txtEmail').val().trim())) {
            fields = fields + 'Invalid Email Address \n';
        }
    }
    else if ($('#txtEmail').val().trim() == '') {
        var filter = /^((\+[1-9]{1,4}[ \-]*)|(\([0-9]{2,3}\)[ \-]*)|([0-9]{2,4})[ \-]*)*?[0-9]{3,4}?[ \-]*[0-9]{3,4}?$/;
        if (!filter.test($('#txtNumber').val().trim())) {
            fields = fields + 'Invalid Mobile Number \n';
        }
    }
    if (fields.length > 0) {
        alert(Title + fields);
        return false;
    }
    else {
        ForgotPassword();
    }
}

function ForgotPassword() {
    LoadingMessage('Checking Details', '<b>Please Wait ...</b>');

    $.ajax({
        type: "POST",
        url: URL + "/ForgotPassword",
        data: '{"UserName":"' + $('#txtUserName').val().trim().replace(r, '').replace("\\", '') + '","Email":"' + $('#txtEmail').val().trim().replace(r, '').replace("\\", '') + '","MobileNo":"' + $('#txtNumber').val() + '","OrgId":"' + orgId + '"}',
        contentType: "application/json;charset=utf-8",
        dataType: "json",
        success: function (data) {
            var datas = $.parseJSON(data.d);
            if (datas.Res != '') {
                CloseHls();
                $("#lblErrorCode").html(datas.Res);
                $("#lblErrorCode").css("display", "");
                $("#lblSuccessCode").css("display", "none");
            }
            else {
                if ($('#txtEmail').val().trim() == '') {
                    LoadingMessage('We are sending you a link to reset your password, please check your email.', '<b>Please Wait ...</b>');
                    SendSMS(datas.Code, datas.MobileNumber);
                }
                else {
                    LoadingMessage('We are sending you a link to reset your password, please check your email.', '<b>Please Wait ...</b>');
                    SendEmail(datas.Code, datas.Email);
                }
            }
        },
        error: function (xhr, status, error) {
            var err = eval("(" + xhr.responseText + ")");
            console.log(err.Message);
            CloseHls();
        }
    });
}

function SendEmail(Code, Email) {
    $.ajax({
        type: "POST",
        url: URL + "/SendEmail",
        data: '{"Code":"' + Code + '","Email":"' + Email + '","UserName":"' + $('#txtUserName').val().trim().replace(r, '').replace("\\", '') + '","RedirectUrl":"' + URL + '","OrgId":"' + orgId + '"}',
        contentType: "application/json;charset=utf-8",
        dataType: "json",
        success: function (data) {
            LoadingMessage('Success.', '<b>Please Wait ...</b>');
            window.setTimeout(function () { CloseHls(); }, 500);
            if (data.d == 1) {
                $("#lblSuccessCode").html("Email Sent..!!");
                $("#lblSuccessCode").css("display", "");
                $("#lblErrorCode").css("display", "none");
            }
            else {
                $("#lblErrorCode").html("An issue has arisen, the school administrator will be reaching out to you shortly");
                $("#lblErrorCode").css("display", "");
                $("#lblSuccessCode").css("display", "none");
            }
        },
        error: function (xhr, status, error) {
            var err = eval("(" + xhr.responseText + ")");
            console.log(err.Message);
            CloseHls();
        }
    });
}

function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : event.keyCode;
    if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
}

function SendSMS(Code, MobileNumber) {
    $.ajax({
        type: "POST",
        url: URL + "/SendSMS",
        data: '{"Code":"' + Code + '","MobileNo":"' + MobileNumber + '","UserName":"' + $('#txtUserName').val().trim().replace(r, '').replace("\\", '') + '","RedirectUrl":"' + URL + '","OrgId":"' + orgId + '"}',
        contentType: "application/json;charset=utf-8",
        dataType: "json",
        success: function (data) {
            LoadingMessage('Success.', '<b>Please Wait ...</b>');
            window.setTimeout(function () { CloseHls(); }, 500);
            if (data.d == 1) {
                $("#lblSuccessCode").html("SMS Sent..!!");
                $("#lblSuccessCode").css("display", "");
                $("#lblErrorCode").css("display", "none");
            }
            else {
                $("#lblErrorCode").html("An issue has arisen, the school administrator will be reaching out to you shortly");
                $("#lblErrorCode").css("display", "");
                $("#lblSuccessCode").css("display", "none");
            }
        },
        error: function (xhr, status, error) {
            var err = eval("(" + xhr.responseText + ")");
            console.log(err.Message);
            CloseHls();
        }
    });
}