<%@ page language="C#" autoeventwireup="true" inherits="MLogin, App_Web_mfuq2den" title="Vidyalaya - Login" stylesheettheme="Default" uiculture="auto" meta:resourcekey="PageResource1" enableEventValidation="false" viewStateEncryptionMode="Never" %>

<%@ Register Src="~/UserControls/ConfirmationBox/ConfirmationBoxControl.ascx" TagName="ConfirmationBoxControl"
    TagPrefix="uc1" %>
<%@ Register Src="~/UserControls/Security/ForgotPassword.ascx" TagName="ForgotPasswordControl"
    TagPrefix="fpc" %>
<!DOCTYPE html>
<html>



<head id="Head1" runat="server">
    <title>Login Page</title>
    <link rel="shortcut icon" href="~/ContentTemplates/Brand/favicon.png" type="image/x-icon" />
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link href="~/App_Themes/newTheme/css/bootstrap.css" rel="stylesheet" />
    <!-- Font Awesome Icons -->
    <link href="~/App_Themes/newTheme/css/fontawesome.min.css" rel="stylesheet" type="text/css" />
    <!-- Theme style -->
    <link href="~/App_Themes/newTheme/css/mobile.css" rel="stylesheet" />
    <link href="~/App_Themes/newTheme/css/ghpages-materialize.css" rel="stylesheet" />

    
    
    <style type="text/css">
    .body {
        /*background: url(../../../Images/white-bg.jpg) no-repeat center center;*/
        /*background-image: linear-gradient(to right,#404E67 0,#6F85AD 100%);*/
        background-size: cover;
        /*background-color: #404E67;*/
        overflow-y: auto;
        max-height: 662px;
    }

    .constellation {
        position: absolute;
        top: 0;
        left: 0;
        z-index: 99;
    }

    .alert-danger, .alert-error {
        margin-top: -27px;
    }

    .login-page.body {
           /*background-image: -moz-radial-gradient(ellipse at center, #6F85AD 0%,#404E67 80%);
            background-image: -o-radial-gradient(ellipse at center, #6F85AD 0%,#404E67 80%);
            background-image: -webkit-radial-gradient(ellipse at center, #6F85AD 0%,#404E67 80%);
            background-image: radial-gradient(ellipse at center, #6F85AD 0%,#404E67 80%);*/
            background-image: url("../../../ContentTemplates/Brand/white-bg.jpg");
    }

        .login-page.body .overlay {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #000; 
            z-index: 99;
            opacity:0.2;
        }

  </style>
</head>
<body id="bodytag" runat="server" class="login-page body">
    <div class="overlay"></div>
    <canvas class="constellation" id="canvas"></canvas>
    <div class="row">

        <form class="form-signin col-md-4 offset-md-4 mt1 col-sm-12 offset-sm-0" method="post" id="form1" runat="server">
            <div class="card border-grey border-lighten-3 m-0" id="monster">
                <div class="card-header no-border">
                    <div class="login-logo card-title text-xs-center">
                        <a runat="server" id="BrandWebsite" class="p-1">
                            <img src="../../../Images/Logo.png" alt="vidyalaya logo" /><br />
                            <b style="        color: #3c8dbc">
                                <asp:Label runat="server" ID="BrandName" Style="        display: none"></asp:Label>
                            </b>
                        </a>
                    </div>
                    <div class="pt-10 text-r col-xs-12 font-small-5">
                        <asp:Label ID="ErrorLabel" CssClass="alert alert-danger col-xs-12 fade in" runat="server" Style="        display: none" meta:resourcekey="ErrorLabelResource1"></asp:Label>
                    </div>
                    <h6 class="col-xs-12 card-subtitle line-on-side text-muted text-xs-center font-small-3 m-0"><span>Sign in to start your session</span></h6>
                </div>


                <div class="card-body overflow-hidden">
                    <div class="card-block pb-0 pt-0">
                        <asp:ScriptManager ID="LoginScriptManager" runat="server" EnablePageMethods="True">
                        </asp:ScriptManager>
                        <div class="form-group  position-relative">
                            <asp:DropDownList ID="OrgDropDownList" runat="server"
                                AutoPostBack="true" OnSelectedIndexChanged="OrgDropDownList_OnSelectedIndexChanged">
                            </asp:DropDownList>
                        </div>

                        <div class="form-group  position-relative">
                            <asp:DropDownList ID="BatchDropDownList" runat="server">
                            </asp:DropDownList>
                        </div>
                        <%--UserName--%>
                        <div class="form-group position-relative has-icon-left input-field">
                            <div class="form-control-position">
                                <i class="fal fa-user"></i>
                            </div>
                            <asp:TextBox ID="userNameTextBox" MaxLength="100" runat="server" AutoPostBack="false"
                                onfocus="if (this.value=='User name'){this.value='';};return false;"
                                onblur="if (this.value==''){this.value='User name';return false;}"
                                meta:resourcekey="userNameTextBoxResource1" OnTextChanged="userNameTextBox_TextChanged"></asp:TextBox>
                            <label>User Name</label>
                        </div>
                        <%--Password--%>
                        <div class="form-group position-relative has-icon-left input-field">
                            <div class="form-control-position">
                                <i class="fal fa-key"></i>
                            </div>
                            <asp:TextBox ID="passwordTextBox" MaxLength="25" TextMode="Password" runat="server"
                                onfocus="if (this.value=='Password'){this.value='';};return false;"
                                onblur="if (this.value==''){this.value='Password';return false;}"
                                meta:resourcekey="passwordTextBoxResource1"></asp:TextBox>
                            <label>Password</label>
                        </div>

                        <div class="form-group row">
                            <%--remember me--%>
                            <div class="col-md-7 col-xs-12 text-xs-center text-md-left">
                                <fieldset>
                                    <asp:CheckBox ID="chkRememberMe" runat="server" Text="Remember Login?" />
                                    <%--     <asp:Label ID="IsRemember" runat="server"
                            ></asp:Label>--%>
                                </fieldset>
                            </div>
                            <%--./remember me--%>
                            <%--./Forget pwd--%>
                            <div class="col-md-5 col-xs-12 text-xs-center text-md-right">
                                <fpc:ForgotPasswordControl ID="ForgotPasswordBox" runat="server" Visible="false" />
                            </div>
                            <%--./Forget pwd--%>
                        </div>
                        <%-- login button--%>
                        <div class="row">

                            <asp:UpdatePanel ID="ConfirmationBoxUpdatePanel" runat="server" RenderMode="Inline">
                                <ContentTemplate>
                                    <uc1:ConfirmationBoxControl ID="LoginConfirmBox" runat="server" OnOkClick="ConfirmBox_OK"
                                        OnCancelClick="ConfirmBox_Cancel" Visible="false" />
                                </ContentTemplate>
                            </asp:UpdatePanel>

                            <asp:LinkButton ID="loginButton" runat="server" class="btn btn-primary btn-lg btn-block"
                                OnClick="loginButton_Click"
                                meta:resourcekey="loginButtonResource1">
                                   <i class="fas fa-lock"></i> Login
                            </asp:LinkButton>


                            <asp:UpdatePanel ID="ForgotPasswordUpdatePanel" runat="server" RenderMode="Inline">
                                <ContentTemplate>
                                </ContentTemplate>
                            </asp:UpdatePanel>

                        </div>

                        <%-- login button--%>
                        <div class="row">
                            <asp:ImageButton Visible="false" runat="server" ID="LogoImageButton" ImageUrl="../../../Images/LogoNew.png" />
                            <%--</form>--%>
                        </div>
                    </div>
                </div>
            </div>
        </form>

    </div>
    <script src="../../../App_Themes/newTheme/js/jquery-3.3.1.min.js"></script>
    <script src="../../../App_Themes/newTheme/js/constellation.js"></script>
    <script src="../../../App_Themes/newTheme/js/materialize.js" type="text/javascript"></script>
    <script src="../../../App_Themes/newTheme/js/init.js" type="text/javascript"></script>
    <script>
 $( document ).ready(function() {
if($('#ErrorLabel').text()!="")
{
$("#ErrorLabel").show();
$(".card-subtitle").css({"padding-top": "32px"});
 }  
else
{
$("#ErrorLabel").hide();
$(".card-subtitle").css({"padding-top": "0px"});
}
});
    </script>
    <script src="../../../App_Themes/BlackTheme/plugins/jQuery/jQuery-2.1.3.min.js" type="text/javascript"></script>
    <!-- Bootstrap 3.3.2 JS -->
    <script src="../../../App_Themes/BlackTheme/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
</body>
</html>
