﻿<%@ control language="C#" autoeventwireup="true" inherits="UserControls_Common_DocumentSearch_DocumentSearch, App_Web_51tuuxlc" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<%@ Register Src="~/UserControls/GridViewPager/GridViewPager.ascx" TagName="GridViewPager"
    TagPrefix="uc1" %>
<%@ Register Src="~/UserControls/MessageBox/MessageBoxControl.ascx" TagName="MessageControl"
    TagPrefix="uc1" %>
<%@ Register Src="~/UserControls/DatePicker/DatePickerControl.ascx" TagName="DataPickerControl"
    TagPrefix="HIMS" %>
<cc1:ModalPopupExtender ID="DocumentSearchExtender" runat="server" TargetControlID="HidenButton"
    PopupControlID="ModalPopUpPanel" BackgroundCssClass="modalBackground"
    Drag="True" PopupDragHandleControlID="dragPanel" DynamicServicePath=""
    Enabled="True" />
<asp:LinkButton runat="server" ID="HidenButton"
    meta:resourcekey="HidenButtonResource1" />

<asp:Panel ID="ModalPopUpPanel" runat="server" CssClass="dragControl"
    Width="850px" meta:resourcekey="ModalPopUpPanelResource1">
    <div class="card card-box">
        <asp:Panel ID="dragPanel" runat="server" CssClass="dragMePanel" Width="100%"
            meta:resourcekey="dragPanelResource1">
            <div id="dragMe1" class="dragMe" style="cursor: move">
                <div class="himsPopupWireBox">
                    <div class="himsBoxHeadermain">
                        <div>
                        </div>
                    </div>
                    <div class="himsBoxTopper card-head text-center">
                        <div class="fLeft headerText">
                            <asp:UpdatePanel ID="UpdatePanel1" runat="server" RenderMode="Inline">
                                <ContentTemplate>
                                    <asp:Label ID="DialogHeaderLabel" runat="server"
                                        meta:resourcekey="DialogHeaderLabelResource1"></asp:Label>
                                </ContentTemplate>
                            </asp:UpdatePanel>
                        </div>
                        <asp:Button runat="server" ID="CancelButton" Text="&#xf00d;" OnClick="CancelButton_Click"
                            TabIndex="7" SkinID="0" CssClass="fas close-btn pull-right"/>
                    </div>
                </div>
            </div>
        </asp:Panel>


        <asp:UpdatePanel ID="DocumentSearchUpdatePanel" runat="server"
            RenderMode="Inline">
            <ContentTemplate>

                <div id="bodyContainer">
                    <!--Main Container Starts Here-->
                    <!--Div Container Starts-->
                    <div class="himsPopupWireBox">
                        <div class="himsBoxHeadermain">
                            <div>
                            </div>
                        </div>
                        <uc1:MessageControl ID="SearchMessageBox" runat="server" />
                        <div class="himsBoxContentmain" style="overflow: hidden">
                            <div id="divContentPage">
                                <div class="spacer">
                                    <asp:Image ID="Image1" runat="server" ImageUrl="~/Images/spacer.gif"
                                        meta:resourcekey="Image1Resource1" />
                                </div>
                                <!-- ContentPlaceHolder Box Starts -->
                                <div>
                                    <div class="himssuHeader2WireBox">
                                        <div class="himsBoxHeader">
                                            <asp:Panel ID="TopPanel" runat="server" meta:resourcekey="TopPanelResource1">
                                                <div class="leftdiv">
                                                </div>
                                                <div class="himsBoxTitle">
                                                    <div class="headerText">
                                                        <asp:Label ID="DocumentSearchHeaderLabel" runat="server" Text="Search"
                                                            meta:resourcekey="DocumentSearchHeaderLabelResource1"></asp:Label>
                                                    </div>
                                                    <div>
                                                    </div>
                                                </div>
                                            </asp:Panel>
                                        </div>
                                        <div class="himsBoxContent card-body">
                                            <asp:Panel ID="DetailPanel" runat="server"
                                                meta:resourcekey="DetailPanelResource1">
                                                <div class="contentHolder">
                                                    <asp:Panel ID="SearchCriteriaPanel" runat="server"
                                                        meta:resourcekey="SearchCriteriaPanelResource1">
                                                        <div class="outerBox pTop5 col-md-6">
                                                            <div class="controlLabelWidth">
                                                                <asp:Label ID="PatientIdLabel" runat="server" Text="Patient ID"
                                                                    meta:resourcekey="PatientIdLabelResource1"></asp:Label>
                                                            </div>
                                                            <div class="fLeft ">
                                                                <asp:TextBox ID="PatientIdTextBox" runat="server" AutoCompleteType="Disabled"
                                                                    meta:resourcekey="PatientIdTextBoxResource1"></asp:TextBox>
                                                            </div>
                                                        </div>
                                                        <div class="outerBox pTop5 col-md-6">
                                                            <div class="controlLabelWidth">
                                                                <asp:Label ID="PatientNameLabel" runat="server" Text="Patient Name"
                                                                    meta:resourcekey="PatientNameLabelResource1"></asp:Label>
                                                            </div>
                                                            <div class="fLeft ">
                                                                <asp:TextBox ID="PatientNameTextBox" runat="server" AutoCompleteType="Disabled"
                                                                    meta:resourcekey="PatientNameTextBoxResource1"></asp:TextBox>
                                                            </div>
                                                        </div>
                                                        <div class="outerBox pTop5 col-md-6">
                                                            <div class="controlLabelWidth">
                                                                <asp:Label ID="CorporateNameLabel" runat="server" Text="Corporate Name"
                                                                    meta:resourcekey="CorporateNameLabelResource1"></asp:Label>
                                                            </div>
                                                            <div class="fLeft ">
                                                                <asp:TextBox ID="CorporateNameTextBox" runat="server"
                                                                    AutoCompleteType="Disabled" meta:resourcekey="CorporateNameTextBoxResource1"></asp:TextBox>
                                                            </div>
                                                        </div>
                                                        <div class="cBoth">
                                                        </div>
                                                        <div class="outerBox pTop5 col-md-6">
                                                            <div class="controlLabelWidth">
                                                                <asp:Label ID="DocNoLabel" runat="server" Text="Bill No"
                                                                    meta:resourcekey="DocNoLabelResource1"></asp:Label>
                                                            </div>
                                                            <div class="fLeft ">
                                                                <asp:TextBox ID="DocNoTextBox" runat="server" AutoCompleteType="Disabled"
                                                                    meta:resourcekey="DocNoTextBoxResource1"></asp:TextBox>
                                                            </div>
                                                        </div>
                                                        <div class="outerBoxPreBtn pTop5">
                                                            <div class="controlLabelWidth"></div>
                                                            <div class="fLeft ">
                                                                <asp:CheckBox ID="SearchByDateCheckbox" CssClass="fLeft" runat="server"
                                                                    AutoPostBack="True" OnCheckedChanged="SearchByDateCheckbox_Checked"
                                                                    meta:resourcekey="SearchByDateCheckboxResource1" />
                                                                <asp:HiddenField ID="HiddenField" runat="server"></asp:HiddenField>
                                                            </div>
                                                            <div class="fLeft pLeft5 pTop5">
                                                                <asp:Label ID="SearchByDateLabel" runat="server" Text="Search By Date"
                                                                    meta:resourcekey="SearchByDateLabelResource1"></asp:Label>
                                                            </div>
                                                        </div>
                                                        <div class="outerBoxPreBtn pTop5" id="fromToDateTable" runat="server">
                                                            <div class="controlLabelWidth">
                                                                <asp:Label ID="FromLabel" runat="server" Text="From"
                                                                    meta:resourcekey="FromLabelResource1"></asp:Label>
                                                            </div>
                                                            <div class="fLeft ">
                                                                <HIMS:DataPickerControl DateTabIndex="1" AutoCompleteType="Disabled" ID="FromDataPickerControl"
                                                                    runat="server" DisplayDatePicker="true" />
                                                            </div>
                                                        </div>
                                                        <div class="outerBoxPreBtn pTop5" id="fromToDateTable2" runat="server">
                                                            <div class="controlLabelWidth">
                                                                <asp:Label ID="ToLabel" runat="server" Text="To"
                                                                    meta:resourcekey="ToLabelResource1"></asp:Label>
                                                            </div>
                                                            <div class="fLeft ">
                                                                <HIMS:DataPickerControl DateTabIndex="2" AutoCompleteType="Disabled" ID="ToDataPickerControl"
                                                                    runat="server" DisplayDatePicker="true" />
                                                            </div>
                                                        </div>
                                                        <div class="cBoth"></div>

                                                    </asp:Panel>

                                                    <div class="tableContainer col-md-12 pTop5 pb5 alignCenter">

                                                        <asp:Button ID="SearchButton" Text="&#xf002; Search" TabIndex="6" runat="server"
                                                            OnClick="SearchButton_Click" SkinID="0"  CssClass="btn btn-search fas" />

                                                            <asp:Button runat="server" ID="OkButton" Text="&#xf164;  Ok" OnClick="OkButton_Click"
                                                            meta:resourcekey="OkButtonResource1"  SkinID="0"  CssClass="btn btn-ok fas" />

                                                        <asp:Button ID="ResetButton" Text="&#xf12d; Clear" TabIndex="7" runat="server"
                                                            OnClick="ResetButton_Click" meta:resourcekey="ResetButtonResource1"   SkinID="0"  CssClass="btn btn-clear fas"/>
                                                    

                                                    </div>
                                                    <div id="MainDiv" runat="server">
                                                        <div id="PatientSearchGridDiv" runat="server" visible="False">

                                                            <div class="himssuHeader1WireBox" id="PatientRelationDiv" runat="server">
                                                                <div class="himsBoxHeader card-head inner" id="GridHeaderDiv" runat="server" visible="False">
                                                                    <div class="leftdiv">
                                                                    </div>
                                                                    <div class="himsBoxTitle" style="width: 99%">
                                                                        <div class="headerText">
                                                                            <div class="fLeft">
                                                                                <header>
                                                                                    <asp:Label ID="DocumentSearchGridViewLabel" Text="List" runat="server"
                                                                                        meta:resourcekey="DocumentSearchGridViewLabelResource1" />
                                                                                </header>
                                                                            </div>
                                                                        </div>
                                                                        <div class="fRight pTop5">
                                                                            <uc1:GridViewPager ParentGridView="SearchGridView" ID="SearchGridViewGridViewPager"
                                                                                runat="server" OnFirstRecordClick="GridViewPager_FirstRecordClick" OnLastRecordClick="GridViewPager_LastRecordClick"
                                                                                OnNextRecordClick="GridViewPager_NextRecordClick" OnPrevRecordClick="GridViewPager_PrevRecordClick"
                                                                                OnTextBoxValueChange="GridViewPager_TextBoxValueChange" />
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="himsBoxContent pTop5">
                                                                    <div class="himsBoxContentMsg" id="GridContentDiv" runat="server"
                                                                        visible="False">
                                                                    </div>
                                                                    <asp:GridView ID="SearchGridView" runat="server" Width="100%" AllowSorting="True"
                                                                        AutoGenerateColumns="False" DataKeyNames="Id,PatientNumber,PatientName,CorporateName,DocumentNumber,Amount,OutstandingAmount,Currency,RegistrationId,TotalRecords"
                                                                        AllowPaging="True" OnSelectedIndexChanged="GridView_SelectedIndexChanged" OnRowDataBound="GridView_RowDataBound"
                                                                        OnPageIndexChanging="SearchGridView_OnPageIndexChanging"
                                                                        EmptyDataText="No records available for the search criteria."
                                                                        meta:resourcekey="SearchGridViewResource1">
                                                                        <Columns>
                                                                            <asp:TemplateField meta:resourcekey="TemplateFieldResource1">
                                                                                <ItemTemplate>
                                                                                    <asp:LinkButton ID="SelectLinkButton" runat="server" CommandName="Select"
                                                                                        meta:resourcekey="SelectLinkButtonResource1" OnClick="LinkButton_Click"
                                                                                        Text="Select"></asp:LinkButton>
                                                                                </ItemTemplate>
                                                                                <ItemStyle HorizontalAlign="Center" Width="33px" />
                                                                            </asp:TemplateField>
                                                                            <asp:BoundField DataField="Id" HeaderText="Id"
                                                                                Visible="False" meta:resourcekey="BoundFieldResource1">
                                                                                <HeaderStyle HorizontalAlign="Left" />
                                                                                <ItemStyle HorizontalAlign="Left" />
                                                                            </asp:BoundField>
                                                                            <asp:BoundField DataField="PatientNumber" HeaderText="PID"
                                                                                meta:resourcekey="BoundFieldResource2">
                                                                                <HeaderStyle HorizontalAlign="Left" />
                                                                                <ItemStyle HorizontalAlign="Left" Width="90px" />
                                                                            </asp:BoundField>
                                                                            <asp:BoundField DataField="PatientName" HeaderText="Patient Name"
                                                                                meta:resourcekey="BoundFieldResource3">
                                                                                <HeaderStyle HorizontalAlign="Left" />
                                                                                <ItemStyle HorizontalAlign="Left" Width="100px" />
                                                                            </asp:BoundField>
                                                                            <asp:BoundField DataField="CorporateCode" HeaderText="Corporate Code"
                                                                                meta:resourcekey="BoundFieldResource4">
                                                                                <HeaderStyle HorizontalAlign="Left" />
                                                                                <ItemStyle HorizontalAlign="Left" Width="120px" />
                                                                            </asp:BoundField>
                                                                            <asp:BoundField DataField="CorporateName" HeaderText="Corporate Name"
                                                                                meta:resourcekey="BoundFieldResource5">
                                                                                <HeaderStyle HorizontalAlign="Left" />
                                                                                <ItemStyle HorizontalAlign="Left" Width="135px" />
                                                                            </asp:BoundField>
                                                                            <asp:BoundField DataField="DocumentNumber" HeaderText="Document Number"
                                                                                meta:resourcekey="BoundFieldResource6">
                                                                                <HeaderStyle HorizontalAlign="Left" />
                                                                                <ItemStyle HorizontalAlign="Left" Width="80px" />
                                                                            </asp:BoundField>
                                                                            <asp:TemplateField HeaderText="Document Date"
                                                                                meta:resourcekey="TemplateFieldResource2">
                                                                                <EditItemTemplate>
                                                                                    <asp:TextBox ID="DocumentDateTextBox" runat="server"
                                                                                        Text='<%# Bind("DocumentDate") %>'
                                                                                        meta:resourcekey="DocumentDateTextBoxResource1"></asp:TextBox>
                                                                                </EditItemTemplate>
                                                                                <ItemTemplate>
                                                                                    <asp:Label ID="DocumentDateLabel" runat="server"
                                                                                        meta:resourcekey="DocumentDateLabelResource1"
                                                                                        Text='<%# ((DateTime)DataBinder.Eval(Container.DataItem,"DocumentDate")).ToShortDateString() %>'></asp:Label>
                                                                                </ItemTemplate>
                                                                                <ItemStyle HorizontalAlign="Center" Width="38px" />
                                                                            </asp:TemplateField>
                                                                            <asp:BoundField DataField="Amount" HeaderText="Amount"
                                                                                DataFormatString="{0:F}" meta:resourcekey="BoundFieldResource7">
                                                                                <HeaderStyle HorizontalAlign="Left" />
                                                                                <ItemStyle HorizontalAlign="Right" Width="100px" />
                                                                            </asp:BoundField>
                                                                            <asp:BoundField DataField="OutstandingAmount" DataFormatString="{0:F}"
                                                                                HeaderText="Outstanding Amount" meta:resourcekey="BoundFieldResource8">
                                                                                <HeaderStyle HorizontalAlign="Left" />
                                                                                <ItemStyle HorizontalAlign="Right" Width="100px" />
                                                                            </asp:BoundField>
                                                                            <asp:BoundField DataField="Currency" HeaderText="Currency" Visible="False"
                                                                                meta:resourcekey="BoundFieldResource9">
                                                                                <HeaderStyle HorizontalAlign="Left" />
                                                                                <ItemStyle HorizontalAlign="Right" Width="100px" />
                                                                            </asp:BoundField>
                                                                            <asp:BoundField DataField="RegistrationId" HeaderText="RegistrationId"
                                                                                Visible="False" meta:resourcekey="BoundFieldResource10">
                                                                                <HeaderStyle HorizontalAlign="Left" />
                                                                                <ItemStyle HorizontalAlign="Right" />
                                                                            </asp:BoundField>
                                                                        </Columns>
                                                                        <PagerSettings Visible="False" />
                                                                    </asp:GridView>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </asp:Panel>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
                </div>
                    <%--<asp:UpdateProgress ID="MainUpdateProgress" runat="server" DisplayAfter="200">
                        <ProgressTemplate>
                            <div style="position: absolute; top: 50%; left: 45%; font-size: 20px">
                                <asp:Image ID="LoadImage3" runat="server" ImageUrl="~/Images/Loading.gif"
                                    meta:resourcekey="LoadImage3Resource1" />
                            </div>
                        </ProgressTemplate>
                    </asp:UpdateProgress>--%>
                </div>
            </div>
            </ContentTemplate>
        </asp:UpdatePanel>
</asp:Panel>
