﻿<%@ WebHandler Language="C#" Class="Upload" %>
 

using System;
using System.Web;
using System.IO;
using Sapphire.Ohu.Web.SessionHelper;
using System.Windows.Forms;
using Sapphire.Ohu.Web.PageController;
using Sapphire.Ohu.BusinessEntity.Framework.BaseFrameworkBE;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Security.AccessControl;
using System.Collections.Generic;


public class Upload : IHttpHandler, System.Web.SessionState.IRequiresSessionState
{

    public void ProcessRequest(HttpContext context)
    {
        context.Response.ContentType = "text/plain";
        context.Response.Expires = -1;
        try
        {
            HttpPostedFile postedFile = context.Request.Files["Filedata"];

            string savepath = "";
            string tempPath = "";

            List<string> ValidClassworkFileExtensionList = new List<string>() { ".bmp", 
                    ".gif", ".jpeg", ".jpg", ".png",".pdf",".pptx",".ppt",".xlsx",".xls",".docx",".doc",".txt",".csv" };

            List<string> ValidCircularExtensionList = new List<string>() { ".bmp", 
                    ".gif", ".jpeg", ".jpg", ".png",".pdf",".pptx",".ppt",".xlsx",".xls",".docx",".doc",".txt",".csv",".mp4" };

            List<string> ValidPhotosExtensionList = new List<string>() { ".bmp", ".jpeg", ".jpg", ".png" };

            if (SecuritySession.UserProfile != null)
            {
                if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentMaster)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/StudentPhotos";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadStudentPhoto)
                {
                    if (context.Session["UploadFor"] == "TempStudentPhotos")
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempStudentPhotos";
                    else if (context.Session["UploadFor"] == "TempStudentFatherPhotos")
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempStudentFatherPhotos";
                    else if (context.Session["UploadFor"] == "TempStudentMotherPhotos")
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempStudentMotherPhotos";
                    else if (context.Session["UploadFor"] == "TempStudentRelativePhotos")
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempStudentRelativePhotos";
                }
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadStudentdocument)
                {
                    if (context.Session["UploadDocument"] == "Temp")
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/Temp";
                }
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentICard)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempStudentICard";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.EmployeeICard)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempEmployeeICard";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentDocuments)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/StudentDocuments/Temp";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentOtherPhoto)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/StudentPhoto/Temp";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.EmployeeDocument)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/EmployeeDocuments/Temp";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.EmployeeGeneral)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/EmployeePhotos";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)InstituteManagementScreenId.Setup.OrganizationMaster)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/OrgLogos";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.UploadResult)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/UploadResult/" + context.Session["ResultId"];
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)SupportScreenId.Utility.ViewPhoto)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Gallery/" + context.Session["CategoryId"];
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Assignment)
                    if (context.Session["TempAssignmentId"] != null)
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/Assignment/TempAssignment/" + context.Session["TempAssignmentId"];
                    else if (context.Session["AssignmentId"] != null)
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/Assignment/" + context.Session["AssignmentId"];
                    else
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/Assignment/Temp";
                //else if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Circular)
                //    if (context.Session["CircularId"] != null)
                //        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Circular/" + context.Session["CircularId"];
                //    else
                //        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Circular/Temp";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Circular)
                    if (context.Session["TempCircularId"] != null)
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/TempCircular/" + context.Session["TempCircularId"];
                    else
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Circular/Temp";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.Leave)
                    if (context.Session["LeaveId"] != null)
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Leave/" + context.Session["LeaveId"];
                    else
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Leave/Temp";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.MyLeave)
                    if (context.Session["LeaveId"] != null)
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Leave/" + context.Session["LeaveId"];
                    else
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Leave/Temp";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.Classwork)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/Classwork/" + context.Session["ClassworkId"];
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)ComponentsScreenId.Alert.SMSFromExcel)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId;
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportEmployee)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId;
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStudent)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId;
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportUser)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId;
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportBook)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId;
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportFee)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId;
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportAdmissionForm)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId;
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportSubjectActivity)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId;
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportSubjectActivityIndicator)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId;
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportCoScholasticIndicator)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId;
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.MonthlyAttendance)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempMonthlyAttendance";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentDataUpdate)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempStudentDataUpdate";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.FeeInvoiceImport)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempFeeInvoiceImport";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.FeeReceiptImport)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempFeeReceiptImport";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.BulkEmployeeDataUpdate)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempEmployeeDataUpdate";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadStudentPhoto)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempStudentPhotos";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadEmployeePhoto)
                {
                    if (context.Session["UploadFor"] == "TempEmployeePhotos")
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempEmployeePhotos";
                    else if (context.Session["UploadFor"] == "TempEmployeeSign")
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempEmployeeSign";
                }
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadCandidatePhoto)
                {
                    if (context.Session["UploadFor"] == "TempCandidatePhotos")
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempCandidatePhotos";
                    else if (context.Session["UploadFor"] == "TempEmployeeSign")
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempEmployeeSign";
                }
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadOrganizationPhoto)
                {
                    if (context.Session["UploadFor"] == "LoginBG")
                    {
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/Other/";
                    }
                    else if (context.Session["UploadFor"] == "MobileAppLogo")
                    {
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/MobileApp/";
                    }

                    else
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/OrgLogos";
                }
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.ReceiptBookMaster)
                {
                    if (context.Session["UploadFor"] == "ReceiptLogo")
                    {
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/ReceiptLogoTemp/";
                    }
                    if (context.Session["UploadForInvoice"] == "ReceiptLogo1")
                    {
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgGroupId + "OrgGroup/ReceiptLogoTemp1/";
                    }
                }

                else if (SecuritySession.UserProfile.CurrentScreenId == (int)SupportScreenId.Utility.VideoMaster)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/Video";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryAllSubject)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempMarkEntry/" + context.Session["ExamId"];
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryForAll)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempMarkEntry/" + context.Session["ExamId"];
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.SubjectActivityMarkEntryBulk)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempMarkEntry/" + context.Session["ExamId"];

                else if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.UploadEBookView)


                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgGroupId + "Book/" + context.Session["EBookId"];

                else if (SecuritySession.UserProfile.CurrentScreenId == (int)AttendanceScreenId.Attendance.DivisionRegister)


                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempDivisionRegister/";

                else if (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.StudentResultRemark)


                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempRemark/";

                else if (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.SubjectRemark)


                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempSubjectRemark/";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryOtherDetail)


                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempMarkEntryRemark/";

                else if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSExamScoreBulk)


                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempCSExamScoreBulk/";

                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Administration.ImportMasterData)


                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempMasterData/";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportAdmissionInquiry)


                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempAdmissionInquiry/";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockInwardBulk)


                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempStockInword/";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSIndicatorMaster)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempIndicator/";

                else if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.SubjectIndicator)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempSubjectIndicator/";

                else if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSExamMarkEntryBulk)


                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempCSExamScoreBulk/";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.BulkUpdate)


                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempLessonPlan/";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.TopicMaster)


                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempTopicMaster/";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSExamIndicator)


                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempCSExamIndicator/";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportHostel)


                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId;
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.SubjectActivityGradeScoreBulk)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempSubjectActivityBulk/";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStudentOldDetail)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/TempStudentOldDetail/";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockInwardNew)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/Stock/";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockIssueNew)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/Stock/";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockAdjustment)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/Stock/";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStockItem)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + "/Stock/";
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.ReceiptBookMaster)
                {
                    if (context.Session["FeeReceiptHeader"] == "FeeReceiptHeader")
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgGroupId + "/OrgGroup/ReceiptLogoTemp";
                    else
                        tempPath = "~/Content/" + SecuritySession.UserProfile.OrgGroupId + "/OrgGroup/ReceiptLogoTemp1";
                }
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)CertificateScreenId.Certificate.LeavingBulk)
                    tempPath = "~/Content/" + SecuritySession.UserProfile.OrgId + context.Session["LeavingBulk"];
               
                savepath = context.Server.MapPath(tempPath);
                string filename = postedFile.FileName;
                string fileext = Path.GetExtension(filename);
                string renamefile = string.Empty;
                decimal filesize = decimal.Parse((decimal.Parse(postedFile.ContentLength.ToString()) / 1048576).ToString("0.00"));
                if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentMaster ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.EmployeeGeneral ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)InstituteManagementScreenId.Setup.OrganizationMaster ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.UploadResult && fileext.ToLower() == ".pdf") ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)SupportScreenId.Utility.ViewPhoto && filesize <= 1 ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Assignment ||
                    //SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Circular && filesize <= 10 && ValidCircularExtensionList.Contains(fileext.ToLower()) ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Circular && filesize <= 10 && ValidCircularExtensionList.Contains(fileext.ToLower()) ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.Classwork && ValidClassworkFileExtensionList.Contains(fileext.ToLower()) ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.MyLeave && ValidClassworkFileExtensionList.Contains(fileext.ToLower()) ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.Leave && ValidClassworkFileExtensionList.Contains(fileext.ToLower())) ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)ComponentsScreenId.Alert.SMSFromExcel && (fileext.ToLower() == ".xls" || fileext.ToLower() == ".xlsx")) ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportEmployee && (fileext.ToLower() == ".xls" || fileext.ToLower() == ".xlsx" || fileext.ToLower() == ".csv")) ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStudent && (fileext.ToLower() == ".xls" || fileext.ToLower() == ".xlsx" || fileext.ToLower() == ".csv")) ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportUser && (fileext.ToLower() == ".xls" || fileext.ToLower() == ".xlsx" || fileext.ToLower() == ".csv")) ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportBook && (fileext.ToLower() == ".xls" || fileext.ToLower() == ".xlsx")) ||
                     (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportFee && (fileext.ToLower() == ".xls" || fileext.ToLower() == ".xlsx")) ||
                      (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportAdmissionForm && (fileext.ToLower() == ".xls" || fileext.ToLower() == ".xlsx")) ||
                      (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportSubjectActivity && (fileext.ToLower() == ".xls" || fileext.ToLower() == ".xlsx")) ||
                       (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportSubjectActivityIndicator && (fileext.ToLower() == ".xls" || fileext.ToLower() == ".xlsx")) ||
                       (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportCoScholasticIndicator && (fileext.ToLower() == ".xls" || fileext.ToLower() == ".xlsx")) ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.MonthlyAttendance && (fileext.ToLower() == ".xls" || fileext.ToLower() == ".xlsx")) ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentDataUpdate && (fileext.ToLower() == ".xls" || fileext.ToLower() == ".xlsx")) ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.FeeInvoiceImport && (fileext.ToLower() == ".xls" || fileext.ToLower() == ".xlsx")) ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.FeeReceiptImport && (fileext.ToLower() == ".xls" || fileext.ToLower() == ".xlsx")) ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.BulkEmployeeDataUpdate && (fileext.ToLower() == ".xls" || fileext.ToLower() == ".xlsx")) ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryAllSubject && fileext.ToLower() == ".xls") ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryForAll && fileext.ToLower() == ".xls") ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadStudentPhoto && ValidPhotosExtensionList.Contains(fileext.ToLower())) ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadEmployeePhoto && ValidPhotosExtensionList.Contains(fileext.ToLower()) && context.Session["UploadFor"] == "TempEmployeePhotos") ||
                    (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadEmployeePhoto && ValidPhotosExtensionList.Contains(fileext.ToLower()) && filesize <= (decimal)0.01 && context.Session["UploadFor"] == "TempEmployeeSign") ||

                      (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadCandidatePhoto && ValidPhotosExtensionList.Contains(fileext.ToLower()) && context.Session["UploadFor"] == "TempCandidatePhotos") ||
                    //(SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadCandidatePhoto && ValidPhotosExtensionList.Contains(fileext.ToLower()) && filesize <= (decimal)0.01 && context.Session["UploadFor"] == "TempEmployeeSign") ||



                    SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadOrganizationPhoto ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.ReceiptBookMaster ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)SupportScreenId.Utility.VideoMaster && filesize <= 25 ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentDocuments ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.EmployeeDocument ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentOtherPhoto ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentICard ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.EmployeeICard ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.UploadEBookView ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)AttendanceScreenId.Attendance.DivisionRegister ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.StudentResultRemark ||
                       SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.SubjectRemark ||
                        SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryOtherDetail ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSExamScoreBulk ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Administration.ImportMasterData ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportAdmissionInquiry ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryAllSubject ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockInwardBulk ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSIndicatorMaster ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.SubjectIndicator ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSExamMarkEntryBulk ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.BulkUpdate ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.TopicMaster ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSExamIndicator ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportHostel ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.SubjectActivityGradeScoreBulk ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.SubjectActivityMarkEntryBulk ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStudentOldDetail ||
                     SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockInwardNew ||
                     SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockIssueNew ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockAdjustment ||
                    SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStockItem||
                     SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryForAll
                )
                {
                    if (!Directory.Exists(savepath))
                    {
                        Directory.CreateDirectory(savepath);

                        DirectoryInfo dir1 = new DirectoryInfo(savepath);
                        System.Security.Principal.WindowsIdentity self = System.Security.Principal.WindowsIdentity.GetCurrent();
                        DirectorySecurity ds = dir1.GetAccessControl();
                        ds.AddAccessRule(new FileSystemAccessRule(self.Name,
                        FileSystemRights.FullControl,
                        InheritanceFlags.ObjectInherit |
                        InheritanceFlags.ContainerInherit,
                        PropagationFlags.None,
                        AccessControlType.Allow));
                        dir1.SetAccessControl(ds);
                    }
                    if ((fileext.ToLower() == ".jpg" || fileext.ToLower() == ".jpeg" || fileext.ToLower() == ".png" || fileext.ToLower() == ".gif") &&
                        (SecuritySession.UserProfile.CurrentScreenId != (int)SupportScreenId.Utility.ViewPhoto)
                        && SecuritySession.UserProfile.CurrentScreenId != (int)StudentManagementScreenId.Student.StudentDocuments
                        && SecuritySession.UserProfile.CurrentScreenId != (int)HRScreenId.EmployeeManagement.EmployeeDocument)
                    {
                        if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadOrganizationPhoto)
                        {

                            if (context.Session["UploadFor"] != null && context.Session["UploadFor"] == "PrincipalSignature")
                            {

                                renamefile = "PrincipalSignature" + Path.GetExtension(filename);
                                Stream strm = postedFile.InputStream;
                                var targetFile = savepath + "/" + renamefile;
                                //Based on scalefactor image size will vary
                                //GenerateThumbnails(strm, targetFile);
                                GenerateImage(strm, targetFile);

                                context.Response.Write(targetFile);
                                context.Response.StatusCode = 200;
                                context.Session["ImagePath"] = tempPath + "/" + renamefile;


                            }

                            else if (context.Session["UploadFor"] != null && context.Session["UploadFor"] == "OrganizationHead")
                            {

                                renamefile = "OrganizationHead" + Path.GetExtension(filename);
                                Stream strm = postedFile.InputStream;
                                var targetFile = savepath + "/" + renamefile;
                                //Based on scalefactor image size will vary
                                //GenerateThumbnails(strm, targetFile);
                                GenerateImage(strm, targetFile);

                                context.Response.Write(targetFile);
                                context.Response.StatusCode = 200;
                                context.Session["ImagePath"] = tempPath + "/" + renamefile;


                            }

                            else if (context.Session["UploadFor"] != null && context.Session["UploadFor"] == "OrganizationHeadA4Landscape")
                            {

                                renamefile = "LandscapeA4" + Path.GetExtension(filename);
                                Stream strm = postedFile.InputStream;
                                var targetFile = savepath + "/" + renamefile;
                                //Based on scalefactor image size will vary
                                //GenerateThumbnails(strm, targetFile);
                                GenerateImage(strm, targetFile);

                                context.Response.Write(targetFile);
                                context.Response.StatusCode = 200;
                                context.Session["ImagePath"] = tempPath + "/" + renamefile;


                            }

                            else if (context.Session["UploadFor"] != null && context.Session["UploadFor"] == "IcardBg")
                            {

                                renamefile = "IcardBg" + Path.GetExtension(filename);
                                Stream strm = postedFile.InputStream;
                                var targetFile = savepath + "/" + renamefile;
                                //Based on scalefactor image size will vary
                                //GenerateThumbnails(strm, targyeetFile);
                                GenerateImage(strm, targetFile);

                                context.Response.Write(targetFile);
                                context.Response.StatusCode = 200;
                                context.Session["ImagePath"] = tempPath + "/" + renamefile;


                            }
                            else if (context.Session["UploadFor"] != null && context.Session["UploadFor"] == "IcardBackBg")
                            {

                                renamefile = "IcardBackBg" + Path.GetExtension(filename);
                                Stream strm = postedFile.InputStream;
                                var targetFile = savepath + "/" + renamefile;
                                //Based on scalefactor image size will vary
                                //GenerateThumbnails(strm, targetFile);
                                GenerateImage(strm, targetFile);

                                context.Response.Write(targetFile);
                                context.Response.StatusCode = 200;
                                context.Session["ImagePath"] = tempPath + "/" + renamefile;


                            }
                            else if (context.Session["UploadFor"] != null && context.Session["UploadFor"] == "LoginBG")
                            {

                                renamefile = "LoginBG" + Path.GetExtension(filename);
                                Stream strm = postedFile.InputStream;
                                var targetFile = savepath + "/" + renamefile;
                                //Based on scalefactor image size will vary
                                //GenerateThumbnails(strm, targetFile);
                                GenerateImage(strm, targetFile);

                                context.Response.Write(targetFile);
                                context.Response.StatusCode = 200;
                                context.Session["ImagePath"] = tempPath + "/" + renamefile;


                            }
                            else if (context.Session["UploadFor"] != null && context.Session["UploadFor"] == "MobileAppLogo")
                            {

                                renamefile = "SchoolLogo" + Path.GetExtension(filename);
                                Stream strm = postedFile.InputStream;
                                var targetFile = savepath + "/" + renamefile;
                                //Based on scalefactor image size will vary
                                //GenerateThumbnails(strm, targetFile);
                                GenerateImage(strm, targetFile);

                                context.Response.Write(targetFile);
                                context.Response.StatusCode = 200;
                                context.Session["ImagePath"] = tempPath + "/" + renamefile;


                            }


                            else
                            {
                                // renamefile = "SchoolLogo" + Path.GetExtension(filename);
                                renamefile = "SchoolLogo.jpg";
                                Stream strm = postedFile.InputStream;
                                var targetFile = savepath + "/" + renamefile;
                                //Based on scalefactor image size will vary
                                //GenerateThumbnails(strm, targetFile, 100, 100);
                                GenerateImage(strm, targetFile);
                                context.Response.Write(targetFile);
                                context.Response.StatusCode = 200;
                                context.Session["ImagePath"] = tempPath + "/" + renamefile;
                            }
                        }

                        else if (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.ReceiptBookMaster)
                        {
                            if (context.Session["UploadFor"] != null && context.Session["UploadFor"] == "ReceiptLogo")
                            {
                                renamefile = "ReceiptLogo" + Path.GetExtension(filename);
                                Stream strm = postedFile.InputStream;
                                var targetFile = savepath + "/" + renamefile;
                                GenerateImage(strm, targetFile);
                                context.Response.Write(targetFile);
                                context.Response.StatusCode = 200;
                                context.Session["ImagePath"] = tempPath + "/" + renamefile;
                            }
                            if (context.Session["UploadForInvoice"] != null && context.Session["UploadForInvoice"] == "ReceiptLogo1")
                            {
                                renamefile = "ReceiptLogo1" + Path.GetExtension(filename);
                                Stream strm = postedFile.InputStream;
                                var targetFile = savepath + "/" + renamefile;
                                GenerateImage(strm, targetFile);
                                context.Response.Write(targetFile);
                                context.Response.StatusCode = 200;
                                context.Session["ImagePath"] = tempPath + "/" + renamefile;
                            }
                        }

                        else if (context.Session["UploadFor"] != null && context.Session["UploadFor"] == "StudentICard")
                        {

                            // renamefile = "IcardBg" + Path.GetExtension(filename);
                            Stream strm = postedFile.InputStream;
                            var targetFile = savepath + "/" + filename;
                            //Based on scalefactor image size will vary
                            //GenerateThumbnails(strm, targetFile);
                            GenerateImage(strm, targetFile);

                            context.Response.Write(targetFile);
                            context.Response.StatusCode = 200;
                            context.Session["ImagePath"] = tempPath;


                        }
                        else if (context.Session["UploadFor"] != null && context.Session["UploadFor"] == "EmployeeICard")
                        {

                            // renamefile = "IcardBg" + Path.GetExtension(filename);
                            Stream strm = postedFile.InputStream;
                            var targetFile = savepath + "/" + filename;
                            //Based on scalefactor image size will vary
                            //GenerateThumbnails(strm, targetFile);
                            GenerateImage(strm, targetFile);

                            context.Response.Write(targetFile);
                            context.Response.StatusCode = 200;
                            context.Session["ImagePath"] = tempPath;


                        }
                        else if (SecuritySession.UserProfile.CurrentScreenId == (int)(int)CommunicationScreenId.Communication.UploadEBookView)
                        {
                            if ((fileext.ToLower() == ".jpg" || fileext.ToLower() == ".jpeg"))
                            {

                                //if (context.Session["BookView"] != null && context.Session["BookView"] == "TempPhotos")
                                //{

                                int result;
                                string numericname;
                                numericname = Path.GetFileNameWithoutExtension(filename);

                                if (int.TryParse(numericname, out result))
                                {

                                    renamefile = Path.GetFileName(filename);
                                    Stream strm = postedFile.InputStream;
                                    var targetFile = savepath + "/" + renamefile;
                                    //Based on scalefactor image size will vary
                                    //GenerateThumbnails(strm, targetFile);
                                    GenerateImage(strm, targetFile);

                                    context.Response.Write(targetFile);
                                    context.Response.StatusCode = 200;
                                    context.Session["ImagePath"] = tempPath + "/" + renamefile;

                                }
                                else
                                {
                                    MessageBox.Show("Image Name should be a Number");
                                }
                                // }
                            }
                            else
                            {
                                MessageBox.Show("File Extension Must be .jpg or .jpeg");
                            }
                        }

                        else
                        {
                            Stream strm = postedFile.InputStream;
                            var targetFile = savepath + "/" + filename;
                            //Based on scalefactor image size will vary
                            if (SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Assignment ||
                                //SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Circular ||
                                SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Circular ||
                                 SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.EmployeeDocument ||
                                SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.Leave ||
                                SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.MyLeave ||
                                SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.Classwork ||
                                (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadEmployeePhoto && context.Session["UploadFor"] == "TempEmployeeSign")
                                )
                                GenerateImage(strm, targetFile);
                            else
                                GenerateThumbnails(strm, targetFile, 120, 120);
                            context.Response.Write(targetFile);
                            context.Response.StatusCode = 200;
                            context.Session["ImagePath"] = tempPath + "/" + filename;
                        }
                    }



                    else
                    {
                        if (SecuritySession.UserProfile.CurrentScreenId == (int)ComponentsScreenId.Alert.SMSFromExcel ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportEmployee ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStudent ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportUser ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportBook ||
                             SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportFee ||
                               SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportAdmissionForm ||
                             SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportSubjectActivity ||
                             SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportSubjectActivityIndicator ||
                               SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportCoScholasticIndicator ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.MonthlyAttendance ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentDataUpdate ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.FeeInvoiceImport ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.FeeReceiptImport ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.BulkEmployeeDataUpdate ||
                             SecuritySession.UserProfile.CurrentScreenId == (int)AttendanceScreenId.Attendance.DivisionRegister ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.StudentResultRemark ||
                             SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.SubjectRemark ||
                              SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryOtherDetail ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSExamScoreBulk ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSExamMarkEntryBulk ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Administration.ImportMasterData ||
                             SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryAllSubject ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportAdmissionInquiry ||
                           SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockInwardBulk ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSIndicatorMaster ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.SubjectIndicator ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSExamMarkConvert ||

                            SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.BulkUpdate ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.TopicMaster ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSExamIndicator ||
                             SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportHostel
                            || SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.SubjectActivityGradeScoreBulk
                            || SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStudentOldDetail ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockInwardNew ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockIssueNew ||
                            SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockAdjustment
                              || SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStockItem||
                            SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryForAll
                            )
                        {
                            if (SecuritySession.UserProfile.CurrentScreenId == (int)ComponentsScreenId.Alert.SMSFromExcel)
                                renamefile = "SMSOrMail.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportEmployee)
                                renamefile = "Employees" + fileext;
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStudent)
                                renamefile = "Students" + fileext;
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportUser)
                                renamefile = "Users" + fileext;
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportBook)
                                renamefile = "Books.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportFee)
                                renamefile = "Fee.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportAdmissionForm)
                                renamefile = "AdmissionForm.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportSubjectActivity)
                                renamefile = "Activity.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportSubjectActivityIndicator)
                                renamefile = "ActivityIndicator.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportCoScholasticIndicator)
                                renamefile = "CoScholasticIndicator.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.MonthlyAttendance)
                                renamefile = "MonthlyAttendance_Import_Template.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)StudentManagementScreenId.Student.StudentDataUpdate)
                                renamefile = "StudentDataUpdate_Import_Template.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.FeeInvoiceImport)
                                renamefile = "FeeInvoiceImport_Import_Template.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)FeeManagementScreenId.FeeManagement.FeeReceiptImport)
                                renamefile = "FeeReceiptImport_Import_Template.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)HRScreenId.EmployeeManagement.BulkEmployeeDataUpdate)
                                renamefile = "EmployeeDataUpdate_Import_Template.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)AttendanceScreenId.Attendance.DivisionRegister)
                                renamefile = "Students.xls";

                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.StudentResultRemark)
                                renamefile = "TempRemark.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.SubjectRemark)
                                renamefile = "TempRemark.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryOtherDetail)
                                renamefile = "TempRemark.xls";

                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSExamScoreBulk)
                                renamefile = "CSExamScore.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Administration.ImportMasterData)
                                renamefile = "Import_Master_Data.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryAllSubject)
                                renamefile = "MarkEntry" + fileext;
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportAdmissionInquiry)
                                renamefile = "Import_Admission_Inquiry" + fileext;
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSIndicatorMaster)
                                renamefile = "CsIndicatorMaster" + fileext;


                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockInwardBulk)
                            {
                                renamefile = "StockInword.xls";

                            }
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.SubjectIndicator)
                            {
                                renamefile = "SubjectIndicatorMaster.xls";

                            }
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSExamMarkEntryBulk)
                                renamefile = "CSExamScoreSetup.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.BulkUpdate)
                                renamefile = "LessonPlan.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)AcademicScreenId.Academic.TopicMaster)
                                renamefile = "TopicMaster.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.CSExamIndicator)
                                renamefile = "CSExamIndicator.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportHostel)
                                renamefile = "Hostel.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)CCEAssessmentScreenId.CCEAssessment.SubjectActivityGradeScoreBulk)
                                renamefile = "SubjectActivityGradeScore.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStudentOldDetail)
                                renamefile = "ImportStudentOldDetail.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStudentOldDetail)
                                renamefile = "ImportStudentOldDetail.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockInwardNew)
                                renamefile = "Stock_Inward.xls";

                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockIssueNew)
                                renamefile = "StockIssue.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)MaterialManagementScreenId.Procurement.StockAdjustment)
                                renamefile = "Stock_Adjustment.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.ImportStockItem)
                                renamefile = "StockItem.xls";
                            else if (SecuritySession.UserProfile.CurrentScreenId == (int)AssessmentScreenId.Assessment.MarkEntryForAll)
                                renamefile = "MarkEntryForAll" + fileext;

                            postedFile.SaveAs(savepath + @"\" + renamefile);
                            context.Response.Write(tempPath + "/" + renamefile);
                            context.Response.StatusCode = 200;
                            context.Session["ImagePath"] = tempPath + "/" + renamefile;
                        }
                        else
                        {
                            postedFile.SaveAs(savepath + @"\" + filename);
                            context.Response.Write(tempPath + "/" + filename);
                            context.Response.StatusCode = 200;
                            context.Session["ImagePath"] = tempPath + "/" + filename;
                        }
                    }
                }
                else if (filesize > 25)
                    MessageBox.Show("You can't upload greater than 25 mb");
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)SupportScreenId.Utility.ViewPhoto && filesize > 1)
                    MessageBox.Show("You can't upload greater than 1 mb");
                else if ((SecuritySession.UserProfile.CurrentScreenId == (int)CommunicationScreenId.Communication.Circular) && filesize > 10)
                    MessageBox.Show("You can't upload greater than 10 mb");
                else if (SecuritySession.UserProfile.CurrentScreenId == (int)BaseframeworkScreenId.Utilities.UploadEmployeePhoto && filesize > (decimal)0.01 && context.Session["UploadFor"] == "TempEmployeeSign")
                    MessageBox.Show("You can't upload greater than 10 kb");

                else
                    MessageBox.Show("File not allowed");
            }
            else
            {
                context.Response.Write("session not created");
            }
        }
        catch (Exception ex)
        {
            context.Response.Write("Error: " + ex.Message);
        }
    }

    private void GenerateThumbnails(Stream sourcePath, string targetPath, int newwidth, int newheight)
    {
        using (var image = Image.FromStream(sourcePath))
        {
            //var newWidth = 120;
            //var newHeight = 120;
            var thumbnailImg = new Bitmap(newwidth, newheight);
            var thumbGraph = Graphics.FromImage(thumbnailImg);

            thumbGraph.CompositingQuality = CompositingQuality.HighQuality;
            thumbGraph.SmoothingMode = SmoothingMode.HighQuality;
            thumbGraph.InterpolationMode = InterpolationMode.HighQualityBilinear;
            thumbGraph.PixelOffsetMode = PixelOffsetMode.HighQuality;
            var imageRectangle = new Rectangle(0, 0, newheight, newheight);
            thumbGraph.DrawImage(image, imageRectangle);
            thumbnailImg.Save(targetPath, image.RawFormat);
        }
    }

    private void GenerateImage(Stream sourcePath, string targetPath)
    {
        using (var image = Image.FromStream(sourcePath))
        {
            //var newWidth = 120;
            //var newHeight = 120;
            var thumbnailImg = new Bitmap(sourcePath);
            var thumbGraph = Graphics.FromImage(thumbnailImg);
            thumbGraph.CompositingQuality = CompositingQuality.HighQuality;
            thumbGraph.SmoothingMode = SmoothingMode.HighQuality;
            thumbGraph.InterpolationMode = InterpolationMode.HighQualityBicubic;
            var imageRectangle = new Rectangle();
            thumbGraph.DrawImage(image, imageRectangle);
            thumbnailImg.Save(targetPath, image.RawFormat);
        }
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }

}

 