﻿<%@ WebHandler Language="C#" Class="ClassWise_file_upload" %>

using System;
using System.Web;
using System.IO;
using Sapphire.Ohu.Web.SessionHelper;
using System.Windows.Forms;
using Sapphire.Ohu.Web.PageController;
using Sapphire.Ohu.BusinessEntity.Framework.BaseFrameworkBE;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Security.AccessControl;
using System.Collections.Generic;
using System.Web.SessionState;
using System.Linq;
using System.Data;

public class ClassWise_file_upload : IHttpHandler, System.Web.SessionState.IRequiresSessionState, System.Web.SessionState.IReadOnlySessionState
{
    public void ProcessRequest(HttpContext context)
    {
        //context.Response.ContentType = "text/plain";
        //context.Response.Write("Hello World");
        var _with1 = HttpContext.Current;
        string strPath = _with1.Server.MapPath("~/Content/");
        HttpFileCollection postedFile = context.Request.Files;        

        string CurrentSize = string.Empty;
        string AllocatedSpace = Sapphire.Ohu.Web.Helper.ConfigurationHelper.GetUserConfigurationValue("Common.CloudStorage");
        string SQL = "SELECT ISNULL(SUM(UD.DocumentSize),0) FROM sCommon.tUploadDocument UD INNER JOIN sSetup.tOrgGroupBatchMaster OGBM ON OGBM.Id = UD.OrgGroupBatchId WHERE OGBM.OrgGroupId = " + SecuritySession.UserProfile.OrgGroupId;        
        Sapphire.Ohu.BaseFramework.Utilities.CommonFunctions cf = new Sapphire.Ohu.BaseFramework.Utilities.CommonFunctions();
        DataSet GetCurrentSizeDS = cf.GetDataset(SQL);
        if (GetCurrentSizeDS != null && GetCurrentSizeDS.Tables.Count > 0 && GetCurrentSizeDS.Tables[0].Rows.Count > 0)
        {
            CurrentSize = GetCurrentSizeDS.Tables[0].Rows[0][0].ToString();
        }

        decimal Size = decimal.Parse(CurrentSize) + postedFile[0].ContentLength / 1024;

        if (!string.IsNullOrEmpty(CurrentSize) && (Size / 1048576) > decimal.Parse(AllocatedSpace))
        {
            context.Response.Write("-007");
            return;
        }

        List<string> ValidCircularExtensionList = new List<string>() { "bmp", "gif", "jpeg", "jpg", "png", "pdf", "pptx", "ppt", "xlsx", "xls", "docx", "doc", "txt", "csv", "mp4", "heic" };
        string FileExtension = postedFile[0].FileName.Split('.').Last().ToLower();
        if (!ValidCircularExtensionList.Contains(FileExtension))
        {
            context.Response.Write("-008");
            return;
        }
        if (postedFile[0].FileName.Contains("//") || postedFile[0].FileName.Contains(".."))
        {
            context.Response.Write("-009");
            return;
        }
        
        string Code = "";
        string filename = "";
        Code = context.Request.QueryString["Code"];

        if (context.Session["ScreenId"].ToString() != null)
        {
            if (Convert.ToInt32(context.Session["ScreenId"].ToString()) == (int)StudentManagementScreenId.Student.MyDigitalForm)
            {
                if (context.Session["DigitalFormId"] != null)
                {
                    string[] AssignFor = Code.Split('_');
                    string Assign = AssignFor[1].ToString();

                    strPath = strPath + context.Session["OrgId"].ToString() + "/DigitalForm/TempStudentPhotos/" + context.Session["DigitalFormId"] + "/" + context.Session["StudentId"] + "/" + Assign;
                    if (Directory.Exists(strPath))
                        Directory.Delete(strPath, true);

                    if (!System.IO.Directory.Exists(strPath))
                    {
                        System.IO.Directory.CreateDirectory(strPath);
                        strPath = strPath + "/";

                    }
                    else
                        strPath = strPath + "/";
                }
                else
                {
                    strPath = strPath + context.Session["OrgId"] + "/DigitalForm/Temp";
                    if (!System.IO.Directory.Exists(strPath))
                        System.IO.Directory.CreateDirectory(strPath);
                    else
                        strPath = strPath + "/";
                }
            }
        }
        
        for (int i = 0; i < postedFile.Count; i++)
        {
            HttpPostedFile file = postedFile[i];
            filename = file.FileName;
            string fileExt1 = System.IO.Path.GetExtension(filename).Replace(".", "");

            if (Convert.ToInt32(context.Session["ScreenId"].ToString()) == (int)StudentManagementScreenId.Student.MyDigitalForm)
            {
                filename = filename + "." + fileExt1.ToString();
            }
            
            context.Session["FileName"] = filename;

            file.SaveAs(strPath + "/" + filename);

            if (System.IO.File.Exists(strPath))
            {
                
            }
        }
      
    }
  

    string str = "";

    
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
}