﻿var gE = function(id) { return document.getElementById(id); }
var MessageArray = new Array();

var DivTableHeader = "<div class='himssuHeader1WireBox'>"
                            + "<div class='himsBoxHeader'>"
                                    + "<div class='leftdiv'>"
                                    + "</div>"
                                        + "<div class='himsBoxTitle'>"
                                            + "<div class='headerText'>"
                                                 + "<SPAN ID='SPAN1'>Laboratory Test Request</SPAN>"
                                               + "</div>"
                                         + "</div>"
                            + "</div>"
                            + "<div class='himsBoxContent'>"
                                + "<div class='contentHolder'>";
var DivTableFooter = "</div></div></div>";

/****************************************************************************************
Function/Procedure  Name            :- fnDisableFields
functionality                       :- This function will take arguments as param array and  Disable coresponding fields
Parameters                          :- ControlId to Disable with comma separated( Ex ("txtCleintId","txtAddress","txtPhone")
returns                             :- None 
written by                          :- Rajendra Patel
		
****************************************************************************************/

function fnDisableFields() {
    for (var i = 0; i < arguments.length; i++) {
        gE(arguments[i]).disabled = true;
    }
}


/****************************************************************************************
Function/Procedure  Name            :- fnCheckEmail
functionality                       :- This function will validate the email Id of given control.
Parameters                          :- Control Value as a String.
returns                             :- boolean 
written by                          :- Rajendra Patel
		
****************************************************************************************/

function fnCheckEmail(ctlValue) {
    var strObjValue = fnTrim(ctlValue);
    var strMail = fnTrim(ctlValue);
    if (strMail.length > 0) {
        if (!fnValidateEmail(strObjValue))
            return false;
    }
}

/****************************************************************************************
Function/Procedure  Name            :- fnValidateEmail
functionality                       :- This function will validate the email Id.
Parameters                          :- String.
returns                             :- boolean 
written by                          :- Rajendra Patel
		
****************************************************************************************/
function fnValidateEmail(str) {
    var emailRegxp = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
    if (emailRegxp.test(str) != true)
        return false;
    return true;
}

/****************************************************************************************
Function/Procedure  Name            :- fnTrim
functionality                       :- this function will trim the string
Parameters                          :- String.
returns                             :- String 
written by                          :- Rajendra Patel
		
****************************************************************************************/
function fnTrim(str) {
    if (typeof (str) != "string") return str;
    var len = str.length;
    var cnt = 0;
    while (str.charAt(cnt) == " ") {
        cnt = cnt + 1;
        if (cnt >= len)
            break;
    }
    str = str.slice(cnt, len);
    len = str.length;
    cnt = len - 1;
    while (str.charAt(cnt) == " ") {
        cnt = cnt - 1;
        if (cnt <= 0)
            break;
    }
    str = str.slice(0, cnt + 1);
    return str;
}
/****************************************************************************************
Function/Procedure  Name            :- fnClearTextBox
functionality                       :- This function will clear the Texboxes and will take  arguments as param array 
Parameters                          :- ControlId  with comma separated( Ex ("txtCleintId","txtAddress","txtPhone")
returns                             :- None 
written by                          :- Rajendra Patel
		
****************************************************************************************/
function fnIsValidPhone(ctlValue) {
    var strName = fnTrim(ctlValue);
    var strCharpos = strName.search("[^0-9,(,),+,-]");
    if (strName.length > 0 && strCharpos >= 0) {
        return false;
    }
    return true;
}

function fnRequiredField(ctlValue) {
    if (ctlValue == null || ctlValue == 'null')
        return false;
    if (ctlValue.length == 0)
        return false;
    return true;
}

function fnErrorMessage(msg) {
    fnSetErrorMsgColor();
    gE("lblMessage").innerHTML = msg;
}

function fnAlphaNumeric(strParam) {
    var strNumaric = fnTrim(strParam);
    for (var j = 0; j < strNumaric.length; j++) {
        var charParam = strNumaric.charAt(j);
        var iChar = charParam.charCodeAt(0);
        if ((iChar == 32) || (iChar > 47 && iChar < 59) || (iChar > 64 && iChar < 91) || (iChar > 96 && iChar < 123)) {

        }
        else {
            return false;
        }
    }

    return true;
}


function fnNumericCheck(strParam) {
    var strNumaric = fnTrim(strParam);



    for (var j = 0; j < strNumaric.length; j++) {
        var charParam = strNumaric.charAt(j);
        var iChar = charParam.charCodeAt(0);
        if (iChar > 47 && iChar < 59) {

        }
        else {
            return false;
        }
    }

    return true;
}
function fnNumericCheckOnTextChange(txt) {
    var strNumaric = fnTrim(txt.value);
    for (var j = 0; j < strNumaric.length; j++) {
        var charParam = strNumaric.charAt(j);
        var iChar = charParam.charCodeAt(0);
        if (iChar > 47 && iChar < 59) {

        }
        else {
            txt.value = "";
            return false;
        }
    }

    return true;
}

function fnCheckAmount(strName) {
    var strCharpos = strName.search("[^0-9,.]");
    if ((strName.length > 0 && strCharpos >= 0) || (strName.indexOf('.') != strName.lastIndexOf('.'))) {
        return false;
    }
    return true;
}

function fnCheckSpaceChar(strFieldName) {
    var strEmpty = "";
    if ((strFieldName.indexOf("nbsp")) >= 0) {
        return strEmpty;
    }
    else {
        return strFieldName;
    }
}

function hims_ctl_val(ControlID, ErrorMsg, Required, ValidationType, MinValue, MaxValue, MaxLength, DepControlID, ValidationFormat) {
    if (ControlID == '' || ErrorMsg == '' || Required == '')
        return null;
    if (typeof (ControlID) == "string") {
        this.ControlID = gE(ControlID); ///fnGetControl(ControlID);
        this.ErrorMsg = ErrorMsg;
        this.Required = Required;
        this.ValidationType = ValidationType;
        this.MinValue = MinValue;
        this.MaxValue = MaxValue;
        this.MaxLength = MaxLength;
        this.CtlName = ControlID;
        this.status = 'F';
    }
    return this;
}

function functionSetMandatoryField(himsMandatoryField) {
    for (var i = 0; i < himsMandatoryField.length; i++) {
        if (himsMandatoryField[i].ControlId.nodeName == "SPAN") {
            himsMandatoryField[i].ControlId.className = himsMandatoryField[i].className;
            himsMandatoryField[i].ControlId.parentElement.className = "formLabel";
        }
        if (himsMandatoryField[i].ControlId.nodeName == "TABLE") {
            himsMandatoryField[i].ControlId.parentElement.innerHTML = DivTableHeader + himsMandatoryField[i].ControlId.parentElement.innerHTML + DivTableFooter;
            gE("SPAN1").innerHTML = himsMandatoryField[i].headertext;
            gE("SPAN1").Id = "";            
        }

    }
}

function hims_Ctl_Mandatory(ControlId, className, headertext) {
    if (ControlId == '')
        return null;
    if (typeof (ControlId) == "string") {
        this.ControlId = gE(ControlId);
        this.className = className;
        this.headertext = headertext;
    }
    return this;
}

function fnDoValidate(himsValidator) {
    MessageArray = new Array();
    indexValue = 0;
    for (var i = 0; i < himsValidator.length; i++) {
        himsValidator[i].status = 'S';
        if (himsValidator[i].Required == 'T' && himsValidator[i].ValidationType == "") {
            if (fnTrim(himsValidator[i].ControlID.value) == "" && gE(himsValidator[i].CtlName).nodeName != "SELECT") {

                himsValidator[i].status = 'F';
                MessageArray[i] = himsValidator[i].ErrorMsg;
            }
            else if (gE(himsValidator[i].CtlName).nodeName == "SELECT") {
                if (fnTrim(himsValidator[i].ControlID.value) == "-1" || fnTrim(himsValidator[i].ControlID.value) == "") {
                    himsValidator[i].status = 'F';
                    MessageArray[i] = himsValidator[i].ErrorMsg;
                }
                else
                    himsValidator[i].status = 'S';
            }
            else if (himsValidator[i].ControlID.type == "checkbox") {
                if (himsValidator[i].ControlID.checked == false) {
                    himsValidator[i].status = 'F';
                    MessageArray[i] = himsValidator[i].ErrorMsg;
                }
                else
                    himsValidator[i].status = 'S';
            }
            else
                himsValidator[i].status = 'S';
        }
        if (himsValidator[i].Required == 'T' && himsValidator[i].ValidationType == 'AN') {
            if (fnTrim(himsValidator[i].ControlID.value) == "") {
                himsValidator[i].status = 'F';
                MessageArray[i] = himsValidator[i].ErrorMsg;
            }
            else if (fnAlphaNumeric(himsValidator[i].ControlID.value) == false) {
                himsValidator[i].status = 'F';
                MessageArray[i] = himsValidator[i].ErrorMsg;
            }
            else
                himsValidator[i].status = 'S';
        }

        if (himsValidator[i].Required == 'T' && himsValidator[i].ValidationType == 'N') {
            if (fnTrim(himsValidator[i].ControlID.value) == "") {
                himsValidator[i].status = 'F';
                MessageArray[i] = himsValidator[i].ErrorMsg;
            }
            else if (fnNumericCheck(himsValidator[i].ControlID.value) == false) {
                himsValidator[i].status = 'F';
                MessageArray[i] = himsValidator[i].ErrorMsg;
            }
            else
                himsValidator[i].status = 'S';
        }
        if (himsValidator[i].Required == 'T' && himsValidator[i].ValidationType == 'DC') {
            if (fnTrim(himsValidator[i].ControlID.value) == "") {
                himsValidator[i].status = 'F';
                MessageArray[i] = himsValidator[i].ErrorMsg;
            }
            else if (fnCheckAmount(himsValidator[i].ControlID.value) == false)
                himsValidator[i].status = 'F';
            else
                himsValidator[i].status = 'S';
        }

        if (himsValidator[i].Required == 'T' && himsValidator[i].ValidationType == 'DSI') {
            if (himsValidator[i].ControlID.selectedIndex <= 0) {
                himsValidator[i].status = 'F';
                MessageArray[i] = himsValidator[i].ErrorMsg;
            }
            else
                himsValidator[i].status = 'S';
        }
        if (himsValidator[i].Required == 'T' && himsValidator[i].ValidationType == 'TIME' && MinValue != "" && MaxValue != "") {
            if (Date.parse(MinValue) > Date.parse(MaxValue)) {
                himsValidator[i].status = 'F';
                MessageArray[i] = himsValidator[i].ErrorMsg;
            }
            else
                himsValidator[i].status = 'S';
        }
        if (himsValidator[i].Required == 'F' && himsValidator[i].ValidationType == 'COUNT') {
            if (gE(himsValidator[i].CtlName).nodeName == "SELECT") {
                if (fnTrim(himsValidator[i].ControlID.length) == 0) {
                    himsValidator[i].status = 'F';
                    MessageArray[i] = himsValidator[i].ErrorMsg;
                }
                else
                    himsValidator[i].status = 'S';

            }
        }
    }
    for (var j = 0; j < himsValidator.length; j++) {
        if (himsValidator[j].status == 'F') {
            SetMessageBoxDetails(MessageArray);
            return false;
        }

    }
    ResetMessageBox();
    return true;
}

/****************************************************************************************
Function/Procedure  Name            :- fnEnableFields
functionality                       :- This function will take arguments as param array and  Enable coresponding fields
Parameters                          :- ControlId to Enable with comma separated( Ex ("txtCleintId","txtAddress","txtPhone")
returns                             :- None 
written by                          :- Rajendra Patel
		
****************************************************************************************/

function fnEnableFields() {
    for (var i = 0; i < arguments.length; i++) {
        fnGetControl(arguments[i]).disabled = false;
    }
}

/****************************************************************************************
Function/Procedure  Name            :- fnClearTextBox
functionality                       :- This function will clear the Texboxes and will take  arguments as param array 
Parameters                          :- ControlId  with comma separated( Ex ("txtCleintId","txtAddress","txtPhone")
returns                             :- None 
written by                          :- Rajendra Patel
		
****************************************************************************************/

function fnClearTextBox() {
    for (var i = 0; i < arguments.length; i++) {
        fnEnableFields(arguments[i]);
        fnGetControl(arguments[i]).value = "";
        fnDisableFields(arguments[i]);
    }
}



// Function To Entering Only Numeric Values In Text Box... 
// Validates On Key Press Event
function fnNumeric(e) {
    var unicode = e.charCode ? e.charCode : e.keyCode
    if (unicode < 8 || unicode > 9) {
        //if the key isn't the backspace key or tab key (which we should allow)
        if (unicode < 48 || unicode > 57) //if not a number
            return false //disable key press
    }
}
function fnDecimalCheckOnKeyPress(evt) {
    //debugger;
    var unicode = evt.charCode ? evt.charCode : evt.keyCode
    if (unicode < 8 || unicode > 9) {
        if (!(unicode == 46 || (unicode >= 48 && unicode <= 57))) return false;
        var parts = evt.srcElement.value.split('.');
        if (parts.length > 2) return false;
        if (unicode == 46) return (parts.length == 1);
    }
}

function fnDecimalCheckOnTextChange(txt) {
    var strName = fnTrim(txt.value);
    var strCharpos = strName.search("[^0-9,.]");
    if ((strName.length > 0 && strCharpos >= 0) || (strName.indexOf('.') != strName.lastIndexOf('.'))) {
        txt.value = "";
        return false;
    }
    return true;
}


/****************************************************************************************
Function/Procedure  Name            :- fnmodalWink
functionality                       :- Function to open Search Window.
****************************************************************************************/

var childPopupArray = new Array(30)

function refreshModalWin(strFullWindowName, strWindowTitle, dialogSize) {

    var targetWin = null;
    var CurrentPopUpIndex = 0;
    for (var PopUpCount = 0; PopUpCount < childPopupArray.length - 1; PopUpCount++) {
        if (childPopupArray[PopUpCount] != undefined)
            if (childPopupArray[PopUpCount][0] == strWindowTitle) {
                targetWin = childPopupArray[PopUpCount][1];
                if (targetWin.closed)
                    childPopupArray[PopUpCount] = undefined;
                break;
            }
    }
    if (targetWin != null && targetWin.closed)
        targetWin = null;
    if (targetWin == null) {
        targetWin = window.open(strFullWindowName, '', 'height=1000,width=1200,toolbar=no,directories=no,status=no, menubar=no,scrollbars=no,resizable=yes');
        targetWin.moveTo(0, 0);
        targetWin.resizeTo(screen.availWidth, screen.availHeight);
    }

    else {
        targetWin.location = strFullWindowName;
        targetWin.focus();
        targetWin.moveTo(0, 0);
        targetWin.resizeTo(screen.availWidth, screen.availHeight);
    }
    for (var ExistingPopUpCount = 0; ExistingPopUpCount < childPopupArray.length - 1; ExistingPopUpCount++) {
        if (childPopupArray[ExistingPopUpCount] != undefined)
            if (childPopupArray[ExistingPopUpCount][0] == strWindowTitle) {
                childPopupArray[ExistingPopUpCount][1] = targetWin;
                CurrentPopUpIndex = ExistingPopUpCount;
                break;
            }
    }
    if (CurrentPopUpIndex == 0) {
        for (var EmptyPopUpCount = 0; EmptyPopUpCount < childPopupArray.length - 1; EmptyPopUpCount++) {
            if (childPopupArray[EmptyPopUpCount] == undefined) {
                childPopupArray[EmptyPopUpCount] = new Array(2);
                childPopupArray[EmptyPopUpCount][0] = strWindowTitle;
                childPopupArray[EmptyPopUpCount][1] = targetWin;
                break;
            }
        }
    }

} 


function modalWin(strFullWindowName, strWindowTitle) {

    var left = (screen.width / 2) - (250 / 2);
    var top = (screen.height / 2) - (255 / 2);

    if (window.showModalDialog) {
        window.showModalDialog(strFullWindowName, strWindowTitle, "dialogWidth:820px;dialogHeight:400px");
    }
    else {        
        window.open(strFullWindowName, strWindowTitle, 'height=255,width=250' + ', top=' + top + ', left=' + left + ',toolbar=no,directories=no,status=no, menubar=no,scrollbars=no,resizable=no ,modal=yes');
    }
}

function modalWin(strFullWindowName, strWindowTitle, width, height) {

    var left = (screen.width / 2) - (width / 2);
    var top = (screen.height / 2) - (height / 2);

    if (window.showModalDialog) {
        window.showModalDialog(strFullWindowName, strWindowTitle, "dialogWidth:" + width + "px ;dialogHeight:" + height + "px");
    }
    else {
        /*window.open(strFullWindowName, strWindowTitle, 'height=' + height + ',width=' + width + ',toolbar=no,directories=no,status=no, menubar=no,scrollbars=no,resizable=no ,modal=yes');*/
        window.open(strFullWindowName, strWindowTitle, 'height=' + height + ',width=' + width + ', top=' + top + ', left=' + left + ', toolbar=no,directories=no,status=no, menubar=no,scrollbars=no,resizable=no ,modal=yes');

    }
    __doPostBack("", strWindowTitle);
    return false;
}

function modalWinPopUp(strFullWindowName, strWindowTitle, width, height) {

    var left = (screen.width / 2) - (width / 2);
    var top = (screen.height / 2) - (height / 2);
    //window.showModalDialog(strFullWindowName, strWindowTitle, "dialogWidth:" + width + "px ;dialogHeight:" + height + "px");
    window.open(strFullWindowName, strWindowTitle, 'height=' + height + ',width=' + width + ', top=' + top + ', left=' + left + ', toolbar=no,directories=no,status=no, menubar=no,scrollbars=no,resizable=no ,modal=yes');
}


/****************************************************************************************
Function/Procedure  Name            :- PatientSearchmodalWin
functionality                       :- Function to open the Popup page.		
****************************************************************************************/

function PatientSearchModalWin(strFullWindowName, strWindowTitle) {

    var left = (screen.width / 2) - (1500 / 2);
    var top = (screen.height / 2) - (1500 / 2);

    if (window.showModalDialog) {
        window.showModalDialog(strFullWindowName, strWindowTitle, "dialogWidth:800px;dialogHeight:565px");
    }
    else {
        //window.open(strFullWindowName, strWindowTitle, 'height=1500px,width=1500px,toolbar=no,directories=no,status=no, menubar=no,scrollbars=no,resizable=no ,modal=yes');
        window.open(strFullWindowName, strWindowTitle, 'height=1500px,width=1500px ' + ', top=' + top + ', left=' + left + ', toolbar=no,directories=no,status=no, menubar=no,scrollbars=no,resizable=no ,modal=yes');

    } 
    __doPostBack("", "");
    return false;
}

function NonModalWin(strFullWindowName, strWindowTitle, width, height) {

    var left = (screen.width / 2) - (width / 2);
    var top = (screen.height / 2) - (height / 2);
    var targetWin = window.open(strFullWindowName, strWindowTitle, 'toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=yes, copyhistory=no, width=' + width + ', height=' + height + ', top=' + top + ', left=' + left);
}

/****************************************************************************************
Function/Procedure  Name            :- fnonTextChangeCodeField()
functionality                       :- Function to handle text Change For Code Field		
****************************************************************************************/
function fnonTextChangeCodeField(txt) {
    var strCode = fnTrim(txt.value);
    for (var j = 0; j < strCode.length; j++) {
        var charParam = strCode.charAt(j);
        var iChar = charParam.charCodeAt(0);
        if ((iChar > 64 && iChar < 91) || (iChar > 96 && iChar < 123) || (iChar == 45))//if not a number
        {
            txt.value = txt.value.toUpperCase();
        }
        else {
            txt.value = "";
            return false;
        }
    }
    __doPostBack(txt.Id, "TextChanged");
    //    return true;
}

/****************************************************************************************
Function/Procedure  Name            :- fnKeyPressForCodeField()
functionality                       :- Function to handle key Press For Code Field		
****************************************************************************************/
function fnKeyPressForCodeField(e) {
    try {

        var unicode = e.charCode ? e.charCode : e.keyCode
        if (unicode < 8 || unicode > 9) {
            //if the key isn't the backspace key or tab key (which we should allow)
            if ((unicode > 64 && unicode < 91) || (unicode > 96 && unicode < 123) || unicode == 45 || (unicode > 47 && unicode < 58)) //if not a number
                return true
            else
                return false;  //disable key press
        }

    }
    catch (e) {
    }
}

/****************************************************************************************
Function/Procedure  Name            :- fnonTextChangeCodeField()
functionality                       :- Function to handle text Change For Code Field		
****************************************************************************************/
function fnonTextChangeCodeField(txt) {
    //debugger; ;
    var strCode = fnTrim(txt.value);
    for (var j = 0; j < strCode.length; j++) {
        var charParam = strCode.charAt(j);
        var iChar = charParam.charCodeAt(0);
        if ((iChar > 64 && iChar < 91) || (iChar > 96 && iChar < 123) || (iChar == 45) || (iChar > 47 && iChar < 58))//if not a number
        {

        }
        else {
            txt.value = "";
            return false;
        }
    }
    txt.value = strCode.toUpperCase();    
    return false;
}

/****************************************************************************************
Function/Procedure  Name            :- fnKeyPressForDescriptionField()
functionality                       :- Function to handle key Press For Description Field		
****************************************************************************************/
function fnKeyPressForDescriptionField(e) {
    try {

        return true

    }
    catch (e) {
    }
}

/****************************************************************************************
Function/Procedure  Name            :- fnonTextChangeDescriptionField(txt)
functionality                       :- Function to handle text Change For Description Field		
****************************************************************************************/
function fnonTextChangeDescriptionField(txt) {
    try {

        return true

    }
    catch (e) {
    }
}

/****************************************************************************************
Function/Procedure  Name            :- fnKeyPressForNameField(e)
functionality                       :- Function to handle key Press For Description Field		
****************************************************************************************/
function fnKeyPressForNameField(e) {
    try {

        return true

    }
    catch (e) {
    }
}

/****************************************************************************************
Function/Procedure  Name            :- fnonTextChangeNameField(txt)
functionality                       :- Function to handle text Change For Description Field		
****************************************************************************************/
function fnonTextChangeNameField(txt) {
    try {

        return true

    }
    catch (e) {
    }
}



/****************************************************************************************
Function/Procedure  Name            :- fnKeyPressForCodeField()
functionality                       :- Function to handle key Press For Code Field		
****************************************************************************************/
function fnKeyPressForAutoCompleteCodeField(e) {
    try {

        var unicode = e.charCode ? e.charCode : e.keyCode
        if (unicode < 8 || unicode > 9) {
            //if the key isn't the backspace key or tab key (which we should allow)
            //debugger; ;
            if ((unicode > 64 && unicode < 91)
                || (unicode > 96 && unicode < 123)
                || unicode == 45                    // - sign
                || (unicode > 47 && unicode < 58)
                || (unicode == 189)                 // - sign
                || (unicode == 46)                 // Delete Key            
                )
                return true
            else
                return false;  //disable key press
        }

    }
    catch (e) {
    }
}

/****************************************************************************************
Function/Procedure  Name            :- fnonTextChangeCodeField()
functionality                       :- Function to handle text Change For Code Field		
****************************************************************************************/
function fnOnTextChangeAutoCompleteCodeField(txt) {
    var strCode = fnTrim(txt.value);
    for (var j = 0; j < strCode.length; j++) {
        var charParam = strCode.charAt(j);
        var iChar = charParam.charCodeAt(0);
        if ((iChar > 64 && iChar < 91) || (iChar > 96 && iChar < 123) || (iChar == 45) || (iChar > 47 && iChar < 58))//if not a number
        {

        }
        else {
            txt.value = "";
            return false;
        }
    }
    return false;
}

/****************************************************************************************
Function/Procedure  Name            :- fnKeyPressForDescriptionField()
functionality                       :- Function to handle key Press For Description Field		
****************************************************************************************/
function fnKeyPressForAutoCompleteDescriptionField(e) {
    try {

        return true

    }
    catch (e) {
    }
}

/****************************************************************************************
Function/Procedure  Name            :- fnonTextChangeDescriptionField(txt)
functionality                       :- Function to handle text Change For Description Field		
****************************************************************************************/
function fnOnTextChangeAutoCompleteDescriptionField(txt) {
    try {

        return true

    }
    catch (e) {
    }
}

/****************************************************************************************
Function/Procedure  Name            :- fnCloseWindow
functionality                       :- To Call Function to close the page.		
****************************************************************************************/

function fnCloseWindow() {
    window.close();
    return false;

}
function fnCloseRefreshWindow() {
    window.opener.location.href = window.opener.location.href;
    self.close();
    return false;

}
/****************************************************************************************
Function/Procedure  Name            :- CheckLength
functionality                       :- To restrict the user entering the max characters.		
****************************************************************************************/

function CheckLength(text, long) {
    var maxlength = new Number(long); // Change number to your max length.
    if (text.value.length > maxlength) {
        text.value = text.value.substring(0, maxlength);
    }
}

/****************************************************************************************
Function/Procedure  Name            :- showHideTooltip
functionality                       :- To display Tool Tip for DropDwonList and ListBox	
****************************************************************************************/


showHideTooltip = function() {


    var obj = event.srcElement;
    with (document.getElementById("tooltip")) {
        with (style) {
            if (event.type == "mouseleave") {
                display = "none";
                return;
            } else {
                display = "inline";
                left = event.x;
                top = event.y;
            }
        }
        if (obj.type == 'text') {
            innerHTML = obj.value;

            if (obj.value == '') {
                with (style) {
                    display = "none";
                    return;
                }
            }
        }
        if (obj.type == 'textarea') {
            innerHTML = obj.value;

            if (obj.value == '') {
                with (style) {
                    display = "none";
                    return;
                }
            }
        }
        else if (obj.selectedIndex > -1 && obj.type == 'select-one') {
            innerHTML = obj.options[obj.selectedIndex].innerText;
            for (var DropDownCount = 0; DropDownCount < obj.options.length; DropDownCount++) {
                obj.options[DropDownCount].title = obj.options[DropDownCount].innerText;
            }
        }
    }
}

function hims_TimePicker(ControlId, enable) {
    if (ControlId == '')
        return null;
    if (enable == "True")
        enable = false;
    else if (enable == "False")
        enable = true;
    if (typeof (ControlId) == "string") {
        this.ControlId = ControlId;
        this.enable = enable;
    }
    return this;
}

function DisableEnableTimePicker(himsTimePicker) {
    for (var i = 0; i < himsTimePicker.length; i++) {
        var ImageUpControlId = "ctl00$CP$" + himsTimePicker[i].ControlId + "_imgUp";
        var ImageDownControlId = "ctl00$CP$" + himsTimePicker[i].ControlId + "_imgDown";
        gE(ImageUpControlId).disabled = himsTimePicker[i].enable;
        gE(ImageDownControlId).disabled = himsTimePicker[i].enable;
    }
}



function EnableDisableTimePicker(himsTimePicker) {
    for (var i = 0; i < himsTimePicker.length; i++) {
        var ImageUpControlId = himsTimePicker[i].ControlId + "_imgUp";
        var ImageDownControlId = himsTimePicker[i].ControlId + "_imgDown";
        gE(ImageUpControlId).disabled = himsTimePicker[i].enable;
        gE(ImageDownControlId).disabled = himsTimePicker[i].enable;
    }
}



/****************************************************************************************
Function/Procedure  Name            :- MaskDecimal
functionality                       :- To Allow entering Decimal Values	
****************************************************************************************/

function MaskDecimal(evt, lengthOfIntegral, lengthOfMantisa) {
//    debugger;

    var unicode = evt.charCode ? evt.charCode : evt.keyCode

    if (unicode < 8 || unicode > 9) {
        if (!(unicode == 46 || unicode == 45 || (unicode >= 48 && unicode <= 57))) return false;
        var parts = evt.srcElement.value.split('.');
        if (parts.length > 2) return false;
        if (unicode == 46) return (parts.length == 1);
        if (evt.srcElement.value.length >= (lengthOfIntegral + lengthOfMantisa + 1)) return false;
        if (parts[0].length == lengthOfIntegral && parts.length == 1) return false;        
    }
}
/****************************************************************************************
Function/Procedure  Name            :- MaskDecimalWithNegative
functionality                       :- To Allow entering Decimal Values with Negative
****************************************************************************************/

function MaskDecimalWithNegative(evt, lengthOfIntegral, lengthOfMantisa) {
    //debugger;

    var unicode = evt.charCode ? evt.charCode : evt.keyCode

    if (unicode < 8 || unicode > 9) {
        if (!(unicode == 45 || unicode == 46 || (unicode >= 48 && unicode <= 57))) return false;
        var parts = evt.srcElement.value.split('.');
        if (parts.length > 2) return false;
        if (unicode == 46) return (parts.length == 1);
        if (evt.srcElement.value.length >= (lengthOfIntegral + lengthOfMantisa + 1)) return false;
        if (parts[0].length == lengthOfIntegral && parts.length == 1) return false;

        //if (parts.length == 2 && parts[1].length == 3) return false;
    }
} 
/****************************************************************************************
Function/Procedure  Name            :- fnValidateDecimal
functionality                       :- To validate Decimal Values	
****************************************************************************************/

function fnValidateDecimal(textbox, lengthOfIntegral, lengthOfMantisa) {
    var str = textbox.value;
    if (str.length == 0) {
        return true;
    }

    var integerRegExp = /^-?\d*[0-9]$/;

    str = textbox.value;
    if (str.length == 0) {
        return true;
    }
    var newStr = "";
    var parts = str.split('.');
    if (parts.length >= 2) {

        if ((parts[0].length > 0) && (integerRegExp.test(parts[0]) != true)) {
            textbox.value = "";
            return true;
        }
        if ((parts[1].length > 0) && (integerRegExp.test(parts[1]) != true)) {
            textbox.value = "";
            return true;
        }
        if (parts[0].length > lengthOfIntegral) {
            newStr = parts[0].substring(0, lengthOfIntegral);
        }
        else { newStr = parts[0]; }
        if (parts[1].length > lengthOfMantisa) {
            newStr = newStr + '.' + parts[1].substring(0, lengthOfMantisa);
        }
        else { newStr = newStr + '.' + parts[1]; }
    }
    else {
        if ((parts[0].length > 0) && (integerRegExp.test(parts[0]) != true)) {
            textbox.value = "";
            return true;
        }
        if (str.indexOf('.') >= 0) {
            if (str.length > lengthOfMantisa + 1) {
                newStr = str.substring(0, lengthOfMantisa + 1);
            }
            else { newStr = str; }
        }
        else {

            if (str.length > lengthOfIntegral) {
                newStr = str.substring(0, lengthOfIntegral);
            }
            else { newStr = str; }

        }
    }
    if (newStr.length > 0) {
        str = newStr;
    }
    textbox.value = str;
}
/****************************************************************************************
Function/Procedure  Name            :- fnValidateDecimal 
functionality                       :- To validate Decimal Values with negative values	
****************************************************************************************/
function fnValidateDecimalWithNegative(textbox, lengthOfIntegral, lengthOfMantisa) {
    var str = textbox.value;
    if (str.length == 0) {
        return true;
    }

    var integerRegExp = -/^\d*[0-9]$/;

    str = textbox.value;
    if (str.length == 0) {
        return true;
    }
    var newStr = "";
    var parts = str.split('.');
    if (parts.length >= 2) {

        if ((parts[0].length > 0) && (integerRegExp.test(parts[0]) != true)) {
            textbox.value = "";
            return true;
        }
        if ((parts[1].length > 0) && (integerRegExp.test(parts[1]) != true)) {
            textbox.value = "";
            return true;
        }
        if (parts[0].length > lengthOfIntegral) {
            newStr = parts[0].substring(0, lengthOfIntegral);
        }
        else { newStr = parts[0]; }
        if (parts[1].length > lengthOfMantisa) {
            newStr = newStr + '.' + parts[1].substring(0, lengthOfMantisa);
        }
        else { newStr = newStr + '.' + parts[1]; }
    }
    else {
        if ((parts[0].length > 0) && (integerRegExp.test(parts[0]) != true)) {
            textbox.value = "";
            return true;
        }
        if (str.indexOf('.') >= 0) {
            if (str.length > lengthOfMantisa + 1) {
                newStr = str.substring(0, lengthOfMantisa + 1);
            }
            else { newStr = str; }
        }
        else {

            if (str.length > lengthOfIntegral) {
                newStr = str.substring(0, lengthOfIntegral);
            }
            else { newStr = str; }

        }
    }
    if (newStr.length > 0) {
        str = newStr;
    }
    textbox.value = str;
}

/****************************************************************************************
Function/Procedure  Name            :- MaskInteger
functionality                       :- To Allow entering Integer Values	
****************************************************************************************/

function MaskInteger(evt, length) {
    var unicode = evt.charCode ? evt.charCode : evt.keyCode
    if (unicode < 8 || unicode > 9) {
        if (!(unicode >= 48 && unicode <= 57)) return false;
        if (evt.srcElement.value.length > length) return false;
    }
}


function ValidateNumericRangeValue(textbox, MaxRange) {
 
    var str = textbox.value;
    if (str.length == 0) {
        return true;
    }

    if (str > MaxRange) {
        textbox.value = '';
        MessageArray = new Array();        
//        SetMessageBoxDetails(MessageArray);
        SetMessageBox('Enter Valid Value', 'info')
        textbox.focus();
        return false;
    }
    ResetMessageBox();
    return true;
     

}

/****************************************************************************************
Function/Procedure  Name            :- fnValidateInteger
functionality                       :- To validate Integer Values	
****************************************************************************************/

function fnValidateInteger(textbox, lengthOfInteger) {
    var str = textbox.value;
    if (str.length == 0) {
        return true;
    }
    var integerRegExp = /^\d*[0-9]$/;
    if (integerRegExp.test(str) != true) {
        textbox.value = "";
        return true;
    }

    if (str.length > lengthOfInteger) {
        str = str.substring(0, lengthOfInteger);
        textbox.value = str;
    }

    return true;
}

function fnMaxLength(textBox, long) {
    //debugger;
    var maxlength = new Number(long);
    return (textBox.value.length < maxlength);
}

function CreateGridHeader(DataDiv, GridView1, HeaderDiv) {
//    debugger;
    alert("Hiiiiiiii");
    var DataDivObj = document.getElementById(DataDiv);
    var DataGridObj = document.getElementById(GridView1);
    var HeaderDivObj = document.getElementById(HeaderDiv);

    //********* Creating new table which contains the header row ***********
    var HeadertableObj = HeaderDivObj.appendChild(document.createElement('table'));

    DataDivObj.style.paddingTop = '0px';
    var DataDivWidth = DataDivObj.clientWidth;
    DataDivObj.style.width = '5000px';

    //********** Setting the style of Header Div as per the Data Div ************
    HeaderDivObj.className = DataDivObj.className;
    HeaderDivObj.style.cssText = DataDivObj.style.cssText;
    //**** Making the Header Div scrollable. *****
    HeaderDivObj.style.overflow = 'auto';
    //*** Hiding the horizontal scroll bar of Header Div ****
    HeaderDivObj.style.overflowX = 'hidden';
    //**** Hiding the vertical scroll bar of Header Div **** 
    HeaderDivObj.style.overflowY = 'hidden';
    HeaderDivObj.style.height = DataGridObj.rows[0].clientHeight + 'px';
    //**** Removing any border between Header Div and Data Div ****
    HeaderDivObj.style.borderBottomWidth = '0px';

    //********** Setting the style of Header Table as per the GridView ************
    HeadertableObj.className = DataGridObj.className;
    //**** Setting the Headertable css text as per the GridView css text 
    HeadertableObj.style.cssText = DataGridObj.style.cssText;
    HeadertableObj.border = '1px';
    HeadertableObj.rules = 'all';
    HeadertableObj.cellPadding = DataGridObj.cellPadding;
    HeadertableObj.cellSpacing = DataGridObj.cellSpacing;

    //********** Creating the new header row **********
    var Row = HeadertableObj.insertRow(0);
    Row.className = DataGridObj.rows[0].className;
    Row.style.cssText = DataGridObj.rows[0].style.cssText;
    //Row.style.fontWeight = 'bold';

    //******** This loop will create each header cell *********
    for (var iCntr = 0; iCntr < DataGridObj.rows[0].cells.length; iCntr++) {
        var spanTag = Row.appendChild(document.createElement('td'));
        spanTag.innerHTML = DataGridObj.rows[0].cells[iCntr].innerHTML;
        var width = 0;
        //****** Setting the width of Header Cell **********
        if (spanTag.clientWidth > DataGridObj.rows[1].cells[iCntr].clientWidth) {
            width = spanTag.clientWidth;
        }
        else {
            width = DataGridObj.rows[1].cells[iCntr].clientWidth;
        }
        if (iCntr <= DataGridObj.rows[0].cells.length - 2) {
            spanTag.style.width = width + 'px';
        }
        else {
            spanTag.style.width = width + 20 + 'px';
        }
        DataGridObj.rows[1].cells[iCntr].style.width = width + 'px';
    }
    var tableWidth = DataGridObj.clientWidth;
    //********* Hidding the original header of GridView *******
    DataGridObj.rows[0].style.display = 'none';
    //********* Setting the same width of all the componets **********
    HeaderDivObj.style.width = DataDivWidth + 'px';
    DataDivObj.style.width = DataDivWidth + 'px';
    DataGridObj.style.width = tableWidth + 'px';
    HeadertableObj.style.width = tableWidth + 20 + 'px';
    HeadertableObj.style.display = 'visible';
    DataDivObj.style.display = 'visible';
    return false;
}

function Onscrollfnction() {

    var div = document.getElementById('DataDiv');
    var div2 = document.getElementById('HeaderDiv');
    //****** Scrolling HeaderDiv along with DataDiv ******
    div2.scrollLeft = div.scrollLeft;
    return false;
}


/****************************************************************************************
Function/Procedure  Name            :- fnGetTimeSelectorClientId
functionality                       :- To get Time Selector Control Client ID	
****************************************************************************************/
function fnGetTimeSelectorClientId(ControlID) {
    var count = document.forms[0].length;
    var i = 0;
    var eleName;
    for (i = 0; i < count; i++) {
        eleName = document.forms[0].elements[i].id;
        pos = eleName.indexOf(ControlID);
        if (pos >= 0) break;
    }
    return eleName;
}


/****************************************************************************************
Function/Procedure  Name            :- fnCheckForMandatory
functionality                       :- To Validate The Mandatory Fields of a Page Before Save	
****************************************************************************************/
function fnCheckForMandatory(control) {
    if (control.value == "") {
        return false;
    }
}

/****************************************************************************************
Function/Procedure  Name            :- KeysShortcut
functionality                       :- To Validate The Mandatory Fields of a Page Before Save	
****************************************************************************************/
function KeysShortcut(ImageControlName) {
    if (event.keyCode == 113) {
        document.getElementById(ImageControlName).click();
    }
}

/****************************************************************************************
Function/Procedure  Name            :- modalWin
functionality                       :- Function to open the Popup page.		
****************************************************************************************/
function openReportWin(strFullWindowName, strWindowTitle, dialogSize) {

    //    if (window.showModalDialog) {
    //        window.showModalDialog(strFullWindowName, strWindowTitle, "dialogWidth:820px;dialogHeight:480px");
    //    }
    //    else {
    window.open(strFullWindowName, strWindowTitle, 'height=1500px,width=1500px,left=0px,top=0px,toolbar=no,directories=no,status=no, menubar=no,scrollbars=yes,resizable=yes ,modal=yes');
 
    //    }

    //__doPostBack("", "");
    return false;
}


/*For Global Button*/
function globalButtonover(getTag) {
    if (document.getElementById(getTag).className == 'buttonGlobalCustom') {
        document.getElementById(getTag).className = 'buttonGlobalCustomOver';
    }
    else {
        document.getElementById(getTag).className = 'buttonGlobalOver';
    }
}

function globalButtonout(getTag) {
    if (document.getElementById(getTag).className == 'buttonGlobalCustomOver') {
        document.getElementById(getTag).className = 'buttonGlobalCustom';
    }
    else {
        document.getElementById(getTag).className = 'buttonGlobal';
    }
}

function bodyButtonover(getTag) {
    if (document.getElementById(getTag).className == 'buttonLBlueCustom') {
        document.getElementById(getTag).className = 'buttonLBlueCustomOver'
    }
    else {
        document.getElementById(getTag).className = 'buttonLBlueOver';
    }
}

function bodyButtonout(getTag) {
    if (document.getElementById(getTag).className == 'buttonLBlueCustomOver') {
        document.getElementById(getTag).className = 'buttonLBlueCustom'
    }
    else {
        document.getElementById(getTag).className = 'buttonLBlue';
    }
}

counterb = 0;
function hideshowbutton() {
    if (counterb == 0) {
        document.getElementById('leftContainer').style.display = 'none';
        counterb = 1;
    }
    else {
        document.getElementById('leftContainer').style.display = 'block';
        counterb = 0;
    }
}

//Modal popup
popcounter = 0;
function openModalpopup() {
    if (popcounter == 0) {
        document.getElementById('popUp').style.display = 'block';
        document.getElementById('blocklayer').style.display = 'block';
        document.getElementById('blocklayer').style.height = screen.height;
        document.getElementById('blocklayer').style.width = screen.width;
        popcounter = popcounter + 1;
    }
    else {
        document.getElementById('popUp').style.display = 'none';
        document.getElementById('blocklayer').style.display = 'none';
        popcounter = 0;
    }
}

/*For FullScreen POPUP*/
function fullPopup(url) {
    params = 'width=' + screen.width;
    params += ', height=' + screen.height;
    params += ', top=0, left=0';
    params += ', fullscreen=no';

    window.open(url, 'windowname4', params);
    //if (window.focus) {newwin.focus()}
    //return false;
}
/*End FullScreen POPUP*/

function SetMessageBoxDetails(msgs) {

    var whole_msg = '<div class="messageHolder newmsg"><div class="himsWireBox"><div class="himsBoxHeader"><div></div></div><div class="himsBoxContent messageMessage"><div class="errorContainer"><div class="fLeft statusImage"><div style="width: 18px; height: 19px;"></div></div><div class="statusMessage fLeft"><div>';
    whole_msg += 'Mandatory fields are not filled.';
    whole_msg += '</div><div id="hideShowError"><ul>';
    for (var m = 0; m < msgs.length; m++) {
        if (msgs[m])
            whole_msg += "<li>" + msgs[m] + "</li>\n";
    }
    whole_msg += '</ul></div></div><div align="right" class="pRight5 cursorHand" id="maxmin"><div id="hideShowImg" class="fRight icon-ex"><img src="../../../images/icons/collapsetab.png" title="Minimize" onclick="maxmin()" /></div></div><div class="cBoth"></div></div></div><div class="himsBoxFooter"><div></div></div></div></div>';

    var MessageBoxDiv = document.getElementById('MessageBoxDiv');
    MessageBoxDiv.innerHTML = whole_msg;
}




// Script for Message hide and show Starts
var counter = 0;
function maxmin() {

    if (counter == 0) {
        document.getElementById('hideShowImg').innerHTML = '<img src="../../../images/icons/expandtab.png" title="Maximize" onclick="maxmin()" />';
        document.getElementById('hideShowError').style.display = 'none';
        counter = counter + 1;
    }
    else {
        document.getElementById('hideShowImg').innerHTML = '<img src="../../../images/icons/collapsetab.png" title="Minimize" onclick="maxmin()" />';
        document.getElementById('hideShowError').style.display = 'block';
        counter = 0;
    }
    /*
    if (document.getElementById('hideShowError').style.display == 'none') {
    document.getElementById('hideShowError').src = '../../../images/icons/collapsetab.png';
    document.getElementById('hideShowError').style.display = 'block';
    }
    else {
    document.getElementById('hideShowError').src = '../../../images/icons/expandtab.png';
    document.getElementById('hideShowError').style.display = 'none';
    }*/
}

function SetMessageBox(pMessage, pMessageType) {
    var MessageBoxDiv = document.getElementById('MessageBoxDiv');
    var valMessageType = pMessageType.toLowerCase();
    MessageBoxDiv.innerHTML = '<div class="messageHolder newmsg"><div class="himsWireBox" ><div class="himsBoxHeader"><div></div></div><div class="himsBoxContent messageMessage"><div class="' + valMessageType + 'Container"><div class="fLeft statusImage"><div></div></div><div class="statusMessage fLeft"><div>' + pMessage + '</div></div><div class="cBoth"></div></div></div><div class="himsBoxFooter"><div></div></div></div></div>';
    return false;
}
function ResetMessageBox() {
    var MessageBoxDiv = document.getElementById('MessageBoxDiv');
    MessageBoxDiv.innerHTML = '';
    return false;
}

/*Tab Container Javascripts*/
function tabChange(tabSelected) {
    var tabMenu = document.getElementById("tabMenu").getElementsByTagName("li");
    for (i = 1; i <= tabMenu.length; i++) {
        document.getElementById("tab" + i).className = "";
        document.getElementById("tab" + i + "content").style.display = "none";
    }
    document.getElementById(tabSelected).className = "current";
    document.getElementById(tabSelected + "content").style.display = "block";
}


// new prototype defintion
document.include = function(url) {
    if ('undefined' == typeof (url)) return false;
    var p, rnd;
    if (document.all) {
        // For IE, create an ActiveX Object instance
        p = new ActiveXObject("Microsoft.XMLHTTP");
    }
    else {
        // For mozilla, create an instance of XMLHttpRequest.
        p = new XMLHttpRequest();
    }
    // Prevent browsers from caching the included page
    // by appending a random  number
    rnd = Math.random().toString().substring(2);
    // url = url.indexOf('?')>-1 ? url+'&rnd='+rnd : url+'?rnd='+rnd;
    // Open the url and write out the response

    p.open("GET", url, false);
    p.send(null);
    document.write(p.responseText);
}

function fnCloseForm() {

    window.close();

    return false;
}

 

/**
* DHTML date validation script. Courtesy of SmartWebby.com (http://www.smartwebby.com/dhtml/datevalidation.asp)
*/
// Declaring valid date character, minimum year and maximum year
var dtCh = "/";
var minYear = 1900;
var maxYear = 2100;

function isInteger(s) {
    var i;
    for (i = 0; i < s.length; i++) {
        // Check that current character is number.
        var c = s.charAt(i);
        if (((c < "0") || (c > "9"))) return false;
    }
    // All characters are numbers.
    return true;
}

function stripCharsInBag(s, bag) {
    var i;
    var returnString = "";
    // Search through string's characters one by one.
    // If character is not in bag, append to returnString.
    for (i = 0; i < s.length; i++) {
        var c = s.charAt(i);
        if (bag.indexOf(c) == -1) returnString += c;
    }
    return returnString;
}

function daysInFebruary(year) {
    // February has 29 days in any year evenly divisible by four,
    // EXCEPT for centurial years which are not also divisible by 400.
    return (((year % 4 == 0) && ((!(year % 100 == 0)) || (year % 400 == 0))) ? 29 : 28);
}
function DaysArray(n) {
    for (var i = 1; i <= n; i++) {
        this[i] = 31
        if (i == 4 || i == 6 || i == 9 || i == 11) { this[i] = 30 }
        if (i == 2) { this[i] = 29 }
    }
    return this
}

function isDate(dtStr) {
    
    var daysInMonth = DaysArray(12)
    var pos1 = dtStr.indexOf(dtCh)
    var pos2 = dtStr.indexOf(dtCh, pos1 + 1)
    var strMonth = dtStr.substring(0, pos1)
    var strDay = dtStr.substring(pos1 + 1, pos2)
    var strYear = dtStr.substring(pos2 + 1)
    strYr = strYear
    if (strDay.charAt(0) == "0" && strDay.length > 1) strDay = strDay.substring(1)
    if (strMonth.charAt(0) == "0" && strMonth.length > 1) strMonth = strMonth.substring(1)
    for (var i = 1; i <= 3; i++) {
        if (strYr.charAt(0) == "0" && strYr.length > 1) strYr = strYr.substring(1)
    }
    month = parseInt(strMonth)
    day = parseInt(strDay)
    year = parseInt(strYr)
    if (pos1 == -1 || pos2 == -1) {
        SetMessageBoxforDatePicker("The date format should be : mm/dd/yyyy");
        return false
    }
    if (strMonth.length < 1 || month < 1 || month > 12) {
        SetMessageBoxforDatePicker("Please enter a valid month");
        return false
    }
    if (strDay.length < 1 || day < 1 || day > 31 || (month == 2 && day > daysInFebruary(year)) || day > daysInMonth[month]) {
        SetMessageBoxforDatePicker("Please enter a valid day");
        return false
    }
    if (strYear.length != 4 || year == 0 || year < minYear || year > maxYear) {
        SetMessageBoxforDatePicker("Please enter a valid year between "+ minYear +" and "+maxYear);
        return false
    }
    if (dtStr.indexOf(dtCh, pos2 + 1) != -1 || isInteger(stripCharsInBag(dtStr, dtCh)) == false) {
        SetMessageBoxforDatePicker("Please enter a valid date");
        return false
    }
    return true
}

function ValidateDateFormate(lnk) {
    ResetMessageBox();
    //	    var dt=document.frmSample.txtDate
    if (lnk.value != '') {
        if (isDate(lnk.value) == false) {
            lnk.focus()
            return false
        }
    }
    return true
}



function SetMessageBoxforDatePicker(msgs) {
    
    var myDate = new Date();
    var myDateFormat = myDate.toLocaleString();
    var whole_msg = '<div class="messageHolder newmsg"><div class="himsWireBox"><div class="himsBoxHeader"><div></div></div><div class="himsBoxContent messageMessage"><div class="errorContainer"><div class="fLeft statusImage"><div></div></div><div class="statusMessage fLeft"><div>';   
    whole_msg += '</div><div id="hideShowError"><ul>';
    whole_msg += "date format should be : mm/dd/yyyy";

//    whole_msg += "date format should be : " + myDateFormat;

    whole_msg += "<li>" + msgs + "</li>\n";
  
    whole_msg += '</ul></div></div><div align="right" class="pRight5 cursorHand" id="maxmin"><div id="hideShowImg" class="fRight icon-ex"><img src="../../images/icons/collapsetab.png" title="Minimize" onclick="maxmin()" /></div></div><div class="cBoth"></div></div></div><div class="himsBoxFooter"><div></div></div></div></div>';

    var MessageBoxDiv = document.getElementById('MessageBoxDiv');
    MessageBoxDiv.innerHTML = whole_msg;
}




function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : event.keyCode
    if ((charCode < 48 || charCode > 57))
        return false;
    else
        return true;
}



//2 newly added functions from commonfuntions.js

