﻿<%@ Page Title="Student Search" Language="C#" MasterPageFile="~/Pages/Common/MasterPages/MainMasterPage_new.master" AutoEventWireup="true" CodeFile="StudentSearch.aspx.cs"
    Inherits="Pages_StudentManagement_StudentSearch" meta:resourcekey="PageResource1" UICulture="auto" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register Src="~/UserControls/GridViewPager/GridViewPager.ascx" TagName="GridViewPager" TagPrefix="uc1" %>
<%@ Register Src="~/UserControls/Common/CommonSearch/CommonSearch.ascx" TagName="CommonSearchUserControl" TagPrefix="Common" %>
<%@ Register Src="~/UserControls/Common/ScreenGroup/ScreenGroup.ascx" TagName="ScreenGroupControl" TagPrefix="ScreenGroup" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CP" runat="Server">
    <asp:UpdatePanel ID="HREmployeeMasterSearchUpdatePanel" runat="server">
        <ContentTemplate>
            <Common:CommonSearchUserControl ID="CommonSearchControl" runat="server" Visible="false" />
            <div id="divContentPage" class="divcontentpagemargin">

                <div class="dashBoardLeftCont">
                    <div class="himssuHeader3WireBox">
                        <table>
                            <tr>
                                <td>
                                    <div class="himsBoxContent">
                                        <div class="leftUlMenu">
                                            <ScreenGroup:ScreenGroupControl EnableViewState="true" ID="ScreenGroupControl" ScreenGroupId="102"
                                                Visible="true" runat="server" />
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="row whiteboxpaddingleft">
                    <div class="himssuHeader5WireBox card card-box">
                        <div class="himsBoxHeader card-head">
                            <asp:Panel ID="SearchHeaderPanel" runat="server" meta:resourcekey="SearchHeaderPanelResource1">
                                <div class="leftdiv">
                                </div>
                                <div class="himsBoxTitle">
                                    <div class="headerText">
                                        <header>
                                            <i class="fas fa-search"></i>
                                            <asp:Label ID="SearchHeaderLabel" runat="server" Text="Search"></asp:Label>
                                        </header>
                                    </div>
                                </div>
                                <div class="fRight mt-27">
                                    <asp:Button ID="AddnewButton" runat="server" OnClick="AddnewButtonControls_Click" SkinID="0" CssClass="btn btn-add fas" Text="&#xf067; Add" />
                                </div>
                            </asp:Panel>
                        </div>
                        <asp:Panel ID="SearchDetailPanel" runat="server" meta:resourcekey="SearchDetailPanelResource1">
                            <div class="himsBoxContent card-body">
                                <div class="contentHolder">
                                    <div class="outerBox pTop5 col-md-3">
                                        <div class="controlLabelWidth">
                                            <asp:Label ID="IDNoLabel" runat="server" Text="ID No" meta:resourcekey="IDNoLabelResource1"></asp:Label>
                                        </div>
                                        <div class="fLeft pRight5">
                                            <asp:TextBox ID="IDNoTextBox" runat="server" onmouseleave="showHideTooltip()" SkinID="CustomWidthTextBox"
                                                onmouseenter="showHideTooltip()" meta:resourcekey="IDNoSearchTextBoxResource1"
                                                MaxLength="20"></asp:TextBox>
                                        </div>
                                    </div>
                                    <div class="outerBox pTop5 col-md-3">
                                        <div class="controlLabelWidth">
                                            <asp:Label ID="FirstNameSearchLabel" runat="server" Text="First Name" meta:resourcekey="FirstNameSearchLabelResource1"></asp:Label>
                                        </div>
                                        <div class="fLeft pRight5">
                                            <asp:TextBox ID="FirstNameSearchTextBox" SkinID="CustomWidthTextBox"
                                                runat="server" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()"
                                                meta:resourcekey="FirstNameSearchTextBoxResource1" MaxLength="100"></asp:TextBox>
                                        </div>
                                    </div>
                                    <div class="outerBox pTop5 col-md-3">
                                        <div class="controlLabelWidth">
                                            <asp:Label ID="MiddleNameSearchLabel" runat="server" Text="Middle Name" meta:resourcekey="MiddleNameSearchLabelResource1"></asp:Label>
                                        </div>
                                        <div class="fLeft pRight5">
                                            <asp:TextBox ID="MiddleNameSearchTextBox" SkinID="CustomWidthTextBox"
                                                runat="server" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()"
                                                meta:resourcekey="MiddleNameSearchTextBoxResource1" MaxLength="100"></asp:TextBox>
                                        </div>
                                    </div>
                                    <div class="outerBox pTop5 col-md-3">
                                        <div class="controlLabelWidth">
                                            <asp:Label ID="LastNameLabel" runat="server" Text="Last Name"></asp:Label>
                                        </div>
                                        <div class="fLeft pRight5">
                                            <asp:TextBox ID="LastNameTextBox" SkinID="CustomWidthTextBox" runat="server"
                                                onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()" meta:resourcekey="LastNameTextBoxResource1"
                                                MaxLength="100"></asp:TextBox>
                                        </div>
                                    </div>

                                    <div class="outerBox pTop5 col-md-3">
                                        <div class="controlLabelWidth">
                                            <asp:Label ID="DepartmentLabel" runat="server" Text="Department"></asp:Label>
                                        </div>
                                        <div class="fLeft pRight5">
                                            <asp:DropDownList runat="server" ID="DepartmentDropDownList" SkinID="CustomWidthDropDownList"
                                                CssClass="form-control" onmouseleave="showHideTooltip()" AutoPostBack="true" onmouseenter="showHideTooltip()"
                                                OnSelectedIndexChanged="DepartmentDropDownList_SelectedIndexChanged">
                                            </asp:DropDownList>
                                        </div>
                                    </div>
                                    <div class="outerBox pTop5 col-md-3">
                                        <div class="controlLabelWidth">
                                            <asp:Label ID="ClassLabel" runat="server" Text="Class"></asp:Label>
                                        </div>
                                        <div class="fLeft pRight5">
                                            <asp:DropDownList runat="server" ID="ClassDropDownList" SkinID="CustomWidthDropDownList"
                                                CssClass="form-control" onmouseleave="showHideTooltip()" AutoPostBack="true" onmouseenter="showHideTooltip()"
                                                OnSelectedIndexChanged="ClassDropDownList_SelectedIndexChanged">
                                            </asp:DropDownList>
                                        </div>
                                    </div>
                                    <div class="outerBox pTop5 col-md-3">
                                        <div class="controlLabelWidth">
                                            <asp:Label ID="DivisionLabel" runat="server" Text="Division"></asp:Label>
                                        </div>
                                        <div class="fLeft pRight5">
                                            <asp:DropDownList runat="server" ID="DivisionDropDownList" SkinID="CustomWidthDropDownList"
                                                CssClass="form-control" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()">
                                            </asp:DropDownList>
                                        </div>
                                    </div>

                                    <div class="outerBox pTop5 col-md-3">
                                        <div class="controlLabelWidth">
                                            <asp:Label ID="RollNoLabel" runat="server" Text="Roll No"></asp:Label>
                                        </div>
                                        <div class="fLeft pRight5">
                                            <asp:TextBox ID="RollNoTextBox" SkinID="CustomWidthTextBox" runat="server"
                                                onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()" meta:resourcekey="RollNoTextBoxResource1"
                                                MaxLength="100" onkeypress="return isNumberKey(event)"></asp:TextBox>
                                        </div>
                                    </div>
                                    <div class="outerBox pTop5 col-md-3">
                                        <div class="controlLabelWidth">
                                            <asp:Label ID="StatusLabel" runat="server" Text="Status"></asp:Label>
                                        </div>
                                        <div class="fLeft pRight5">
                                            <asp:DropDownList runat="server" ID="StatusDropDownList" SkinID="CustomWidthDropDownList"
                                                CssClass="form-control" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()">
                                            </asp:DropDownList>
                                        </div>
                                    </div>
                                    <div class="outerBox pTop5 col-md-3">
                                        <div class="controlLabelWidth">
                                            <asp:Label ID="Label1" runat="server" Text="Class Status"></asp:Label>
                                        </div>
                                        <div class="fLeft pRight5">
                                            <asp:DropDownList runat="server" ID="ClassStatusDropDownList" SkinID="CustomWidthDropDownList"
                                                CssClass="form-control" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()">
                                            </asp:DropDownList>
                                        </div>
                                    </div>
                                    <div class="outerBox pTop5 col-md-3">
                                        <div class="controlLabelWidth">
                                            <asp:Label ID="OrderByLabel" runat="server" Text="Order By"></asp:Label>
                                        </div>
                                        <div class="fLeft pRight5">
                                            <asp:DropDownList runat="server" ID="OrderByDropDownList" SkinID="CustomWidthDropDownList"
                                                CssClass="form-control" onmouseleave="showHideTooltip()" onmouseenter="showHideTooltip()">
                                                <asp:ListItem Text="Roll No" Value="1" Selected="True"></asp:ListItem>
                                                <asp:ListItem Text="ID No" Value="2"></asp:ListItem>
                                            </asp:DropDownList>
                                        </div>
                                    </div>

                                    <div id="SUIdDiv" class="outerBox pTop5 col-md-3" runat="server" visible="false">
                                        <div class="controlLabelWidth">
                                            <asp:Label ID="SUIdLabel" runat="server" Text="SU Id" SkinID="MandatoryLabel"></asp:Label>
                                        </div>
                                        <div class="fLeft pRight5">
                                            <asp:TextBox ID="SUIdTextBox" runat="server" SkinID="CustomWidthTextBox"
                                                MaxLength="50"></asp:TextBox>
                                        </div>
                                    </div>

                                    <div id="ContactNoDiv" class="outerBox pTop5 col-md-3" runat="server">
                                        <div class="controlLabelWidth">
                                            <asp:Label ID="ContactNoLabel" runat="server" Text="Contact No."></asp:Label>
                                        </div>
                                        <div class="fLeft pRight5">
                                            <asp:TextBox ID="ContactNoTextBox" runat="server" SkinID="CustomWidthTextBox"></asp:TextBox>
                                        </div>
                                    </div>

                                    <div class="outerBox col-md-3 pTop15">
                                        <asp:CheckBox ID="ShowWithPhotoCheckBox" runat="server" AutoPostBack="false" Text="Show With Photo" class="pLeft5" />
                                        <%--   <asp:Label ID="ShowWithPhotoLabel" runat="server" Text="Show With Photo"></asp:Label>--%>
                                    </div>

                                    <div class="alignCenter col-md-12 pTop5 pb5">
                                        <asp:Button ID="SearchButton" runat="server" Text="&#xf002; Search" OnClick="SearchButton_Click"
                                            SkinID="0" CssClass="btn-search btn fas" />
                                        <asp:Button ID="ClearButton" runat="server" Text="&#xf0e2; Reset" OnClick="ClearSearchControls_Click"
                                            meta:resourcekey="ClearButtonResource1" SkinID="0" CssClass="btn-reset btn fas" />
                                    </div>

                                    <div id="StudentMasterGridDiv" runat="server" visible="false">
                                        <div class="himssuHeader7WireBox col-md-12 pTop5">
                                            <div class="himsBoxHeader" id="StudentDiv" visible="false" runat="server">
                                                <div class="leftdiv">
                                                </div>
                                                <div class="himsBoxTitle">
                                                    <div class="headerText">
                                                        <div>
                                                            <asp:Label ID="GridViewLabel" Text="" runat="server" Font-Bold="true" />
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12 padd-0">

                                                        <div class="col-md-5">
                                                            <asp:Label ID="RecordsPerPage" Text="Records per Page : " runat="server" />
                                                            <asp:DropDownList ID="AddRowsToGridDropDownList" SkinID="CustomWidthDropDownList" Width="60px" runat="server"
                                                                AutoPostBack="true" OnSelectedIndexChanged="AddRowsToGridDropDownList_SelectedIndexChanged">
                                                                <asp:ListItem Text="10" Value="10" Selected="True"></asp:ListItem>
                                                                <asp:ListItem Text="20" Value="20"></asp:ListItem>
                                                                <asp:ListItem Text="50" Value="50"></asp:ListItem>
                                                                <asp:ListItem Text="100" Value="100"></asp:ListItem>
                                                            </asp:DropDownList>
                                                        </div>
                                                        <div class="col-md-7">
                                                            <uc1:GridViewPager ID="StudentSearchGridView_GridViewPager" runat="server" OnFirstRecordClick="StudentSearchGridView_GridViewPager_FirstRecordClick"
                                                                OnLastRecordClick="StudentSearchGridView_GridViewPager_LastRecordClick" OnNextRecordClick="StudentSearchGridView_GridViewPager_NextRecordClick"
                                                                OnPrevRecordClick="StudentSearchGridView_GridViewPager_PrevRecordClick" OnTextBoxValueChange="StudentSearchGridView_GridViewPager_TextBoxValueChange"
                                                                ParentGridView="StudentSearchGridView" />
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                            <div class="himsBoxContent  pTop5">
                                                <asp:UpdatePanel ID="MenuPlanDetailUpdatePanel" runat="server" UpdateMode="Always">
                                                    <ContentTemplate>
                                                        <div id="Div5" runat="server" class="table-responsive ">
                                                            <asp:GridView ID="StudentSearchGridView" runat="server" AutoGenerateColumns="False" EmptyDataText="No records found"
                                                                OnRowDataBound="StudentSearchGridView_RowDataBound" OnPageIndexChanging="StudentSearchGridView_PageIndexChanging"
                                                                AllowPaging="true" PageSize="10" SkinID="" ShowHeader="True" PagerSettings-Visible="false"
                                                                DataKeyNames="Id,AcademicId" CssClass="table table-striped table-bordered table-hover">
                                                                <Columns>
                                                                    <asp:TemplateField ItemStyle-Width="70px" ItemStyle-HorizontalAlign="Center" ItemStyle-Wrap="true">
                                                                        <ItemTemplate>
                                                                            <asp:LinkButton ID="EditLinkButton" runat="server" CommandName="Select" OnClick="LinkButton_Click"
                                                                                Text="Select" CausesValidation="false"></asp:LinkButton>
                                                                        </ItemTemplate>
                                                                    </asp:TemplateField>
                                                                    <asp:TemplateField ItemStyle-Width="70px" ItemStyle-HorizontalAlign="Center" ItemStyle-Wrap="true">
                                                                        <ItemTemplate>
                                                                            <asp:LinkButton ID="StudentAllLinkButton" runat="server" CommandName="StudentAll" OnClick="StudentAllLinkButton_Click"
                                                                                Text="All" CausesValidation="false"></asp:LinkButton>
                                                                        </ItemTemplate>
                                                                    </asp:TemplateField>
                                                                    <asp:TemplateField Visible="false" ItemStyle-Width="70px" ItemStyle-HorizontalAlign="Center" ItemStyle-Wrap="true">
                                                                        <ItemTemplate>
                                                                            <asp:LinkButton ID="InDetailLinkButton" runat="server" CommandName="InDetail" OnClick="InDetailLinkButton_Click"
                                                                                Text="Profile" CausesValidation="false"></asp:LinkButton>
                                                                        </ItemTemplate>
                                                                    </asp:TemplateField>
                                                                    <asp:TemplateField ItemStyle-Width="10%" ItemStyle-HorizontalAlign="Center" ItemStyle-Wrap="true">
                                                                        <ItemTemplate>
                                                                            <asp:LinkButton ID="ProfileLinkButton" runat="server" CommandName="Profile" OnClick="ProfileLinkButton_Click"
                                                                                Text="Profile" CausesValidation="false"></asp:LinkButton>
                                                                        </ItemTemplate>
                                                                    </asp:TemplateField>
                                                                    <asp:TemplateField ItemStyle-Width="10%" ItemStyle-HorizontalAlign="Center" ItemStyle-Wrap="true">
                                                                        <ItemTemplate>
                                                                            <asp:LinkButton ID="ViewLinkButton" runat="server" OnClick="ViewLinkButton_Click"
                                                                                Text="360 View" CausesValidation="false"></asp:LinkButton>
                                                                        </ItemTemplate>
                                                                    </asp:TemplateField>
                                                                    <asp:BoundField DataField="SUId" HeaderText="SU Id" HeaderStyle-HorizontalAlign="Left"
                                                                        ItemStyle-Width="10%" />
                                                                    <asp:BoundField DataField="Code" HeaderStyle-HorizontalAlign="Left"
                                                                        ItemStyle-Width="10%" />
                                                                    <asp:TemplateField HeaderText="Name" HeaderStyle-HorizontalAlign="Left"
                                                                        ItemStyle-Wrap="true">
                                                                        <ItemTemplate>
                                                                            <asp:Label ID="NameLabel" CssClass="boxEllips" ToolTip='<%#((Sapphire.Vidyalaya.BusinessEntity.Business.StudentManagementBE.Student)Container.DataItem).Name%>' runat="server"
                                                                                Text='<%# ((Sapphire.Vidyalaya.BusinessEntity.Business.StudentManagementBE.Student)Container.DataItem).Name %>'></asp:Label>
                                                                        </ItemTemplate>
                                                                    </asp:TemplateField>
                                                                    <asp:BoundField DataField="ClassDiv" HeaderText="Class" HeaderStyle-HorizontalAlign="Left"
                                                                        ItemStyle-Width="10%" />

                                                                    <asp:BoundField DataField="RollNo" HeaderText="Roll No" HeaderStyle-HorizontalAlign="Left"
                                                                        ItemStyle-Width="7%" />

                                                                    <asp:TemplateField HeaderText="Status" ItemStyle-Width="70px" HeaderStyle-HorizontalAlign="Center"
                                                                        ItemStyle-HorizontalAlign="Center" ItemStyle-Wrap="true">
                                                                        <ItemTemplate>
                                                                            <asp:Label ID="StatLabel" runat="server" Text='<%# ((Sapphire.Vidyalaya.BusinessEntity.Business.StudentManagementBE.Student)Container.DataItem).StatusName%>' Font-Bold="true"> </asp:Label>
                                                                        </ItemTemplate>
                                                                    </asp:TemplateField>
                                                                    <asp:TemplateField HeaderText="Class Status" ItemStyle-Width="70px" HeaderStyle-HorizontalAlign="Center"
                                                                        ItemStyle-HorizontalAlign="Center" ItemStyle-Wrap="true">
                                                                        <ItemTemplate>
                                                                            <asp:Label ID="ClassStatLabel" runat="server" Text='<%# ((Sapphire.Vidyalaya.BusinessEntity.Business.StudentManagementBE.Student)Container.DataItem).ClassStatusName%>' Font-Bold="true"> </asp:Label>
                                                                        </ItemTemplate>
                                                                    </asp:TemplateField>
                                                                    <asp:TemplateField HeaderText="Photo" ItemStyle-Width="190px" HeaderStyle-HorizontalAlign="Center"
                                                                        ItemStyle-HorizontalAlign="Center" ItemStyle-Wrap="true">
                                                                        <ItemTemplate>
                                                                            <asp:Image ID="StudentPhoto" Height="60px" Width="60px" runat="server" ImageUrl='<%# Eval("StudentPhoto")%>' />
                                                                        </ItemTemplate>
                                                                    </asp:TemplateField>
                                                                </Columns>
                                                            </asp:GridView>
                                                        </div>

                                                        <div id="Popupdiv" style="display: none;">
                                                            <div class="sweet-alert showSweetAlert visible" style="display: block; background-color: #ffcccc; margin-top: -100px;">
                                                                <div class="sa-icon sa-error" style="display: none;">
                                                                    <span class="sa-x-mark">
                                                                        <span class="sa-line sa-left"></span>
                                                                        <span class="sa-line sa-right"></span>
                                                                    </span>
                                                                </div>
                                                                <div class="sa-icon sa-warning" style="display: none;">
                                                                    <span class="sa-body"></span>
                                                                    <span class="sa-dot"></span>
                                                                </div>
                                                                <div class="sa-icon sa-info" style="display: none;"></div>
                                                                <div class="sa-icon sa-success" style="display: none;">
                                                                    <span class="sa-line sa-tip"></span>
                                                                    <span class="sa-line sa-long"></span>

                                                                    <div class="sa-placeholder"></div>
                                                                    <div class="sa-fix"></div>
                                                                </div>
                                                                <div class="sa-icon sa-custom" style="display: none;"></div>
                                                                <h3><b>Your extra student limit has been exceeded kindly contact your School Administrator.</h3>
                                                                </b>
                                                                <p></p>
                                                            </div>
                                                        </div>

                                                    </ContentTemplate>
                                                </asp:UpdatePanel>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </asp:Panel>

                    </div>
                </div>

            </div>
        </ContentTemplate>
    </asp:UpdatePanel>
    <script type="text/javascript">

        function showmodalpopup() {
            $(".hls-bg").show();
            $(".container").hide();
            $("#Popupdiv").show();
            setTimeout(function () {
                $("#Popupdiv").hide();
                $(".hls-bg").hide();
                $(".container").show();
            }, 4000);
        };
    </script>
    <%--<script data-main="../../JavaScript/rjs/encrypt/student-search-encrypt" src="../../JavaScript/rjs/require.js"></script>--%>
    <script data-main='<%=ResolveUrl("~/JavaScript/rjs/student-search")%>' src='<%=ResolveUrl("~/JavaScript/rjs/require.js")%>'></script>
</asp:Content>
