﻿<%@ WebService Language="C#" Class="CRMSyncWebService" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using Sapphire.Vidyalaya.BusinessLogic.Business.InstituteManagement.SetupBL;
using Sapphire.Vidyalaya.BusinessLogic.Business.Library.LibraryBL;
using Sapphire.Vidyalaya.BusinessLogic.Business.Attendance.AttendanceBL;
using Sapphire.Ohu.BaseFramework.Utilities;
using Sapphire.Ohu.BusinessEntity.Framework.BaseFrameworkBE;
using System.Data;
using Sapphire.Ohu.BusinessEntity.Component.AlertBE;
using System.Collections.Generic;
using System.Text;
using Microsoft.Azure;
using Microsoft.WindowsAzure.Storage;
using Microsoft.WindowsAzure.Storage.Blob;
using Microsoft.WindowsAzure.Storage.File;
using System.Net;
using System.Linq;
using System.IO;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
// [System.Web.Script.Services.ScriptService]
public class CRMSyncWebService : System.Web.Services.WebService
{

    private OrganizationMasterService OrganizationMasterServiceClient
    {
        get { return new OrganizationMasterService(); }
    }

    // vs command prompt wsdl http://localhost:5568/Services/CRMSyncWebService.asmx
    // browse the service and put /service before part of url in config file
    //string SyncCRMUrl = System.Configuration.ConfigurationManager.AppSettings["SyncCRMUrl"];
    ///// <remarks/>
    //public PortalSyncWebService()
    //{
    //    this.Url = SyncCRMUrl + "/Services/CRMSyncWebService.asmx";
    //}

    // * Customer Master Details*
    #region Customer Master Details
    [WebMethod]
    public DataSet GetCustomerMasterDetails(int OrgGroupId)
    {
        CommonFunctions objCommonFunction = new CommonFunctions();

        DataSet ds = new DataSet();
        string SQL_String = "SELECT * FROM sErp.tCustomerMaster WHERE OrgGroupId =" + OrgGroupId;
        ds = objCommonFunction.GetDataset(SQL_String);
        return ds;
    }
    #endregion

    // * Add Or Update Support Ticket*
    #region Create Or Update Support Ticket
    [WebMethod]
    public int CreateOrUpdateSupportTicket(int Id, int ProductId, string LicenseNo, int OrgGroupId, int OrgId, int ModuleId, int SupportCategoryId, int SupportPriorityId,
                                           string IssueDescription, string IssueSteps, string ContactName,
                                           string ContactNo, string AlternateContactNo, string ConvenientStartTime, string ConvenientEndTime, Int16 SupportTicketStatusId, string UserName, Int64 UserId)
    {
        int Result = 0;
        List<DataParameter> dp = new List<DataParameter>();
        DataParameter d;

        d = new DataParameter { Name = "@rId", Value = Id, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rProductId", Value = ProductId, DataType = System.Data.DbType.Int16 };
        dp.Add(d);

        d = new DataParameter { Name = "@rLicenseNo", Value = LicenseNo, DataType = System.Data.DbType.String };
        dp.Add(d);

        d = new DataParameter { Name = "@rOrgGroupId", Value = OrgGroupId, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rOrgId", Value = OrgId, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rModuleId", Value = ModuleId, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rSupportCategoryId", Value = SupportCategoryId, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rSupportPriorityId", Value = SupportPriorityId, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        //d = new DataParameter { Name = "@rDeadlineDate", Value = DeadlineDate, DataType = System.Data.DbType.DateTime };
        //dp.Add(d);

        //d = new DataParameter { Name = "@rDeadlineHour", Value = DeadlineHour, DataType = System.Data.DbType.Int32 };
        //dp.Add(d);

        //d = new DataParameter { Name = "@rDeadlineMinute", Value = DeadlineMinute, DataType = System.Data.DbType.Int32 };
        //dp.Add(d);

        d = new DataParameter { Name = "@rIssueDescription", Value = IssueDescription, DataType = System.Data.DbType.String };
        dp.Add(d);

        d = new DataParameter { Name = "@rIssueSteps", Value = IssueSteps, DataType = System.Data.DbType.String };
        dp.Add(d);

        d = new DataParameter { Name = "@rContactName", Value = ContactName, DataType = System.Data.DbType.String };
        dp.Add(d);

        d = new DataParameter { Name = "@rContactNo", Value = ContactNo, DataType = System.Data.DbType.String };
        dp.Add(d);

        d = new DataParameter { Name = "@rAlternateContactNo", Value = AlternateContactNo, DataType = System.Data.DbType.String };
        dp.Add(d);

        d = new DataParameter { Name = "@rConvenientStartTime", Value = ConvenientStartTime, DataType = System.Data.DbType.Time };
        dp.Add(d);

        d = new DataParameter { Name = "@rConvenientEndTime", Value = ConvenientEndTime, DataType = System.Data.DbType.Time };
        dp.Add(d);

        d = new DataParameter { Name = "@rSupportTicketStatusId", Value = SupportTicketStatusId, DataType = System.Data.DbType.Int16 };
        dp.Add(d);

        d = new DataParameter { Name = "@rUserName", Value = UserName, DataType = System.Data.DbType.String };
        dp.Add(d);

        d = new DataParameter { Name = "@rUserId", Value = UserId, DataType = System.Data.DbType.Int64 };
        dp.Add(d);

        CommonFunctions cf = new CommonFunctions();
        DataSet ds = cf.GetDatasetFromSp("sErp.pSupportTicketAdd", dp);

        if (ds != null && ds.Tables[0] != null && ds.Tables[0].Rows.Count > 0 && Convert.ToInt32(ds.Tables[0].Rows[0][0].ToString()) >= 1)
            Result = Convert.ToInt32(ds.Tables[0].Rows[0][0].ToString());
        else if (ds != null && ds.Tables[0] != null && ds.Tables[0].Rows.Count > 0 && ds.Tables[0].Rows[0][0].ToString() == "-11")
            Result = -11;
        else
            Result = -1;

        return Result;
    }
    #endregion

    #region SetModuleGrid
    [WebMethod]
    public DataSet SetModuleGrid(int ModuleId, int OrgGroupId)
    {
        try
        {
            string Result = "";
            List<DataParameter> dp = new List<DataParameter>();
            CommonFunctions cf = new CommonFunctions();

            string SQL_String = "Select AutoId as Id ,MM.Title AS Module, STSM.Title AS SupportTicketStatus,ISNULL(ST.IssueSteps,'') AS IssueSteps,ISNULL(ST.IssueDescription,'') AS IssueDescription from sErp.tSupportTicket ST " +
               " INNER JOIN sCommon.tModuleMaster MM ON MM.Id = ST.ModuleId INNER JOIN sErp.tSupportTicketStatusMaster STSM ON STSM.Id = ST.SupportTicketStatusId"
               + " where ST.ModuleId = " + ModuleId + " and ST.SupportTicketStatusId = 1 AND OrgGroupId = " + OrgGroupId + " ORDER BY ST.AutoId DESC";
            DataSet ds = cf.GetDataset(SQL_String);

            return ds;
        }
        catch (Exception ex)
        {
            throw (new Exception("Error Getting Data"));
        }
    }
    #endregion

    // * Update Support Ticket Status*
    #region  Update Support Ticket Status
    [WebMethod]
    public string UpdateSupportTicketStatus(int Id, Int16 SupportTicketStatusId, string VidyalayaExecutiveName, DateTime TicketClosingDateTime)
    {
        string Result = "";
        List<DataParameter> dp = new List<DataParameter>();
        CommonFunctions cf = new CommonFunctions();
        string SQL_String = "";
        if (TicketClosingDateTime.Date.ToString() == "01/01/0001 00:00:00")
        {
            SQL_String = "If Exists(Select AutoId from sErp.tSupportTicket Where AutoId = " + Id + ") BEGIN Update sErp.tSupportTicket SET SupportTicketStatusId =" + SupportTicketStatusId + " , VidyalayaExecutiveName ='" + VidyalayaExecutiveName + "', UpdatedDateTime=getdate()" +
          " Where AutoId = " + Id + " Select 1 END ELSE BEGIN Select -1 END";
        }
        else
        {
            SQL_String = "If Exists(Select AutoId from sErp.tSupportTicket Where AutoId = " + Id + ") BEGIN Update sErp.tSupportTicket SET SupportTicketStatusId =" + SupportTicketStatusId + " , VidyalayaExecutiveName ='" + VidyalayaExecutiveName + "' , TicketClosingDateTime = '" + TicketClosingDateTime.ToString("yyyy-MM-dd HH:mm") + "', UpdatedDateTime=getdate()" +
               " Where AutoId = " + Id + " Select 1 END ELSE BEGIN Select -1 END";
        }

        DataSet ds = cf.GetDataset(SQL_String);

        if (ds != null && ds.Tables[0] != null && ds.Tables[0].Rows.Count > 0 && Convert.ToInt32(ds.Tables[0].Rows[0][0].ToString()) == 1)
            Result = "Updated Successfully";
        else if (ds != null && ds.Tables[0] != null && ds.Tables[0].Rows.Count > 0 && Convert.ToInt32(ds.Tables[0].Rows[0][0].ToString()) == -1)
            Result = "Ticket Not Exists";
        else
            Result = "Failed";

        return Result;
    }
    #endregion

    // * Update Support Vidyalaya Ticket Number* 
    #region  Update Support Vidyalaya Ticket Number
    [WebMethod]
    public string UpdateVidyalayaTicketNumber(int Id, Int64 VidyalayaTicketNumber)
    {
        string Result = "";
        List<DataParameter> dp = new List<DataParameter>();
        CommonFunctions cf = new CommonFunctions();

        string SQL_String = "If Exists(Select AutoId from sErp.tSupportTicket Where AutoId = " + Id + ") BEGIN Update sErp.tSupportTicket SET VidyalayaTicketNumber =" + VidyalayaTicketNumber +
            " Where AutoId = " + Id + " Select 1 END ELSE BEGIN Select -1 END";
        DataSet ds = cf.GetDataset(SQL_String);

        if (ds != null && ds.Tables[0] != null && ds.Tables[0].Rows.Count > 0 && Convert.ToInt32(ds.Tables[0].Rows[0][0].ToString()) == 1)
            Result = "Updated Successfully";
        else if (ds != null && ds.Tables[0] != null && ds.Tables[0].Rows.Count > 0 && Convert.ToInt32(ds.Tables[0].Rows[0][0].ToString()) == -1)
            Result = "Ticket Not Exists";
        else
            Result = "Failed";

        return Result;
    }
    #endregion

    #region Create Ticket Log
    [WebMethod]
    public void CreateTicketActivityLog(Int64 UserId, string Activity, Int32 TicketId)
    {
        try
        {
            List<DataParameter> dp = new List<DataParameter>();
            DataParameter d;

            d = new DataParameter { Name = "@rUserId", Value = UserId, DataType = System.Data.DbType.Int64 };
            dp.Add(d);

            d = new DataParameter { Name = "@rActivity", Value = Activity, DataType = System.Data.DbType.String };
            dp.Add(d);

            d = new DataParameter { Name = "@rTicketId", Value = TicketId, DataType = System.Data.DbType.Int32 };
            dp.Add(d);

            CommonFunctions cf = new CommonFunctions();
            cf.GetDatasetFromSp("[sErp].[pSupportTicketLogAdd]", dp);
        }
        catch (Exception ex)
        {
            throw (new Exception("Error creating Audit Log"));
        }
    }
    #endregion
    // * Get Support Ticket*
    #region Get Support Ticket
    [WebMethod]
    public DataSet GetSupportTicket(Int32 Id, Int32 OrgGroupId, Int32 OrgId, Int32 ModuleId, Int32 SupportCategoryId, Int32 SupportPriorityId,
                                    Int32 SupportTicketStatusId, DateTime FromDeadlineDate, DateTime ToDeadlineDate, Int64 VidyalayaTicketNo = 0)
    {

        List<DataParameter> dp = new List<DataParameter>();
        DataParameter d;

        d = new DataParameter { Name = "@rId", Value = Id, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rOrgGroupId", Value = OrgGroupId, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rOrgId", Value = OrgId, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rModuleId", Value = ModuleId, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rSupportCategoryId", Value = SupportCategoryId, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rSupportPriorityId", Value = SupportPriorityId, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rSupportTicketStatusId", Value = SupportTicketStatusId, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rFromDeadlineDate", Value = FromDeadlineDate, DataType = System.Data.DbType.DateTime };
        dp.Add(d);

        d = new DataParameter { Name = "@rToDeadlineDate", Value = ToDeadlineDate, DataType = System.Data.DbType.DateTime };
        dp.Add(d);

        d = new DataParameter { Name = "@rVidyalayaTicketNo", Value = VidyalayaTicketNo, DataType = System.Data.DbType.Int64 };
        dp.Add(d);

        CommonFunctions cf = new CommonFunctions();
        DataSet ds = cf.GetDatasetFromSp("sErp.pSupportTicketGet", dp);

        return ds;
    }
    #endregion
    //* Update Escalate L1 & L2*
    #region Update Escalate L1 & L2
    [WebMethod]
    public DataSet UpdateSupportTicketCategory(int Id, Int16 SupportTicketCategoryId, int OrgGroupId)
    {
        CommonFunctions cf = new CommonFunctions();
        string SQL_String_CRMEscalate = "Update  [sErp].[tSupportTicket] set SupportCategoryId =" + SupportTicketCategoryId + ", UpdatedDateTime=getdate()" + " where AutoId =" + Id + " and OrgGroupId = " + OrgGroupId + " Select @@Identity";
        DataSet ds = cf.GetDataset(SQL_String_CRMEscalate);
        return ds;
    }
    #endregion

    // * GetLogDetail*
    #region GetLogDetail
    [WebMethod]
    public DataSet GetLogDetail(int TicketId)
    {
        CommonFunctions cf = new CommonFunctions();
        string SQL_String_CRMEscalate = "Select  AL.CreatedDateTime as AuditDate, Activity, '' as Remark from [sErp].[tSupportTicketLog] AL where AL.TicketId ="
            + TicketId + "  Order By AL.CreatedDateTime Desc";
        DataSet ds = cf.GetDataset(SQL_String_CRMEscalate);
        return ds;
    }
    #endregion
    // * Get Windows Support Ticket*
    #region Get Support Ticket Windows
    [WebMethod]
    public DataSet GetWindowsSupportTicket(Int32 Id, DateTime UpdatedDate)
    {

        List<DataParameter> dp = new List<DataParameter>();
        DataParameter d;

        d = new DataParameter { Name = "@rId", Value = Id, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rUpdatedDate", Value = UpdatedDate, DataType = System.Data.DbType.DateTime };
        dp.Add(d);
        CommonFunctions cf = new CommonFunctions();
        DataSet ds = cf.GetDatasetFromSp("sErp.pWindowsSupportTicketGet", dp);

        return ds;
    }
    #endregion

    // * Delete Support Ticket*
    #region Delete Support Ticket
    [WebMethod]
    public int DeleteSupportTicket(int Id)
    {
        int Result = 0;
        try
        {

            CommonFunctions objCommonFunction = new CommonFunctions();
            DataSet ds = new DataSet();
            string SQL_String = "DELETE FROM sErp.tSupportTicket WHERE AutoId =" + Id;
            objCommonFunction.GetDataset(SQL_String);
            Result = 1;
        }
        catch (Exception ex)
        {
            Result = -1;
            return Result;
        }
        return Result;
    }
    #endregion

    // * Release Note Detail*
    #region Release Note Detail

    [WebMethod]
    public DataSet GetReleaseNote()
    {
        CommonFunctions objCommonFunction = new CommonFunctions();
        string SQL_String = "SELECT * FROM sErp.tReleaseNote ORDER BY Id DESC";
        DataSet ds = objCommonFunction.GetDataset(SQL_String);
        return ds;
    }

    [WebMethod]
    public DataSet GetReleaseNoteDetail(int Id)
    {
        CommonFunctions objCommonFunction = new CommonFunctions();
        string SQL_String = "SELECT RND.ReleaseNoteId,RN.ReleaseDate,RN.VersionNumber,RN.VersionId,M.Title As ModuleName,RND.IssueDescription,IT.Title As IssueType " +
                            "FROM sErp.tReleaseNote RN INNER JOIN sErp.tReleaseNoteDetail RND on RN.id=RND.ReleaseNoteId " +
                            "INNER JOIN sCommon.tModuleMaster M on RND.ModuleId=M.Id INNER JOIN sErp.tIssueTypeMaster IT on RND.IssueTypeId=IT.Id " +
                            "ORDER BY RN.VersionId DESC";
        DataSet ds = objCommonFunction.GetDataset(SQL_String);
        return ds;
    }
    #endregion
    // * Screen Functionality Training Detail*
    #region Screen Functionality Training Detail

    [WebMethod]
    public DataSet ScreenFunctionalityGet(int ScreenId)
    {
        CommonFunctions objCommonFunction = new CommonFunctions();
        string SQL_String = "SELECT SFM.Id,SFM.ScreenFunctionality,SFMT.TrainingRemark,ISNULL(SFMT.AutoId,0)As AutoId " +
                            "FROM sErp.tScreenFunctionalityMaster SFM " +
                            "LEFT OUTER JOIN sErp.tScreenFunctionalityTraining SFMT ON SFM.ID=SFMT.ScreenFunctionalityId " +
                            "INNER JOIN sSecurity.tScreen S ON  SFM.ScreeId=S.Id WHERE S.Id=" + ScreenId;
        DataSet ds = objCommonFunction.GetDataset(SQL_String);
        return ds;
    }

    [WebMethod]
    public int CreateScreenFunctionalityTraining(int Id, int OrgGroupId, int ScreenFunctionalityId, string TrainingRemark, string UserName)
    {
        int Result = 0;
        List<DataParameter> dp = new List<DataParameter>();
        DataParameter d;

        d = new DataParameter { Name = "@rId", Value = Id, DataType = System.Data.DbType.Int32 };
        dp.Add(d);
        d = new DataParameter { Name = "@rOrgGroupId", Value = OrgGroupId, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rScreenFunctionalityId", Value = ScreenFunctionalityId, DataType = System.Data.DbType.Int32 };
        dp.Add(d);

        d = new DataParameter { Name = "@rTrainingRemark", Value = TrainingRemark, DataType = System.Data.DbType.String };
        dp.Add(d);

        d = new DataParameter { Name = "@rUserName", Value = UserName, DataType = System.Data.DbType.String };
        dp.Add(d);



        //CommonFunctions cf = new CommonFunctions();
        //DataSet ds = cf.GetDatasetFromSp("sErp.pScreenFunctionalityTrainingAdd", dp);

        //if (ds != null && ds.Tables[0] != null && ds.Tables[0].Rows.Count > 0 && ds.Tables[0].Rows[0][0].ToString() == "1")
        //    Result = 1;
        //else
        //    Result = -1;

        //return Result;

        CommonFunctions cf = new CommonFunctions();
        DataSet ds = cf.GetDatasetFromSp("sErp.pScreenFunctionalityTrainingAdd", dp);


        //if (ds != null && ds.Tables[0] != null && ds.Tables[0].Rows.Count > 0 && ds.Tables[0].Rows[0][0].ToString() == "1")
        //    Result = 1;
        //else if (ds != null && ds.Tables[0] != null && ds.Tables[0].Rows.Count > 0 && ds.Tables[0].Rows[0][0].ToString() == "11")
        //    Result = 11;


        return Result;
    }
    [WebMethod]
    public DataSet ModuleScreenFunctionalityGet(int ScreenId, int ModuleId)
    {
        CommonFunctions objCommonFunction = new CommonFunctions();
        string SQL_String = "SELECT SFM.Id,S.Title,SFM.ScreenFunctionality,SFMT.TrainingRemark,ISNULL(SFMT.AutoId,0)As AutoId " +
                            "FROM sErp.tScreenFunctionalityMaster SFM " +
                            "LEFT OUTER JOIN sErp.tScreenFunctionalityTraining SFMT ON SFM.ID=SFMT.ScreenFunctionalityId " +
                            "INNER JOIN sSecurity.tScreen S ON  SFM.ScreeId=S.Id " +
                            "INNER JOIN sSecurity.tTask T on T.Id = S.TaskId  INNER JOIN sCommon.tModuleMaster M on M.Id = T.ModuleId " +
                            "WHERE M.Id=" + ModuleId + " AND M.IsObsolete = 0 AND (S.Id=" + ScreenId + " OR (" + ScreenId + " = 0))";
        DataSet ds = objCommonFunction.GetDataset(SQL_String);
        return ds;
    }
    #endregion
    [WebMethod]
    public DataSet CloudStorage(int TypeId, int OrgGroupId, int OrgGroupBatchId)
    {
        string[] UploadFunc = { "Circular", "Assignment", "OnlineLearning", "Leave", "Query", "Behaviour", "Classwork", "Book", "Chat", "StudentAllDocuments", "EmployeeAllDocuments",
    "EmployeeDocuments", "LostFoundRegister", "StudentUploadedDocuments", "UploadResult", "InwardRegister", "OutwardRegister", "EmployeeUploadedDocuments", "Gallery", "MobileApp", 
    "OrgLogos", "StudentPhoto", "Expense", "Task"};

        DataSet ds = new DataSet();
        DataTable dt = new DataTable();
        dt.Columns.Add("Type");
        dt.Columns.Add("Size");

        DataTable SpaceDetaildt = new DataTable();
        dt.Columns.Add("Allocated");
        dt.Columns.Add("Used");
        dt.Columns.Add("Remaining");

        CloudStorageAccount storageAccount = CloudStorageAccount.Parse(CloudConfigurationManager.GetSetting("StorageConnectionString"));
        ServicePointManager.SecurityProtocol |= SecurityProtocolType.Tls12;
        CloudBlobClient blobClient = storageAccount.CreateCloudBlobClient();
        CloudBlobContainer blobContainer = blobClient.GetContainerReference("vidyalayacontainer");
        if(TypeId == 0)
        {
            DataRow dr = dt.NewRow();
            string AllocatedSpace = "5";            
            CommonFunctions cf = new CommonFunctions();
            string CloudStorageConfig = "SELECT ItemValue FROM sConfig.tConfigurationSetup WHERE ConfigurationId = 426 AND SourceTypeId = 2010 AND SourceId = " + OrgGroupId;
            DataSet CloudStorageConfigDS = cf.GetDataset(CloudStorageConfig);
            if (CloudStorageConfigDS != null && CloudStorageConfigDS.Tables.Count > 0)
            {
                AllocatedSpace = CloudStorageConfigDS.Tables[0].Rows[0][0].ToString();
            }
            double Size = 0;
            var blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG", useFlatBlobListing: true).ToList();
            Size += (from CloudBlockBlob blob in blobs select blob.Properties.Length).Sum();
            //Local
            DirectoryInfo di = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/"));
            long LocSize = di.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
            Size = Size + LocSize;
            string RemainingSpace = Math.Round((int.Parse(AllocatedSpace) - Size / 1073741824), 2).ToString();

            dr[0] = AllocatedSpace;
            dr[1] = Math.Round(Size / 1073741824,3).ToString();
            dr[2] = RemainingSpace;
            dt.Rows.Add(dr);
        }
        else if (TypeId == 1)
        {
            CommonFunctions cf = new CommonFunctions();
            string GetOrgGroupBatch = "SELECT Id, Title AS OrgGroupTitle FROM sSetup.tOrgGroupMaster WHERE Id = " + OrgGroupId;
            DataSet OrgGroupDS = cf.GetDataset(GetOrgGroupBatch);
            if (OrgGroupDS != null && OrgGroupDS.Tables.Count > 0)
            {
                for (int i = 0; i < OrgGroupDS.Tables[0].Rows.Count; i++)
                {
                    DataRow dr = dt.NewRow();
                    double Size = 0;
                    var blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG", useFlatBlobListing: true).ToList();
                    Size += (from CloudBlockBlob blob in blobs select blob.Properties.Length).Sum();
                    //Local
                    DirectoryInfo di = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/"));
                    long LocSize = di.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
                    Size = Size + LocSize;
                    dr[0] = OrgGroupDS.Tables[0].Rows[0]["OrgGroupTitle"].ToString();
                    dr[1] = Size.ToString();
                    dt.Rows.Add(dr);
                }
            }
        }
        else if (TypeId == 2)
        {
            CommonFunctions cf = new CommonFunctions();
            string GetOrgGroupBatch = "SELECT Id, Title AS OrgGroupBatchTitle,'' AS Size FROM sSetup.tOrgGroupBatchMaster WHERE OrgGroupId = " + OrgGroupId;
            DataSet OrgGroupBatchDS = cf.GetDataset(GetOrgGroupBatch);
            double Size = 0;
            if (OrgGroupBatchDS != null && OrgGroupBatchDS.Tables.Count > 0)
            {
                for (int j = 0; j < OrgGroupBatchDS.Tables[0].Rows.Count; j++)
                {
                    DataRow dr = dt.NewRow();
                    for (int i = 0; i < UploadFunc.Length; i++)
                    {
                        //Azure                             
                        var blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG/" + UploadFunc[i] + "/" + OrgGroupBatchId + "OGB/", useFlatBlobListing: true).ToList();
                        Size += (from CloudBlockBlob blob in blobs select blob.Properties.Length).Sum();
                    }
                    //Local
                    DirectoryInfo di = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/"));
                    long LocSize = di.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
                    Size = Size + LocSize;
                    dr[0] = OrgGroupBatchDS.Tables[0].Rows[0]["OrgGroupBatchTitle"].ToString();
                    dr[1] = Size.ToString();
                    dt.Rows.Add(dr);
                }
            }
        }
        else if (TypeId == 3)
        {
            CommonFunctions cf = new CommonFunctions();
            DataTable dt1 = new DataTable();
            dt1.Columns.Add("Type");
            dt1.Columns.Add("Size");
            double Size = 0;
            double Size1 = 0;

            //Functionality
            for (int i = 0; i < UploadFunc.Length; i++)
            {
                DataRow dr = dt.NewRow();
                dr[0] = UploadFunc[i];

                var blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG/" + UploadFunc[i] + "/" + OrgGroupBatchId + "OGB/", useFlatBlobListing: true).ToList();
                Size = (from CloudBlockBlob blob in blobs select blob.Properties.Length).Sum();

                if (UploadFunc[i] == "Assignment" || UploadFunc[i] == "StudentUploadedDocuments" || UploadFunc[i] == "UploadResult" || UploadFunc[i] == "InwardRegister" || UploadFunc[i] == "OutwardRegister" || UploadFunc[i] == "OrgLogos" || UploadFunc[i] == "Task" || UploadFunc[i] == "EmployeeUploadedDocuments")
                {
                    string GetOrg = "SELECT Id FROM sSetup.tOrganizationMaster WHERE OrgGroupId = " + OrgGroupId;
                    DataSet OrgDS = cf.GetDataset(GetOrg);
                    for (int j = 0; j < OrgDS.Tables[0].Rows.Count; j++)
                    {
                        DirectoryInfo di = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/" + int.Parse(OrgDS.Tables[0].Rows[j][0].ToString()) + "/" + UploadFunc[i] + "/"));
                        if (di.Exists)
                        {
                            long LocSize = di.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
                            Size = Size + LocSize;
                        }
                    }
                }
                if (UploadFunc[i] == "OnlineLearning")
                {
                    long LocSize = 0;
                    DirectoryInfo di = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/" + OrgGroupId + "OrgGroup/OnlineLearning/Assignment/"));
                    if (di.Exists)
                        LocSize += di.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
                    DirectoryInfo di1 = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/" + OrgGroupId + "OrgGroup/OnlineLearning/AssignmentSubmit/"));
                    if (di1.Exists)
                        LocSize += di1.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
                    DirectoryInfo di2 = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/" + OrgGroupId + "OrgGroup/OnlineLearning/Resource/"));
                    if (di2.Exists)
                        LocSize += di2.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
                    Size = Size + LocSize;
                }
                if (UploadFunc[i] == "Leave")
                {
                    DirectoryInfo di = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/" + OrgGroupId + "OrgGroup/" + UploadFunc[i] + "/"));
                    if (di.Exists)
                    {
                        long LocSize = di.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
                        Size = Size + LocSize;
                    }
                }
                if (UploadFunc[i] == "StudentAllDocuments" || UploadFunc[i] == "EmployeeAllDocuments")
                {
                    string GetOrg = "SELECT Id FROM sSetup.tOrganizationMaster WHERE OrgGroupId = " + OrgGroupId;
                    DataSet OrgDS = cf.GetDataset(GetOrg);
                    for (int j = 0; j < OrgDS.Tables[0].Rows.Count; j++)
                    {
                        DirectoryInfo di = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/" + int.Parse(OrgDS.Tables[0].Rows[j][0].ToString()) + "/" + UploadFunc[i] + "/"));
                        if (di.Exists)
                        {
                            long LocSize = di.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
                            Size = Size + LocSize;
                        }
                    }
                }
                else
                {
                    DirectoryInfo di = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/" + OrgGroupId + "OrgGroup/" + UploadFunc[i] + "/"));
                    if (di.Exists)
                    {
                        long LocSize = di.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
                        Size = Size + LocSize;
                    }
                }

                dr[1] = Size.ToString();
                dt.Rows.Add(dr);
            }
            // Organization
            string SQL = "SELECT Id,Title FROM sSetup.tOrganizationMaster WHERE OrgGroupId = " + OrgGroupId;
            DataSet OrganizationDS = cf.GetDataset(SQL);
            for (int j = 0; j < OrganizationDS.Tables[0].Rows.Count; j++)
            {
                DataRow dr = dt1.NewRow();
                dr[0] = OrganizationDS.Tables[0].Rows[j]["Title"].ToString();
                for (int i = 0; i < UploadFunc.Length; i++)
                {
                    //Azure                    
                    if (UploadFunc[i] == "Assignment" || UploadFunc[i] == "StudentUploadedDocuments" || UploadFunc[i] == "UploadResult" || UploadFunc[i] == "InwardRegister" || UploadFunc[i] == "OutwardRegister" || UploadFunc[i] == "OrgLogos" || UploadFunc[i] == "Task" || UploadFunc[i] == "EmployeeUploadedDocuments")
                    {
                        var blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG/" + UploadFunc[i] + "/" + OrgGroupBatchId + "OGB/" + int.Parse(OrganizationDS.Tables[0].Rows[j]["Id"].ToString()) + "OR/" + UploadFunc[i] + "/", useFlatBlobListing: true).ToList();
                        Size += (from CloudBlockBlob blob in blobs select blob.Properties.Length).Sum();

                        DirectoryInfo di = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/" + int.Parse(OrganizationDS.Tables[0].Rows[j]["Id"].ToString()) + "/" + UploadFunc[i] + "/"));
                        if (di.Exists)
                        {
                            long LocSize = di.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
                            Size = Size + LocSize;
                        }
                    }
                    if (UploadFunc[i] == "OnlineLearning")
                    {
                        long LocSize = 0;
                        var blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG/" + UploadFunc[i] + "/" + OrgGroupBatchId + "OGB/" + int.Parse(OrganizationDS.Tables[0].Rows[j]["Id"].ToString()) + "OR/Assignment/", useFlatBlobListing: true).ToList();
                        Size += (from CloudBlockBlob blob in blobs select blob.Properties.Length).Sum();
                        blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG/" + UploadFunc[i] + "/" + OrgGroupBatchId + "OGB/" + int.Parse(OrganizationDS.Tables[0].Rows[j]["Id"].ToString()) + "OR/AssignmentSubmit/", useFlatBlobListing: true).ToList();
                        Size += (from CloudBlockBlob blob in blobs select blob.Properties.Length).Sum();
                        blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG/" + UploadFunc[i] + "/" + OrgGroupBatchId + "OGB/" + int.Parse(OrganizationDS.Tables[0].Rows[j]["Id"].ToString()) + "OR/Resource/", useFlatBlobListing: true).ToList();
                        Size += (from CloudBlockBlob blob in blobs select blob.Properties.Length).Sum();

                        DirectoryInfo di = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/" + OrgGroupId + "OrgGroup/OnlineLearning/Assignment/"));
                        if (di.Exists)
                            LocSize += di.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
                        DirectoryInfo di1 = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/" + OrgGroupId + "OrgGroup/OnlineLearning/AssignmentSubmit/"));
                        if (di1.Exists)
                            LocSize += di1.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
                        DirectoryInfo di2 = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/" + OrgGroupId + "OrgGroup/OnlineLearning/Resource/"));
                        if (di2.Exists)
                            LocSize += di2.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
                        Size = Size + LocSize;
                    }
                    if (UploadFunc[i] == "Leave")
                    {
                        var blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG/" + UploadFunc[i] + "/" + OrgGroupBatchId + "OGB/" + int.Parse(OrganizationDS.Tables[0].Rows[j]["Id"].ToString()) + "OR/", useFlatBlobListing: true).ToList();
                        Size += (from CloudBlockBlob blob in blobs select blob.Properties.Length).Sum();

                        DirectoryInfo di = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/" + OrgGroupId + "OrgGroup/" + UploadFunc[i] + "/"));
                        if (di.Exists)
                        {
                            long LocSize = di.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
                            Size = Size + LocSize;
                        }
                    }
                    if (UploadFunc[i] == "StudentAllDocuments" || UploadFunc[i] == "EmployeeAllDocuments")
                    {
                        var blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG/" + UploadFunc[i] + "/" + OrgGroupBatchId + "OGB/" + int.Parse(OrganizationDS.Tables[0].Rows[j]["Id"].ToString()) + "OR/Temp", useFlatBlobListing: true).ToList();
                        Size += (from CloudBlockBlob blob in blobs select blob.Properties.Length).Sum();

                        DirectoryInfo di = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/" + int.Parse(OrganizationDS.Tables[0].Rows[j]["Id"].ToString()) + "/" + UploadFunc[i] + "/"));
                        if (di.Exists)
                        {
                            long LocSize = di.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
                            Size = Size + LocSize;
                        }
                    }
                    else
                    {
                        var blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG/" + UploadFunc[i] + "/" + OrgGroupBatchId + "OGB/", useFlatBlobListing: true).ToList();
                        Size += (from CloudBlockBlob blob in blobs select blob.Properties.Length).Sum();

                        DirectoryInfo di = new DirectoryInfo(HttpContext.Current.Server.MapPath("~/Content/" + OrgGroupId + "OrgGroup/" + UploadFunc[i] + "/"));
                        if (di.Exists)
                        {
                            long LocSize = di.EnumerateFiles("*", SearchOption.AllDirectories).Sum(fi => fi.Length);
                            Size = Size + LocSize;
                        }
                    }
                }                                                
                dr[1] = Size1.ToString();
                dt1.Rows.Add(dr);
            }
            ds.Tables.Add(dt1);
        }
        ds.Tables.Add(dt);
        return ds;
    }
}