﻿<%@ WebService Language="C#" Class="PortalAdmissionDownloadWebService" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using Sapphire.Vidyalaya.BusinessLogic.Business.InstituteManagement.SetupBL;
using Sapphire.Vidyalaya.BusinessLogic.Business.Library.LibraryBL;
using Sapphire.Vidyalaya.BusinessLogic.Business.Attendance.AttendanceBL;
using Sapphire.Ohu.BaseFramework.Utilities;
using Sapphire.Ohu.BusinessEntity.Framework.BaseFrameworkBE;
using Sapphire.Vidyalaya.BusinessLogic.Business.Admission.AdmissionBL;
using System.Data;

[WebService(Namespace = "http://tempuri.org/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
// To allow this Web Service to be called from script, using ASP.NET AJAX, uncomment the following line. 
// [System.Web.Script.Services.ScriptService]
public class PortalAdmissionDownloadWebService : System.Web.Services.WebService
{


    // vs command prompt wsdl http://localhost:5568/Services/PortalAdmissionDownloadWebService.asmx?wsdl
    // browse the service and put /service before part of url in config file
    //string SyncServiceUrl = System.Configuration.ConfigurationManager.AppSettings["SyncServiceUrl"];
    ///// <remarks/>
    //public PortalSyncWebService()
    //{
    //    this.Url = SyncServiceUrl + "/Services/PortalSyncWebService.asmx";
    //}





    private PortalSynchDataService PortalSynchDataServiceClient
    {
        get { return new PortalSynchDataService(); }
    }

    private PortalAdmissionDownloadService PortalAdmissionDownloadDataServiceClient
    {
        get { return new PortalAdmissionDownloadService(); }
    }

    [WebMethod]
    public DataSet PortalAdmissionDataset(Int16 orgId, Int32 BatchId, Int32 ForClassId,string FormNo)
    {
        return PortalAdmissionDownloadDataServiceClient.PortalAdmissionDataset(orgId, BatchId, ForClassId, FormNo);

    }
    [WebMethod]
    public DataSet PortalAdmissionFormFamilyDataset(Int16 orgId, Int32 BatchId, Int32 ForClassId, String FormNo)
    {
        return PortalAdmissionDownloadDataServiceClient.PortalAdmissionFormFamilyDataset(orgId, BatchId, ForClassId, FormNo);

    }

    [WebMethod]
    public DataSet PortalAdmissionFormParentDataset(Int16 orgId, Int32 BatchId, Int32 ForClassId, String FormNo)
    {
        return PortalAdmissionDownloadDataServiceClient.PortalAdmissionFormParentDataset(orgId, BatchId, ForClassId, FormNo);

    }

    [WebMethod]
    public DataSet PortalAdmissionFormStudentAcademicDataset(Int16 orgId, Int32 BatchId, Int32 ForClassId, String FormNo)
    {
        return PortalAdmissionDownloadDataServiceClient.PortalAdmissionFormStudentAcademicDataset(orgId, BatchId, ForClassId, FormNo);

    }

    [WebMethod]
    public DataSet PortalAdmissionFormReferenceDataset(Int16 orgId, Int32 BatchId, Int32 ForClassId, String FormNo)
    {
        return PortalAdmissionDownloadDataServiceClient.PortalAdmissionFormReferenceDataset(orgId, BatchId, ForClassId, FormNo);

    }

    [WebMethod]
    public DataSet PortalAdmissionFormSiblingDataset(Int16 orgId, Int32 BatchId, Int32 ForClassId, String FormNo)
    {
        return PortalAdmissionDownloadDataServiceClient.PortalAdmissionFormSiblingDataset(orgId, BatchId, ForClassId, FormNo);

    }

    [WebMethod]
    public DataSet PortalAdmissionFormInquiryDataset(Int32 OrgGroupId, Int32 BatchId, Int32 ForClassId)
    {
        return PortalAdmissionDownloadDataServiceClient.PortalAdmissionFormInquiryDataset(OrgGroupId, BatchId, ForClassId);

    }
    [WebMethod]
    public Int32 PortalAdmissionUpdate(string XML, Int16 orggroupId, Int32 BatchId, Int32 ForClassId)
    {
        return PortalAdmissionDownloadDataServiceClient.PortalAdmissionUpdate(XML, orggroupId, BatchId, ForClassId);

    }

    [WebMethod]
    public Int32 PortalAdmissionFormDowanload(string strXMLStudentMaster, Int16 OrgId, int BatchId, int ForClassId, string FormNo)
    {
        return PortalAdmissionDownloadDataServiceClient.PortalAdmissionFormDowanload(strXMLStudentMaster, OrgId, BatchId, ForClassId, FormNo);
    }

    [WebMethod]
    public int PortalAdmissionFamilyDetailDowanload(string strxml)
    {
        return PortalAdmissionDownloadDataServiceClient.PortalAdmissionFamilyDetailDowanload(strxml);
    }

    [WebMethod]
    public int PortalAdmissionParentDetailDowanload(string strXML)
    {
        return PortalAdmissionDownloadDataServiceClient.PortalAdmissionParentDetailDowanload(strXML);
    }


    [WebMethod]
    public int PortalAdmissionStudentDetailDowanload(string strxml)
    {
        return PortalAdmissionDownloadDataServiceClient.PortalAdmissionStudentDetailDowanload(strxml);
    }


    [WebMethod]
    public int PortalAdmissionReferenceDowanload(string strxml)
    {
        return PortalAdmissionDownloadDataServiceClient.PortalAdmissionReferenceDowanload(strxml);
    }


    [WebMethod]
    public int PortalAdmissionSiblingDetailDowanload(string strxml)
    {
        return PortalAdmissionDownloadDataServiceClient.PortalAdmissionSiblingDetailDowanload(strxml);
    }

    [WebMethod]
    public DataSet PortalStudentDetailGetDowanload(Int16 OrgId, Int32 BatchId, Int32 ClassID)
    {
        return PortalAdmissionDownloadDataServiceClient.PortalStudentDetailGetDowanload(OrgId, BatchId, ClassID);
    }
}