﻿<%@ WebHandler Language="C#" Class="DocumentUpload" %>

using System;
using System.Web;
using System.IO;
using Sapphire.Ohu.Web.SessionHelper;
using System.Windows.Forms;
using Sapphire.Ohu.Web.PageController;
using Sapphire.Ohu.BusinessEntity.Framework.BaseFrameworkBE;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Security.AccessControl;
using System.Collections.Generic;
using System.Web.SessionState;
using System.Linq;
using System.Data;
using System.Configuration;
using Microsoft.Azure;
using Microsoft.WindowsAzure.Storage;
using Microsoft.WindowsAzure.Storage.Blob;
using Microsoft.WindowsAzure.Storage.File;
using Sapphire.Ohu.Web.Helper;
using Sapphire.Ohu.BaseFramework.Utilities;
using System.Net;
using System.Drawing.Imaging;

public class DocumentUpload : IHttpHandler, System.Web.SessionState.IRequiresSessionState, System.Web.SessionState.IReadOnlySessionState
{
    public void ProcessRequest(HttpContext context)
    {
        var _with = HttpContext.Current;
        string strPath = string.Empty;
        bool IsImageOptimize = false;

        IsImageOptimize = Convert.ToBoolean(ConfigurationHelper.GetUserConfigurationValue("sCommon.IsOptimizeAppImageUpload"));
        // Configuration - Local Drive, Different Drive, Azure
        string UploadConfiguration = ConfigurationHelper.GetUserConfigurationValue("Utility.UploadConfiguration");

        if (string.IsNullOrEmpty(UploadConfiguration))
            strPath = _with.Server.MapPath("/Content/");
        else if (UploadConfiguration == "Local Drive")
            strPath = _with.Server.MapPath("/Content/");
        else if (UploadConfiguration == "Different Drive")
            strPath = ConfigurationManager.AppSettings["DocumentPath"] + "/";

        int len = context.Request.Files.Count;

        for (int i = 0; i < len; i++)
        {
            if (UploadConfiguration == "Azure")
            {
                CloudStorageAccount storageAccount = CloudStorageAccount.Parse(CloudConfigurationManager.GetSetting("StorageConnectionString"));
                CloudFileClient fileClient = storageAccount.CreateCloudFileClient();

                HttpPostedFile postedFile = context.Request.Files[i];

                string CurrentSize = string.Empty;
                string AllocatedSpace = Sapphire.Ohu.Web.Helper.ConfigurationHelper.GetUserConfigurationValue("Common.CloudStorage");
                string SQL = "SELECT ISNULL(SUM(UD.DocumentSize),0) FROM sCommon.tUploadDocument UD INNER JOIN sSetup.tOrgGroupBatchMaster OGBM ON OGBM.Id = UD.OrgGroupBatchId WHERE OGBM.OrgGroupId = " + SecuritySession.UserProfile.OrgGroupId;
                Sapphire.Ohu.BaseFramework.Utilities.CommonFunctions cf = new Sapphire.Ohu.BaseFramework.Utilities.CommonFunctions();
                DataSet GetCurrentSizeDS = cf.GetDataset(SQL);
                if (GetCurrentSizeDS != null && GetCurrentSizeDS.Tables.Count > 0 && GetCurrentSizeDS.Tables[0].Rows.Count > 0)
                {
                    CurrentSize = GetCurrentSizeDS.Tables[0].Rows[0][0].ToString();
                }

                decimal Size = decimal.Parse(CurrentSize) + postedFile.ContentLength / 1024;

                if (!string.IsNullOrEmpty(CurrentSize) && (Size / 1048576) > decimal.Parse(AllocatedSpace))
                {
                    context.Response.Write("-007");
                    return;
                }

                //remove mp4 file validation because of 0026910 mantis issue (no need to allow mp4 file in Gallery)and also not required for all modules as discussed with tester
                List<string> ValidCircularExtensionList = new List<string>() { "bmp", "gif", "jpeg", "jpg", "png", "pdf", "pptx", "ppt", "xlsx", "xls", "docx", "doc", "txt", "csv", "heic", "webp" };
                string FileExtension = postedFile.FileName.Split('.').Last().ToLower();
                if (!ValidCircularExtensionList.Contains(FileExtension))
                {
                    context.Response.Write("-008");
                    return;
                }
                if (postedFile.FileName.Contains("//") || postedFile.FileName.Contains(".."))
                {
                    context.Response.Write("-009");
                    return;
                }

                ServicePointManager.SecurityProtocol |= SecurityProtocolType.Tls12;

                string fileName = Path.GetFileName(postedFile.FileName);
                CloudFileShare share = fileClient.GetShareReference("vidyalayafiles");
                share.CreateIfNotExists();

                CloudBlobClient blobClient = storageAccount.CreateCloudBlobClient();

                CloudBlobContainer container = blobClient.GetContainerReference("vidyalayacontainer");
                container.CreateIfNotExists();

                string OrgId = SecuritySession.UserProfile.OrgId.ToString();
                string OrgGroupId = SecuritySession.UserProfile.OrgGroupId.ToString();
                string OrgGroupBatchId = SecuritySession.UserProfile.OrgGroupBatchId.ToString();
                string UploadFunctionalityId = context.Request["ScreenTypeId"].ToString();
                string UserSourceTypeId = context.Request["UserSourceTypeId"].ToString();
                string UserSourceId = context.Request["UserSourceId"].ToString();
                string DocumentId = context.Request["DocumentId"].ToString();
                string DocumentName = fileName;
                string GUID = context.Request["GUID"].ToString();
                string CreatedUserId = SecuritySession.UserProfile.UserId.ToString();

                SQLConnectionFunction obj = new SQLConnectionFunction();
                CloudBlockBlob destBlob = null;

                if (UploadFunctionalityId == "1")
                {
                    if (GUID.ToString() != "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Assignment/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/TempAssignment/" + GUID + "/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Assignment/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Assignment/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "2")
                {
                    if (GUID.ToString() != "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/OnlineLearning/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/TempAssignment/" + GUID + "/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/OnlineLearning/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Assignment/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "3")
                {
                    if (GUID.ToString() != "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/OnlineLearning/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/AssignmentSubmit/Temp/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/OnlineLearning/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/AssignmentSubmit/" + DocumentId + "/" + SecuritySession.UserProfile.AcademicId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "4")
                {
                    if (GUID.ToString() != "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Circular/" + OrgGroupBatchId + "OGB/TempCircular/" + GUID + "/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Circular/" + OrgGroupBatchId + "OGB/Circular/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "5")
                {
                    if (DocumentId.ToString() == "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Leave/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Leave/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "6")
                {
                    if (GUID.ToString() != "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Query/" + OrgGroupBatchId + "OGB/TempQuery/" + GUID + "/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Query/" + OrgGroupBatchId + "OGB/Query/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "7")
                {
                    if (DocumentId.ToString() == "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Behaviour/" + OrgGroupBatchId + "OGB/BehaviourTemp/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Behaviour/" + OrgGroupBatchId + "OGB/Behaviour/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "8")
                {
                    if (DocumentId.ToString() == "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Classwork/" + OrgGroupBatchId + "OGB/ClassworkTemp/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Classwork/" + OrgGroupBatchId + "OGB/Classwork/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "9")
                {
                    if (GUID.ToString() != "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Book/" + OrgGroupBatchId + "OGB/TempBook/" + GUID + "/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Book/" + OrgGroupBatchId + "OGB/Book/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "10")
                {
                    if (GUID.ToString() != "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Chat/" + OrgGroupBatchId + "OGB/ChatDetail/" + GUID + "/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Chat/" + OrgGroupBatchId + "OGB/ChatDetail/" + UserSourceTypeId + "/" + UserSourceId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "11")
                {
                    if (context.Session["UploadDocument"] == "Temp")
                    {
                        if (DocumentId.ToString() != "0")
                        {
                            CloudBlobContainer blobContainer = blobClient.GetContainerReference("vidyalayacontainer");
                            if (i <= 0)
                            {
                                var blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG/StudentAllDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentId, useFlatBlobListing: true).ToList();
                                foreach (var blob in blobs)
                                {

                                    CloudBlockBlob DesBlock = blobContainer.GetBlockBlobReference("Content/" + OrgGroupId + "OG/StudentAllDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentId + "/" + System.Uri.UnescapeDataString("" + blob.Uri.Segments.Last().ToString() + ""));

                                    if (DesBlock.Exists())
                                    {
                                        DesBlock.Delete();
                                    }
                                }
                            }
                            destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/StudentAllDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentId + "/" + DocumentName);
                        }
                    }
                    else
                    {
                        if (DocumentId.ToString() != "0")
                        {
                            DataSet ds = cf.GetDataset("DELETE FROM  sStudent.tStudentDocument WHERE SubmitDocumentMasterId=" + DocumentId + " AND StudentId=" + StudentManagementSession.StudentList[0].Id.ToString() + "");

                            destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/StudentAllDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentId + "/" + DocumentName);
                        }
                        else
                        {
                            destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/StudentDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentName);
                        }
                    }
                }
                else if (UploadFunctionalityId == "12")
                {
                    if (context.Session["UploadDocument"] == "Temp")
                    {
                        if (DocumentId.ToString() != "0")
                        {
                            CloudBlobContainer blobContainer = blobClient.GetContainerReference("vidyalayacontainer");
                            if (i <= 0)
                            {
                                var blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG/EmployeeAllDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentId, useFlatBlobListing: true).ToList();
                                foreach (var blob in blobs)
                                {

                                    CloudBlockBlob DesBlock = blobContainer.GetBlockBlobReference("Content/" + OrgGroupId + "OG/EmployeeAllDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentId + "/" + System.Uri.UnescapeDataString("" + blob.Uri.Segments.Last().ToString() + ""));

                                    if (DesBlock.Exists())
                                    {
                                        DesBlock.Delete();
                                    }
                                }
                            }
                            destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/EmployeeAllDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentId + "/" + DocumentName);
                        }
                    }
                    else
                    {
                        if (DocumentId.ToString() != "0")
                        {
                            DataSet ds = cf.GetDataset("DELETE FROM  sHrm.tEmployeeDocument WHERE SubmitDocumentMasterId=" + DocumentId + " AND EmployeeId=" + HrmSession.EmployeeDetailsList[0].Id.ToString() + "");

                            destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/EmployeeAllDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentId + "/" + DocumentName);
                        }
                        else
                        {
                            destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/EmployeeDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentName);
                        }
                    }
                }
                else if (UploadFunctionalityId == "13")
                {

                    if (DocumentId.ToString() != "0")
                    {
                        CloudBlobContainer blobContainer = blobClient.GetContainerReference("vidyalayacontainer");
                        var blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG/EmployeeAllDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentId, useFlatBlobListing: true).ToList();
                        foreach (var blob in blobs)
                        {

                            CloudBlockBlob DesBlock = blobContainer.GetBlockBlobReference("Content/" + OrgGroupId + "OG/EmployeeAllDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentId + "/" + System.Uri.UnescapeDataString("" + blob.Uri.Segments.Last().ToString() + ""));

                            if (DesBlock.Exists())
                            {
                                DesBlock.Delete();
                            }
                        }
                        blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG/EmployeeAllDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/" + HrmSession.EmployeeDetailsData.Id.ToString() + "/" + DocumentId, useFlatBlobListing: true).ToList();
                        foreach (var blob in blobs)
                        {

                            CloudBlockBlob DesBlock = blobContainer.GetBlockBlobReference("Content/" + OrgGroupId + "OG/EmployeeAllDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/" + HrmSession.EmployeeDetailsData.Id.ToString() + "/" + DocumentId + "/" + System.Uri.UnescapeDataString("" + blob.Uri.Segments.Last().ToString() + ""));

                            if (DesBlock.Exists())
                            {
                                DesBlock.Delete();
                            }
                        }

                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/EmployeeAllDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentId + "/" + DocumentName);

                        DataSet ds = cf.GetDataset("DELETE FROM  sHrm.tEmployeeDocument WHERE SubmitDocumentMasterId=" + DocumentId + " AND EmployeeId=" + HrmSession.EmployeeDetailsData.Id.ToString() + "");
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/EmployeeDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentName);
                    }

                }
                else if (UploadFunctionalityId == "14")
                {
                    if (DocumentId.ToString() == "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/LostFoundRegister/" + OrgGroupBatchId + "OGB/LostFoundTemp/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/LostFoundRegister/" + OrgGroupBatchId + "OGB/LostFound/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "15")
                {
                    if (DocumentId.ToString() == "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/StudentUploadedDocuments/" + OrgGroupBatchId + "OGB/Temp/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/StudentUploadedDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/StudentUploadedDocuments/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "16")
                {
                    if (DocumentId.ToString() == "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/UploadResult/" + OrgGroupBatchId + "OGB/Temp/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/UploadResult/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/UploadResult/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "17")
                {
                    if (DocumentId.ToString() == "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/InwardRegister/" + OrgGroupBatchId + "OGB/Temp/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/InwardRegister/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/InwardRegister/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "18")
                {
                    if (DocumentId.ToString() == "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/OutwardRegister/" + OrgGroupBatchId + "OGB/Temp/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/OutwardRegister/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/OutwardRegister/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "20")
                {
                    if (DocumentId.ToString() == "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/EmployeeUploadedDocuments/" + OrgGroupBatchId + "OGB/Temp/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/EmployeeUploadedDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/EmployeeUploadedDocuments/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "19")
                {
                    if (GUID.ToString() != "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/OnlineLearning/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/TempResource/" + GUID + "/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/OnlineLearning/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Resource/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "21")
                {
                    if (GUID.ToString() != "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Gallery/" + OrgGroupBatchId + "OGB/TempGallery/" + GUID + "/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Gallery/" + OrgGroupBatchId + "OGB/Gallery/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "22")
                {
                    string[] FileName = DocumentName.Split('.');
                    if (context.Session["UploadFor"] == "LoginBG")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Other/LoginBG." + FileName[1]);
                    }
                    else if (context.Session["UploadFor"] == "MobileAppLogo")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/MobileApp/" + OrgGroupBatchId + "OGB/MobileApp/SchoolLogo." + FileName[1]);
                    }
                    else if (context.Session["UploadFor"] == "CertificateHead")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/OrgLogos/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/OrgLogos/CertificateHead." + FileName[1]);
                    }
                    else if (context.Session["UploadFor"] == "MarkSheetHead")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/OrgLogos/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/OrgLogos/MarkSheetHead." + FileName[1]);
                    }
                    else if (context.Session["UploadFor"] == "PayrollHead")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/PayrollHeader/" + OrgGroupBatchId + "OGB/PayrollHeader/PayrollHead." + FileName[1]);
                    }
                    else
                    {
                        if (context.Session["UploadFor"] == "PrincipalSignature")
                        {
                            destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/OrgLogos/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/OrgLogos/PrincipalSignature." + FileName[1]);
                        }
                        else if (context.Session["UploadFor"] == "OrganizationHead")
                        {
                            destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/OrgLogos/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/OrgLogos/OrganizationHead." + FileName[1]);
                        }
                        else if (context.Session["UploadFor"] == "OrganizationHeadA4Landscape")
                        {
                            destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/OrgLogos/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/OrgLogos/OrganizationHeadA4Landscape." + FileName[1]);
                        }
                        else if (context.Session["UploadFor"] == "IcardBg")
                        {
                            destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/OrgLogos/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/OrgLogos/IcardBg." + FileName[1]);
                        }
                        else if (context.Session["UploadFor"] == "IcardBackBg")
                        {
                            destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/OrgLogos/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/OrgLogos/IcardBackBg." + FileName[1]);
                        }
                        else
                        {
                            destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/OrgLogos/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/OrgLogos/SchoolLogo." + FileName[1]);
                        }
                    }
                }
                else if (UploadFunctionalityId == "23")
                {
                    string[] FileName = DocumentName.Split('.');
                    if (DocumentId == "1")
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/TempImageRepository/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/TempImageRepository/TemplateImage_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + FileName[1].ToString());
                    else if (DocumentId == "3")
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Admission/" + DocumentName);
                    else if (DocumentId == "4")
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Inquiry/" + DocumentName);
                    else if (DocumentId == "2")
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/StudentBirthdayCard/" + DocumentName);
                }
                else if (UploadFunctionalityId == "24")
                {
                    destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/StudentPhoto/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentName);
                }
                else if (UploadFunctionalityId == "25")
                {
                    string[] FileName = DocumentName.Split('.');
                    destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/TempStudentICard/" + OrgId + "OR/TempStudentICard/StudentICard_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + FileName[1].ToString());
                }
                else if (UploadFunctionalityId == "26")
                {
                    string[] FileName = DocumentName.Split('.');
                    destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/TempEmployeeICard/" + OrgId + "OR/TempEmployeeICard/EmployeeICard_" + string.Format("{0:MMddyyyyhhmmssfffffftt}", DateTime.Now) + "." + FileName[1].ToString()); //Changes for Mantis Id: 0033162
                }
                else if (UploadFunctionalityId == "27")
                {
                    if (GUID.ToString() != "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Expense/" + OrgGroupBatchId + "OGB/Expense/Temp/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Expense/" + OrgGroupBatchId + "OGB/Expense/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "28")
                {
                    string FilePath = HttpContext.Current.Request.QueryString["FilePath"];
                    CloudBlobContainer blobContainer = blobClient.GetContainerReference("vidyalayacontainer");
                    var blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG/TempRecruitmentRecruiterDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/TempRecruitmentRecruiterDocuments/" + FilePath + "/" + DocumentId, useFlatBlobListing: true).ToList();
                    foreach (var blob in blobs)
                    {
                        CloudBlockBlob DesBlock = blobContainer.GetBlockBlobReference("Content/" + OrgGroupId + "OG/TempRecruitmentRecruiterDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/TempRecruitmentRecruiterDocuments/" + FilePath + "/" + DocumentId + "/" + System.Uri.UnescapeDataString("" + blob.Uri.Segments.Last().ToString() + ""));

                        if (DesBlock.Exists())
                        {
                            DesBlock.Delete();
                        }
                    }
                    destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/TempRecruitmentRecruiterDocuments/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/TempRecruitmentRecruiterDocuments/" + FilePath + "/" + DocumentId + "/" + DocumentName);

                }
                else if (UploadFunctionalityId == "29")
                {
                    if (GUID.ToString() != "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Task/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/TempTask/" + GUID + "/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Task/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Task/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "30")
                {
                    if (DocumentId.ToString() == "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Classwork/" + OrgGroupBatchId + "OGB/ClassworkTemp/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Classwork/" + OrgGroupBatchId + "OGB/Homework/" + DocumentId + "/HomeworkSubmitted/" + SecuritySession.UserProfile.AcademicId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "36")
                {
                    if (GUID.ToString() != "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/StockInward/TempStockInward/" + GUID + "/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/StockInward/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "31")
                {
                    destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/Assignment/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/SubmitAssignmentDocument/" + DocumentId + "/" + context.Session["AssignmentDocumentUploadSource"].ToString() + "/" + DocumentName);
                }
                else if (UploadFunctionalityId == "34")
                {
                    if (DocumentId.ToString() == "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/StudentLeave/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/Temp/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/StudentLeave/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "35")
                {
                    if (DocumentId.ToString() == "0")
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/UploadResult/2/" + OrgGroupBatchId + "OGB/Temp/" + DocumentName);
                    }
                    else
                    {
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/UploadResult/" + OrgGroupBatchId + "OGB/" + OrgId + "OR/UploadResult/2/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "37")
                {
                    if (context.Request.Form[2].ToString() == "1")
                    {
                        if (GUID.ToString() != "0")
                            destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/AssetMaster/TempAssetPhotos/" + GUID + "/" + DocumentName);
                        else
                            destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/AssetPhotos/" + DocumentId + "/" + DocumentName);
                    }
                    else if (context.Request.Form[2].ToString() == "2")
                    {
                        if (GUID.ToString() != "0")
                            destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/AssetMaster/TempAssetMaster/" + GUID + "/" + DocumentName);
                        else
                            destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/AssetMaster/" + DocumentId + "/" + DocumentName);
                    }
                }
                else if (UploadFunctionalityId == "38")
                {
                    if (GUID.ToString() != "0")
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/LessonPlan/TempLessonPlan/" + GUID + "/" + DocumentName);
                    else
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/LessonPlan/" + DocumentId + "/" + DocumentName);
                }
                else if (UploadFunctionalityId == "47")
                {
                    if (DocumentId.ToString() != "0")
                    {
                        CloudBlobContainer blobContainer = blobClient.GetContainerReference("vidyalayacontainer");
                        var blobs = blobContainer.ListBlobs(prefix: "Content/" + OrgGroupId + "OG/VehicleDocuments/Temp/" + DocumentId, useFlatBlobListing: true).ToList();
                        foreach (var blob in blobs)
                        {
                            var blobFileName = System.Uri.UnescapeDataString("" + blob.Uri.Segments.Last().ToString() + "");
                            CloudBlockBlob DesBlock = blobContainer.GetBlockBlobReference("Content/" + OrgGroupId + "/VehicleDocuments/Temp" + DocumentId + "/" + blobFileName);

                            if (DesBlock.Exists())
                                DesBlock.Delete();
                        }
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/VehicleDocuments/Temp/" + DocumentId + "/" + DocumentName);
                    }
                    else
                        destBlob = container.GetBlockBlobReference("Content/" + OrgGroupId + "OG/VehicleDocuments/" + DocumentId + "/" + DocumentName);
                }

                using (var s = postedFile.InputStream)
                {
                    var st = postedFile.InputStream;
                    if (IsImageOptimize == true)
                    {
                        if (UploadFunctionalityId == "24" || UploadFunctionalityId == "5" || UploadFunctionalityId == "17" || UploadFunctionalityId == "18" || UploadFunctionalityId == "9" || UploadFunctionalityId == "4" || UploadFunctionalityId == "1" || UploadFunctionalityId == "8" || UploadFunctionalityId == "14" || UploadFunctionalityId == "7" || UploadFunctionalityId == "3" || UploadFunctionalityId == "19" || UploadFunctionalityId == "22" || UploadFunctionalityId == "2" || UploadFunctionalityId == "37")
                        {
                            if (Path.GetExtension(postedFile.FileName).ToLower() == ".jpg" || Path.GetExtension(postedFile.FileName).ToLower() == ".jpeg" || Path.GetExtension(postedFile.FileName).ToLower() == ".bmp" || Path.GetExtension(postedFile.FileName).ToLower() == ".png")
                            {
                                byte[] ImgArray = null;
                                using (var binaryReader = new BinaryReader(postedFile.InputStream))
                                {
                                    ImgArray = binaryReader.ReadBytes(postedFile.ContentLength);

                                    using (MemoryStream StartMemoryStream = new MemoryStream(),
                                                        NewMemoryStream = new MemoryStream())
                                    {
                                        StartMemoryStream.Write(ImgArray, 0, ImgArray.Length);

                                        if (ImgArray.Length > 4)
                                        {
                                            Bitmap startBitmap = new Bitmap(StartMemoryStream);
                                            System.Drawing.Image image = System.Drawing.Image.FromStream(new System.IO.MemoryStream(ImgArray));

                                            int newHeight = image.Height;
                                            int newWidth = image.Width;

                                            Bitmap newBitmap = new Bitmap(newWidth, newHeight);
                                            newBitmap = ResizeImage(startBitmap, newWidth, newHeight);

                                            newBitmap.Save(NewMemoryStream, System.Drawing.Imaging.ImageFormat.Jpeg);

                                            ImgArray = NewMemoryStream.ToArray();

                                            Stream stream = new MemoryStream(ImgArray);
                                            st = stream;
                                            destBlob.UploadFromStream(st);
                                        }
                                    }

                                }
                            }
                            else
                            {
                                destBlob.UploadFromStream(s);
                            }
                        }
                        else
                        {
                            destBlob.UploadFromStream(s);
                        }
                    }
                    else
                    {
                        destBlob.UploadFromStream(s);
                    }
                    //To Store Gallery Thumbnail image in Local Storage 
                    if (UploadFunctionalityId == "21")
                    {

                        if (GUID.ToString() == "0")
                        {
                            string ThumbnailPath = HttpContext.Current.Server.MapPath("~/Content/" + OrgGroupId + "OG/Gallery/" + OrgGroupBatchId + "OGB/Gallery/" + DocumentId);
                            if (!System.IO.Directory.Exists(ThumbnailPath))
                            {
                                System.IO.Directory.CreateDirectory(ThumbnailPath);
                            }
                            byte[] GalleryThumbnail = null;
                            postedFile.InputStream.Position = 0;
                            using (var binaryReader = new BinaryReader(postedFile.InputStream))
                            {
                                GalleryThumbnail = binaryReader.ReadBytes(postedFile.ContentLength);

                                using (MemoryStream StartMemoryStream = new MemoryStream(),
                                                            NewMemoryStream = new MemoryStream())
                                {
                                    // write the string to the stream  
                                    StartMemoryStream.Write(GalleryThumbnail, 0, GalleryThumbnail.Length);

                                    // create the start Bitmap from the MemoryStream that contains the image  
                                    if (GalleryThumbnail.Length > 4)
                                    {
                                        Bitmap startBitmap = new Bitmap(StartMemoryStream);

                                        // set thumbnail height and width proportional to the original image.  
                                        int newHeight;
                                        int newWidth;
                                        double HW_ratio;
                                        //Mantis: 36526, change by dhruvik, because thay want better resolution while opning thumbnail
                                        if (startBitmap.Height > startBitmap.Width)
                                        {
                                            newHeight = 250;
                                            HW_ratio = (double)((double)250 / (double)startBitmap.Height);
                                            newWidth = (int)(HW_ratio * (double)startBitmap.Width);
                                        }
                                        else
                                        {
                                            newWidth = 250;
                                            HW_ratio = (double)((double)250 / (double)startBitmap.Width);
                                            newHeight = (int)(HW_ratio * (double)startBitmap.Height);
                                        }

                                        // create a new Bitmap with dimensions for the thumbnail.  
                                        Bitmap newBitmap = new Bitmap(newWidth, newHeight);

                                        // Copy the image from the START Bitmap into the NEW Bitmap.  
                                        // This will create a thumnail size of the same image.  
                                        newBitmap = ResizeImage(startBitmap, newWidth, newHeight);

                                        // Save this image to the specified stream in the specified format.  
                                        newBitmap.Save(NewMemoryStream, System.Drawing.Imaging.ImageFormat.Jpeg);

                                        // Fill the byte[] for the thumbnail from the new MemoryStream.  
                                        GalleryThumbnail = NewMemoryStream.ToArray();
                                    }
                                }

                            }
                            File.WriteAllBytes(ThumbnailPath + "\\" + DocumentName, GalleryThumbnail);
                        }
                    }
                    //destBlob.UploadFromStream(st);

                }

                if (GUID.ToString() == "0")
                {
                    List<DataParameter> dp = new List<DataParameter>();
                    DataParameter d;

                    if (IsDigitsOnly(DocumentId))
                    {
                        d = new DataParameter { Name = "@rUploadFunctionalityId", Value = UploadFunctionalityId, DataType = System.Data.DbType.Int16 };
                        dp.Add(d);

                        d = new DataParameter { Name = "@rUserSourceTypeId", Value = UserSourceTypeId, DataType = System.Data.DbType.Int16 };
                        dp.Add(d);

                        d = new DataParameter { Name = "@rUserSourceId", Value = UserSourceId, DataType = System.Data.DbType.Int64 };
                        dp.Add(d);

                        d = new DataParameter { Name = "@rDocumentId", Value = DocumentId, DataType = System.Data.DbType.Int64 };
                        dp.Add(d);

                        if (UploadFunctionalityId == "25")
                            d = new DataParameter { Name = "@rDocumentName", Value = Path.GetFileName(destBlob.Uri.AbsoluteUri), DataType = System.Data.DbType.String };
                        else
                            d = new DataParameter { Name = "@rDocumentName", Value = DocumentName, DataType = System.Data.DbType.String };
                        dp.Add(d);

                        d = new DataParameter { Name = "@rCreatedUserId", Value = CreatedUserId, DataType = System.Data.DbType.Int64 };
                        dp.Add(d);

                        d = new DataParameter { Name = "@rDocumentSize", Value = (Decimal)destBlob.Properties.Length / 1024, DataType = System.Data.DbType.Decimal };
                        dp.Add(d);

                        d = new DataParameter { Name = "@rOrgGroupBatchId", Value = OrgGroupBatchId, DataType = System.Data.DbType.Int32 };
                        dp.Add(d);

                        cf.GetDatasetFromSp("[sCommon].[pUploadDocumentAdd]", dp);
                    }

                }
            }
        }
    }
    public bool IsReusable
    {
        get
        {
            return false;
        }
    }

    public bool IsDigitsOnly(string str)
    {
        foreach (char c in str)
        {
            if (c < '0' || c > '9')
                return false;
        }
        return true;
    }
    private static Bitmap ResizeImage(Bitmap image, int width, int height)
    {
        var destRect = new Rectangle(0, 0, width, height);
        Bitmap resizedImage = new Bitmap(width, height);
        using (Graphics gfx = Graphics.FromImage(resizedImage))
        {
            gfx.CompositingMode = CompositingMode.SourceCopy;
            gfx.CompositingQuality = CompositingQuality.HighQuality;
            gfx.InterpolationMode = InterpolationMode.HighQualityBicubic;
            gfx.SmoothingMode = SmoothingMode.HighQuality;
            gfx.PixelOffsetMode = PixelOffsetMode.HighQuality;

            using (var wrapMode = new ImageAttributes())
            {
                wrapMode.SetWrapMode(WrapMode.TileFlipXY);
                gfx.DrawImage(image, destRect, 0, 0, image.Width, image.Height, GraphicsUnit.Pixel, wrapMode);
            }

            //gfx.DrawImage(image, new Rectangle(0, 0, width, height),
            //        new Rectangle(0, 0, image.Width, image.Height), GraphicsUnit.Pixel);
        }
        return resizedImage;
    }
}